/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class ArtifactBySourceFileFinderImpl
extends ArtifactBySourceFileFinder {
    private CachedValue<MultiValuesMap<VirtualFile, Artifact>> myFile2Artifacts;
    private final Project myProject;

    public ArtifactBySourceFileFinderImpl(Project project) {
        this.myProject = project;
    }

    public CachedValue<MultiValuesMap<VirtualFile, Artifact>> getFileToArtifactsMap() {
        if (this.myFile2Artifacts == null) {
            this.myFile2Artifacts = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                MultiValuesMap<VirtualFile, Artifact> result = this.computeFileToArtifactsMap();
                ArrayList<ModificationTracker> trackers = new ArrayList<ModificationTracker>();
                trackers.add(ArtifactManager.getInstance((Project)this.myProject).getModificationTracker());
                for (ComplexPackagingElementType type : PackagingElementFactory.getInstance().getComplexElementTypes()) {
                    ContainerUtil.addIfNotNull(trackers, (Object)type.getAllSubstitutionsModificationTracker(this.myProject));
                }
                return CachedValueProvider.Result.create(result, trackers);
            }, false);
        }
        return this.myFile2Artifacts;
    }

    private MultiValuesMap<VirtualFile, Artifact> computeFileToArtifactsMap() {
        final MultiValuesMap result = new MultiValuesMap();
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.myProject);
        for (final Artifact artifact : artifactManager.getArtifacts()) {
            final PackagingElementResolvingContext context = artifactManager.getResolvingContext();
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(this){

                @Override
                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile root = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                        if (root != null) {
                            result.put((Object)root, (Object)artifact);
                        }
                    } else if (element instanceof ModuleOutputPackagingElement) {
                        for (VirtualFile sourceRoot : ((ModuleOutputPackagingElement)element).getSourceRoots(context)) {
                            result.put((Object)sourceRoot, (Object)artifact);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, context, true);
        }
        return result;
    }

    @Override
    public Collection<? extends Artifact> findArtifacts(@NotNull VirtualFile sourceFile) {
        MultiValuesMap map;
        if (sourceFile == null) {
            ArtifactBySourceFileFinderImpl.$$$reportNull$$$0(0);
        }
        if ((map = (MultiValuesMap)this.getFileToArtifactsMap().getValue()).isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result = null;
        for (VirtualFile file = sourceFile; file != null; file = file.getParent()) {
            Collection artifacts = map.get((Object)file);
            if (artifacts == null) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.addAll(artifacts);
        }
        return result != null ? result : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/packaging/impl/artifacts/ArtifactBySourceFileFinderImpl", "findArtifacts"));
    }
}

