/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.FileOrDirectoryPackagingElementEntity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessing;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactManagerBridge;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.platform.backend.workspace.UseNewWorkspaceModelApiKt;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.query.APIKt;
import com.intellij.platform.workspace.storage.query.AssociationQuery;
import com.intellij.platform.workspace.storage.query.CollectionQuery;
import com.intellij.platform.workspace.storage.query.StorageQuery;
import com.intellij.util.PathUtil;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\n0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "parentPathsToArtifacts", "Lcom/intellij/platform/workspace/storage/CachedValue;", "", "", "", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "after", "", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "filePathChanged", "oldPath", "newPath", "parentPathToArtifactReferences", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "getParentPathToArtifactReferences", "()Ljava/util/Map;", "parentPathToArtifacts", "getParentPathToArtifacts", "propertyChanged", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "Companion", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nArtifactVirtualFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactVirtualFileListener.kt\ncom/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 API.kt\ncom/intellij/platform/workspace/storage/query/APIKt\n*L\n1#1,161:1\n44#2,2:162\n46#2:167\n44#2,2:168\n46#2:173\n29#3,3:164\n29#3,3:170\n10#4:174\n*S KotlinDebug\n*F\n+ 1 ArtifactVirtualFileListener.kt\ncom/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener\n*L\n54#1:162,2\n54#1:167\n95#1:168,2\n95#1:173\n54#1:164,3\n95#1:170,3\n108#1:174\n*E\n"})
public final class ArtifactVirtualFileListener
implements BulkFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CachedValue<Map<String, List<ArtifactEntity>>> parentPathsToArtifacts;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final AssociationQuery<String, List<EntityPointer<ArtifactEntity>>> query;
    @NotNull
    private static final AtomicLong filePathChangedMs;
    @NotNull
    private static final AtomicLong propertyChangedMs;

    public ArtifactVirtualFileListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.parentPathsToArtifacts = new CachedValue(ArtifactVirtualFileListener::parentPathsToArtifacts$lambda$0);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileMoveEvent) {
                String string = ((VFileMoveEvent)vFileEvent).getOldPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOldPath(...)");
                String string2 = ((VFileMoveEvent)vFileEvent).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                this.filePathChanged(string, string2);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            this.propertyChanged((VFilePropertyChangeEvent)vFileEvent);
        }
    }

    private final void filePathChanged(String oldPath, String newPath) {
        AtomicLong atomicLong;
        long start$iv$iv;
        Unit value$iv;
        block4: {
            Sequence sequence;
            block5: {
                block3: {
                    AtomicLong arg0$iv = filePathChangedMs;
                    boolean bl = false;
                    value$iv = null;
                    boolean $i$f$measureTimeMillis = false;
                    start$iv$iv = System.currentTimeMillis();
                    atomicLong = arg0$iv;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!UseNewWorkspaceModelApiKt.useQueryCacheWorkspaceModelApi()) break block3;
                    Sequence sequence2 = this.getParentPathToArtifactReferences().get(oldPath);
                    if (sequence2 == null || (sequence2 = CollectionsKt.asSequence((Iterable)((Iterable)sequence2))) == null) break block4;
                    Sequence refs = sequence2;
                    ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
                    sequence = SequencesKt.map((Sequence)refs, arg_0 -> ArtifactVirtualFileListener.filePathChanged$lambda$0$0(storage, arg_0));
                    break block5;
                }
                sequence = this.getParentPathToArtifacts().get(oldPath);
                if (sequence == null || (sequence = CollectionsKt.asSequence((Iterable)((Iterable)sequence))) == null) break block4;
            }
            Sequence artifactEntities = sequence;
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)this.project);
            artifactManager.getArtifacts();
            ExternalEntityMapping<ArtifactBridge> artifactsMap = ArtifactManagerBridge.Companion.getArtifactsMap((EntityStorage)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot());
            ModifiableArtifactModel model = artifactManager.createModifiableModel();
            for (ArtifactEntity artifactEntity : artifactEntities) {
                ArtifactBridge artifact;
                if ((ArtifactBridge)((Object)artifactsMap.getDataByEntity((WorkspaceEntity)artifactEntity)) == null) continue;
                ModifiableArtifact modifiableArtifact = model.getOrCreateModifiableArtifact((Artifact)artifact);
                Intrinsics.checkNotNullExpressionValue((Object)modifiableArtifact, (String)"getOrCreateModifiableArtifact(...)");
                Artifact copy = (Artifact)modifiableArtifact;
                ArtifactUtil.processFileOrDirectoryCopyElements(copy, new PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>>(oldPath, newPath){
                    final /* synthetic */ String $oldPath;
                    final /* synthetic */ String $newPath;
                    {
                        this.$oldPath = $oldPath;
                        this.$newPath = $newPath;
                    }

                    public boolean process(FileOrDirectoryCopyPackagingElement<?> element, PackagingElementPath pathToElement) {
                        Intrinsics.checkNotNullParameter(element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)pathToElement, (String)"pathToElement");
                        String path = element.getFilePath();
                        if (FileUtil.startsWith((String)path, (String)this.$oldPath)) {
                            Intrinsics.checkNotNull((Object)path);
                            String string = path.substring(this.$oldPath.length());
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            element.setFilePath(this.$newPath + string);
                        }
                        return true;
                    }
                }, artifactManager.getResolvingContext(), false);
            }
            model.commit();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final Map<String, List<EntityPointer<ArtifactEntity>>> getParentPathToArtifactReferences() {
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        Intrinsics.checkNotNull((Object)storage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.ImmutableEntityStorage");
        return (Map)storage.cached((StorageQuery)query);
    }

    private final Map<String, List<ArtifactEntity>> getParentPathToArtifacts() {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
        return (Map)((WorkspaceModelInternal)workspaceModel).getEntityStorage().cachedValue(this.parentPathsToArtifacts);
    }

    private final void propertyChanged(VFilePropertyChangeEvent event) {
        VirtualFile parent;
        AtomicLong arg0$iv = propertyChangedMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl2 = false;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)"name", (Object)event.getPropertyName()) && (parent = event.getFile().getParent()) != null) {
            String string = parent.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String parentPath = string;
            this.filePathChanged(parentPath + "/" + event.getOldValue(), parentPath + "/" + event.getNewValue());
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private static final Map parentPathsToArtifacts$lambda$0(EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        return ArtifactVirtualFileListener.Companion.computeParentPathToArtifactMap(storage);
    }

    private static final ArtifactEntity filePathChanged$lambda$0$0(ImmutableEntityStorage $storage, EntityPointer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WorkspaceEntity workspaceEntity = it.resolve((EntityStorage)$storage);
        Intrinsics.checkNotNull((Object)workspaceEntity);
        return (ArtifactEntity)workspaceEntity;
    }

    private static final boolean query$lambda$0$0$0(List $this_buildList, ArtifactEntity $artifactEntity, FileOrDirectoryPackagingElementEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        String string = VfsUtilCore.urlToPath((String)entity.getFilePath().getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
        String path = string;
        while (((CharSequence)path).length() > 0) {
            $this_buildList.add(TuplesKt.to((Object)$artifactEntity.createPointer(), (Object)path));
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)path), (String)"getParentPath(...)");
        }
        return true;
    }

    private static final Iterable query$lambda$0(ArtifactEntity artifactEntity, ImmutableEntityStorage immutableEntityStorage) {
        List list;
        Intrinsics.checkNotNullParameter((Object)artifactEntity, (String)"artifactEntity");
        Intrinsics.checkNotNullParameter((Object)immutableEntityStorage, (String)"<unused var>");
        List $this$query_u24lambda_u240_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        PackagingElementProcessing.processFileOrDirectoryCopyElements(artifactEntity, (Function1<? super FileOrDirectoryPackagingElementEntity, Boolean>)((Function1)arg_0 -> ArtifactVirtualFileListener.query$lambda$0$0$0($this$query_u24lambda_u240_u240, artifactEntity, arg_0)));
        return CollectionsKt.build((List)list);
    }

    private static final String query$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getSecond();
    }

    private static final EntityPointer query$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (EntityPointer)it.getFirst();
    }

    static {
        Logger logger = Logger.getInstance(ArtifactVirtualFileListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        boolean $i$f$entities = false;
        query = APIKt.groupBy((CollectionQuery)APIKt.flatMap((CollectionQuery)APIKt.entities((KClass)Reflection.getOrCreateKotlinClass(ArtifactEntity.class)), ArtifactVirtualFileListener::query$lambda$0), ArtifactVirtualFileListener::query$lambda$1, ArtifactVirtualFileListener::query$lambda$2);
        filePathChangedMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        propertyChangedMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        ArtifactVirtualFileListener.Companion.setupOpenTelemetryReporting(TelemetryManager.Companion.getMeter(PlatformScopesKt.Compiler));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a$\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\n\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "query", "Lcom/intellij/platform/workspace/storage/query/AssociationQuery;", "", "Lcom/intellij/openapi/util/NlsSafe;", "", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "computeParentPathToArtifactMap", "", "", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "filePathChangedMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "propertyChangedMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.java.compiler.impl"})
    @SourceDebugExtension(value={"SMAP\nArtifactVirtualFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactVirtualFileListener.kt\ncom/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,161:1\n1342#2,2:162\n383#3,7:164\n*S KotlinDebug\n*F\n+ 1 ArtifactVirtualFileListener.kt\ncom/intellij/packaging/impl/artifacts/ArtifactVirtualFileListener$Companion\n*L\n125#1:162,2\n129#1:164,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, List<ArtifactEntity>> computeParentPathToArtifactMap(EntityStorage storage) {
            Map result = new HashMap();
            Sequence $this$forEach$iv = storage.entities(ArtifactEntity.class);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArtifactEntity artifact = (ArtifactEntity)element$iv;
                boolean bl = false;
                PackagingElementProcessing.processFileOrDirectoryCopyElements(artifact, (Function1<? super FileOrDirectoryPackagingElementEntity, Boolean>)((Function1)arg_0 -> Companion.computeParentPathToArtifactMap$lambda$0$0(result, artifact, arg_0)));
            }
            return result;
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement filePathChangedGauge = meter.gaugeBuilder("compiler.ArtifactVirtualFileListener.filePathChanged.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableLongMeasurement propertyChangedGauge = meter.gaugeBuilder("compiler.ArtifactVirtualFileListener.propertyChanged.ms").ofLongs().setDescription("Total time spent in method").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{propertyChangedGauge};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(filePathChangedGauge, propertyChangedGauge), (ObservableMeasurement)filePathChangedGauge, observableMeasurementArray);
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean computeParentPathToArtifactMap$lambda$0$0(Map $result, ArtifactEntity $artifact, FileOrDirectoryPackagingElementEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            String string = VfsUtilCore.urlToPath((String)entity.getFilePath().getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
            String path = string;
            while (((CharSequence)path).length() > 0) {
                Object object;
                void $this$getOrPut$iv;
                Map map = $result;
                String key$iv = path;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add($artifact);
                Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)path), (String)"getParentPath(...)");
            }
            return true;
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $filePathChangedGauge, ObservableLongMeasurement $propertyChangedGauge) {
            $filePathChangedGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)filePathChangedMs));
            $propertyChangedGauge.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)propertyChangedMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

