/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts.workspacemodel;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.java.workspace.entities.ArchivePackagingElementEntity;
import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactId;
import com.intellij.java.workspace.entities.ArtifactOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntity;
import com.intellij.java.workspace.entities.ArtifactRootElementEntity;
import com.intellij.java.workspace.entities.CompositePackagingElementEntity;
import com.intellij.java.workspace.entities.CustomPackagingElementEntity;
import com.intellij.java.workspace.entities.DirectoryCopyPackagingElementEntity;
import com.intellij.java.workspace.entities.DirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.ExtractedDirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.FileCopyPackagingElementEntity;
import com.intellij.java.workspace.entities.LibraryFilesPackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleSourcePackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleTestOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactLoadingErrorDescription;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.ArtifactManagerBridge;
import com.intellij.packaging.impl.artifacts.workspacemodel.InvalidArtifactBridge;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleSourceElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0002\u001a&\u0010\u0012\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00132\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u00010\u0015\u001a\u0012\u0010\u0016\u001a\u00020\t*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a \u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00130\u001eH\u0000\u001a\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030 H\u0000\u001a&\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007\u00a8\u0006'"}, d2={"addBridgesToDiff", "", "newBridges", "", "Lcom/intellij/packaging/impl/artifacts/workspacemodel/ArtifactBridge;", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "createArtifactBridge", "it", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "entityStorage", "Lcom/intellij/platform/workspace/storage/VersionedEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "createInvalidArtifact", "Lcom/intellij/packaging/impl/artifacts/workspacemodel/InvalidArtifactBridge;", "message", "", "forThisAndFullTree", "Lcom/intellij/packaging/elements/PackagingElement;", "action", "Lkotlin/Function1;", "get", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "id", "Lcom/intellij/java/workspace/entities/ArtifactId;", "sameTypeWith", "", "Lcom/intellij/java/workspace/entities/PackagingElementEntity;", "type", "Lcom/intellij/packaging/elements/PackagingElementType;", "propertiesTag", "Lcom/intellij/packaging/artifacts/ArtifactProperties;", "getArtifactProperties", "artifactEntity", "artifactType", "Lcom/intellij/packaging/artifacts/ArtifactType;", "propertiesProvider", "Lcom/intellij/packaging/artifacts/ArtifactPropertiesProvider;", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nBridgeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeUtils.kt\ncom/intellij/packaging/impl/artifacts/workspacemodel/BridgeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n296#2,2:173\n1915#2,2:175\n1915#2,2:178\n1#3:177\n*S KotlinDebug\n*F\n+ 1 BridgeUtils.kt\ncom/intellij/packaging/impl/artifacts/workspacemodel/BridgeUtilsKt\n*L\n81#1:173,2\n111#1:175,2\n68#1:178,2\n*E\n"})
public final class BridgeUtilsKt {
    public static final void addBridgesToDiff(@NotNull List<? extends ArtifactBridge> newBridges, @NotNull MutableEntityStorage builder) {
        Intrinsics.checkNotNullParameter(newBridges, (String)"newBridges");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        for (ArtifactBridge artifactBridge : newBridges) {
            ArtifactEntity artifactEntity;
            if ((ArtifactEntity)builder.resolve((SymbolicEntityId)artifactBridge.getArtifactId()) == null) continue;
            ArtifactManagerBridge.Companion.getMutableArtifactsMap$intellij_java_compiler_impl(builder).addMapping((WorkspaceEntity)artifactEntity, (Object)artifactBridge);
        }
    }

    @NotNull
    public static final ArtifactBridge createArtifactBridge(@NotNull ArtifactEntity it, @NotNull VersionedEntityStorage entityStorage, @NotNull Project project) {
        Object v3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (ArtifactType.findById((String)it.getArtifactType()) == null) {
                Object[] objectArray = new Object[]{it.getArtifactType()};
                String string = JavaCompilerBundle.message((String)"unknown.artifact.type.0", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return BridgeUtilsKt.createInvalidArtifact(it, entityStorage, project, string);
            }
            CompositePackagingElementEntity compositePackagingElementEntity = it.getRootElement();
            Intrinsics.checkNotNull((Object)compositePackagingElementEntity);
            String missingArtifactType = BridgeUtilsKt.createArtifactBridge$findMissingArtifactType((PackagingElementEntity)compositePackagingElementEntity);
            if (missingArtifactType != null) {
                Object[] objectArray = new Object[]{missingArtifactType};
                String string = JavaCompilerBundle.message((String)"unknown.element.0", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return BridgeUtilsKt.createInvalidArtifact(it, entityStorage, project, string);
            }
            Iterable $this$firstOrNull$iv = it.getCustomProperties();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ArtifactPropertiesEntity it2 = (ArtifactPropertiesEntity)element$iv;
                boolean bl = false;
                if (!(ArtifactPropertiesProvider.findById((String)it2.getProviderType()) == null)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        ArtifactPropertiesEntity unknownProperty = v3;
        if (unknownProperty != null) {
            Object[] objectArray = new Object[]{unknownProperty.getProviderType()};
            String string = JavaCompilerBundle.message((String)"unknown.artifact.properties.0", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return BridgeUtilsKt.createInvalidArtifact(it, entityStorage, project, string);
        }
        return new ArtifactBridge(it.getSymbolicId(), entityStorage, project, null, null);
    }

    private static final InvalidArtifactBridge createInvalidArtifact(ArtifactEntity it, VersionedEntityStorage entityStorage, Project project, @Nls String message) {
        InvalidArtifactBridge invalidArtifactBridge = new InvalidArtifactBridge(it.getSymbolicId(), entityStorage, project, null, message);
        ArtifactLoadingErrorDescription errorDescription = new ArtifactLoadingErrorDescription(project, invalidArtifactBridge);
        ProjectLoadingErrorsNotifier.getInstance((Project)project).registerError((ConfigurationErrorDescription)errorDescription);
        UnknownFeaturesCollector.getInstance((Project)project).registerUnknownFeature(new UnknownFeature(errorDescription.getErrorType().getFeatureType(), JavaCompilerBundle.message((String)"plugins.advertiser.feature.artifact", (Object[])new Object[0]), it.getArtifactType()));
        return invalidArtifactBridge;
    }

    public static final void forThisAndFullTree(@NotNull PackagingElement<?> $this$forThisAndFullTree, @NotNull Function1<? super PackagingElement<?>, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forThisAndFullTree, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke($this$forThisAndFullTree);
        if ($this$forThisAndFullTree instanceof CompositePackagingElement) {
            List list = ((CompositePackagingElement)$this$forThisAndFullTree).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PackagingElement it = (PackagingElement)element$iv;
                boolean bl = false;
                if (it instanceof CompositePackagingElement) {
                    BridgeUtilsKt.forThisAndFullTree(it, action);
                    continue;
                }
                Intrinsics.checkNotNull((Object)it);
                action.invoke((Object)it);
            }
        }
    }

    @NotNull
    public static final ArtifactEntity get(@NotNull EntityStorage $this$get, @NotNull ArtifactId id) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ArtifactEntity artifactEntity = (ArtifactEntity)$this$get.resolve((SymbolicEntityId)id);
        if (artifactEntity == null) {
            throw new IllegalStateException(("Cannot find artifact by id: " + id.getName()).toString());
        }
        return artifactEntity;
    }

    public static final boolean sameTypeWith(@NotNull PackagingElementEntity $this$sameTypeWith, @NotNull PackagingElementType<? extends PackagingElement<?>> type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$sameTypeWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        PackagingElementEntity packagingElementEntity = $this$sameTypeWith;
        if (packagingElementEntity instanceof ModuleOutputPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, (Object)((Object)ProductionModuleOutputElementType.ELEMENT_TYPE));
        } else if (packagingElementEntity instanceof ModuleTestOutputPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, (Object)((Object)TestModuleOutputElementType.ELEMENT_TYPE));
        } else if (packagingElementEntity instanceof ModuleSourcePackagingElementEntity) {
            bl = Intrinsics.areEqual(type, (Object)((Object)ProductionModuleSourceElementType.ELEMENT_TYPE));
        } else if (packagingElementEntity instanceof ArtifactOutputPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
        } else if (packagingElementEntity instanceof ExtractedDirectoryPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE);
        } else if (packagingElementEntity instanceof FileCopyPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE);
        } else if (packagingElementEntity instanceof DirectoryCopyPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE);
        } else if (packagingElementEntity instanceof DirectoryPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, PackagingElementFactoryImpl.DIRECTORY_ELEMENT_TYPE);
        } else if (packagingElementEntity instanceof ArchivePackagingElementEntity) {
            bl = Intrinsics.areEqual(type, PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
        } else if (packagingElementEntity instanceof ArtifactRootElementEntity) {
            bl = Intrinsics.areEqual(type, PackagingElementFactoryImpl.ARTIFACT_ROOT_ELEMENT_TYPE);
        } else if (packagingElementEntity instanceof LibraryFilesPackagingElementEntity) {
            bl = Intrinsics.areEqual(type, (Object)((Object)LibraryElementType.LIBRARY_ELEMENT_TYPE));
        } else if (packagingElementEntity instanceof CustomPackagingElementEntity) {
            bl = Intrinsics.areEqual((Object)((CustomPackagingElementEntity)$this$sameTypeWith).getTypeId(), (Object)type.getId());
        } else {
            throw new IllegalStateException(("Unexpected branch. " + $this$sameTypeWith).toString());
        }
        return bl;
    }

    @Nullable
    public static final String propertiesTag(@NotNull ArtifactProperties<?> $this$propertiesTag) {
        String string;
        Intrinsics.checkNotNullParameter($this$propertiesTag, (String)"<this>");
        Object state = $this$propertiesTag.getState();
        if (state != null) {
            Element element = XmlSerializer.serialize$default((Object)state, null, (boolean)false, (int)6, null);
            if (element == null) {
                return null;
            }
            Element element2 = element;
            element2.setName("options");
            string = JDOMUtil.write((Element)element2);
        } else {
            string = null;
        }
        return string;
    }

    @ApiStatus.Internal
    @Nullable
    public static final ArtifactProperties<?> getArtifactProperties(@NotNull ArtifactEntity artifactEntity, @NotNull ArtifactType artifactType, @NotNull ArtifactPropertiesProvider propertiesProvider) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)artifactEntity, (String)"artifactEntity");
            Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
            Intrinsics.checkNotNullParameter((Object)propertiesProvider, (String)"propertiesProvider");
            String providerId = propertiesProvider.getId();
            Iterable iterable = artifactEntity.getCustomProperties();
            for (Object t : iterable) {
                ArtifactPropertiesEntity it = (ArtifactPropertiesEntity)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProviderType(), (Object)providerId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ArtifactPropertiesEntity artifactPropertiesEntity = v0;
        if (artifactPropertiesEntity == null) {
            return propertiesProvider.isAvailableFor(artifactType) ? propertiesProvider.createProperties(artifactType) : null;
        }
        ArtifactPropertiesEntity customProperty = artifactPropertiesEntity;
        ArtifactProperties artifactProperties = propertiesProvider.createProperties(artifactType);
        Intrinsics.checkNotNull((Object)artifactProperties, (String)"null cannot be cast to non-null type com.intellij.packaging.artifacts.ArtifactProperties<kotlin.Any>");
        ArtifactProperties createdProperties = artifactProperties;
        Object object = createdProperties.getState();
        Intrinsics.checkNotNull((Object)object);
        Object state = object;
        String string = customProperty.getPropertiesXmlTag();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Element element = JDOMUtil.load((CharSequence)it);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            XmlSerializer.deserializeInto((Element)element, (Object)state);
        }
        createdProperties.loadState(state);
        return createdProperties;
    }

    private static final String createArtifactBridge$findMissingArtifactType(PackagingElementEntity element) {
        if (element instanceof CustomPackagingElementEntity && PackagingElementFactory.getInstance().findElementType(((CustomPackagingElementEntity)element).getTypeId()) == null) {
            return ((CustomPackagingElementEntity)element).getTypeId();
        }
        if (element instanceof CompositePackagingElementEntity) {
            Iterable $this$forEach$iv = ((CompositePackagingElementEntity)element).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String artifactType;
                PackagingElementEntity child = (PackagingElementEntity)element$iv;
                boolean bl = false;
                String string = artifactType = BridgeUtilsKt.createArtifactBridge$findMissingArtifactType(child);
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }
}

