/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArtifactCompileScope {
    private static final Key<Boolean> FORCE_ARTIFACT_BUILD = Key.create((String)"force_artifact_build");
    private static final Key<Artifact[]> ARTIFACTS_KEY = Key.create((String)"artifacts");
    private static final Key<Set<Artifact>> CACHED_ARTIFACTS_KEY = Key.create((String)"cached_artifacts");

    private ArtifactCompileScope() {
    }

    public static ModuleCompileScope createScopeForModulesInArtifacts(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts) {
        if (project == null) {
            ArtifactCompileScope.$$$reportNull$$$0(0);
        }
        if (artifacts == null) {
            ArtifactCompileScope.$$$reportNull$$$0(1);
        }
        Set<Module> modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, project);
        return new ModuleCompileScope(project, modules.toArray(Module.EMPTY_ARRAY), true);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts) {
        if (project == null) {
            ArtifactCompileScope.$$$reportNull$$$0(2);
        }
        if (artifacts == null) {
            ArtifactCompileScope.$$$reportNull$$$0(3);
        }
        return ArtifactCompileScope.createArtifactsScope(project, artifacts, false);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts, boolean forceArtifactBuild) {
        if (project == null) {
            ArtifactCompileScope.$$$reportNull$$$0(4);
        }
        if (artifacts == null) {
            ArtifactCompileScope.$$$reportNull$$$0(5);
        }
        return ArtifactCompileScope.createScopeWithArtifacts(ArtifactCompileScope.createScopeForModulesInArtifacts(project, artifacts), artifacts, forceArtifactBuild);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope baseScope, @NotNull Collection<? extends Artifact> artifacts) {
        if (artifacts == null) {
            ArtifactCompileScope.$$$reportNull$$$0(6);
        }
        return ArtifactCompileScope.createScopeWithArtifacts(baseScope, artifacts, false);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope baseScope, @NotNull Collection<? extends Artifact> artifacts, boolean forceArtifactBuild) {
        if (artifacts == null) {
            ArtifactCompileScope.$$$reportNull$$$0(7);
        }
        baseScope.putUserData(ARTIFACTS_KEY, (Object)artifacts.toArray(new Artifact[0]));
        if (forceArtifactBuild) {
            baseScope.putUserData(FORCE_ARTIFACT_BUILD, (Object)Boolean.TRUE);
        }
        return baseScope;
    }

    public static Set<Artifact> getArtifactsToBuild(Project project, CompileScope compileScope, boolean addIncludedArtifactsWithOutputPathsOnly) {
        Artifact[] artifactsFromScope = ArtifactCompileScope.getArtifacts(compileScope);
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        if (artifactsFromScope != null) {
            return ArtifactCompileScope.addIncludedArtifacts(Arrays.asList(artifactsFromScope), context, addIncludedArtifactsWithOutputPathsOnly);
        }
        Set cached = (Set)compileScope.getUserData(CACHED_ARTIFACTS_KEY);
        if (cached != null) {
            return cached;
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Set<Module> modules = Set.of(compileScope.getAffectedModules());
        List<Module> allModules = Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        for (Artifact artifact : artifactManager.getArtifacts()) {
            if (!artifact.isBuildOnMake() || !modules.containsAll(allModules) && !ArtifactCompileScope.containsModuleOutput(artifact, modules, context)) continue;
            artifacts.add(artifact);
        }
        Set<Artifact> result = ArtifactCompileScope.addIncludedArtifacts(artifacts, context, addIncludedArtifactsWithOutputPathsOnly);
        compileScope.putUserData(CACHED_ARTIFACTS_KEY, result);
        return result;
    }

    public static Artifact @Nullable [] getArtifacts(CompileScope compileScope) {
        return (Artifact[])compileScope.getUserData(ARTIFACTS_KEY);
    }

    public static boolean isArtifactRebuildForced(@NotNull CompileScope scope) {
        if (scope == null) {
            ArtifactCompileScope.$$$reportNull$$$0(8);
        }
        return Boolean.TRUE.equals(scope.getUserData(FORCE_ARTIFACT_BUILD));
    }

    private static boolean containsModuleOutput(Artifact artifact, Set<? extends Module> modules, PackagingElementResolvingContext context) {
        return !ArtifactUtil.processPackagingElements(artifact, ProductionModuleOutputElementType.ELEMENT_TYPE, moduleOutputPackagingElement -> {
            Module module = moduleOutputPackagingElement.findModule(context);
            return module == null || !modules.contains(module);
        }, context, true);
    }

    @NotNull
    private static Set<Artifact> addIncludedArtifacts(@NotNull Collection<? extends Artifact> artifacts, @NotNull PackagingElementResolvingContext context, boolean withOutputPathOnly) {
        if (artifacts == null) {
            ArtifactCompileScope.$$$reportNull$$$0(9);
        }
        if (context == null) {
            ArtifactCompileScope.$$$reportNull$$$0(10);
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            ArtifactCompileScope.collectIncludedArtifacts(artifact, context, new HashSet(), result, withOutputPathOnly);
        }
        HashSet<Artifact> hashSet = result;
        if (hashSet == null) {
            ArtifactCompileScope.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static void collectIncludedArtifacts(Artifact artifact, PackagingElementResolvingContext context, Set<? super Artifact> processed, Set<? super Artifact> result, boolean withOutputPathOnly) {
        if (!processed.add((Artifact)artifact)) {
            return;
        }
        if (!withOutputPathOnly || !StringUtil.isEmpty((String)artifact.getOutputPath())) {
            result.add((Artifact)artifact);
        }
        ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, element -> {
            Artifact included = element.findArtifact(context);
            if (included != null) {
                ArtifactCompileScope.collectIncludedArtifacts(included, context, processed, result, withOutputPathOnly);
            }
            return true;
        }, context, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/compiler/ArtifactCompileScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/compiler/ArtifactCompileScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addIncludedArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeForModulesInArtifacts";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactsScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createScopeWithArtifacts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isArtifactRebuildForced";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addIncludedArtifacts";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

