/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LibraryElementType
extends ComplexPackagingElementType<LibraryPackagingElement> {
    public static final LibraryElementType LIBRARY_ELEMENT_TYPE = new LibraryElementType();

    LibraryElementType() {
        super("library", JavaCompilerBundle.messagePointer((String)"element.type.name.library.files", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            LibraryElementType.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            LibraryElementType.$$$reportNull$$$0(1);
        }
        return !LibraryElementType.getAllLibraries(context).isEmpty();
    }

    @NotNull
    public List<? extends LibraryPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            LibraryElementType.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            LibraryElementType.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            LibraryElementType.$$$reportNull$$$0(4);
        }
        List selected = context.chooseLibraries(JavaCompilerBundle.message((String)"dialog.title.packaging.choose.library", (Object[])new Object[0]));
        ArrayList<LibraryPackagingElement> elements = new ArrayList<LibraryPackagingElement>();
        for (Library library : selected) {
            elements.add(new LibraryPackagingElement(library.getTable().getTableLevel(), library.getName(), null));
        }
        ArrayList<LibraryPackagingElement> arrayList = elements;
        if (arrayList == null) {
            LibraryElementType.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static List<Library> getAllLibraries(ArtifactEditorContext context) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        ContainerUtil.addAll(libraries, (Object[])LibraryTablesRegistrar.getInstance().getGlobalLibraryTable(context.getProject()).getLibraries());
        ContainerUtil.addAll(libraries, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable(context.getProject()).getLibraries());
        return libraries;
    }

    @NotNull
    public LibraryPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            LibraryElementType.$$$reportNull$$$0(6);
        }
        return new LibraryPackagingElement();
    }

    public String getShowContentActionText() {
        return JavaCompilerBundle.message((String)"show.library.files", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/LibraryElementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/LibraryElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEmpty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

