/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArchiveElementType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.DirectoryCopyElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryElementType;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyElementType;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleSourceElementType;
import com.intellij.packaging.impl.elements.ProductionModuleSourcePackagingElement;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackagingElementFactoryImpl
extends PackagingElementFactory {
    private static final Logger LOG = Logger.getInstance(PackagingElementFactoryImpl.class);
    public static final PackagingElementType<DirectoryPackagingElement> DIRECTORY_ELEMENT_TYPE = new DirectoryElementType();
    public static final PackagingElementType<ArchivePackagingElement> ARCHIVE_ELEMENT_TYPE = new ArchiveElementType();
    public static final PackagingElementType<FileCopyPackagingElement> FILE_COPY_ELEMENT_TYPE = new FileCopyElementType();
    public static final PackagingElementType<DirectoryCopyPackagingElement> DIRECTORY_COPY_ELEMENT_TYPE = new DirectoryCopyElementType();
    public static final PackagingElementType<ExtractedDirectoryPackagingElement> EXTRACTED_DIRECTORY_ELEMENT_TYPE = new ExtractedDirectoryElementType();
    public static final PackagingElementType<ArtifactRootElement<?>> ARTIFACT_ROOT_ELEMENT_TYPE = new ArtifactRootElementType();
    private static final List<PackagingElementType<?>> STANDARD_TYPES = ExtensionsKt.persistentListOf((Object[])new PackagingElementType[]{DIRECTORY_ELEMENT_TYPE, ARCHIVE_ELEMENT_TYPE, LibraryElementType.LIBRARY_ELEMENT_TYPE, ProductionModuleOutputElementType.ELEMENT_TYPE, TestModuleOutputElementType.ELEMENT_TYPE, ProductionModuleSourceElementType.ELEMENT_TYPE, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, FILE_COPY_ELEMENT_TYPE, DIRECTORY_COPY_ELEMENT_TYPE, EXTRACTED_DIRECTORY_ELEMENT_TYPE});

    public PackagingElementType<?> @NotNull [] getNonCompositeElementTypes() {
        ArrayList<PackagingElementType> elementTypes = new ArrayList<PackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (elementType instanceof CompositePackagingElementType) continue;
            elementTypes.add(elementType);
        }
        PackagingElementType[] packagingElementTypeArray = elementTypes.toArray(new PackagingElementType[0]);
        if (packagingElementTypeArray == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(0);
        }
        return packagingElementTypeArray;
    }

    public ComplexPackagingElementType<?> @NotNull [] getComplexElementTypes() {
        ArrayList<ComplexPackagingElementType> types = new ArrayList<ComplexPackagingElementType>();
        for (PackagingElementType type : this.getAllElementTypes()) {
            if (!(type instanceof ComplexPackagingElementType)) continue;
            types.add((ComplexPackagingElementType)type);
        }
        ComplexPackagingElementType[] complexPackagingElementTypeArray = types.toArray(new ComplexPackagingElementType[0]);
        if (complexPackagingElementTypeArray == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(1);
        }
        return complexPackagingElementTypeArray;
    }

    public CompositePackagingElementType<?> @NotNull [] getCompositeElementTypes() {
        ArrayList<CompositePackagingElementType> elementTypes = new ArrayList<CompositePackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!(elementType instanceof CompositePackagingElementType)) continue;
            elementTypes.add((CompositePackagingElementType)elementType);
        }
        CompositePackagingElementType[] compositePackagingElementTypeArray = elementTypes.toArray(new CompositePackagingElementType[0]);
        if (compositePackagingElementTypeArray == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(2);
        }
        return compositePackagingElementTypeArray;
    }

    public PackagingElementType<?> findElementType(String id) {
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!elementType.getId().equals(id)) continue;
            return elementType;
        }
        if (id.equals(ARTIFACT_ROOT_ELEMENT_TYPE.getId())) {
            return ARTIFACT_ROOT_ELEMENT_TYPE;
        }
        return null;
    }

    @NotNull
    public List<PackagingElementType> getAllElementTypes() {
        PersistentList persistentList = ExtensionsKt.toPersistentList((Iterable)PackagingElementType.EP_NAME.getExtensionList()).addAll(STANDARD_TYPES);
        if (persistentList == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(3);
        }
        return persistentList;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull Artifact artifact, @NotNull Project project) {
        if (artifact == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(5);
        }
        return new ArtifactPackagingElement(project, ArtifactPointerManager.getInstance((Project)project).createPointer(artifact));
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull String artifactName, @NotNull Project project) {
        if (artifactName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(7);
        }
        return new ArtifactPackagingElement(project, ArtifactPointerManager.getInstance((Project)project).createPointer(artifactName));
    }

    @NotNull
    public DirectoryPackagingElement createDirectory(@NotNull @NonNls String directoryName) {
        if (directoryName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(8);
        }
        return new DirectoryPackagingElement(directoryName);
    }

    @NotNull
    public ArtifactRootElement<?> createArtifactRootElement() {
        return new ArtifactRootElementImpl();
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateDirectory(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(9);
        }
        if (relativePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(10);
        }
        return this.getOrCreateDirectoryOrArchive(parent, relativePath, true, false);
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateArchive(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(11);
        }
        if (relativePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(12);
        }
        return this.getOrCreateDirectoryOrArchive(parent, relativePath, false, false);
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath) {
        if (root == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(13);
        }
        if (outputDirectoryPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(14);
        }
        if (sourceFilePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(15);
        }
        this.addFileCopy(root, outputDirectoryPath, sourceFilePath, null, false);
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath, @Nullable String outputFileName, boolean addAsFirstChild) {
        if (root == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(16);
        }
        if (outputDirectoryPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(17);
        }
        if (sourceFilePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(18);
        }
        String fileName = PathUtil.getFileName((String)sourceFilePath);
        if (outputFileName != null && outputFileName.equals(fileName)) {
            outputFileName = null;
        }
        CompositePackagingElement<?> parent = this.getOrCreateDirectoryOrArchive(root, outputDirectoryPath, true, true);
        PackagingElement<?> child = this.createFileCopy(sourceFilePath, outputFileName);
        if (addAsFirstChild) {
            parent.addFirstChild(child);
        } else {
            parent.addOrFindChild(child);
        }
    }

    @NotNull
    private CompositePackagingElement<?> getOrCreateDirectoryOrArchive(@NotNull CompositePackagingElement<?> root, @NotNull @NonNls String path, boolean directory, boolean addAsFirstChild) {
        CompositePackagingElement<?> last;
        if (root == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(19);
        }
        if (path == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(20);
        }
        if ((path = StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/")).isEmpty()) {
            CompositePackagingElement<?> compositePackagingElement = root;
            if (compositePackagingElement == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(21);
            }
            return compositePackagingElement;
        }
        int index = path.lastIndexOf(47);
        String lastName = path.substring(index + 1);
        String parentPath = index != -1 ? path.substring(0, index) : "";
        CompositePackagingElement<?> parent = this.getOrCreateDirectoryOrArchive(root, parentPath, true, addAsFirstChild);
        CompositePackagingElement<?> compositePackagingElement = last = directory ? this.createDirectory(lastName) : this.createArchive(lastName);
        if (addAsFirstChild) {
            parent.addFirstChild(last);
            CompositePackagingElement<?> compositePackagingElement2 = last;
            if (compositePackagingElement2 == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(22);
            }
            return compositePackagingElement2;
        }
        CompositePackagingElement compositePackagingElement3 = (CompositePackagingElement)parent.addOrFindChild(last);
        if (compositePackagingElement3 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(23);
        }
        return compositePackagingElement3;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull String moduleName, @NotNull Project project) {
        if (moduleName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(24);
        }
        if (project == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(25);
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)project).create(moduleName);
        return new ProductionModuleOutputPackagingElement(project, pointer);
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull Module module) {
        if (module == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(26);
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        return new ProductionModuleOutputPackagingElement(module.getProject(), modulePointer);
    }

    @NotNull
    public PackagingElement<?> createModuleSource(@NotNull Module module) {
        if (module == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(27);
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        return new ProductionModuleSourcePackagingElement(module.getProject(), modulePointer);
    }

    @NotNull
    public PackagingElement<?> createTestModuleOutput(@NotNull String moduleName, @NotNull Project project) {
        if (moduleName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(28);
        }
        if (project == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(29);
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)project).create(moduleName);
        return new TestModuleOutputPackagingElement(project, pointer);
    }

    @NotNull
    public PackagingElement<?> createTestModuleOutput(@NotNull Module module) {
        if (module == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(30);
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        return new TestModuleOutputPackagingElement(module.getProject(), pointer);
    }

    @NotNull
    public List<PackagingElement<?>> createLibraryElements(@NotNull Library library) {
        Module module;
        if (library == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(31);
        }
        LibraryTable table = library.getTable();
        String libraryName = library.getName();
        if (table != null) {
            List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, table.getTableLevel(), null));
            if (list == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(32);
            }
            return list;
        }
        if (libraryName != null && (module = ((LibraryEx)library).getModule()) != null) {
            List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, "module", module.getName()));
            if (list == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(33);
            }
            return list;
        }
        ArrayList elements = new ArrayList();
        for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
            String path = FileUtil.toSystemIndependentName((String)PathUtil.getLocalPath((VirtualFile)file));
            elements.add(file.isDirectory() && file.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(path) : new FileCopyPackagingElement(path));
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createLibraryElements(@NotNull LibraryEntity libraryEntity, String moduleName) {
        if (libraryEntity == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(35);
        }
        String libraryType = libraryEntity.getTableId().getLevel();
        String libraryName = libraryEntity.getName();
        if ("project".equals(libraryType) || "application".equals(libraryType)) {
            List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, libraryType, null));
            if (list == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(36);
            }
            return list;
        }
        List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, libraryType, moduleName));
        if (list == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull ArtifactPointer artifactPointer, @NotNull Project project) {
        if (artifactPointer == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(38);
        }
        if (project == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(39);
        }
        return new ArtifactPackagingElement(project, artifactPointer);
    }

    @NotNull
    public PackagingElement<?> createLibraryFiles(@NotNull String libraryName, @NotNull String level, String moduleName) {
        if (libraryName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(40);
        }
        if (level == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(41);
        }
        return new LibraryPackagingElement(level, libraryName, moduleName);
    }

    @NotNull
    public CompositePackagingElement<?> createArchive(@NotNull @NonNls String archiveFileName) {
        if (archiveFileName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(42);
        }
        return new ArchivePackagingElement(archiveFileName);
    }

    @Nullable
    private static PackagingElement<?> findArchiveOrDirectoryByName(@NotNull CompositePackagingElement<?> parent, @NotNull String name) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(43);
        }
        if (name == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(44);
        }
        for (PackagingElement element : parent.getChildren()) {
            if ((!(element instanceof ArchivePackagingElement) || !((ArchivePackagingElement)element).getArchiveFileName().equals(name)) && (!(element instanceof DirectoryPackagingElement) || !((DirectoryPackagingElement)element).getDirectoryName().equals(name))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static String suggestFileName(@NotNull CompositePackagingElement<?> parent, @NonNls @NotNull String prefix, @NonNls @NotNull String suffix) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(45);
        }
        if (prefix == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(46);
        }
        if (suffix == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(47);
        }
        String name = prefix + suffix;
        int i = 2;
        while (PackagingElementFactoryImpl.findArchiveOrDirectoryByName(parent, name) != null) {
            name = prefix + i++ + suffix;
        }
        String string = name;
        if (string == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    public PackagingElement<?> createDirectoryCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(49);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(50);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, new DirectoryCopyPackagingElement(filePath));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(51);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectoryWithParentDirectories(@NotNull String jarPath, @NotNull String pathInJar, @NotNull String relativeOutputPath) {
        if (jarPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(52);
        }
        if (pathInJar == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(53);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(54);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, new ExtractedDirectoryPackagingElement(jarPath, pathInJar));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(55);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectory(@NotNull VirtualFile jarEntry) {
        if (jarEntry == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(56);
        }
        LOG.assertTrue(jarEntry.getFileSystem() instanceof JarFileSystem, (Object)("Expected file from JAR but file from " + String.valueOf(jarEntry.getFileSystem()) + " found"));
        String fullPath = jarEntry.getPath();
        int jarEnd = fullPath.indexOf("!/");
        return new ExtractedDirectoryPackagingElement(fullPath.substring(0, jarEnd), fullPath.substring(jarEnd + 1));
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(57);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(58);
        }
        PackagingElement<?> packagingElement = this.createFileCopyWithParentDirectories(filePath, relativeOutputPath, null);
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(59);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath, @Nullable String outputFileName) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(60);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(61);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, this.createFileCopy(filePath, outputFileName));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(62);
        }
        return packagingElement;
    }

    public PackagingElement<?> createFileCopy(@NotNull String filePath, String outputFileName) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(63);
        }
        return new FileCopyPackagingElement(filePath, outputFileName);
    }

    @NotNull
    public PackagingElement<?> createParentDirectories(@NotNull String relativeOutputPath, @NotNull PackagingElement<?> element) {
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(64);
        }
        if (element == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(65);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, Collections.singletonList(element)).get(0);
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(66);
        }
        return packagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createParentDirectories(@NotNull String relativeOutputPath, @NotNull List<? extends PackagingElement<?>> elements) {
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(67);
        }
        if (elements == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(68);
        }
        if ((relativeOutputPath = StringUtil.trimStart((String)relativeOutputPath, (String)"/")).isEmpty()) {
            List<? extends PackagingElement<?>> list = elements;
            if (list == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(69);
            }
            return list;
        }
        int slash = relativeOutputPath.indexOf(47);
        if (slash == -1) {
            slash = relativeOutputPath.length();
        }
        String rootName = relativeOutputPath.substring(0, slash);
        String pathTail = relativeOutputPath.substring(slash);
        DirectoryPackagingElement root = this.createDirectory(rootName);
        CompositePackagingElement<?> last = this.getOrCreateDirectory(root, pathTail);
        last.addOrFindChildren(elements);
        List<DirectoryPackagingElement> list = Collections.singletonList(root);
        if (list == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(70);
        }
        return list;
    }

    public static CompositePackagingElement<?> createDirectoryOrArchiveWithParents(@NotNull String path, boolean archive) {
        if (path == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(71);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        CompositeElementWithManifest element = archive ? new ArchivePackagingElement(fileName) : new DirectoryPackagingElement(fileName);
        return (CompositePackagingElement)PackagingElementFactoryImpl.getInstance().createParentDirectories(parentPath, (PackagingElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 24, 25, 26, 27, 28, 29, 30, 31, 35, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 50, 52, 53, 54, 56, 57, 58, 60, 61, 63, 64, 65, 67, 68, 71 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 7: 
            case 25: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 9: 
            case 11: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectoryPath";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePath";
                break;
            }
            case 20: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEntity";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPointer";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFileName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 49: 
            case 57: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 50: 
            case 54: 
            case 58: 
            case 61: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeOutputPath";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarEntry";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonCompositeElementTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexElementTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeElementTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElementTypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDirectoryOrArchive";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryElements";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryCopyWithParentDirectories";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractedDirectoryWithParentDirectories";
                break;
            }
            case 59: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileCopyWithParentDirectories";
                break;
            }
            case 66: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateArchive";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addFileCopy";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectoryOrArchive";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createModuleOutput";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createModuleSource";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createTestModuleOutput";
                break;
            }
            case 31: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryElements";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryFiles";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createArchive";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findArchiveOrDirectoryByName";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryCopyWithParentDirectories";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedDirectoryWithParentDirectories";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedDirectory";
                break;
            }
            case 57: 
            case 58: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createFileCopyWithParentDirectories";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createFileCopy";
                break;
            }
            case 64: 
            case 65: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirectories";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryOrArchiveWithParents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 24, 25, 26, 27, 28, 29, 30, 31, 35, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 49, 50, 52, 53, 54, 56, 57, 58, 60, 61, 63, 64, 65, 67, 68, 71 -> new IllegalArgumentException(string);
        };
    }

    private static class ArtifactRootElementType
    extends PackagingElementType<ArtifactRootElement<?>> {
        protected ArtifactRootElementType() {
            super("root", () -> "");
        }

        public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
            if (context == null) {
                ArtifactRootElementType.$$$reportNull$$$0(0);
            }
            if (artifact == null) {
                ArtifactRootElementType.$$$reportNull$$$0(1);
            }
            return false;
        }

        @NotNull
        public List<? extends ArtifactRootElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
            if (context == null) {
                ArtifactRootElementType.$$$reportNull$$$0(2);
            }
            if (artifact == null) {
                ArtifactRootElementType.$$$reportNull$$$0(3);
            }
            if (parent == null) {
                ArtifactRootElementType.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException("'create' not implemented in " + ((Object)((Object)this)).getClass().getName());
        }

        @NotNull
        public ArtifactRootElement<?> createEmpty(@NotNull Project project) {
            if (project == null) {
                ArtifactRootElementType.$$$reportNull$$$0(5);
            }
            return new ArtifactRootElementImpl();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canCreate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseAndCreate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createEmpty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

