/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTask;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProviderBase;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BuildArtifactsBeforeRunTaskProvider
extends BuildArtifactsBeforeRunTaskProviderBase<BuildArtifactsBeforeRunTask> {
    @NonNls
    public static final String BUILD_ARTIFACTS_ID = "BuildArtifacts";
    public static final Key<BuildArtifactsBeforeRunTask> ID = Key.create((String)"BuildArtifacts");

    public BuildArtifactsBeforeRunTaskProvider(Project project) {
        super(BuildArtifactsBeforeRunTask.class, project);
    }

    public Key<BuildArtifactsBeforeRunTask> getId() {
        return ID;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public String getName() {
        return JavaCompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
    }

    public Icon getTaskIcon(BuildArtifactsBeforeRunTask task2) {
        List<ArtifactPointer> pointers = task2.getArtifactPointers();
        if (pointers == null || pointers.isEmpty()) {
            return this.getIcon();
        }
        Artifact artifact = pointers.get(0).getArtifact();
        if (artifact == null) {
            return this.getIcon();
        }
        return artifact.getArtifactType().getIcon();
    }

    public String getDescription(BuildArtifactsBeforeRunTask task2) {
        List<ArtifactPointer> pointers = task2.getArtifactPointers();
        if (pointers.isEmpty()) {
            return JavaCompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
        }
        if (pointers.size() == 1) {
            return JavaCompilerBundle.message((String)"build.artifacts.before.run.description.single", (Object[])new Object[]{pointers.get(0).getArtifactName()});
        }
        return JavaCompilerBundle.message((String)"build.artifacts.before.run.description.multiple", (Object[])new Object[]{pointers.size()});
    }

    public static void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, Project project, @NotNull Artifact artifact, boolean enable) {
        BeforeRunTaskProvider provider;
        if (runConfigurationEditorComponent == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if ((provider = BuildArtifactsBeforeRunTaskProvider.getProvider((Project)project, ID)) != null) {
            ((BuildArtifactsBeforeRunTaskProvider)provider).setBuildArtifactBeforeRunOption(runConfigurationEditorComponent, artifact, enable);
        }
    }

    public static void setBuildArtifactBeforeRun(@NotNull Project project, @NotNull RunConfiguration configuration, @NotNull Artifact artifact) {
        if (project == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
        ArrayList<BuildArtifactsBeforeRunTask> buildArtifactsTasks = new ArrayList<BuildArtifactsBeforeRunTask>(runManager.getBeforeRunTasks(configuration, ID));
        if (runManager.getBeforeRunTasks(configuration, ID).isEmpty()) {
            BuildArtifactsBeforeRunTask task2 = new BuildArtifactsBeforeRunTask(project);
            buildArtifactsTasks.add(task2);
            ArrayList<BuildArtifactsBeforeRunTask> tasks = new ArrayList<BuildArtifactsBeforeRunTask>(runManager.getBeforeRunTasks(configuration));
            tasks.add(task2);
            runManager.setBeforeRunTasks(configuration, tasks);
        }
        for (BuildArtifactsBeforeRunTask task3 : buildArtifactsTasks) {
            task3.setEnabled(true);
            task3.addArtifact(artifact);
        }
    }

    @Override
    @NotNull
    protected BuildArtifactsBeforeRunTask doCreateTask(Project project) {
        return new BuildArtifactsBeforeRunTask(project);
    }

    @Override
    @NotNull
    protected ProjectTask createProjectTask(@NotNull Project project, @NotNull List<? extends Artifact> artifacts) {
        if (project == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (artifacts == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        ProjectTask projectTask = ProjectTaskManager.getInstance((Project)project).createBuildTask(true, (ProjectModelBuildableElement[])artifacts.toArray(new Artifact[0]));
        if (projectTask == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        return projectTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationEditorComponent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setBuildArtifactBeforeRunOption";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBuildArtifactBeforeRun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProjectTask";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

