/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.ModuleLibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryElementPresentation
extends PackagingElementPresentation {
    @NlsSafe
    private final String myLevel;
    @NlsSafe
    private final String myModuleName;
    private final Library myLibrary;
    @NlsSafe
    private final String myLibraryName;
    private final ArtifactEditorContext myContext;

    public LibraryElementPresentation(String libraryName, String level, @Nullable String moduleName, Library library, ArtifactEditorContext context) {
        this.myLevel = level;
        this.myModuleName = moduleName;
        this.myLibrary = library;
        this.myLibraryName = libraryName;
        this.myContext = context;
    }

    public String getPresentableName() {
        return this.myLibraryName;
    }

    public boolean canNavigateToSource() {
        return this.myLibrary != null;
    }

    public void navigateToSource() {
        this.myContext.selectLibrary(this.myLibrary);
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        if (presentationData == null) {
            LibraryElementPresentation.$$$reportNull$$$0(0);
        }
        if (this.myLibrary != null) {
            presentationData.setIcon(PlatformIcons.LIBRARY_ICON);
            presentationData.addText(this.getPresentableName(), mainAttributes);
            presentationData.addText(LibraryElementPresentation.getLibraryTableComment(this.myLibrary), commentAttributes);
        } else {
            presentationData.addText(this.getPresentableName() + " (" + (this.myModuleName != null ? JavaCompilerBundle.message((String)"label.library.element.module", (Object[])new Object[]{this.myModuleName}) : this.myLevel) + ")", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public int getWeight() {
        return 30;
    }

    public static String getLibraryTableDisplayName(Library library) {
        LibraryTable table = library.getTable();
        LibraryTablePresentation presentation = table != null ? table.getPresentation() : ModuleLibraryTableBase.MODULE_LIBRARY_TABLE_PRESENTATION;
        return presentation.getDisplayName(false);
    }

    @NlsContexts.Label
    public static String getLibraryTableComment(Library library) {
        String displayName;
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            displayName = libraryTable.getPresentation().getDisplayName(false);
        } else {
            Module module = ((LibraryEx)library).getModule();
            String tableName = LibraryElementPresentation.getLibraryTableDisplayName(library);
            displayName = module != null ? "'" + module.getName() + "' " + tableName : tableName;
        }
        return " (" + displayName + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/packaging/impl/ui/LibraryElementPresentation", "render"));
    }
}

