/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConditionalCanBeOptionalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            ConditionalCanBeOptionalInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ConditionalCanBeOptionalInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitConditionalExpression(@NotNull PsiConditionalExpression ternary) {
                boolean mayChangeSemantics;
                List references;
                TernaryNullCheck ternaryNullCheck;
                if (ternary == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((ternaryNullCheck = TernaryNullCheck.from(ternary)) == null) {
                    return;
                }
                PsiVariable variable = ternaryNullCheck.myVariable;
                PsiExpression nullBranch = ternaryNullCheck.myNullBranch;
                PsiExpression notNullBranch = ternaryNullCheck.myNotNullBranch;
                if (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)nullBranch)) {
                    if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nullBranch, arg_0 -> ((PsiVariable)variable).equals(arg_0))) {
                        return;
                    }
                }
                if ((references = VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)notNullBranch)).isEmpty() || variable instanceof PsiField && !ContainerUtil.exists((Iterable)references, ExpressionUtil::isEffectivelyUnqualified)) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)notNullBranch, arg_0 -> ((PsiVariable)variable).equals(arg_0))) {
                    return;
                }
                if (!1.areTypesCompatible(nullBranch, notNullBranch)) {
                    return;
                }
                boolean bl = mayChangeSemantics = !ExpressionUtils.isNullLiteral((PsiExpression)nullBranch) && NullabilityUtil.getExpressionNullability((PsiExpression)notNullBranch, (boolean)true) != Nullability.NOT_NULL;
                if (!isOnTheFly && mayChangeSemantics) {
                    return;
                }
                holder.registerProblem((PsiElement)ternary.getCondition(), JavaBundle.message((String)"inspection.message.can.be.replaced.with.optional.of.nullable", (Object[])new Object[0]), mayChangeSemantics ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceConditionWithOptionalFix(mayChangeSemantics)});
            }

            private static boolean areTypesCompatible(PsiExpression nullBranch, PsiExpression notNullBranch) {
                PsiType notNullType = ((PsiExpression)notNullBranch.copy()).getType();
                PsiType nullType = ((PsiExpression)nullBranch.copy()).getType();
                if (nullType == null || notNullType == null) {
                    return false;
                }
                if (nullType.isAssignableFrom(notNullType)) {
                    return true;
                }
                if (nullType.equals(PsiTypes.nullType())) {
                    return true;
                }
                return OptionalUtil.isOptionalEmptyCall((PsiExpression)nullBranch) && TypeUtils.isOptional((PsiType)notNullType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ternary", "com/intellij/codeInspection/ConditionalCanBeOptionalInspection$1", "visitConditionalExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class TernaryNullCheck {
        final PsiVariable myVariable;
        final PsiExpression myNullBranch;
        final PsiExpression myNotNullBranch;

        private TernaryNullCheck(PsiVariable variable, PsiExpression nullBranch, PsiExpression notNullBranch) {
            this.myVariable = variable;
            this.myNullBranch = nullBranch;
            this.myNotNullBranch = notNullBranch;
        }

        @Contract(value="null -> null")
        @Nullable
        public static TernaryNullCheck from(@Nullable PsiConditionalExpression ternary) {
            PsiExpression notNullBranch;
            if (ternary == null) {
                return null;
            }
            PsiExpression condition = ternary.getCondition();
            boolean isNull = true;
            PsiReferenceExpression ref = ExpressionUtils.getReferenceExpressionFromNullComparison((PsiExpression)condition, (boolean)true);
            if (ref == null) {
                isNull = false;
                ref = ExpressionUtils.getReferenceExpressionFromNullComparison((PsiExpression)condition, (boolean)false);
            }
            if (ref == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (variable == null || variable instanceof PsiField && !ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)ref)) {
                return null;
            }
            PsiExpression nullBranch = isNull ? ternary.getThenExpression() : ternary.getElseExpression();
            PsiExpression psiExpression = notNullBranch = isNull ? ternary.getElseExpression() : ternary.getThenExpression();
            if (nullBranch == null || notNullBranch == null) {
                return null;
            }
            return new TernaryNullCheck(variable, nullBranch, notNullBranch);
        }
    }

    private static class ReplaceConditionWithOptionalFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myChangesSemantics;

        ReplaceConditionWithOptionalFix(boolean changesSemantics) {
            this.myChangesSemantics = changesSemantics;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + (this.myChangesSemantics ? JavaBundle.message((String)"quickfix.text.suffix.may.change.semantics", (Object[])new Object[0]) : "");
            if (string == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.replace.with.optional.of.nullable.chain", (Object[])new Object[0]);
            if (string == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiConditionalExpression ternary;
            TernaryNullCheck ternaryNullCheck;
            if (project == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceConditionWithOptionalFix.$$$reportNull$$$0(4);
            }
            if ((ternaryNullCheck = TernaryNullCheck.from(ternary = (PsiConditionalExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiConditionalExpression.class}))) == null) {
                return;
            }
            PsiVariable variable = ternaryNullCheck.myVariable;
            String name = variable.getName();
            if (name == null) {
                return;
            }
            String inLambdaName = new VariableNameGenerator((PsiElement)ternary, VariableKind.PARAMETER).byName(new String[]{name}).byType(variable.getType()).generate(true);
            PsiExpression nullBranch = ternaryNullCheck.myNullBranch;
            PsiExpression notNullBranch = ternaryNullCheck.myNotNullBranch;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            for (Object reference : VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)nullBranch)) {
                if (!ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)reference)) continue;
                PsiElement result = ct.replace((PsiElement)reference, "null");
                if (nullBranch != reference) continue;
                nullBranch = (PsiExpression)result;
            }
            String origExpression = null;
            for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)notNullBranch)) {
                PsiExpression qualifier = reference.getQualifierExpression();
                if (qualifier != null) {
                    if (!ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)reference)) continue;
                    if (origExpression == null) {
                        origExpression = ct.text((PsiElement)reference);
                    }
                    ct.delete((PsiElement)qualifier);
                }
                ExpressionUtils.bindReferenceTo((PsiReferenceExpression)reference, (String)inLambdaName);
            }
            PsiLambdaExpression trueLambda = (PsiLambdaExpression)factory.createExpressionFromText("(" + variable.getType().getCanonicalText() + " " + inLambdaName + ")->" + ct.text((PsiElement)notNullBranch), (PsiElement)ternary);
            PsiParameter lambdaParameter = Objects.requireNonNull(trueLambda.getParameterList().getParameter(0));
            PsiExpression trueBody = Objects.requireNonNull((PsiExpression)trueLambda.getBody());
            String ofNullableText = "java.util.Optional.ofNullable(" + (origExpression == null ? name : origExpression) + ")";
            String replacement = OptionalRefactoringUtil.generateOptionalUnwrap((String)ofNullableText, (PsiVariable)lambdaParameter, (PsiExpression)trueBody, (PsiExpression)((PsiExpression)ct.markUnchanged((PsiElement)nullBranch)), (PsiType)ternary.getType(), (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)nullBranch) ? 1 : 0) != 0);
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)ternary, replacement);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection$ReplaceConditionWithOptionalFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ConditionalCanBeOptionalInspection$ReplaceConditionWithOptionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

