/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.JavaBundle;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.migration.TryWithIdenticalCatchesInspection;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DuplicateBranchesInSwitchInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(DuplicateBranchesInSwitchInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(0);
        }
        return new DuplicateBranchesVisitor(holder);
    }

    @NotNull
    private static Collection<List<Rule>> collectProbablySimilarRules(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock switchBody;
        if (switchBlock == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(1);
        }
        if ((switchBody = switchBlock.getBody()) == null) {
            List<List<Rule>> list = Collections.emptyList();
            if (list == null) {
                DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(2);
            }
            return list;
        }
        Int2ObjectOpenHashMap rulesByHash = new Int2ObjectOpenHashMap();
        ArrayList<String> commentTexts = new ArrayList<String>();
        for (PsiElement element = switchBody.getFirstChild(); element != null; element = element.getNextSibling()) {
            PsiSwitchLabeledRuleStatement ruleStatement;
            PsiStatement body;
            TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)element, commentTexts);
            if (!(element instanceof PsiSwitchLabeledRuleStatement) || (body = (ruleStatement = (PsiSwitchLabeledRuleStatement)element).getBody()) == null) continue;
            element = DuplicateBranchesInSwitchInspection.collectCommentsUntilNewLine(commentTexts, element);
            Rule rule = new Rule((PsiElement)ruleStatement, ruleStatement, body, ArrayUtilRt.toStringArray(commentTexts));
            commentTexts.clear();
            ((List)rulesByHash.computeIfAbsent(rule.hash(), __ -> new ArrayList())).add(rule);
        }
        return new ArrayList<List<Rule>>((Collection<List<Rule>>)rulesByHash.values());
    }

    @NotNull
    private static PsiElement collectCommentsUntilNewLine(List<String> commentTexts, PsiElement element) {
        ArrayList mightBeCommentTexts = new ArrayList();
        for (PsiElement currentSibling = element.getNextSibling(); currentSibling != null; currentSibling = currentSibling.getNextSibling()) {
            if (currentSibling instanceof PsiWhiteSpace) {
                PsiWhiteSpace whiteSpace = (PsiWhiteSpace)currentSibling;
                if (!whiteSpace.textContains('\n')) continue;
                commentTexts.addAll(mightBeCommentTexts);
                PsiElement psiElement = currentSibling;
                if (psiElement == null) {
                    DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(3);
                }
                return psiElement;
            }
            if (currentSibling instanceof PsiComment) {
                TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)currentSibling, mightBeCommentTexts);
                continue;
            }
            PsiElement psiElement = currentSibling;
            if (psiElement == null) {
                DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @NotNull
    static Collection<List<Branch>> collectProbablySimilarBranches(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock body;
        if (switchBlock == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(6);
        }
        if ((body = switchBlock.getBody()) == null) {
            List<List<Branch>> list = Collections.emptyList();
            if (list == null) {
                DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<PsiStatement> statementList = null;
        Comments comments = new Comments();
        Branch previousBranch = null;
        Int2ObjectOpenHashMap branchesByHash = new Int2ObjectOpenHashMap();
        for (PsiElement child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement switchLabel = (PsiSwitchLabelStatement)child;
                previousBranch = DuplicateBranchesInSwitchInspection.addBranchToMap((Int2ObjectMap<List<Branch>>)branchesByHash, statementList, DuplicateBranchesInSwitchInspection.hasImplicitBreak((PsiStatement)switchLabel), comments, previousBranch);
                statementList = null;
                comments.addFrom((PsiStatement)switchLabel);
                continue;
            }
            if (child instanceof PsiStatement) {
                PsiStatement statement = (PsiStatement)child;
                if (statementList == null) {
                    statementList = new ArrayList<PsiStatement>();
                }
                statementList.add(statement);
                comments.addFrom(statement);
                continue;
            }
            comments.addPending(child);
        }
        DuplicateBranchesInSwitchInspection.addBranchToMap((Int2ObjectMap<List<Branch>>)branchesByHash, statementList, true, comments, previousBranch);
        List<List<Branch>> list = List.copyOf(branchesByHash.values());
        if (list == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private static Branch addBranchToMap(@NotNull Int2ObjectMap<List<Branch>> branchesByHash, @Nullable List<PsiStatement> statementList, boolean hasImplicitBreak, @NotNull Comments comments, @Nullable Branch previousBranch) {
        if (branchesByHash == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(9);
        }
        if (comments == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(10);
        }
        if (statementList == null || statementList.isEmpty()) {
            return previousBranch;
        }
        PsiStatement first = statementList.getFirst();
        PsiSwitchLabelStatement[] labels = Branch.collectLabels(first);
        if (labels.length == 0) {
            return previousBranch;
        }
        Branch branch = new Branch((PsiElement)first, labels, statementList, hasImplicitBreak, comments.fetchTexts());
        if (!(branch.canFallThrough() || previousBranch != null && previousBranch.canFallThrough())) {
            int hash = branch.hash();
            ArrayList<Branch> branches = (ArrayList<Branch>)branchesByHash.get(hash);
            if (branches == null) {
                branches = new ArrayList<Branch>();
                branchesByHash.put(hash, branches);
            }
            branches.add(branch);
        }
        return branch;
    }

    static LevelType canBeJoined(@NotNull BranchBase<?> branch, @NotNull BranchBase<?> otherBranch) {
        Match otherMatch;
        if (branch == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(11);
        }
        if (otherBranch == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(12);
        }
        if (branch.isSimpleExit() != otherBranch.isSimpleExit() || branch.canFallThrough() != otherBranch.canFallThrough() || branch.effectiveLength() != otherBranch.effectiveLength()) {
            return LevelType.NO;
        }
        if (!branch.canBeJoinedWith(otherBranch)) {
            return LevelType.NO;
        }
        Match match = branch.match(otherBranch);
        if (match != null && (otherMatch = otherBranch.match(branch)) != null) {
            if (!Arrays.equals(branch.myCommentTexts, otherBranch.myCommentTexts)) {
                return LevelType.INFO;
            }
            return ReturnValue.areEquivalent((ReturnValue)match.getReturnValue(), (ReturnValue)otherMatch.getReturnValue()) ? LevelType.WARN : LevelType.NO;
        }
        return LevelType.NO;
    }

    private static boolean hasImplicitBreak(@NotNull PsiStatement statement) {
        if (statement == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(13);
        }
        while (statement instanceof PsiSwitchLabelStatement) {
            statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
        return statement == null || DuplicateBranchesInSwitchInspection.isBreakWithoutLabel(statement);
    }

    @Contract(value="null -> false")
    private static boolean isBreakWithoutLabel(@Nullable PsiStatement statement) {
        PsiBreakStatement breakStatement;
        return statement instanceof PsiBreakStatement && (breakStatement = (PsiBreakStatement)statement).getLabelIdentifier() == null;
    }

    @Contract(value="_,null -> false")
    private static boolean isRedundantComment(@NotNull @Unmodifiable Set<String> existingComments, @Nullable PsiElement element) {
        if (existingComments == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(14);
        }
        if (element instanceof PsiComment) {
            PsiComment comment = (PsiComment)element;
            String text = TryWithIdenticalCatchesInspection.getCommentText((PsiComment)comment);
            return text.isEmpty() || existingComments.contains(text);
        }
        return false;
    }

    private static boolean hasPattern(PsiSwitchLabelStatementBase[] labels) {
        return labels != null && Arrays.stream(labels).map(t -> t.getCaseLabelElementList()).flatMap(t -> t != null ? Arrays.stream(t.getElements()) : Stream.empty()).anyMatch(e -> e instanceof PsiPattern);
    }

    @NotNull
    private static DuplicatesFinder createFinder(PsiElement @NotNull [] elements, @NotNull @NotNull List<@NotNull PsiVariable> variables) {
        if (variables == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(15);
        }
        if (elements == null) {
            DuplicateBranchesInSwitchInspection.$$$reportNull$$$0(16);
        }
        Project project = elements[0].getProject();
        InputVariables inputVariables = new InputVariables(variables, project, new LocalSearchScope(elements), false, Collections.emptySet());
        return new DuplicatesFinder(elements, inputVariables, null, Collections.emptyList());
    }

    static void copyCaseValues(@Nullable PsiCaseLabelElementList from, @Nullable PsiCaseLabelElementList to, boolean mergeWithDefault) {
        if (from == null || to == null) {
            return;
        }
        for (PsiCaseLabelElement caseValue : from.getElements()) {
            if (mergeWithDefault) {
                to.addBefore((PsiElement)caseValue, to.getFirstChild());
                continue;
            }
            to.addAfter((PsiElement)caseValue, to.getLastChild());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesByHash";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranch";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingComments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProbablySimilarRules";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommentsUntilNewLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProbablySimilarBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectProbablySimilarRules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectProbablySimilarBranches";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addBranchToMap";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canBeJoined";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitBreak";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isRedundantComment";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFinder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class DuplicateBranchesVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        DuplicateBranchesVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement switchStatement) {
            if (switchStatement == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(switchStatement);
            this.visitSwitchBlock((PsiSwitchBlock)switchStatement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression switchExpression) {
            if (switchExpression == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(1);
            }
            super.visitSwitchExpression(switchExpression);
            this.visitSwitchBlock((PsiSwitchBlock)switchExpression);
        }

        private void visitSwitchBlock(PsiSwitchBlock switchBlock) {
            if (SwitchUtils.isRuleFormatSwitch((PsiSwitchBlock)switchBlock)) {
                this.visitEnhancedSwitch(switchBlock);
                return;
            }
            for (List<Branch> branches : DuplicateBranchesInSwitchInspection.collectProbablySimilarBranches(switchBlock)) {
                this.registerProblems(branches);
            }
        }

        private void visitEnhancedSwitch(@NotNull PsiSwitchBlock switchBlock) {
            if (switchBlock == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(2);
            }
            Collection<List<Rule>> probablySimilarRules = DuplicateBranchesInSwitchInspection.collectProbablySimilarRules(switchBlock);
            for (List<Rule> rules : probablySimilarRules) {
                this.registerProblems(rules);
            }
        }

        void registerProblems(List<? extends BranchBase<?>> branches) {
            int size = branches.size();
            if (size > 1) {
                BranchBase<?> branch;
                int index;
                boolean[] isDuplicate = new boolean[size];
                int defaultIndex = ContainerUtil.indexOf(branches, BranchBase::isDefault);
                if (defaultIndex >= 0) {
                    BranchBase<?> defaultBranch = branches.get(defaultIndex);
                    for (index = 0; index < size; ++index) {
                        LevelType state;
                        if (index == defaultIndex || (state = DuplicateBranchesInSwitchInspection.canBeJoined(defaultBranch, branch = branches.get(index))) == LevelType.NO) continue;
                        isDuplicate[defaultIndex] = true;
                        isDuplicate[index] = true;
                        this.highlightDefaultDuplicate(branch, defaultBranch, state);
                    }
                }
                int compareCount = 0;
                for (index = 0; index < size - 1; ++index) {
                    if (isDuplicate[index]) continue;
                    branch = branches.get(index);
                    for (int otherIndex = index + 1; otherIndex < size; ++otherIndex) {
                        if (isDuplicate[otherIndex]) continue;
                        if (++compareCount > 200) {
                            return;
                        }
                        BranchBase<?> otherBranch = branches.get(otherIndex);
                        LevelType state = DuplicateBranchesInSwitchInspection.canBeJoined(branch, otherBranch);
                        if (state != LevelType.NO) {
                            isDuplicate[otherIndex] = true;
                            LocalQuickFix fix = branch.mergeCasesFix(otherBranch);
                            if (fix != null) {
                                this.registerProblem(otherBranch, otherBranch.getCaseBranchMessage(), state, fix);
                            }
                        }
                        if ((state = DuplicateBranchesVisitor.canDominateAndJoin(branch, otherBranch)) == LevelType.NO) continue;
                        isDuplicate[otherIndex] = true;
                        Object otherLabel = otherBranch.myFirstLabel;
                        DeleteRedundantRuleFix fix = new DeleteRedundantRuleFix((SmartPsiElementPointer<PsiSwitchLabelStatementBase>)SmartPointerManager.createPointer(otherLabel));
                        this.registerProblem(branch, branch.getCaseBranchMessage(), state, new LocalQuickFix[]{fix});
                    }
                }
            }
        }

        @NotNull
        private static LevelType canDominateAndJoin(@NotNull BranchBase<?> branch, @NotNull BranchBase<?> otherBranch) {
            PsiTypeTestPattern otherBranchPattern;
            PsiTypeTestPattern branchPattern;
            if (branch == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(3);
            }
            if (otherBranch == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(4);
            }
            if (branch.isDefault() || otherBranch.isDefault()) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(5);
                }
                return levelType;
            }
            if (branch.canFallThrough() || otherBranch.canFallThrough()) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(6);
                }
                return levelType;
            }
            if (branch.isSimpleExit() != otherBranch.isSimpleExit() || branch.effectiveLength() != otherBranch.effectiveLength()) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(7);
                }
                return levelType;
            }
            if (branch.effectiveLength() == 0) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(8);
                }
                return levelType;
            }
            if (!branch.isNearby(otherBranch)) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(9);
                }
                return levelType;
            }
            if (!(branch instanceof Rule)) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(10);
                }
                return levelType;
            }
            Rule branchRule = (Rule)branch;
            if (!(otherBranch instanceof Rule)) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(11);
                }
                return levelType;
            }
            Rule otherBranchRule = (Rule)otherBranch;
            if (((PsiSwitchLabeledRuleStatement)branchRule.myFirstLabel).getGuardExpression() != null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(12);
                }
                return levelType;
            }
            if (((PsiSwitchLabeledRuleStatement)otherBranchRule.myFirstLabel).getGuardExpression() != null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(13);
                }
                return levelType;
            }
            PsiCaseLabelElementList branchList = ((PsiSwitchLabeledRuleStatement)branchRule.myFirstLabel).getCaseLabelElementList();
            if (branchList == null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(14);
                }
                return levelType;
            }
            if (branchList.getElementCount() != 1) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(15);
                }
                return levelType;
            }
            PsiCaseLabelElement psiCaseLabelElement = branchList.getElements()[0];
            if (!(psiCaseLabelElement instanceof PsiTypeTestPattern) || (branchPattern = (PsiTypeTestPattern)psiCaseLabelElement).getPatternVariable() == null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(16);
                }
                return levelType;
            }
            PsiCaseLabelElementList otherBranchList = ((PsiSwitchLabeledRuleStatement)otherBranchRule.myFirstLabel).getCaseLabelElementList();
            if (otherBranchList == null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(17);
                }
                return levelType;
            }
            if (otherBranchList.getElementCount() != 1) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(18);
                }
                return levelType;
            }
            PsiCaseLabelElement psiCaseLabelElement2 = otherBranchList.getElements()[0];
            if (!(psiCaseLabelElement2 instanceof PsiTypeTestPattern) || (otherBranchPattern = (PsiTypeTestPattern)psiCaseLabelElement2).getPatternVariable() == null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(19);
                }
                return levelType;
            }
            if (!JavaPsiPatternUtil.dominates((PsiCaseLabelElement)otherBranchPattern, (PsiCaseLabelElement)branchPattern)) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(20);
                }
                return levelType;
            }
            Match match = DuplicateBranchesVisitor.isRuleDuplicate(branchRule, otherBranchRule, branchPattern, otherBranchPattern);
            if (match == null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(21);
                }
                return levelType;
            }
            Match otherMatch = DuplicateBranchesVisitor.isRuleDuplicate(otherBranchRule, branchRule, otherBranchPattern, branchPattern);
            if (otherMatch == null) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(22);
                }
                return levelType;
            }
            if (!ReturnValue.areEquivalent((ReturnValue)match.getReturnValue(), (ReturnValue)otherMatch.getReturnValue())) {
                LevelType levelType = LevelType.NO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(23);
                }
                return levelType;
            }
            if (!Arrays.equals(branch.myCommentTexts, otherBranch.myCommentTexts)) {
                LevelType levelType = LevelType.INFO;
                if (levelType == null) {
                    DuplicateBranchesVisitor.$$$reportNull$$$0(24);
                }
                return levelType;
            }
            LevelType levelType = LevelType.WARN;
            if (levelType == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(25);
            }
            return levelType;
        }

        @Nullable
        private static Match isRuleDuplicate(@NotNull Rule branchRule, @NotNull Rule otherBranchRule, @NotNull PsiTypeTestPattern branchPattern, @NotNull PsiTypeTestPattern otherBranchPattern) {
            PsiPatternVariable patternVariable;
            if (branchRule == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(26);
            }
            if (otherBranchRule == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(27);
            }
            if (branchPattern == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(28);
            }
            if (otherBranchPattern == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(29);
            }
            if ((patternVariable = branchPattern.getPatternVariable()) == null) {
                return null;
            }
            PsiPatternVariable otherPatternVariable = otherBranchPattern.getPatternVariable();
            if (otherPatternVariable == null) {
                return null;
            }
            DuplicatesFinder finder = DuplicateBranchesInSwitchInspection.createFinder((PsiElement[])branchRule.myStatements, List.of(patternVariable));
            Match match = finder.isDuplicate((PsiElement)otherBranchRule.myStatements[0], true);
            if (match == null) {
                return null;
            }
            List values = match.getParameterValues((PsiVariable)patternVariable);
            if (values != null) {
                for (PsiElement value : values) {
                    PsiReferenceExpression referenceExpression;
                    if (value instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)value).resolve() == otherPatternVariable) continue;
                    return null;
                }
            }
            return match;
        }

        private void highlightDefaultDuplicate(@NotNull BranchBase<?> branch, BranchBase<?> defaultBranch, LevelType state) {
            if (branch == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(30);
            }
            ArrayList fixes = new ArrayList();
            LocalQuickFix deleteCaseFix = branch.deleteCaseFix();
            ContainerUtil.addIfNotNull(fixes, (Object)deleteCaseFix);
            LocalQuickFix mergeWithDefaultFix = branch.mergeWithDefaultFix(defaultBranch);
            ContainerUtil.addIfNotNull(fixes, (Object)mergeWithDefaultFix);
            if (!fixes.isEmpty()) {
                this.registerProblem(branch, branch.getDefaultBranchMessage(), state, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private void registerProblem(@NotNull BranchBase<?> duplicate, @NotNull @InspectionMessage String message, @NotNull LevelType state, LocalQuickFix ... fixes) {
            if (duplicate == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(31);
            }
            if (message == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(32);
            }
            if (state == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(33);
            }
            if (fixes == null) {
                DuplicateBranchesVisitor.$$$reportNull$$$0(34);
            }
            PsiStatement[] elements = duplicate.myStatements;
            if (state == LevelType.NO) {
                return;
            }
            if (state == LevelType.INFO && !this.myHolder.isOnTheFly()) {
                return;
            }
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.myHolder.getProject());
            ProblemDescriptor descriptor = state == LevelType.INFO ? inspectionManager.createProblemDescriptor((PsiElement)elements[0], (PsiElement)elements[elements.length - 1], message, ProblemHighlightType.INFORMATION, this.myHolder.isOnTheFly(), fixes) : inspectionManager.createProblemDescriptor((PsiElement)elements[0], message, this.myHolder.isOnTheFly(), fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            this.myHolder.registerProblem(descriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchBlock";
                    break;
                }
                case 3: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherBranch";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DuplicateBranchesVisitor";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchRule";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherBranchRule";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchPattern";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherBranchPattern";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicate";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DuplicateBranchesVisitor";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "canDominateAndJoin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSwitchExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitEnhancedSwitch";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canDominateAndJoin";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "isRuleDuplicate";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "highlightDefaultDuplicate";
                    break;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "registerProblem";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
            };
        }
    }

    private static class Rule
    extends BranchBase<PsiSwitchLabeledRuleStatement> {
        private final boolean myIsSimpleExit;
        private final boolean myCanMergeBranches;
        private final boolean myCanMergeWithDefaultBranch;

        Rule(@NotNull PsiElement context, @NotNull PsiSwitchLabeledRuleStatement rule, @NotNull PsiStatement body, String @NotNull [] commentTexts) {
            if (context == null) {
                Rule.$$$reportNull$$$0(0);
            }
            if (rule == null) {
                Rule.$$$reportNull$$$0(1);
            }
            if (body == null) {
                Rule.$$$reportNull$$$0(2);
            }
            if (commentTexts == null) {
                Rule.$$$reportNull$$$0(3);
            }
            super(context, (PsiSwitchLabelStatementBase[])new PsiSwitchLabeledRuleStatement[]{rule}, new PsiStatement[]{body}, commentTexts);
            this.myIsSimpleExit = body instanceof PsiExpressionStatement || body instanceof PsiThrowStatement;
            this.myCanMergeBranches = Rule.calculateCanMergeBranches((PsiSwitchLabelStatementBase)rule);
            this.myCanMergeWithDefaultBranch = SwitchUtils.isCaseNull((PsiSwitchLabelStatementBase)rule);
        }

        static boolean calculateCanMergeBranches(@NotNull PsiSwitchLabelStatementBase rule) {
            PsiCaseLabelElementList labelElementList;
            if (rule == null) {
                Rule.$$$reportNull$$$0(4);
            }
            if ((labelElementList = rule.getCaseLabelElementList()) == null) {
                return false;
            }
            Object[] elements = labelElementList.getElements();
            return !ContainerUtil.exists((Object[])elements, element -> {
                PsiExpression expr;
                return element instanceof PsiPattern && (!PsiUtil.isAvailable((JavaFeature)JavaFeature.UNNAMED_PATTERNS_AND_VARIABLES, (PsiElement)element) || JavaPsiPatternUtil.containsNamedPatternVariable((PsiCaseLabelElement)element)) || element instanceof PsiExpression && ExpressionUtils.isNullLiteral((PsiExpression)(expr = (PsiExpression)element));
            });
        }

        @Override
        boolean canMergeBranch() {
            return this.myCanMergeBranches;
        }

        @Override
        PsiSwitchLabelStatementBase[] getLabels() {
            return new PsiSwitchLabeledRuleStatement[]{(PsiSwitchLabeledRuleStatement)this.myFirstLabel};
        }

        @Override
        boolean isSimpleExit() {
            return this.myIsSimpleExit;
        }

        @Override
        boolean canFallThrough() {
            return false;
        }

        @Override
        @Nullable
        LocalQuickFix mergeCasesFix(BranchBase<?> otherBranch) {
            if (!otherBranch.canMergeBranch()) {
                return null;
            }
            String switchLabelText = this.getSwitchLabelText();
            if (switchLabelText == null) {
                return null;
            }
            return this.myCanMergeBranches ? new MergeRulesFix(switchLabelText) : null;
        }

        @Override
        @Nullable
        LocalQuickFix mergeWithDefaultFix(BranchBase<?> defaultBranch) {
            return this.myCanMergeWithDefaultBranch ? new MergeWithDefaultRuleFix() : null;
        }

        @Override
        @Nullable
        LocalQuickFix deleteCaseFix() {
            return this.myCanDeleteRedundantBranch ? new DeleteRedundantRuleFix() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentTexts";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$Rule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateCanMergeBranches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Comments {
        private final List<String> myTexts = new ArrayList<String>();
        private final List<PsiElement> myPending = new ArrayList<PsiElement>();

        private Comments() {
        }

        String[] fetchTexts() {
            String[] result = ArrayUtilRt.toStringArray(this.myTexts);
            this.myTexts.clear();
            return result;
        }

        void addFrom(PsiStatement statement) {
            for (PsiElement pending : this.myPending) {
                TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)pending, this.myTexts);
            }
            this.myPending.clear();
            TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)statement, this.myTexts);
        }

        void addPending(PsiElement element) {
            this.myPending.add(element);
        }
    }

    private static class Branch
    extends BranchBase<PsiSwitchLabelStatement> {
        private static final PsiSwitchLabelStatement[] EMPTY_LABELS_ARRAY = new PsiSwitchLabelStatement[0];
        private final boolean myIsSimpleExit;
        private final boolean myCanFallThrough;
        private final boolean myCanMergeBranch;
        private final boolean myHasSingleNullCase;
        private final boolean myCanCopyCaseValues;
        private final PsiSwitchLabelStatement @NotNull [] myLabels;

        Branch(@NotNull PsiElement context, PsiSwitchLabelStatement @NotNull [] labels, @NotNull List<PsiStatement> statementList, boolean hasImplicitBreak, String @NotNull [] comments) {
            if (context == null) {
                Branch.$$$reportNull$$$0(0);
            }
            if (statementList == null) {
                Branch.$$$reportNull$$$0(1);
            }
            if (labels == null) {
                Branch.$$$reportNull$$$0(2);
            }
            if (comments == null) {
                Branch.$$$reportNull$$$0(3);
            }
            super(context, (PsiSwitchLabelStatementBase[])labels, Branch.statementsWithoutTrailingBreak(statementList), comments);
            int lastIndex = statementList.size() - 1;
            PsiStatement lastStatement = statementList.get(lastIndex);
            this.myCanFallThrough = !hasImplicitBreak && ControlFlowUtils.statementMayCompleteNormally((PsiStatement)lastStatement);
            this.myIsSimpleExit = lastIndex == 0 && Branch.isSimpleExit(lastStatement);
            this.myCanMergeBranch = Branch.calculateCanMergeBranches(labels);
            this.myHasSingleNullCase = ContainerUtil.exists((Object[])labels, SwitchUtils::isCaseNull);
            this.myCanCopyCaseValues = ContainerUtil.all((Object[])labels, label -> Rule.calculateCanMergeBranches((PsiSwitchLabelStatementBase)label));
            this.myLabels = labels;
        }

        @Override
        boolean canFallThrough() {
            return this.myCanFallThrough;
        }

        private static boolean calculateCanMergeBranches(PsiSwitchLabelStatement @NotNull [] labels) {
            if (labels == null) {
                Branch.$$$reportNull$$$0(4);
            }
            for (PsiSwitchLabelStatement label : labels) {
                PsiCaseLabelElement[] elements;
                PsiCaseLabelElementList labelElementList = label.getCaseLabelElementList();
                if (labelElementList == null) continue;
                for (PsiCaseLabelElement element : elements = labelElementList.getElements()) {
                    if (!(element instanceof PsiPattern) || !JavaPsiPatternUtil.containsNamedPatternVariable((PsiCaseLabelElement)element)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        boolean canMergeBranch() {
            return this.myCanMergeBranch;
        }

        @Override
        PsiSwitchLabelStatementBase[] getLabels() {
            return this.myLabels;
        }

        boolean canCopyCaseValues(Branch other) {
            if (!this.myCanCopyCaseValues) {
                return false;
            }
            if (!DuplicateBranchesInSwitchInspection.hasPattern(this.getLabels())) {
                return true;
            }
            if (other.getLabels().length > 1 || this.getLabels().length > 1) {
                return false;
            }
            PsiExpression myGuardExpression = ((PsiSwitchLabelStatement)this.myFirstLabel).getGuardExpression();
            PsiExpression otherGuardExpression = ((PsiSwitchLabelStatement)other.myFirstLabel).getGuardExpression();
            if (myGuardExpression == null && otherGuardExpression != null || myGuardExpression != null && otherGuardExpression == null) {
                return false;
            }
            if (myGuardExpression != null) {
                return DuplicateBranchesInSwitchInspection.createFinder(new PsiElement[]{myGuardExpression}, Collections.emptyList()).isDuplicate((PsiElement)otherGuardExpression, true) != null;
            }
            return true;
        }

        boolean hasSingleNullCase() {
            return this.myHasSingleNullCase;
        }

        @Override
        boolean isSimpleExit() {
            return this.myIsSimpleExit;
        }

        @Override
        @Nullable
        LocalQuickFix mergeCasesFix(BranchBase<?> otherBranch) {
            if (!otherBranch.canMergeBranch()) {
                return null;
            }
            String switchLabelText = this.getSwitchLabelText();
            if (switchLabelText == null) {
                return null;
            }
            return this.myCanMergeBranch ? new MergeBranchesFix(switchLabelText) : null;
        }

        @Override
        @Nullable
        LocalQuickFix mergeWithDefaultFix(BranchBase<?> defaultBranch) {
            if (!this.myCanMergeBranch) {
                return null;
            }
            MergeWithDefaultBranchFix fix = new MergeWithDefaultBranchFix();
            if (!DuplicateBranchesInSwitchInspection.hasPattern(defaultBranch.getLabels()) && !DuplicateBranchesInSwitchInspection.hasPattern(this.getLabels())) {
                return fix;
            }
            return this.isNearby(defaultBranch) ? fix : null;
        }

        @Override
        @Nullable
        LocalQuickFix deleteCaseFix() {
            return this.myCanDeleteRedundantBranch ? new DeleteRedundantBranchFix() : null;
        }

        @NotNull
        List<PsiElement> getBranchPrefix() {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (PsiElement element = this.myStatements[0].getPrevSibling(); !(element == null || Branch.isLeftBrace(element) || !(element instanceof PsiSwitchLabelStatement) && element instanceof PsiStatement); element = element.getPrevSibling()) {
                result.add(element);
            }
            Collections.reverse(result);
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                Branch.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static boolean isLeftBrace(PsiElement element) {
            PsiJavaToken token;
            return element instanceof PsiJavaToken && JavaTokenType.LBRACE.equals((token = (PsiJavaToken)element).getTokenType());
        }

        PsiStatement[] getStatementsToDelete() {
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.myStatements[this.myStatements.length - 1], PsiStatement.class);
            if (DuplicateBranchesInSwitchInspection.isBreakWithoutLabel(nextStatement)) {
                PsiStatement[] statements = Arrays.copyOf(this.myStatements, this.myStatements.length + 1);
                statements[this.myStatements.length] = nextStatement;
                return statements;
            }
            return this.myStatements;
        }

        private static boolean isSimpleExit(@Nullable PsiStatement statement) {
            if (statement instanceof PsiBreakStatement || statement instanceof PsiYieldStatement || statement instanceof PsiContinueStatement || statement instanceof PsiThrowStatement) {
                return true;
            }
            if (statement instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                return Branch.isSimpleExpression(returnStatement.getReturnValue());
            }
            return false;
        }

        private static boolean isSimpleExpression(@Nullable PsiExpression expression) {
            if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) == null || expression instanceof PsiLiteralExpression) {
                return true;
            }
            if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)expression;
                PsiExpression qualifier = ref.getQualifierExpression();
                return qualifier == null || qualifier instanceof PsiQualifiedExpression;
            }
            if (expression instanceof PsiUnaryExpression) {
                PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression;
                return Branch.isSimpleExpression(unaryExpression.getOperand());
            }
            return false;
        }

        private static PsiSwitchLabelStatement[] collectLabels(@Nullable PsiStatement statement) {
            if (statement == null) {
                return EMPTY_LABELS_ARRAY;
            }
            ArrayList<PsiSwitchLabelStatement> labels = new ArrayList<PsiSwitchLabelStatement>();
            PsiElement element = PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (element instanceof PsiSwitchLabelStatement) {
                labels.add((PsiSwitchLabelStatement)element);
                element = PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PsiStatement.class);
            }
            Collections.reverse(labels);
            return labels.toArray(EMPTY_LABELS_ARRAY);
        }

        private static PsiStatement[] statementsWithoutTrailingBreak(List<? extends PsiStatement> statementList) {
            int lastIndex = statementList.size() - 1;
            PsiStatement lastStatement = statementList.get(lastIndex);
            if (lastIndex > 0 && DuplicateBranchesInSwitchInspection.isBreakWithoutLabel(lastStatement)) {
                statementList = statementList.subList(0, lastIndex);
            }
            return statementList.toArray(PsiStatement.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementList";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labels";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comments";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$Branch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$Branch";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranchPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "calculateCanMergeBranches";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class BranchBase<T extends PsiSwitchLabelStatementBase> {
        @NotNull
        protected final T myFirstLabel;
        protected final PsiStatement @NotNull [] myStatements;
        protected final String @NotNull [] myCommentTexts;
        private final boolean myIsDefault;
        private DuplicatesFinder myFinder;
        protected final boolean myCanDeleteRedundantBranch;
        private final PsiElement myContext;

        BranchBase(@NotNull PsiElement context, T @NotNull [] labels, PsiStatement @NotNull [] statements, String @NotNull [] commentTexts) {
            if (context == null) {
                BranchBase.$$$reportNull$$$0(0);
            }
            if (labels == null) {
                BranchBase.$$$reportNull$$$0(1);
            }
            if (statements == null) {
                BranchBase.$$$reportNull$$$0(2);
            }
            if (commentTexts == null) {
                BranchBase.$$$reportNull$$$0(3);
            }
            LOG.assertTrue(labels.length != 0, (Object)"labels.length");
            LOG.assertTrue(statements.length != 0, (Object)"statements.length");
            this.myContext = context;
            this.myFirstLabel = labels[0];
            this.myStatements = statements;
            this.myCommentTexts = commentTexts;
            this.myIsDefault = ContainerUtil.exists((Object[])labels, label -> label.isDefaultCase() || SwitchUtils.isCaseNullDefault((PsiSwitchLabelStatementBase)label));
            this.myCanDeleteRedundantBranch = labels.length > 1 || !ContainerUtil.exists((Object[])labels, BranchBase::hasNullCase);
        }

        private static boolean hasNullCase(@NotNull PsiSwitchLabelStatementBase label) {
            PsiCaseLabelElementList labelElementList;
            if (label == null) {
                BranchBase.$$$reportNull$$$0(4);
            }
            if ((labelElementList = label.getCaseLabelElementList()) == null) {
                return false;
            }
            Object[] elements = labelElementList.getElements();
            return ContainerUtil.exists((Object[])elements, el -> {
                PsiExpression expr;
                return el instanceof PsiExpression && ExpressionUtils.isNullLiteral((PsiExpression)(expr = (PsiExpression)el));
            });
        }

        boolean isDefault() {
            return this.myIsDefault;
        }

        @Nullable
        String getSwitchLabelText() {
            return BranchBase.getSwitchLabelText(this.myFirstLabel);
        }

        abstract boolean isSimpleExit();

        abstract boolean canFallThrough();

        abstract boolean canMergeBranch();

        abstract PsiSwitchLabelStatementBase[] getLabels();

        private boolean canBeJoinedWith(@NotNull BranchBase<?> other) {
            PsiExpression otherGuard;
            PsiExpression thisGuard;
            if (other == null) {
                BranchBase.$$$reportNull$$$0(5);
            }
            if (this.isDefault() && !BranchBase.hasDominanceAfter(other, this)) {
                return true;
            }
            if (other.isDefault() && !BranchBase.hasDominanceAfter(this, other)) {
                return true;
            }
            if (!this.canMergeBranch()) {
                return false;
            }
            if (!other.canMergeBranch()) {
                return false;
            }
            boolean thisPattern = DuplicateBranchesInSwitchInspection.hasPattern(this.getLabels());
            boolean otherPattern = DuplicateBranchesInSwitchInspection.hasPattern(other.getLabels());
            if (otherPattern != thisPattern) {
                return false;
            }
            if (!thisPattern) {
                return true;
            }
            if (this instanceof Rule) {
                thisGuard = this.myFirstLabel.getGuardExpression();
                otherGuard = other.myFirstLabel.getGuardExpression();
                if (thisGuard == null && otherGuard != null || thisGuard != null && otherGuard == null) {
                    return false;
                }
                if (thisGuard != null) {
                    return DuplicateBranchesInSwitchInspection.createFinder(new PsiElement[]{thisGuard}, Collections.emptyList()).isDuplicate((PsiElement)otherGuard, true) != null;
                }
            }
            if (this instanceof Branch) {
                thisGuard = this.myFirstLabel.getGuardExpression();
                otherGuard = other.myFirstLabel.getGuardExpression();
                if (thisGuard != null && otherGuard != null) {
                    return true;
                }
            }
            return this.isNearby(other);
        }

        boolean isNearby(@NotNull BranchBase<?> other) {
            if (other == null) {
                BranchBase.$$$reportNull$$$0(6);
            }
            PsiSwitchLabelStatementBase[] thisLabels = this.getLabels();
            PsiSwitchLabelStatementBase[] otherLabels = other.getLabels();
            IElementType baseElementType = other instanceof Rule ? JavaElementType.SWITCH_LABELED_RULE : JavaElementType.SWITCH_LABEL_STATEMENT;
            return PsiTreeUtil.findSiblingBackward((PsiElement)thisLabels[0], (IElementType)baseElementType, (boolean)true, null) == otherLabels[otherLabels.length - 1] || PsiTreeUtil.findSiblingForward((PsiElement)thisLabels[thisLabels.length - 1], (IElementType)baseElementType, (boolean)true, null) == otherLabels[0];
        }

        private static boolean hasDominanceAfter(@NotNull BranchBase<?> branch, @NotNull BranchBase<?> other) {
            if (branch == null) {
                BranchBase.$$$reportNull$$$0(7);
            }
            if (other == null) {
                BranchBase.$$$reportNull$$$0(8);
            }
            PsiElement context = branch.myContext;
            PsiSwitchLabelStatementBase overWhom = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)branch.myContext, PsiSwitchLabelStatementBase.class, (boolean)false);
            if (overWhom == null) {
                return false;
            }
            PsiCaseLabelElementList whomCaseLabelElementList = overWhom.getCaseLabelElementList();
            if (whomCaseLabelElementList == null) {
                return false;
            }
            PsiSwitchLabelStatementBase until = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)other.myContext, PsiSwitchLabelStatementBase.class, (boolean)false);
            PsiSwitchBlock switchBlock = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)context, PsiSwitchBlock.class, (boolean)false);
            if (switchBlock == null) {
                return false;
            }
            boolean start = false;
            PsiExpression switchBlockExpression = switchBlock.getExpression();
            if (switchBlockExpression == null) {
                return false;
            }
            PsiType expressionType = switchBlockExpression.getType();
            if (expressionType == null) {
                return false;
            }
            for (PsiElement switchBranch : JavaPsiSwitchUtil.getSwitchBranches((PsiSwitchBlock)switchBlock)) {
                if (!start) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)switchBranch, (boolean)false)) continue;
                    start = true;
                    continue;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)until, (PsiElement)switchBranch, (boolean)false)) {
                    return false;
                }
                if (!ContainerUtil.or((Object[])whomCaseLabelElementList.getElements(), element -> JavaPsiSwitchUtil.isDominated((PsiCaseLabelElement)element, (PsiElement)switchBranch, (PsiType)expressionType))) continue;
                return true;
            }
            return false;
        }

        int effectiveLength() {
            int n;
            PsiStatement psiStatement;
            if (this.myStatements.length == 1 && (psiStatement = this.myStatements[0]) instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)psiStatement;
                n = blockStatement.getCodeBlock().getStatementCount();
            } else {
                n = this.myStatements.length;
            }
            return n;
        }

        int hash() {
            return BranchBase.hashStatements(this.myStatements);
        }

        @Nullable
        abstract LocalQuickFix mergeCasesFix(BranchBase<?> var1);

        @Nullable
        abstract LocalQuickFix deleteCaseFix();

        @Nullable
        abstract LocalQuickFix mergeWithDefaultFix(BranchBase<?> var1);

        @Nullable
        Match match(@NotNull BranchBase<?> other) {
            if (other == null) {
                BranchBase.$$$reportNull$$$0(9);
            }
            return this.getFinder().isDuplicate((PsiElement)other.myStatements[0], true);
        }

        @NotNull
        private DuplicatesFinder getFinder() {
            if (this.myFinder == null) {
                this.myFinder = DuplicateBranchesInSwitchInspection.createFinder((PsiElement[])this.myStatements, Collections.emptyList());
            }
            DuplicatesFinder duplicatesFinder = this.myFinder;
            if (duplicatesFinder == null) {
                BranchBase.$$$reportNull$$$0(10);
            }
            return duplicatesFinder;
        }

        @InspectionMessage
        String getCaseBranchMessage() {
            return JavaBundle.message((String)"inspection.duplicate.branches.in.switch.message", (Object[])new Object[0]);
        }

        @InspectionMessage
        String getDefaultBranchMessage() {
            return JavaBundle.message((String)"inspection.duplicate.branches.in.switch.default.message", (Object[])new Object[0]);
        }

        public String toString() {
            return StringUtil.notNullize((String)this.getSwitchLabelText());
        }

        @Nullable
        static String getSwitchLabelText(@Nullable PsiSwitchLabelStatementBase switchLabel) {
            if (switchLabel != null) {
                PsiCaseLabelElement[] expressions;
                if (switchLabel.isDefaultCase()) {
                    return "default";
                }
                PsiCaseLabelElementList labelElementList = switchLabel.getCaseLabelElementList();
                if (labelElementList != null && (expressions = labelElementList.getElements()).length != 0) {
                    return "case " + expressions[0].getText();
                }
            }
            return null;
        }

        private static int hashElement(@Nullable PsiElement element, int depth) {
            IElementType type;
            if (element == null) {
                return 0;
            }
            if (element instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)element;
                return BranchBase.hashExpression(expression);
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)element;
                return BranchBase.hashStatements(blockStatement.getCodeBlock().getStatements()) * 31 + JavaElementType.BLOCK_STATEMENT.getIndex();
            }
            int hash = 0;
            if (depth > 0) {
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiJavaToken) continue;
                    hash = hash * 31 + BranchBase.hashElement(child, depth - 1);
                }
            }
            if ((type = PsiUtilCore.getElementType((PsiElement)element)) != null) {
                hash = hash * 31 + type.getIndex();
            }
            return hash;
        }

        private static int hashExpression(@Nullable PsiExpression expression) {
            PsiNewExpression newExpression;
            PsiJavaCodeReferenceElement reference;
            if (expression == null) {
                return 0;
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return BranchBase.hashExpression(parenthesizedExpression.getExpression());
            }
            short index = expression.getNode().getElementType().getIndex();
            if (expression instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression;
                return BranchBase.hashReference((PsiJavaCodeReferenceElement)methodReferenceExpression, index) * 31 + BranchBase.hashElement(methodReferenceExpression.getQualifier(), 1);
            }
            if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                return BranchBase.hashReference((PsiJavaCodeReferenceElement)referenceExpression, index);
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                return BranchBase.hashReference((PsiJavaCodeReferenceElement)methodCallExpression.getMethodExpression(), index);
            }
            if (expression instanceof PsiNewExpression && (reference = (newExpression = (PsiNewExpression)expression).getClassOrAnonymousClassReference()) != null) {
                return BranchBase.hashReference(reference, index);
            }
            if (expression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                PsiExpression lExpression = assignmentExpression.getLExpression();
                PsiExpression rExpression = assignmentExpression.getRExpression();
                return (BranchBase.hashExpression(lExpression) * 31 + BranchBase.hashExpression(rExpression)) * 31 + index;
            }
            return index;
        }

        private static int hashReference(@Nullable PsiJavaCodeReferenceElement reference, short index) {
            return reference == null ? 0 : Objects.hashCode(reference.getReferenceName()) * 31 + index;
        }

        private static int hashStatements(PsiStatement @NotNull [] statements) {
            if (statements == null) {
                BranchBase.$$$reportNull$$$0(11);
            }
            int hash = statements.length;
            for (PsiStatement statement : statements) {
                hash = hash * 31 + BranchBase.hashElement((PsiElement)statement, 2);
            }
            return hash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labels";
                    break;
                }
                case 2: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commentTexts";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$BranchBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$BranchBase";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNullCase";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeJoinedWith";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isNearby";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "hasDominanceAfter";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "match";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "hashStatements";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10 -> new IllegalStateException(string);
            };
        }
    }

    private static enum LevelType {
        WARN,
        NO,
        INFO;

    }

    private static class RuleFixContext {
        private Rule myRuleToDelete;
        private Rule myRuleToMergeWith;
        private Set<String> myCommentsToMergeWith;

        private RuleFixContext() {
        }

        boolean prepare(PsiElement startElement, Predicate<? super Rule> shouldMergeWith) {
            PsiSwitchBlock switchBlock;
            PsiSwitchLabeledRuleStatement ruleStatement;
            if (startElement != null && (ruleStatement = (PsiSwitchLabeledRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiSwitchLabeledRuleStatement.class)) != null && (switchBlock = ruleStatement.getEnclosingSwitchBlock()) != null) {
                List<Rule> candidateRules = null;
                for (List<Rule> rules : DuplicateBranchesInSwitchInspection.collectProbablySimilarRules(switchBlock)) {
                    this.myRuleToDelete = (Rule)ContainerUtil.find(rules, r -> r.myFirstLabel == ruleStatement);
                    if (this.myRuleToDelete == null) continue;
                    candidateRules = rules;
                    break;
                }
                if (candidateRules == null) {
                    return false;
                }
                for (Rule rule : candidateRules) {
                    if (!shouldMergeWith.test(rule)) continue;
                    this.myRuleToMergeWith = rule;
                    break;
                }
                if (this.myRuleToMergeWith == null) {
                    return false;
                }
            }
            if (this.myRuleToMergeWith == null) {
                return false;
            }
            this.myCommentsToMergeWith = Set.of(this.myRuleToMergeWith.myCommentTexts);
            return true;
        }

        void deleteRedundantComments() {
            PsiComment comment;
            PsiWhiteSpace whiteSpace;
            PsiElement element;
            ArrayList redundantComments = new ArrayList();
            ArrayList<PsiComment> mightBeRedundantComments = new ArrayList<PsiComment>();
            for (element = ((PsiSwitchLabeledRuleStatement)this.myRuleToDelete.myFirstLabel).getNextSibling(); element != null; element = element.getNextSibling()) {
                if (element instanceof PsiWhiteSpace) {
                    whiteSpace = (PsiWhiteSpace)element;
                    if (!whiteSpace.textContains('\n')) continue;
                    redundantComments.addAll(mightBeRedundantComments);
                    break;
                }
                if (!(element instanceof PsiComment) || !DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, (PsiElement)(comment = (PsiComment)element))) continue;
                mightBeRedundantComments.add(comment);
            }
            mightBeRedundantComments.clear();
            for (element = ((PsiSwitchLabeledRuleStatement)this.myRuleToDelete.myFirstLabel).getPrevSibling(); element != null; element = element.getPrevSibling()) {
                if (element instanceof PsiWhiteSpace) {
                    whiteSpace = (PsiWhiteSpace)element;
                    if (!whiteSpace.textContains('\n')) continue;
                    redundantComments.addAll(mightBeRedundantComments);
                    mightBeRedundantComments.clear();
                    continue;
                }
                if (!(element instanceof PsiComment) || !DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, (PsiElement)(comment = (PsiComment)element))) break;
                mightBeRedundantComments.add(comment);
            }
            redundantComments.forEach(PsiElement::delete);
        }

        @Nullable
        PsiCaseLabelElementList getCaseLabelElementList(@NotNull PsiSwitchLabeledRuleStatement ruleStatement) {
            if (ruleStatement == null) {
                RuleFixContext.$$$reportNull$$$0(0);
            }
            if (ruleStatement.isDefaultCase()) {
                PsiElementFactory factory = PsiElementFactory.getInstance((Project)ruleStatement.getProject());
                PsiSwitchLabeledRuleStatement labelStatement = (PsiSwitchLabeledRuleStatement)factory.createStatementFromText("case default->{}", null);
                PsiStatement body = ruleStatement.getBody();
                if (body != null) {
                    Objects.requireNonNull(labelStatement.getBody()).replace((PsiElement)body);
                }
                PsiSwitchLabeledRuleStatement newLabelStatement = (PsiSwitchLabeledRuleStatement)ruleStatement.replace((PsiElement)labelStatement);
                return newLabelStatement.getCaseLabelElementList();
            }
            return ruleStatement.getCaseLabelElementList();
        }

        void copyCaseValues(boolean mergeWithDefault) {
            @Nullable PsiCaseLabelElementList caseValuesToMergeWith = this.getCaseLabelElementList((PsiSwitchLabeledRuleStatement)this.myRuleToMergeWith.myFirstLabel);
            @Nullable PsiCaseLabelElementList caseValuesToDelete = this.getCaseLabelElementList((PsiSwitchLabeledRuleStatement)this.myRuleToDelete.myFirstLabel);
            DuplicateBranchesInSwitchInspection.copyCaseValues(caseValuesToDelete, caseValuesToMergeWith, mergeWithDefault);
        }

        void deleteRule() {
            CommentTracker tracker = new CommentTracker();
            PsiTreeUtil.processElements((PsiElement)this.myRuleToDelete.myFirstLabel, child -> {
                if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                    tracker.markUnchanged(child);
                }
                return true;
            });
            tracker.deleteAndRestoreComments((PsiElement)this.myRuleToDelete.myFirstLabel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleStatement", "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$RuleFixContext", "getCaseLabelElementList"));
        }
    }

    private static class DeleteRedundantRuleFix
    extends PsiUpdateModCommandQuickFix {
        @Nullable
        private final SmartPsiElementPointer<PsiSwitchLabelStatementBase> mergeWith;

        private DeleteRedundantRuleFix(@Nullable SmartPsiElementPointer<PsiSwitchLabelStatementBase> with) {
            this.mergeWith = with;
        }

        private DeleteRedundantRuleFix() {
            this(null);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiSwitchLabelStatementBase finalRuleMergeWith;
            if (project == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                DeleteRedundantRuleFix.$$$reportNull$$$0(4);
            }
            RuleFixContext context = new RuleFixContext();
            PsiSwitchLabelStatementBase ruleMergeWith = null;
            if (this.mergeWith != null) {
                PsiSwitchLabelStatementBase originalMergeWith = (PsiSwitchLabelStatementBase)this.mergeWith.getElement();
                ruleMergeWith = (PsiSwitchLabelStatementBase)PsiTreeUtil.findSameElementInCopy((PsiElement)originalMergeWith, (PsiFile)element.getContainingFile());
            }
            if (context.prepare(element, arg_0 -> DeleteRedundantRuleFix.lambda$applyFix$0(finalRuleMergeWith = ruleMergeWith, arg_0))) {
                context.deleteRedundantComments();
                context.deleteRule();
            }
        }

        private static /* synthetic */ boolean lambda$applyFix$0(PsiSwitchLabelStatementBase finalRuleMergeWith, Rule rule) {
            return rule.isDefault() || finalRuleMergeWith != null && finalRuleMergeWith == rule.myFirstLabel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantRuleFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantRuleFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MergeRulesFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String mySwitchLabelText;

        MergeRulesFix(@NotNull String switchLabelText) {
            if (switchLabelText == null) {
                MergeRulesFix.$$$reportNull$$$0(0);
            }
            this.mySwitchLabelText = switchLabelText;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MergeRulesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.name", (Object[])new Object[]{this.mySwitchLabelText});
            if (string == null) {
                MergeRulesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            RuleFixContext context;
            if (project == null) {
                MergeRulesFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                MergeRulesFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                MergeRulesFix.$$$reportNull$$$0(5);
            }
            if ((context = new RuleFixContext()).prepare(element, rule -> this.mySwitchLabelText.equals(rule.getSwitchLabelText()))) {
                context.copyCaseValues(false);
                context.deleteRedundantComments();
                context.deleteRule();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchLabelText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeRulesFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeRulesFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class BranchFixContext {
        private Branch myBranchToDelete;
        private Branch myBranchToMergeWith;
        private List<PsiElement> myBranchPrefixToMove;
        private PsiSwitchLabelStatement myLabelToMergeWith;
        private @Unmodifiable Set<String> myCommentsToMergeWith;
        private PsiElement myNextFromLabelToMergeWith;

        private BranchFixContext() {
        }

        private boolean prepare(PsiElement startElement, Predicate<? super Branch> shouldMergeWith) {
            PsiSwitchBlock switchBlock = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiSwitchBlock.class);
            if (switchBlock == null) {
                return false;
            }
            List<Branch> candidateBranches = null;
            for (List<Branch> branches : DuplicateBranchesInSwitchInspection.collectProbablySimilarBranches(switchBlock)) {
                this.myBranchToDelete = (Branch)ContainerUtil.find(branches, branch -> branch.myStatements[0] == startElement);
                if (this.myBranchToDelete == null) continue;
                candidateBranches = branches;
                break;
            }
            if (this.myBranchToDelete == null || candidateBranches == null) {
                return false;
            }
            for (Branch branch2 : candidateBranches) {
                if (!shouldMergeWith.test(branch2) || DuplicateBranchesInSwitchInspection.canBeJoined(this.myBranchToDelete, branch2) == LevelType.NO) continue;
                this.myBranchToMergeWith = branch2;
                break;
            }
            if (this.myBranchToMergeWith == null) {
                return false;
            }
            this.myBranchPrefixToMove = this.myBranchToDelete.getBranchPrefix();
            if (this.myBranchPrefixToMove.isEmpty()) {
                return false;
            }
            this.myLabelToMergeWith = (PsiSwitchLabelStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.myBranchToMergeWith.myStatements[0], PsiSwitchLabelStatement.class);
            if (this.myLabelToMergeWith == null) {
                return false;
            }
            this.myNextFromLabelToMergeWith = PsiTreeUtil.skipWhitespacesForward((PsiElement)this.myLabelToMergeWith);
            this.myCommentsToMergeWith = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])this.myBranchToMergeWith.myCommentTexts));
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void moveBranchLabel() {
            PsiElement lastElementToMove;
            PsiElement firstElementToMove;
            block9: {
                PsiSwitchLabelStatement moveTarget;
                block8: {
                    Iterator<PsiElement> iterator;
                    PsiSwitchLabelStatement labelStatement;
                    block6: {
                        block7: {
                            block5: {
                                PsiElement prevElement;
                                firstElementToMove = this.myBranchPrefixToMove.getFirst();
                                lastElementToMove = this.myBranchPrefixToMove.getLast();
                                moveTarget = this.myLabelToMergeWith;
                                if (this.myLabelToMergeWith.isDefaultCase() && (prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)this.myLabelToMergeWith)) != null) {
                                    moveTarget = prevElement;
                                }
                                if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.SWITCH_EXPRESSION, (PsiElement)moveTarget) || !(moveTarget instanceof PsiSwitchLabelStatement)) break block5;
                                labelStatement = moveTarget;
                                if (!this.myBranchToDelete.canCopyCaseValues(this.myBranchToMergeWith) || SwitchUtils.isCaseNull((PsiSwitchLabelStatementBase)labelStatement) || SwitchUtils.isDefaultLabel((PsiSwitchLabelStatementBase)labelStatement)) break block5;
                                iterator = this.myBranchPrefixToMove.iterator();
                                break block6;
                            }
                            if (!this.myBranchToMergeWith.isDefault()) break block7;
                            break block8;
                        }
                        moveTarget.getParent().addRangeAfter(firstElementToMove, lastElementToMove, (PsiElement)moveTarget);
                        break block9;
                    }
                    while (iterator.hasNext()) {
                        PsiElement element = iterator.next();
                        if (!(element instanceof PsiSwitchLabelStatement)) continue;
                        PsiSwitchLabelStatement statement = (PsiSwitchLabelStatement)element;
                        if (SwitchUtils.isCaseNull((PsiSwitchLabelStatementBase)statement) && this.myLabelToMergeWith.isDefaultCase()) {
                            BranchFixContext.copyCaseValues(statement, this.myLabelToMergeWith, true);
                            continue;
                        }
                        BranchFixContext.copyCaseValues(statement, labelStatement, false);
                    }
                    break block9;
                }
                for (PsiElement current = lastElementToMove; current != firstElementToMove; current = current.getPrevSibling()) {
                    PsiSwitchLabelStatement labelStatement;
                    if (current instanceof PsiWhiteSpace) continue;
                    if (current instanceof PsiSwitchLabelStatement && SwitchUtils.isCaseNull((PsiSwitchLabelStatementBase)(labelStatement = (PsiSwitchLabelStatement)current))) {
                        BranchFixContext.copyCaseValues(labelStatement, this.myLabelToMergeWith, true);
                        continue;
                    }
                    moveTarget.getParent().addAfter(current, (PsiElement)moveTarget);
                }
            }
            firstElementToMove.getParent().deleteChildRange(firstElementToMove, lastElementToMove);
        }

        void deleteStatements() {
            PsiStatement[] statementsToDelete;
            CommentTracker tracker = new CommentTracker();
            for (PsiStatement statement : statementsToDelete = this.myBranchToDelete.getStatementsToDelete()) {
                PsiTreeUtil.processElements((PsiElement)statement, child -> {
                    if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                        tracker.markUnchanged(child);
                    }
                    return true;
                });
            }
            for (int i = 0; i < statementsToDelete.length - 1; ++i) {
                tracker.delete((PsiElement)statementsToDelete[i]);
            }
            tracker.deleteAndRestoreComments((PsiElement)statementsToDelete[statementsToDelete.length - 1]);
        }

        void deleteRedundantComments() {
            ArrayList redundantComments = new ArrayList();
            for (PsiElement element = this.myLabelToMergeWith.getNextSibling(); element != null && element != this.myNextFromLabelToMergeWith; element = element.getNextSibling()) {
                PsiTreeUtil.processElements((PsiElement)element, child -> {
                    if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                        redundantComments.add(child);
                    }
                    return true;
                });
            }
            redundantComments.forEach(PsiElement::delete);
        }

        void deleteBranchLabel() {
            ArrayList<PsiElement> toDelete = new ArrayList<PsiElement>();
            CommentTracker tracker = new CommentTracker();
            for (PsiElement element : this.myBranchPrefixToMove) {
                if (element instanceof PsiWhiteSpace) continue;
                toDelete.add(element);
                PsiTreeUtil.processElements((PsiElement)element, child -> {
                    if (DuplicateBranchesInSwitchInspection.isRedundantComment(this.myCommentsToMergeWith, child)) {
                        tracker.markUnchanged(child);
                    }
                    return true;
                });
            }
            int size = toDelete.size();
            if (size != 0) {
                for (int i = 0; i < size - 1; ++i) {
                    BranchFixContext.deleteKeepingCaseNull((PsiElement)toDelete.get(i), tracker, false);
                }
                BranchFixContext.deleteKeepingCaseNull((PsiElement)toDelete.get(size - 1), tracker, true);
            }
        }

        private static void deleteKeepingCaseNull(@NotNull PsiElement element, @NotNull CommentTracker ct, boolean needRestoreComments) {
            PsiSwitchLabelStatement labelStatement;
            if (element == null) {
                BranchFixContext.$$$reportNull$$$0(0);
            }
            if (ct == null) {
                BranchFixContext.$$$reportNull$$$0(1);
            }
            if (!(element instanceof PsiSwitchLabelStatement) || !SwitchUtils.isCaseNull((PsiSwitchLabelStatementBase)(labelStatement = (PsiSwitchLabelStatement)element))) {
                if (needRestoreComments) {
                    ct.delete(element);
                } else {
                    new CommentTracker().deleteAndRestoreComments(element);
                }
            }
        }

        @Nullable
        private static PsiCaseLabelElementList getCaseLabelElementList(@NotNull PsiSwitchLabelStatement label) {
            if (label == null) {
                BranchFixContext.$$$reportNull$$$0(2);
            }
            if (label.isDefaultCase()) {
                PsiElementFactory factory = PsiElementFactory.getInstance((Project)label.getProject());
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)factory.createStatementFromText("case default:", null);
                PsiSwitchLabelStatement newLabelStatement = (PsiSwitchLabelStatement)label.replace((PsiElement)labelStatement);
                return newLabelStatement.getCaseLabelElementList();
            }
            return label.getCaseLabelElementList();
        }

        private static void copyCaseValues(@NotNull PsiSwitchLabelStatement from, @NotNull PsiSwitchLabelStatement to, boolean mergeWithDefault) {
            if (from == null) {
                BranchFixContext.$$$reportNull$$$0(3);
            }
            if (to == null) {
                BranchFixContext.$$$reportNull$$$0(4);
            }
            @Nullable PsiCaseLabelElementList fromCaseLabelElementList = BranchFixContext.getCaseLabelElementList(from);
            @Nullable PsiCaseLabelElementList toCaseLabelElementList = BranchFixContext.getCaseLabelElementList(to);
            DuplicateBranchesInSwitchInspection.copyCaseValues(fromCaseLabelElementList, toCaseLabelElementList, mergeWithDefault);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$BranchFixContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteKeepingCaseNull";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCaseLabelElementList";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "copyCaseValues";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DeleteRedundantBranchFix
    extends PsiUpdateModCommandQuickFix {
        private DeleteRedundantBranchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.delete.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            BranchFixContext context;
            if (project == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                DeleteRedundantBranchFix.$$$reportNull$$$0(4);
            }
            if ((context = new BranchFixContext()).prepare(element, BranchBase::isDefault)) {
                context.deleteBranchLabel();
                if (!context.myBranchToDelete.hasSingleNullCase()) {
                    context.deleteStatements();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantBranchFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$DeleteRedundantBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MergeWithDefaultRuleFix
    extends MergeWithDefaultBranchFix {
        private MergeWithDefaultRuleFix() {
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            RuleFixContext context;
            if (project == null) {
                MergeWithDefaultRuleFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                MergeWithDefaultRuleFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                MergeWithDefaultRuleFix.$$$reportNull$$$0(2);
            }
            if ((context = new RuleFixContext()).prepare(element, BranchBase::isDefault)) {
                context.copyCaseValues(true);
                context.deleteRedundantComments();
                context.deleteRule();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "updater";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeWithDefaultRuleFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergeWithDefaultBranchFix
    extends PsiUpdateModCommandQuickFix {
        private MergeWithDefaultBranchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.merge.with.default.fix.name", (Object[])new Object[0]);
            if (string == null) {
                MergeWithDefaultBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            BranchFixContext context;
            if (project == null) {
                MergeWithDefaultBranchFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MergeWithDefaultBranchFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MergeWithDefaultBranchFix.$$$reportNull$$$0(3);
            }
            if ((context = new BranchFixContext()).prepare(element, BranchBase::isDefault)) {
                context.moveBranchLabel();
                context.deleteRedundantComments();
                context.deleteStatements();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeWithDefaultBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeWithDefaultBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MergeBranchesFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String mySwitchLabelText;

        MergeBranchesFix(@NotNull String switchLabelText) {
            if (switchLabelText == null) {
                MergeBranchesFix.$$$reportNull$$$0(0);
            }
            this.mySwitchLabelText = switchLabelText;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MergeBranchesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.duplicate.branches.in.switch.merge.fix.name", (Object[])new Object[]{this.mySwitchLabelText});
            if (string == null) {
                MergeBranchesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            BranchFixContext context;
            if (project == null) {
                MergeBranchesFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                MergeBranchesFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                MergeBranchesFix.$$$reportNull$$$0(5);
            }
            if ((context = new BranchFixContext()).prepare(element, branch -> this.mySwitchLabelText.equals(branch.getSwitchLabelText()))) {
                context.moveBranchLabel();
                context.deleteRedundantComments();
                context.deleteStatements();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchLabelText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeBranchesFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DuplicateBranchesInSwitchInspection$MergeBranchesFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

