/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.impl.FillPermitsListFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FillPermitsListInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.SEALED_CLASSES);
        if (set == null) {
            FillPermitsListInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FillPermitsListInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitClass(@NotNull PsiClass psiClass) {
                PsiIdentifier identifier;
                if (psiClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((identifier = psiClass.getNameIdentifier()) == null) {
                    return;
                }
                PsiFile containingFile = (PsiFile)ObjectUtils.tryCast((Object)psiClass.getContainingFile(), PsiJavaFile.class);
                if (containingFile == null) {
                    return;
                }
                PsiModifierList modifiers = psiClass.getModifierList();
                if (modifiers == null || !modifiers.hasExplicitModifier("sealed")) {
                    return;
                }
                Set permittedClasses = ContainerUtil.map2Set((Object[])psiClass.getPermitsListTypes(), PsiClassType::resolve);
                DirectClassInheritorsSearch.searchAllSealedInheritors((PsiClass)psiClass, (SearchScope)GlobalSearchScope.fileScope((PsiFile)containingFile)).forEach(inheritor -> {
                    if (PsiUtil.isLocalOrAnonymousClass((PsiClass)inheritor)) {
                        return false;
                    }
                    if (inheritor.getContainingFile() != containingFile) {
                        return false;
                    }
                    if (!permittedClasses.contains(inheritor)) {
                        holder.problem((PsiElement)identifier, JavaBundle.message((String)"inspection.fill.permits.list.display.name", (Object[])new Object[0])).fix((ModCommandAction)new FillPermitsListFix(identifier)).register();
                        return false;
                    }
                    return true;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/FillPermitsListInspection$1", "visitClass"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/FillPermitsListInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/FillPermitsListInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

