/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SingleFileSourcesTracker;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.ImplicitlyImportedModule;
import com.intellij.psi.ImplicitlyImportedStaticMember;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.util.JvmMainMethodSearcher;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImplicitToExplicitClassBackwardMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final String SHORT_NAME = ImplicitToExplicitClassBackwardMigrationInspection.getShortName((String)ImplicitToExplicitClassBackwardMigrationInspection.class.getSimpleName());

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.IMPLICIT_CLASSES);
        if (set == null) {
            ImplicitToExplicitClassBackwardMigrationInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ImplicitToExplicitClassBackwardMigrationInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitImplicitClass(@NotNull PsiImplicitClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!PsiMethodUtil.hasMainInClass((PsiClass)aClass)) {
                    return;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)aClass)) {
                    return;
                }
                String message = JavaBundle.message((String)"inspection.implicit.to.explicit.class.backward.migration.name", (Object[])new Object[0]);
                PsiMethod method = PsiMethodUtil.findMainMethod((PsiClass)aClass);
                if (method == null) {
                    return;
                }
                PsiIdentifier identifier = method.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                ReplaceWithExplicitClassFix fix = new ReplaceWithExplicitClassFix(aClass);
                if (InspectionProjectProfileManager.isInformationLevel((String)ImplicitToExplicitClassBackwardMigrationInspection.this.getShortName(), (PsiElement)identifier)) {
                    TextRange textRange = TextRange.create((int)0, (int)(method.getParameterList().getTextRange().getEndOffset() - method.getTextRange().getStartOffset()));
                    holder.problem((PsiElement)method, message).range(textRange).fix((ModCommandAction)fix).register();
                } else {
                    holder.problem((PsiElement)identifier, message).fix((ModCommandAction)fix).register();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/ImplicitToExplicitClassBackwardMigrationInspection$1", "visitImplicitClass"));
            }
        };
    }

    @Nullable
    public static PsiUpdateModCommandAction<PsiImplicitClass> createFix(@NotNull PsiElement psiElement) {
        PsiMember member;
        if (psiElement == null) {
            ImplicitToExplicitClassBackwardMigrationInspection.$$$reportNull$$$0(2);
        }
        if (!((member = (PsiMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiMember.class})) instanceof PsiMethod)) {
            return null;
        }
        PsiClass psiClass = member.getContainingClass();
        if (!(psiClass instanceof PsiImplicitClass)) {
            return null;
        }
        PsiImplicitClass implicitClass = (PsiImplicitClass)psiClass;
        boolean hasMainMethod = new JvmMainMethodSearcher(){

            public boolean instanceMainMethodsEnabled(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            protected boolean inheritedStaticMainEnabled(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    2.$$$reportNull$$$0(1);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "psiElement";
                objectArray2[1] = "com/intellij/codeInspection/ImplicitToExplicitClassBackwardMigrationInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "instanceMainMethodsEnabled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inheritedStaticMainEnabled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.hasMainMethod((PsiClass)implicitClass);
        if (!hasMainMethod) {
            return null;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)implicitClass)) {
            return null;
        }
        return new ReplaceWithExplicitClassFix(implicitClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ImplicitToExplicitClassBackwardMigrationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ImplicitToExplicitClassBackwardMigrationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class ReplaceWithExplicitClassFix
    extends PsiUpdateModCommandAction<PsiImplicitClass> {
        private ReplaceWithExplicitClassFix(@NotNull PsiImplicitClass element) {
            if (element == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.implicit.to.explicit.class.backward.migration.fix.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiImplicitClass implicitClass, @NotNull ModPsiUpdater updater) {
            PsiFile containingFile;
            if (context == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(2);
            }
            if (implicitClass == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(4);
            }
            PsiFile originalFile = updater.getOriginalFile(implicitClass.getContainingFile());
            String text = implicitClass.getText();
            String qualifiedName = implicitClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            Project project = implicitClass.getProject();
            PsiClass newClass = PsiElementFactory.getInstance((Project)project).createClassFromText(text, (PsiElement)implicitClass);
            newClass.setName(qualifiedName);
            PsiModifierList modifierList = newClass.getModifierList();
            if (modifierList != null) {
                modifierList.setModifierProperty("public", true);
            }
            if (!((containingFile = implicitClass.getContainingFile()) instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile psiJavaFile = (PsiJavaFile)containingFile;
            Object[] elements = psiJavaFile.getImplicitlyImportedElements();
            List staticImports = ContainerUtil.filterIsInstance((Object[])elements, ImplicitlyImportedStaticMember.class);
            List moduleImports = ContainerUtil.filterIsInstance((Object[])elements, ImplicitlyImportedModule.class);
            PsiElement replaced = implicitClass.replace((PsiElement)newClass);
            PsiJavaFile newPsiJavaFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)replaced, PsiJavaFile.class);
            if (newPsiJavaFile == null) {
                return;
            }
            PsiImportList importList = newPsiJavaFile.getImportList();
            if (importList == null) {
                return;
            }
            ReplaceWithExplicitClassFix.addImplicitStaticImports(project, staticImports, implicitClass, importList);
            ReplaceWithExplicitClassFix.addImplicitJavaModuleImports(project, moduleImports, importList);
            ReplaceWithExplicitClassFix.addPackageStatement(newPsiJavaFile, originalFile);
            ReplaceWithExplicitClassFix.optimizeImport(newPsiJavaFile);
        }

        private static void optimizeImport(@NotNull PsiJavaFile newPsiJavaFile) {
            PsiImportList newImportList;
            if (newPsiJavaFile == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(5);
            }
            JavaCodeStyleSettings original = JavaCodeStyleSettings.getInstance((PsiFile)newPsiJavaFile);
            JavaCodeStyleSettings clone = (JavaCodeStyleSettings)original.clone();
            clone.setDeleteUnusedModuleImports(true);
            PsiImportList newList = new ImportHelper(clone).prepareOptimizeImportsResult(newPsiJavaFile, Predicates.alwaysTrue());
            if (newList != null && (newImportList = newPsiJavaFile.getImportList()) != null) {
                newImportList.getParent().addRangeAfter(newList.getParent().getFirstChild(), newList.getParent().getLastChild(), (PsiElement)newImportList);
                newImportList.delete();
            }
        }

        private static void addPackageStatement(@NotNull PsiJavaFile javaFile, PsiFile originalFile) {
            PsiDirectory directory;
            if (javaFile == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(6);
            }
            if ((directory = originalFile.getContainingDirectory()) == null) {
                return;
            }
            PsiPackage dirPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (dirPackage == null) {
                return;
            }
            PsiPackageStatement packageStatement = javaFile.getPackageStatement();
            if (packageStatement != null) {
                return;
            }
            String packageName = dirPackage.getQualifiedName();
            SingleFileSourcesTracker singleFileSourcesTracker = SingleFileSourcesTracker.getInstance((Project)originalFile.getProject());
            String singleFileSourcePackageName = singleFileSourcesTracker.getPackageNameForSingleFileSource(originalFile.getVirtualFile());
            if (singleFileSourcePackageName != null) {
                packageName = singleFileSourcePackageName;
            }
            if (packageName.isEmpty()) {
                return;
            }
            if (!PsiDirectoryFactory.getInstance((Project)javaFile.getProject()).isValidPackageName(packageName)) {
                return;
            }
            AdjustPackageNameFix.applyFix((PsiElement)javaFile, (PsiFile)originalFile, (PsiDirectory)originalFile.getContainingDirectory());
        }

        private static void addImplicitJavaModuleImports(@NotNull Project project, @NotNull List<ImplicitlyImportedModule> moduleImports, @NotNull PsiImportList list) {
            if (project == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(7);
            }
            if (moduleImports == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(8);
            }
            if (list == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(9);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            for (ImplicitlyImportedModule anImport : moduleImports) {
                PsiImportModuleStatement moduleImportStatement = factory.createImportModuleStatementFromText(anImport.getModuleName());
                PsiImportModuleStatement[] declarations = list.getImportModuleStatements();
                if (declarations.length == 0) {
                    list.add((PsiElement)moduleImportStatement);
                    continue;
                }
                list.addBefore((PsiElement)moduleImportStatement, (PsiElement)declarations[0]);
            }
        }

        private static void addImplicitStaticImports(@NotNull Project project, @NotNull List<ImplicitlyImportedStaticMember> staticImports, @NotNull PsiImplicitClass implicitClass, @NotNull PsiImportList importList) {
            if (project == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(10);
            }
            if (staticImports == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(11);
            }
            if (implicitClass == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(12);
            }
            if (importList == null) {
                ReplaceWithExplicitClassFix.$$$reportNull$$$0(13);
            }
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            for (ImplicitlyImportedStaticMember importMember : staticImports) {
                PsiClass psiClass = psiFacade.findClass(importMember.getContainingClass(), implicitClass.getResolveScope());
                if (psiClass == null) continue;
                PsiReferenceExpressionImpl.bindToElementViaStaticImport((PsiClass)psiClass, (String)importMember.getMemberName(), (PsiImportList)importList);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ImplicitToExplicitClassBackwardMigrationInspection$ReplaceWithExplicitClassFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implicitClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newPsiJavaFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaFile";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleImports";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "staticImports";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ImplicitToExplicitClassBackwardMigrationInspection$ReplaceWithExplicitClassFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "optimizeImport";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addPackageStatement";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addImplicitJavaModuleImports";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addImplicitStaticImports";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

