/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinDeclarationAndAssignmentJavaInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignmentExpression) {
                if (assignmentExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitAssignmentExpression(assignmentExpression);
                this.visitLocation((PsiElement)assignmentExpression);
            }

            public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitLocalVariable(variable);
                if (isOnTheFly && this.isInformationLevel((PsiElement)variable)) {
                    this.visitLocation((PsiElement)variable);
                }
            }

            private void visitLocation(@Nullable PsiElement location) {
                Context context = JoinDeclarationAndAssignmentJavaInspection.getContext(location);
                if (context != null) {
                    PsiLocalVariable variable = context.myVariable;
                    PsiAssignmentExpression assignment = context.myAssignment;
                    assert (location == variable || location == assignment) : "context location";
                    String message = JavaBundle.message((String)"inspection.join.declaration.and.assignment.message", (Object[])new Object[]{context.myName});
                    JoinDeclarationAndAssignmentFix fix = new JoinDeclarationAndAssignmentFix();
                    if (isOnTheFly && (context.myIsUpdate || this.isInformationLevel(location))) {
                        ProblemHighlightType highlightType = context.myIsUpdate ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                        holder.registerProblem(location, message, highlightType, new LocalQuickFix[]{fix});
                    } else if (location == assignment && !context.myIsUpdate) {
                        holder.registerProblem((PsiElement)assignment.getLExpression(), message, new LocalQuickFix[]{fix});
                    }
                }
            }

            private boolean isInformationLevel(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                return InspectionProjectProfileManager.isInformationLevel((String)JoinDeclarationAndAssignmentJavaInspection.this.getShortName(), (PsiElement)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignmentExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLocalVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isInformationLevel";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Contract(value="null -> null")
    @Nullable
    private static Context getContext(@Nullable PsiElement element) {
        if (element != null) {
            if (!(element instanceof PsiAssignmentExpression) && !(element instanceof PsiLocalVariable)) {
                element = element.getParent();
            }
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
                return JoinDeclarationAndAssignmentJavaInspection.getContext(JoinDeclarationAndAssignmentJavaInspection.findVariable(assignment), assignment);
            }
            if (element instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)element;
                return JoinDeclarationAndAssignmentJavaInspection.getContext(variable, JoinDeclarationAndAssignmentJavaInspection.findAssignment(variable));
            }
        }
        return null;
    }

    @Contract(value="null,_ -> null; _,null -> null")
    @Nullable
    private static Context getContext(@Nullable PsiLocalVariable variable, @Nullable PsiAssignmentExpression assignment) {
        if (variable != null && assignment != null) {
            String variableName = variable.getName();
            PsiExpression rExpression = assignment.getRExpression();
            if (rExpression != null) {
                PsiLocalVariable aVar = variable;
                while (aVar != null) {
                    if (VariableAccessUtils.variableIsUsed((PsiVariable)aVar, (PsiElement)rExpression)) {
                        return null;
                    }
                    aVar = (PsiLocalVariable)PsiTreeUtil.getNextSiblingOfType((PsiElement)aVar, PsiLocalVariable.class);
                }
                return new Context(variable, assignment, variableName);
            }
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable findVariable(@NotNull PsiAssignmentExpression assignmentExpression) {
        PsiElement psiElement;
        PsiReferenceExpression reference;
        PsiExpression lExpression;
        if (assignmentExpression == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(1);
        }
        if ((lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression())) instanceof PsiReferenceExpression && !(reference = (PsiReferenceExpression)lExpression).isQualified() && (psiElement = reference.resolve()) instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)psiElement;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)assignmentExpression.getParent(), PsiExpressionStatement.class);
            if (declarationStatement != null && declarationStatement.getParent() instanceof PsiCodeBlock && expressionStatement != null && expressionStatement.getParent() == declarationStatement.getParent()) {
                return JoinDeclarationAndAssignmentJavaInspection.findOccurrence((PsiElement)expressionStatement, variable, PsiTreeUtil::skipWhitespacesAndCommentsBackward, (candidate, unused) -> candidate == declarationStatement ? variable : null);
            }
        }
        return null;
    }

    @Nullable
    private static PsiAssignmentExpression findAssignment(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(2);
        }
        return JoinDeclarationAndAssignmentJavaInspection.findOccurrence(variable.getParent(), variable, PsiTreeUtil::skipWhitespacesAndCommentsForward, JoinDeclarationAndAssignmentJavaInspection::findAssignment);
    }

    @Nullable
    private static <T> T findOccurrence(@Nullable PsiElement start, @NotNull PsiLocalVariable variable, @NotNull Function<? super PsiElement, ? extends PsiElement> advance, @NotNull BiFunction<? super PsiElement, ? super PsiLocalVariable, ? extends T> search) {
        PsiElement candidate;
        T result;
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(3);
        }
        if (advance == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(4);
        }
        if (search == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(5);
        }
        if ((result = search.apply((PsiElement)(candidate = advance.apply((PsiElement)start)), (PsiLocalVariable)variable)) != null) {
            return result;
        }
        if (JoinDeclarationAndAssignmentJavaInspection.canRemoveDeclaration((PsiVariable)variable)) {
            while (candidate != null) {
                result = search.apply((PsiElement)candidate, (PsiLocalVariable)variable);
                if (result != null) {
                    return result;
                }
                if (VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)candidate)) break;
                candidate = advance.apply((PsiElement)candidate);
            }
        }
        return null;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    private static PsiAssignmentExpression findAssignment(@Nullable PsiElement candidate, @NotNull PsiVariable variable) {
        PsiAssignmentExpression assignmentExpression;
        PsiExpressionStatement exprStatement;
        PsiExpression psiExpression;
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(6);
        }
        if (candidate instanceof PsiExpressionStatement && (psiExpression = (exprStatement = (PsiExpressionStatement)candidate).getExpression()) instanceof PsiAssignmentExpression && ExpressionUtils.isReferenceTo((PsiExpression)(assignmentExpression = (PsiAssignmentExpression)psiExpression).getLExpression(), (PsiVariable)variable)) {
            return assignmentExpression;
        }
        return null;
    }

    @Nullable
    private static PsiAssignmentExpression findNextAssignment(@Nullable PsiElement element, @NotNull PsiVariable variable) {
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(7);
        }
        PsiElement candidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        return JoinDeclarationAndAssignmentJavaInspection.findAssignment(candidate, variable);
    }

    private static boolean canRemoveDeclaration(@NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable == null) {
            JoinDeclarationAndAssignmentJavaInspection.$$$reportNull$$$0(8);
        }
        return (initializer = variable.getInitializer()) == null || !SideEffectChecker.checkSideEffects((PsiExpression)initializer, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "advance";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findVariable";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findAssignment";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findOccurrence";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findNextAssignment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canRemoveDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Context {
        @NotNull
        final PsiLocalVariable myVariable;
        @NotNull
        final PsiAssignmentExpression myAssignment;
        @NotNull
        final String myName;
        final boolean myIsUpdate;

        Context(@NotNull PsiLocalVariable variable, @NotNull PsiAssignmentExpression assignment, @NotNull String name) {
            if (variable == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (assignment == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (name == null) {
                Context.$$$reportNull$$$0(2);
            }
            this.myAssignment = assignment;
            this.myVariable = variable;
            this.myName = name;
            this.myIsUpdate = !JavaTokenType.EQ.equals(this.myAssignment.getOperationTokenType()) || JoinDeclarationAndAssignmentJavaInspection.findNextAssignment(this.myAssignment.getParent(), (PsiVariable)this.myVariable) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "assignment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$Context";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JoinDeclarationAndAssignmentFix
    extends ModCommandQuickFix {
        private JoinDeclarationAndAssignmentFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.join.declaration.and.assignment.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            Context context;
            if (project == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(2);
            }
            if ((context = JoinDeclarationAndAssignmentJavaInspection.getContext(element = descriptor.getPsiElement())) == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(3);
                }
                return modCommand;
            }
            PsiLocalVariable variable = context.myVariable;
            PsiExpression initializer = variable.getInitializer();
            List sideEffects = initializer == null || context.myAssignment.getOperationTokenType() != JavaTokenType.EQ ? List.of() : SideEffectChecker.extractSideEffectExpressions((PsiExpression)initializer);
            JoinDeclarationAndAssignmentAction action = new JoinDeclarationAndAssignmentAction(element);
            if (!sideEffects.isEmpty() && !ContainerUtil.exists((Iterable)sideEffects, se -> VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)se))) {
                List<JoinDeclarationAndAssignmentAction> subActions = List.of(new RemoveInitializerFix.SideEffectAwareRemove(initializer, var -> JoinDeclarationAndAssignmentAction.join((PsiElement)var)), action);
                ModCommand modCommand = ModCommand.chooseAction((String)JavaBundle.message((String)"inspection.join.declaration.and.assignment.fix.title", (Object[])new Object[0]), subActions);
                if (modCommand == null) {
                    JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            ModCommand modCommand = action.perform(ActionContext.from((ProblemDescriptor)descriptor));
            if (modCommand == null) {
                JoinDeclarationAndAssignmentFix.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$JoinDeclarationAndAssignmentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$JoinDeclarationAndAssignmentFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class JoinDeclarationAndAssignmentAction
    extends PsiUpdateModCommandAction<PsiElement> {
        protected JoinDeclarationAndAssignmentAction(@NotNull PsiElement element) {
            if (element == null) {
                JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"delete.initializer.completely", (Object[])new Object[0]);
            if (string == null) {
                JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext actionContext, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (actionContext == null) {
                JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(2);
            }
            if (element == null) {
                JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(4);
            }
            JoinDeclarationAndAssignmentAction.join(element);
        }

        private static void join(@NotNull PsiElement element) {
            Context context;
            if (element == null) {
                JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(5);
            }
            if ((context = JoinDeclarationAndAssignmentJavaInspection.getContext(element)) != null) {
                DeclarationJoinLinesHandler.joinDeclarationAndAssignment((PsiLocalVariable)context.myVariable, (PsiAssignmentExpression)context.myAssignment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$JoinDeclarationAndAssignmentAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/JoinDeclarationAndAssignmentJavaInspection$JoinDeclarationAndAssignmentAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

