/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.style.ConditionalModel;
import com.siyeh.ig.style.IfConditionalModel;
import com.siyeh.ig.style.SimplifiableIfStatementInspection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ManualMinMaxCalculationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean disableForNonIntegralTypes = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"disableForNonIntegralTypes", (String)JavaBundle.message((String)"inspection.manual.min.max.calculation.disable.for.non.integral", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ManualMinMaxCalculationInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ManualMinMaxCalculationInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitIfStatement(@NotNull PsiIfStatement statement) {
                IfConditionalModel model;
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((model = IfConditionalModel.from((PsiIfStatement)statement, (boolean)false)) == null) {
                    return;
                }
                this.visitConditional(statement.getFirstChild(), (ConditionalModel)model);
            }

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
                ConditionalModel model;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((model = ConditionalModel.from((PsiConditionalExpression)expression)) == null) {
                    return;
                }
                this.visitConditional((PsiElement)expression, model);
            }

            private void visitConditional(@NotNull PsiElement element, @NotNull ConditionalModel model) {
                PsiBinaryExpression condition;
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (model == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((condition = ManualMinMaxCalculationInspection.getCondition(model.getCondition())) == null) {
                    return;
                }
                PsiExpression left = condition.getLOperand();
                if (SideEffectChecker.mayHaveSideEffects((PsiElement)left, e -> e instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiType leftType = this.getType(left);
                if (leftType == null) {
                    return;
                }
                PsiExpression right = condition.getROperand();
                if (right == null || SideEffectChecker.mayHaveSideEffects((PsiElement)right, e -> e instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiType rightType = this.getType(right);
                if (rightType == null || leftType != rightType) {
                    return;
                }
                EquivalenceChecker equivalenceChecker = EquivalenceChecker.getCanonicalPsiEquivalence();
                boolean useMathMin = equivalenceChecker.expressionsAreEquivalent(left, model.getElseExpression());
                if (!useMathMin && !equivalenceChecker.expressionsAreEquivalent(left, model.getThenExpression())) {
                    return;
                }
                if (!equivalenceChecker.expressionsAreEquivalent(right, useMathMin ? model.getThenExpression() : model.getElseExpression())) {
                    return;
                }
                IElementType tokenType = condition.getOperationTokenType();
                useMathMin ^= JavaTokenType.LT.equals(tokenType) || JavaTokenType.LE.equals(tokenType);
                PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)element);
                if (containingClass != null && "java.lang.Math".equals(containingClass.getQualifiedName())) {
                    return;
                }
                holder.registerProblem(element, JavaBundle.message((String)"inspection.manual.min.max.calculation.description", (Object[])new Object[]{useMathMin ? "min" : "max"}), new LocalQuickFix[]{new ReplaceWithMinMaxFix(useMathMin)});
            }

            @Nullable
            private PsiType getType(@NotNull PsiExpression expression) {
                PsiType type;
                if (expression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((type = expression.getType()) == null) {
                    return null;
                }
                int rank = TypeConversionUtil.getTypeRank((PsiType)type);
                if (rank < 4 || rank > 7) {
                    return null;
                }
                return !ManualMinMaxCalculationInspection.this.disableForNonIntegralTypes || rank <= 5 ? type : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ManualMinMaxCalculationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditionalExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditional";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static PsiBinaryExpression getCondition(@Nullable PsiExpression expression) {
        PsiBinaryExpression condition = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiBinaryExpression.class);
        if (condition == null) {
            return null;
        }
        IElementType tokenType = condition.getOperationTokenType();
        if (JavaTokenType.LT.equals(tokenType) || JavaTokenType.LE.equals(tokenType) || JavaTokenType.GT.equals(tokenType) || JavaTokenType.GE.equals(tokenType)) {
            return condition;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ManualMinMaxCalculationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ManualMinMaxCalculationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ReplaceWithMinMaxFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myUseMathMin;

        @Contract(pure=true)
        private ReplaceWithMinMaxFix(boolean useMathMin) {
            this.myUseMathMin = useMathMin;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x.call", (Object[])new Object[]{"Math." + (this.myUseMathMin ? "min()" : "max()")});
            if (string == null) {
                ReplaceWithMinMaxFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement result;
            if (project == null) {
                ReplaceWithMinMaxFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithMinMaxFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithMinMaxFix.$$$reportNull$$$0(3);
            }
            CommentTracker ct = new CommentTracker();
            if (element instanceof PsiConditionalExpression) {
                ConditionalModel model = ConditionalModel.from((PsiConditionalExpression)((PsiConditionalExpression)element));
                if (model == null) {
                    return;
                }
                String replacement = this.createReplacement(model.getCondition(), ct);
                if (replacement == null) {
                    return;
                }
                PsiReplacementUtil.replaceExpression((PsiExpression)((PsiExpression)element), (String)replacement, (CommentTracker)ct);
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
            if (ifStatement == null) {
                return;
            }
            IfConditionalModel model = IfConditionalModel.from((PsiIfStatement)ifStatement, (boolean)false);
            if (model == null) {
                return;
            }
            String replacement = this.createReplacement(model.getCondition(), ct);
            if (replacement == null) {
                return;
            }
            PsiStatement elseBranch = model.getElseBranch();
            if (elseBranch instanceof PsiDeclarationStatement) {
                PsiReplacementUtil.replaceExpression((PsiExpression)model.getElseExpression(), (String)replacement, (CommentTracker)new CommentTracker());
                result = PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, (String)ct.text((PsiElement)elseBranch), (CommentTracker)ct);
                elseBranch.delete();
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)model.getThenExpression(), (String)replacement, (CommentTracker)new CommentTracker());
                result = PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, (String)ct.text((PsiElement)model.getThenBranch()), (CommentTracker)ct);
                if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)elseBranch, (boolean)true)) {
                    new CommentTracker().deleteAndRestoreComments((PsiElement)elseBranch);
                }
            }
            SimplifiableIfStatementInspection.tryJoinDeclaration((PsiElement)result);
        }

        @Nullable
        private String createReplacement(@NotNull PsiExpression expression, CommentTracker ct) {
            PsiBinaryExpression condition;
            if (expression == null) {
                ReplaceWithMinMaxFix.$$$reportNull$$$0(4);
            }
            if ((condition = ManualMinMaxCalculationInspection.getCondition(expression)) == null) {
                return null;
            }
            PsiExpression left = condition.getLOperand();
            PsiExpression right = condition.getROperand();
            if (right == null) {
                return null;
            }
            return "java.lang.Math" + (this.myUseMathMin ? ".min" : ".max") + "(" + ct.text((PsiElement)left) + "," + ct.text((PsiElement)right) + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ManualMinMaxCalculationInspection$ReplaceWithMinMaxFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ManualMinMaxCalculationInspection$ReplaceWithMinMaxFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createReplacement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

