/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MigrateToJavaLangIoInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean processImplicitClasses = true;
    public boolean processOrdinaryClasses = true;
    private static final CallMatcher PRINT_STREAM_PRINT = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.instanceCall((String)"java.io.PrintStream", (String[])new String[]{"println"}).parameterCount(0), CallMatcher.instanceCall((String)"java.io.PrintStream", (String[])new String[]{"println", "print"}).parameterCount(1)});

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.JAVA_LANG_IO);
        if (set == null) {
            MigrateToJavaLangIoInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"processOrdinaryClasses", (String)JavaBundle.message((String)"inspection.migrate.to.java.lang.io.option.ordinary", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"processImplicitClasses", (String)JavaBundle.message((String)"inspection.migrate.to.java.lang.io.option.implicit", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MigrateToJavaLangIoInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MigrateToJavaLangIoInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                String referenceName = expression.getMethodExpression().getReferenceName();
                if (referenceName == null) {
                    return;
                }
                if (!MigrateToJavaLangIoInspection.isSystemOutPrintln(expression)) {
                    return;
                }
                PsiClass topClass = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, PsiClass.class);
                if (topClass == null) {
                    return;
                }
                boolean applicableForClass = this.isApplicableForClass(topClass);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                if (applicableForClass) {
                    holder.registerProblem((PsiElement)methodExpression, JavaBundle.message((String)"inspection.migrate.to.java.lang.io.name", (Object[])new Object[0]), new LocalQuickFix[]{new ConvertSystemOutPrintlnFix(referenceName)});
                } else {
                    holder.registerProblem((PsiElement)methodExpression, JavaBundle.message((String)"inspection.migrate.to.java.lang.io.name", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new ConvertSystemOutPrintlnFix(referenceName)});
                }
            }

            private boolean isApplicableForClass(@Nullable PsiClass psiClass) {
                if (psiClass == null) {
                    return false;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class, (boolean)true) != null) {
                    return false;
                }
                if (psiClass instanceof PsiImplicitClass) {
                    return MigrateToJavaLangIoInspection.this.processImplicitClasses;
                }
                return MigrateToJavaLangIoInspection.this.processOrdinaryClasses;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/MigrateToJavaLangIoInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    static void replaceToIO(@NotNull PsiMethodCallExpression methodCall) {
        PsiReferenceExpression methodExpr;
        String methodName;
        if (methodCall == null) {
            MigrateToJavaLangIoInspection.$$$reportNull$$$0(3);
        }
        if ((methodName = (methodExpr = methodCall.getMethodExpression()).getReferenceName()) == null) {
            return;
        }
        PsiElement replaced = new CommentTracker().replaceAndRestoreComments((PsiElement)methodExpr, "java.lang.IO." + methodName);
        if (replaced instanceof PsiReferenceExpression) {
            PsiReferenceExpression replacedReferenceExpression = (PsiReferenceExpression)replaced;
            JavaCodeStyleManager.getInstance((Project)replacedReferenceExpression.getProject()).shortenClassReferences((PsiElement)replacedReferenceExpression);
        }
    }

    static boolean isSystemOutPrintln(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MigrateToJavaLangIoInspection.$$$reportNull$$$0(4);
        }
        if (!PRINT_STREAM_PRINT.test(expression)) {
            return false;
        }
        if (!MigrateToJavaLangIoInspection.isSystemOutCall(expression)) {
            return false;
        }
        return MigrateToJavaLangIoInspection.callIOAndSystemIdentical(expression.getArgumentList());
    }

    private static boolean isSystemOutCall(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifier;
        if (expression == null) {
            MigrateToJavaLangIoInspection.$$$reportNull$$$0(5);
        }
        if (!((qualifier = (methodExpression = expression.getMethodExpression()).getQualifierExpression()) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)qualifier;
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)resolved;
        if (!field.getName().equals("out")) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return "java.lang.System".equals(containingClass.getQualifiedName());
    }

    static boolean callIOAndSystemIdentical(@NotNull PsiExpressionList list) {
        PsiExpression[] expressions;
        if (list == null) {
            MigrateToJavaLangIoInspection.$$$reportNull$$$0(6);
        }
        if ((expressions = list.getExpressions()).length == 0) {
            return true;
        }
        if (expressions.length == 1) {
            PsiType type = expressions[0].getType();
            if (type == null) {
                return false;
            }
            if (type instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)type;
                if (PsiTypes.charType().equals((Object)arrayType.getComponentType())) {
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/MigrateToJavaLangIoInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/MigrateToJavaLangIoInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceToIO";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSystemOutPrintln";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSystemOutCall";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "callIOAndSystemIdentical";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static class ConvertSystemOutPrintlnFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String methodName;

        private ConvertSystemOutPrintlnFix(@NotNull String name) {
            if (name == null) {
                ConvertSystemOutPrintlnFix.$$$reportNull$$$0(0);
            }
            this.methodName = name;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.migrate.to.java.lang.io.fix.family", (Object[])new Object[0]);
            if (string == null) {
                ConvertSystemOutPrintlnFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.migrate.to.java.lang.io.fix.name", (Object[])new Object[]{"IO." + this.methodName + "()"});
            if (string == null) {
                ConvertSystemOutPrintlnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                ConvertSystemOutPrintlnFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ConvertSystemOutPrintlnFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ConvertSystemOutPrintlnFix.$$$reportNull$$$0(5);
            }
            if (!((parent = element.getParent()) instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
            MigrateToJavaLangIoInspection.replaceToIO(methodCall);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/MigrateToJavaLangIoInspection$ConvertSystemOutPrintlnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/MigrateToJavaLangIoInspection$ConvertSystemOutPrintlnFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

