/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class OptionalAssignedToNullInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher MAP_GET = CallMatcher.instanceCall((String)"java.util.Map", (String[])new String[]{"get"}).parameterTypes(new String[]{"java.lang.Object"});
    public boolean WARN_ON_COMPARISON = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"WARN_ON_COMPARISON", (String)JavaBundle.message((String)"inspection.null.value.for.optional.option.comparisons", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            OptionalAssignedToNullInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            OptionalAssignedToNullInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalAssignedToNullInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.checkNulls(expression.getType(), expression.getRExpression(), JavaBundle.message((String)"inspection.null.value.for.optional.context.assignment", (Object[])new Object[0]));
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                boolean varArgCall;
                PsiExpression[] args;
                if (call == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((args = call.getArgumentList().getExpressions()).length == 0) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length > args.length) {
                    return;
                }
                boolean bl = varArgCall = method.isVarArgs() && MethodCallUtils.isVarArgCall((PsiCall)call);
                if (!varArgCall && parameters.length < args.length) {
                    return;
                }
                for (int i = 0; i < args.length; ++i) {
                    PsiParameter parameter = parameters[Math.min(parameters.length - 1, i)];
                    PsiType type = parameter.getType();
                    if (varArgCall && i >= parameters.length - 1 && type instanceof PsiEllipsisType) {
                        type = ((PsiEllipsisType)type).getComponentType();
                    }
                    this.checkNulls(type, args[i], JavaBundle.message((String)"inspection.null.value.for.optional.context.parameter", (Object[])new Object[0]));
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
                PsiElement body;
                if (lambda == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((body = lambda.getBody()) instanceof PsiExpression) {
                    this.checkNulls(LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda), (PsiExpression)body, JavaBundle.message((String)"inspection.null.value.for.optional.context.lambda", (Object[])new Object[0]));
                }
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.checkNulls(PsiTypesUtil.getMethodReturnType((PsiElement)statement), statement.getReturnValue(), JavaBundle.message((String)"inspection.null.value.for.optional.context.return", (Object[])new Object[0]));
            }

            public void visitVariable(@NotNull PsiVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.checkNulls(variable.getType(), variable.getInitializer(), JavaBundle.message((String)"inspection.null.value.for.optional.context.declaration", (Object[])new Object[0]));
            }

            public void visitBinaryExpression(@NotNull PsiBinaryExpression binOp) {
                if (binOp == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (!OptionalAssignedToNullInspection.this.WARN_ON_COMPARISON) {
                    return;
                }
                PsiExpression value = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)binOp);
                if (value != null && TypeUtils.isOptional((PsiType)value.getType()) && !1.hasSubsequentIsPresentCall(value, (PsiExpression)binOp, JavaTokenType.EQEQ.equals(binOp.getOperationTokenType())) && !1.comesFromMapGet(value)) {
                    boolean useIsEmpty = binOp.getOperationTokenType().equals(JavaTokenType.EQEQ) && PsiUtil.getLanguageLevel((PsiElement)binOp).isAtLeast(LanguageLevel.JDK_11);
                    holder.problem((PsiElement)binOp, JavaBundle.message((String)"inspection.null.value.for.optional.assigned.message", (Object[])new Object[0])).fix((LocalQuickFix)new ReplaceWithIsPresentFix(useIsEmpty)).fix((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)OptionalAssignedToNullInspection.this, "WARN_ON_COMPARISON", JavaBundle.message((String)"inspection.null.value.for.optional.assigned.ignore.fix.name", (Object[])new Object[0]), false)).register();
                }
            }

            private static boolean comesFromMapGet(PsiExpression value) {
                PsiExpression initializer;
                PsiLocalVariable local = ExpressionUtils.resolveLocalVariable((PsiExpression)value);
                if (local != null && (initializer = (PsiExpression)ContainerUtil.getOnlyItem((Collection)DfaUtil.getVariableValues((PsiVariable)local, (PsiElement)value))) != null) {
                    value = initializer;
                }
                return MAP_GET.matches(ExpressionUtils.resolveExpression((PsiExpression)value));
            }

            private static boolean hasSubsequentIsPresentCall(@NotNull PsiExpression optionalExpression, @NotNull PsiExpression previousExpression, boolean negated) {
                IElementType expectedToken;
                PsiPolyadicExpression parent;
                if (optionalExpression == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (previousExpression == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((parent = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)previousExpression.getParent()), PsiPolyadicExpression.class)) == null) {
                    return false;
                }
                IElementType iElementType = expectedToken = negated ? JavaTokenType.OROR : JavaTokenType.ANDAND;
                if (!parent.getOperationTokenType().equals(expectedToken)) {
                    return false;
                }
                PsiExpression nextExpression = ((StreamEx)((StreamEx)StreamEx.of((Object[])parent.getOperands()).dropWhile(op -> !PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)previousExpression, (boolean)false))).skip(1L)).findFirst().orElse(null);
                if ((nextExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextExpression)) == null) {
                    return false;
                }
                if (negated) {
                    if (!BoolUtils.isNegation((PsiExpression)nextExpression)) {
                        return false;
                    }
                    nextExpression = BoolUtils.getNegated((PsiExpression)nextExpression);
                }
                if (!(nextExpression instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)nextExpression;
                if (!"isPresent".equals(call.getMethodExpression().getReferenceName()) || !call.getArgumentList().isEmpty()) {
                    return false;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                return qualifier != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)optionalExpression);
            }

            private void checkNulls(PsiType type, PsiExpression expression, String declaration) {
                if (expression != null && TypeUtils.isOptional((PsiType)type)) {
                    ExpressionUtils.nonStructuralChildren((PsiExpression)expression).filter(ExpressionUtils::isNullLiteral).forEach(nullLiteral -> this.register((PsiExpression)nullLiteral, (PsiClassType)type, declaration));
                }
            }

            private void register(PsiExpression expression, PsiClassType type, String contextName) {
                holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.null.value.for.optional.message", (Object[])new Object[]{contextName}), new LocalQuickFix[]{new ReplaceWithEmptyOptionalFix(type)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lambda";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "binOp";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalExpression";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previousExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBinaryExpression";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasSubsequentIsPresentCall";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/OptionalAssignedToNullInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithIsPresentFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myUseIsEmpty;

        private ReplaceWithIsPresentFix(boolean useIsEmpty) {
            this.myUseIsEmpty = useIsEmpty;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myUseIsEmpty ? "isEmpty" : "isPresent()"});
            if (string == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"isPresent()"});
            if (string == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiBinaryExpression binOp;
            if (project == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithIsPresentFix.$$$reportNull$$$0(4);
            }
            if ((binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)element, PsiBinaryExpression.class)) == null) {
                return;
            }
            PsiExpression value = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)binOp);
            if (value == null || !TypeUtils.isOptional((PsiType)value.getType())) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String negation = this.myUseIsEmpty || binOp.getOperationTokenType().equals(JavaTokenType.NE) ? "" : "!";
            String methodName = this.myUseIsEmpty ? "isEmpty" : "isPresent";
            ct.replaceAndRestoreComments((PsiElement)binOp, negation + ct.text(value, 1) + "." + methodName + "()");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithIsPresentFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithIsPresentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceWithEmptyOptionalFix
    extends PsiUpdateModCommandQuickFix {
        private final String myTypeName;
        private final String myTypeParameter;
        private final String myMethodName;

        ReplaceWithEmptyOptionalFix(PsiClassType type) {
            this.myTypeName = type.rawType().getCanonicalText();
            PsiType[] parameters = type.getParameters();
            this.myTypeParameter = parameters.length == 1 ? "<" + GenericsUtil.getVariableTypeByExpressionType((PsiType)parameters[0]).getCanonicalText() + ">" : "";
            this.myMethodName = this.myTypeName.equals("com.google.common.base.Optional") ? "absent" : "empty";
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{StringUtil.getShortName((String)this.myTypeName) + "." + this.myMethodName + "()"});
            if (string == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.null.value.for.optional.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiExpression)) {
                return;
            }
            String emptyCall = this.myTypeName + "." + this.myTypeParameter + this.myMethodName + "()";
            PsiElement result = new CommentTracker().replaceAndRestoreComments(element, emptyCall);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

