/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalIsPresentInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(OptionalIsPresentInspection.class);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"isPresent"}).parameterCount(0);
    private static final CallMatcher OPTIONAL_IS_EMPTY = CallMatcher.instanceCall((String)"java.util.Optional", (String[])new String[]{"isEmpty"}).parameterCount(0);
    private static final OptionalIsPresentCase[] CASES = OptionalIsPresentCase.values();

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitConditionalExpression(expression);
                PsiExpression condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getCondition());
                if (condition == null) {
                    return;
                }
                PsiReferenceExpression optionalRef = OptionalIsPresentInspection.extractOptionalFromPresenceCheck(condition);
                if (optionalRef == null) {
                    return;
                }
                boolean invert = OptionalIsPresentInspection.isEmptyCheck(condition);
                PsiExpression thenExpression = invert ? expression.getElseExpression() : expression.getThenExpression();
                PsiExpression elseExpression = invert ? expression.getThenExpression() : expression.getElseExpression();
                this.check(condition, optionalRef, (PsiElement)thenExpression, (PsiElement)elseExpression);
            }

            public void visitIfStatement(@NotNull PsiIfStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitIfStatement(statement);
                PsiExpression condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getCondition());
                if (condition == null) {
                    return;
                }
                PsiReferenceExpression optionalRef = OptionalIsPresentInspection.extractOptionalFromPresenceCheck(condition);
                if (optionalRef == null) {
                    return;
                }
                boolean invert = OptionalIsPresentInspection.isEmptyCheck(condition);
                PsiStatement thenStatement = OptionalIsPresentInspection.extractThenStatement(statement, invert);
                PsiStatement elseStatement = OptionalIsPresentInspection.extractElseStatement(statement, invert);
                this.check(condition, optionalRef, (PsiElement)thenStatement, (PsiElement)elseStatement);
            }

            void check(@NotNull PsiExpression condition, PsiReferenceExpression optionalRef, PsiElement thenElement, PsiElement elseElement) {
                if (condition == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (OptionalIsPresentCase scenario : CASES) {
                    scenario.getProblemType(optionalRef, thenElement, elseElement).registerProblem(holder, condition, scenario);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "condition";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditionalExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "check";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isRaw(@NotNull PsiVariable variable) {
        PsiType type;
        if (variable == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(2);
        }
        return (type = variable.getType()) instanceof PsiClassType && ((PsiClassType)type).isRaw();
    }

    @Nullable
    private static PsiStatement extractThenStatement(@NotNull PsiIfStatement ifStatement, boolean invert) {
        if (ifStatement == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(3);
        }
        if (invert) {
            return OptionalIsPresentInspection.extractElseStatement(ifStatement, false);
        }
        return ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
    }

    @Nullable
    private static PsiStatement extractElseStatement(@NotNull PsiIfStatement ifStatement, boolean invert) {
        PsiElement nextElement;
        PsiStatement thenStatement;
        if (ifStatement == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(4);
        }
        if (invert) {
            return OptionalIsPresentInspection.extractThenStatement(ifStatement, false);
        }
        PsiStatement statement = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getElseBranch());
        if (statement == null && (thenStatement = OptionalIsPresentInspection.extractThenStatement(ifStatement, false)) instanceof PsiReturnStatement && (nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement)) instanceof PsiStatement) {
            statement = ControlFlowUtils.stripBraces((PsiStatement)((PsiStatement)nextElement));
        }
        return statement;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiReferenceExpression extractOptionalFromPresenceCheck(PsiExpression condition) {
        while (condition != null && BoolUtils.isNegation((PsiExpression)condition)) {
            condition = BoolUtils.getNegated((PsiExpression)condition);
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)condition, PsiMethodCallExpression.class);
        if (!OPTIONAL_IS_PRESENT.matches((PsiExpression)call) && !OPTIONAL_IS_EMPTY.matches((PsiExpression)call)) {
            return null;
        }
        PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression()), PsiReferenceExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiElement element = qualifier.resolve();
        if (!(element instanceof PsiVariable) || OptionalIsPresentInspection.isRaw((PsiVariable)element)) {
            return null;
        }
        return qualifier;
    }

    private static boolean isEmptyCheck(PsiExpression condition) {
        boolean invert = false;
        while (condition != null && BoolUtils.isNegation((PsiExpression)condition)) {
            condition = BoolUtils.getNegated((PsiExpression)condition);
            invert = !invert;
        }
        return OPTIONAL_IS_EMPTY.matches(condition) != invert;
    }

    @Contract(value="null, _ -> false")
    static boolean isOptionalGetCall(PsiElement element, @NotNull PsiReferenceExpression optionalRef) {
        PsiMethodCallExpression call;
        if (optionalRef == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(5);
        }
        if (!OptionalUtil.JDK_OPTIONAL_GET.matches((PsiExpression)(call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class)))) {
            return false;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)call.getMethodExpression());
        return qualifier != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)optionalRef);
    }

    @NotNull
    static ProblemType getTypeByLambdaCandidate(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement lambdaCandidate, @Nullable PsiExpression falseExpression) {
        if (optionalRef == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(6);
        }
        if (lambdaCandidate == null) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(7);
            }
            return problemType;
        }
        if (lambdaCandidate instanceof PsiReferenceExpression && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lambdaCandidate, (PsiElement)optionalRef) && OptionalUtil.isOptionalEmptyCall((PsiExpression)falseExpression)) {
            ProblemType problemType = ProblemType.WARNING;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(8);
            }
            return problemType;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaCandidate, arg_0 -> ((PsiReferenceExpression)optionalRef).isReferenceTo(arg_0))) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(9);
            }
            return problemType;
        }
        Ref hasOptionalReference = new Ref((Object)Boolean.FALSE);
        boolean hasNoBadRefs = PsiTreeUtil.processElements((PsiElement)lambdaCandidate, e -> {
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)optionalRef)) {
                return true;
            }
            hasOptionalReference.set((Object)Boolean.TRUE);
            return OptionalIsPresentInspection.isOptionalGetCall(e.getParent().getParent(), optionalRef);
        });
        if (((Boolean)hasOptionalReference.get()).booleanValue() && OptionalIsPresentInspection.getOnlyLocalVariable(lambdaCandidate, optionalRef) != null) {
            ProblemType problemType = ProblemType.WARNING;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(10);
            }
            return problemType;
        }
        if (!hasNoBadRefs) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(11);
            }
            return problemType;
        }
        if (!((Boolean)hasOptionalReference.get()).booleanValue() || !(lambdaCandidate instanceof PsiExpression)) {
            ProblemType problemType = ProblemType.INFO;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(12);
            }
            return problemType;
        }
        PsiExpression expression = (PsiExpression)lambdaCandidate;
        if (falseExpression != null) {
            if (!ExpressionUtils.isNullLiteral((PsiExpression)falseExpression) && NullabilityUtil.getExpressionNullability((PsiExpression)expression, (boolean)true) != Nullability.NOT_NULL) {
                ProblemType problemType = ProblemType.INFO;
                if (problemType == null) {
                    OptionalIsPresentInspection.$$$reportNull$$$0(13);
                }
                return problemType;
            }
            PsiType falseType = falseExpression.getType();
            PsiType trueType = expression.getType();
            if (falseType == null || trueType == null) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    OptionalIsPresentInspection.$$$reportNull$$$0(14);
                }
                return problemType;
            }
            if (falseType instanceof PsiPrimitiveType && trueType instanceof PsiPrimitiveType) {
                if (falseType.equals(trueType) || JavaPsiMathUtil.getNumberFromLiteral((PsiExpression)falseExpression) != null) {
                    ProblemType problemType = ProblemType.WARNING;
                    if (problemType == null) {
                        OptionalIsPresentInspection.$$$reportNull$$$0(15);
                    }
                    return problemType;
                }
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    OptionalIsPresentInspection.$$$reportNull$$$0(16);
                }
                return problemType;
            }
            if (!trueType.isAssignableFrom(falseType)) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    OptionalIsPresentInspection.$$$reportNull$$$0(17);
                }
                return problemType;
            }
        }
        ProblemType problemType = ProblemType.WARNING;
        if (problemType == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(18);
        }
        return problemType;
    }

    @Nullable
    private static PsiLocalVariable getOnlyLocalVariable(@NotNull PsiElement lambdaCandidate, @NotNull PsiReferenceExpression optionalRef) {
        PsiDeclarationStatement declStmt;
        PsiStatement psiStatement;
        if (lambdaCandidate == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(19);
        }
        if (optionalRef == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(20);
        }
        if (!(lambdaCandidate instanceof PsiBlockStatement)) {
            return null;
        }
        PsiBlockStatement blockStmt = (PsiBlockStatement)lambdaCandidate;
        PsiStatement[] statements = blockStmt.getCodeBlock().getStatements();
        if (statements.length == 2 && (psiStatement = statements[0]) instanceof PsiDeclarationStatement && (psiStatement = (declStmt = (PsiDeclarationStatement)psiStatement).getFirstChild()) instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)psiStatement;
            psiStatement = statements[1];
            if (psiStatement instanceof PsiExpressionStatement) {
                PsiExpressionStatement exprStmt = (PsiExpressionStatement)psiStatement;
                PsiExpression localVariableInitializer = localVariable.getInitializer();
                if (localVariableInitializer == null) {
                    return null;
                }
                if (!VariableAccessUtils.variableIsUsed((PsiVariable)localVariable, (PsiElement)exprStmt)) {
                    return null;
                }
                if (!OptionalIsPresentInspection.isOptionalGetCall((PsiElement)localVariableInitializer, optionalRef)) {
                    return null;
                }
                List varReferences = VariableAccessUtils.getVariableReferences((PsiVariable)localVariable);
                PsiType unwrappedOptionalType = PsiUtil.substituteTypeParameter((PsiType)optionalRef.getType(), (String)"java.util.Optional", (int)0, (boolean)false);
                if (unwrappedOptionalType == null) {
                    return null;
                }
                for (PsiReferenceExpression varReference : varReferences) {
                    if (VariableAccessUtils.isVariableTypeChangeSafeForReference((PsiType)unwrappedOptionalType, (PsiReferenceExpression)varReference)) continue;
                    return null;
                }
                return localVariable;
            }
        }
        return null;
    }

    @NotNull
    static String generateOptionalLambda(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, PsiReferenceExpression optionalRef, PsiElement trueValue) {
        if (factory == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(21);
        }
        if (ct == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(22);
        }
        PsiType type = optionalRef.getType();
        String paramName = new VariableNameGenerator(trueValue, VariableKind.PARAMETER).byType(OptionalUtil.getOptionalElementType((PsiType)type)).byName(new String[]{"value"}).generate(true);
        PsiLocalVariable theOnlyVariable = OptionalIsPresentInspection.getOnlyLocalVariable(trueValue, optionalRef);
        if (theOnlyVariable != null && trueValue instanceof PsiBlockStatement) {
            PsiBlockStatement blockStmt = (PsiBlockStatement)trueValue;
            paramName = theOnlyVariable.getName();
            PsiStatement varDecl = blockStmt.getCodeBlock().getStatements()[0];
            varDecl.delete();
            trueValue = blockStmt.getCodeBlock().getStatements()[0];
        }
        if (trueValue instanceof PsiExpressionStatement) {
            trueValue = ((PsiExpressionStatement)trueValue).getExpression();
        }
        ct.markUnchanged(trueValue);
        PsiElement copy = trueValue.copy();
        for (PsiElement getCall : PsiTreeUtil.collectElements((PsiElement)copy, e -> OptionalIsPresentInspection.isOptionalGetCall(e, optionalRef))) {
            PsiElement result = getCall.replace((PsiElement)factory.createIdentifier(paramName));
            if (copy != getCall) continue;
            copy = result;
        }
        if (copy instanceof PsiStatement && !(copy instanceof PsiBlockStatement)) {
            String string = paramName + "->{" + copy.getText() + "}";
            if (string == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = paramName + "->" + copy.getText();
        if (string == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(24);
        }
        return string;
    }

    static String generateOptionalUnwrap(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, @NotNull PsiExpression trueValue, @NotNull PsiExpression falseValue, PsiType targetType) {
        if (factory == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(25);
        }
        if (ct == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(26);
        }
        if (optionalRef == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(27);
        }
        if (trueValue == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(28);
        }
        if (falseValue == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(29);
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)trueValue, (PsiElement)optionalRef) && OptionalUtil.isOptionalEmptyCall((PsiExpression)falseValue)) {
            trueValue = factory.createExpressionFromText("java.util.Optional.of(" + optionalRef.getText() + ".get())", (PsiElement)trueValue);
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseValue, (PsiElement)optionalRef)) {
            falseValue = factory.createExpressionFromText("java.util.Optional.empty()", (PsiElement)falseValue);
        }
        String lambdaText = OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalRef, (PsiElement)trueValue);
        PsiLambdaExpression lambda = (PsiLambdaExpression)factory.createExpressionFromText(lambdaText, (PsiElement)trueValue);
        PsiExpression body = Objects.requireNonNull((PsiExpression)lambda.getBody());
        return OptionalRefactoringUtil.generateOptionalUnwrap((String)optionalRef.getText(), (PsiVariable)lambda.getParameterList().getParameters()[0], (PsiExpression)body, (PsiExpression)((PsiExpression)ct.markUnchanged((PsiElement)falseValue)), (PsiType)targetType, (boolean)true);
    }

    static boolean isSimpleOrUnchecked(PsiExpression expression) {
        return ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expression) || LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 19, 20, 21, 22, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalRef";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaCandidate";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ct";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueValue";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByLambdaCandidate";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "generateOptionalLambda";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRaw";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractThenStatement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractElseStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOptionalGetCall";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByLambdaCandidate";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyLocalVariable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateOptionalLambda";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generateOptionalUnwrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 19, 20, 21, 22, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }

    private static enum ProblemType {
        WARNING,
        INFO,
        NONE;


        void registerProblem(@NotNull ProblemsHolder holder, @NotNull PsiExpression condition, OptionalIsPresentCase scenario) {
            if (holder == null) {
                ProblemType.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                ProblemType.$$$reportNull$$$0(1);
            }
            if (this != NONE) {
                if (this == INFO && !holder.isOnTheFly()) {
                    return;
                }
                holder.registerProblem((PsiElement)condition, JavaBundle.message((String)"inspection.message.can.be.replaced.with.single.expression.in.functional.style", (Object[])new Object[0]), this == INFO ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new OptionalIsPresentFix(scenario)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$ProblemType";
            objectArray[2] = "registerProblem";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum OptionalIsPresentCase {
        RETURN_CASE{

            @Override
            @NotNull
            public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
                PsiReturnStatement trueReturn;
                block9: {
                    block8: {
                        if (optionalRef == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!(trueElement instanceof PsiReturnStatement)) break block8;
                        trueReturn = (PsiReturnStatement)trueElement;
                        if (falseElement instanceof PsiReturnStatement) break block9;
                    }
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return problemType;
                }
                PsiReturnStatement falseReturn = (PsiReturnStatement)falseElement;
                PsiExpression falseValue = falseReturn.getReturnValue();
                PsiExpression trueValue = trueReturn.getReturnValue();
                if (!OptionalIsPresentInspection.isSimpleOrUnchecked(falseValue)) {
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return problemType;
                }
                ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalRef, (PsiElement)trueValue, falseValue);
                if (problemType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return problemType;
            }

            @Override
            @NotNull
            public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalVariable, PsiElement trueElement, PsiElement falseElement) {
                if (factory == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (ct == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (optionalVariable == null) {
                    1.$$$reportNull$$$0(6);
                }
                PsiExpression trueValue = ((PsiReturnStatement)trueElement).getReturnValue();
                PsiExpression falseValue = ((PsiReturnStatement)falseElement).getReturnValue();
                LOG.assertTrue(trueValue != null);
                LOG.assertTrue(falseValue != null);
                String string = "return " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueValue, falseValue, PsiTypesUtil.getMethodReturnType((PsiElement)trueElement)) + ";";
                if (string == null) {
                    1.$$$reportNull$$$0(7);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalRef";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ct";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalVariable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "generateReplacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "generateReplacement";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 7 -> new IllegalStateException(string);
                };
            }
        }
        ,
        ASSIGNMENT_CASE{

            @Override
            @NotNull
            public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalVariable, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
                if (optionalVariable == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment((PsiElement)trueElement);
                PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment((PsiElement)falseElement);
                if (trueAssignment == null || falseAssignment == null) {
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return problemType;
                }
                PsiExpression falseVal = falseAssignment.getRExpression();
                PsiExpression trueVal = trueAssignment.getRExpression();
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)trueAssignment.getLExpression(), (PsiElement)falseAssignment.getLExpression()) && OptionalIsPresentInspection.isSimpleOrUnchecked(falseVal)) {
                    ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueVal, falseVal);
                    if (problemType == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return problemType;
                }
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    2.$$$reportNull$$$0(3);
                }
                return problemType;
            }

            @Override
            @NotNull
            public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, PsiElement trueElement, PsiElement falseElement) {
                if (factory == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (ct == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (optionalRef == null) {
                    2.$$$reportNull$$$0(6);
                }
                PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment((PsiElement)trueElement);
                PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment((PsiElement)falseElement);
                LOG.assertTrue(trueAssignment != null);
                LOG.assertTrue(falseAssignment != null);
                PsiExpression lValue = trueAssignment.getLExpression();
                PsiExpression trueValue = trueAssignment.getRExpression();
                PsiExpression falseValue = falseAssignment.getRExpression();
                LOG.assertTrue(trueValue != null);
                LOG.assertTrue(falseValue != null);
                String string = lValue.getText() + " = " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalRef, trueValue, falseValue, lValue.getType()) + ";";
                if (string == null) {
                    2.$$$reportNull$$$0(7);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalVariable";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ct";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalRef";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "generateReplacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "generateReplacement";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 7 -> new IllegalStateException(string);
                };
            }
        }
        ,
        TERNARY_CASE{

            @Override
            @NotNull
            public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalVariable, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
                PsiExpression trueExpression;
                block9: {
                    block8: {
                        if (optionalVariable == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (!(trueElement instanceof PsiExpression)) break block8;
                        trueExpression = (PsiExpression)trueElement;
                        if (falseElement instanceof PsiExpression) break block9;
                    }
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return problemType;
                }
                PsiExpression falseExpression = (PsiExpression)falseElement;
                PsiType trueType = trueExpression.getType();
                PsiType falseType = falseExpression.getType();
                if (trueType == null || falseType == null || !trueType.isAssignableFrom(falseType) || !OptionalIsPresentInspection.isSimpleOrUnchecked(falseExpression)) {
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return problemType;
                }
                ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueExpression, falseExpression);
                if (problemType == null) {
                    3.$$$reportNull$$$0(3);
                }
                return problemType;
            }

            @Override
            @NotNull
            public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalVariable, PsiElement trueElement, PsiElement falseElement) {
                PsiExpression ternary;
                if (factory == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (ct == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (optionalVariable == null) {
                    3.$$$reportNull$$$0(6);
                }
                LOG.assertTrue((ternary = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)trueElement, PsiConditionalExpression.class)) != null);
                PsiExpression trueExpression = (PsiExpression)trueElement;
                PsiExpression falseExpression = (PsiExpression)falseElement;
                String string = OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueExpression, falseExpression, ternary.getType());
                if (string == null) {
                    3.$$$reportNull$$$0(7);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalVariable";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$3";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ct";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$3";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "generateReplacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "generateReplacement";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 7 -> new IllegalStateException(string);
                };
            }
        }
        ,
        CONSUMER_CASE{

            @Override
            @NotNull
            public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
                if (optionalRef == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (falseElement != null && !(falseElement instanceof PsiEmptyStatement)) {
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return problemType;
                }
                if (!(trueElement instanceof PsiStatement)) {
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return problemType;
                }
                if (trueElement instanceof PsiExpressionStatement) {
                    PsiExpressionStatement expressionStmt = (PsiExpressionStatement)trueElement;
                    PsiExpression expression = expressionStmt.getExpression();
                    if (OptionalIsPresentInspection.isOptionalGetCall((PsiElement)expression, optionalRef)) {
                        ProblemType problemType = ProblemType.NONE;
                        if (problemType == null) {
                            4.$$$reportNull$$$0(3);
                        }
                        return problemType;
                    }
                    trueElement = expression;
                }
                ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalRef, trueElement, null);
                if (problemType == null) {
                    4.$$$reportNull$$$0(4);
                }
                return problemType;
            }

            @Override
            @NotNull
            public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, PsiElement trueElement, PsiElement falseElement) {
                if (factory == null) {
                    4.$$$reportNull$$$0(5);
                }
                if (ct == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (optionalRef == null) {
                    4.$$$reportNull$$$0(7);
                }
                String string = optionalRef.getText() + ".ifPresent(" + OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalRef, trueElement) + ");";
                if (string == null) {
                    4.$$$reportNull$$$0(8);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 4, 8 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "optionalRef";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$4";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ct";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentCase$4";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemType";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "generateReplacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 8: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "generateReplacement";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 4, 8 -> new IllegalStateException(string);
                };
            }
        };


        @NotNull
        abstract ProblemType getProblemType(@NotNull PsiReferenceExpression var1, @Nullable PsiElement var2, @Nullable PsiElement var3);

        @NotNull
        abstract String generateReplacement(@NotNull PsiElementFactory var1, @NotNull CommentTracker var2, @NotNull PsiReferenceExpression var3, PsiElement var4, PsiElement var5);
    }

    static class OptionalIsPresentFix
    extends PsiUpdateModCommandQuickFix {
        private final OptionalIsPresentCase myScenario;

        OptionalIsPresentFix(OptionalIsPresentCase scenario) {
            this.myScenario = scenario;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"intention.family.replace.optional.ispresent.condition.with.functional.style.expression", (Object[])new Object[0]);
            if (string == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiStatement elseElement;
            PsiStatement thenElement;
            if (project == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression condition = (PsiExpression)element;
            PsiReferenceExpression optionalRef = OptionalIsPresentInspection.extractOptionalFromPresenceCheck(condition);
            if (optionalRef == null) {
                return;
            }
            PsiElement cond = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class});
            boolean invert = OptionalIsPresentInspection.isEmptyCheck(condition);
            if (cond instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)cond;
                thenElement = OptionalIsPresentInspection.extractThenStatement(ifStatement, invert);
                elseElement = OptionalIsPresentInspection.extractElseStatement(ifStatement, invert);
            } else if (cond instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)cond;
                thenElement = invert ? ternary.getElseExpression() : ternary.getThenExpression();
                elseElement = invert ? ternary.getThenExpression() : ternary.getElseExpression();
            } else {
                return;
            }
            if (this.myScenario.getProblemType(optionalRef, (PsiElement)thenElement, (PsiElement)elseElement) == ProblemType.NONE) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            String replacementText = this.myScenario.generateReplacement(factory, ct, optionalRef, (PsiElement)thenElement, (PsiElement)elseElement);
            if (thenElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)thenElement, (boolean)true)) {
                ct.delete((PsiElement)thenElement);
            }
            if (elseElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)elseElement, (boolean)true)) {
                ct.delete((PsiElement)elseElement);
            }
            PsiElement result = ct.replaceAndRestoreComments(cond, replacementText);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

