/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NavigateToDuplicateExpressionFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OverwrittenKeyInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher SET_ADD = CallMatcher.instanceCall((String)"java.util.Set", (String[])new String[]{"add"}).parameterCount(1);
    private static final CallMatcher MAP_PUT = CallMatcher.instanceCall((String)"java.util.Map", (String[])new String[]{"put"}).parameterCount(2);
    private static final CallMatcher SET_OF = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.Set", (String[])new String[]{"of"}), CallMatcher.staticCall((String)"java.util.EnumSet", (String[])new String[]{"of"}), CallMatcher.staticCall((String)"com.google.common.collect.ImmutableSet", (String[])new String[]{"of"})});
    private static final CallMatcher MAP_OF = CallMatcher.staticCall((String)"java.util.Map", (String[])new String[]{"of"});
    private static final CallMatcher MAP_OF_ENTRIES = CallMatcher.staticCall((String)"java.util.Map", (String[])new String[]{"ofEntries"});
    private static final CallMatcher MAP_ENTRY = CallMatcher.staticCall((String)"java.util.Map", (String[])new String[]{"entry"});

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OverwrittenKeyInspection.$$$reportNull$$$0(0);
        }
        return new OverwrittenKeyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/OverwrittenKeyInspection", "buildVisitor"));
    }

    private static class OverwrittenKeyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        OverwrittenKeyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitCodeBlock(@NotNull PsiCodeBlock block) {
            if (block == null) {
                OverwrittenKeyVisitor.$$$reportNull$$$0(0);
            }
            PsiExpressionStatement statement = (PsiExpressionStatement)PsiTreeUtil.getChildOfType((PsiElement)block, PsiExpressionStatement.class);
            while (statement != null) {
                PsiExpression expression = statement.getExpression();
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression, PsiMethodCallExpression.class);
                if (SET_ADD.test(call)) {
                    statement = this.processCallSequence(call, statement, SET_ADD, JavaBundle.message((String)"inspection.overwritten.key.set.message", (Object[])new Object[0]));
                } else if (MAP_PUT.test(call)) {
                    statement = this.processCallSequence(call, statement, MAP_PUT, JavaBundle.message((String)"inspection.overwritten.key.map.message", (Object[])new Object[0]));
                }
                if (expression instanceof PsiAssignmentExpression) {
                    statement = this.processArraySequence((PsiAssignmentExpression)expression, statement, JavaBundle.message((String)"inspection.overwritten.key.array.message", (Object[])new Object[0]));
                }
                statement = (PsiExpressionStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiExpressionStatement.class);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                OverwrittenKeyVisitor.$$$reportNull$$$0(1);
            }
            if (SET_OF.test(call)) {
                this.findDuplicates(call.getArgumentList().getExpressions(), JavaBundle.message((String)"inspection.overwritten.key.set.message", (Object[])new Object[0]));
            } else if (MAP_OF.test(call)) {
                Object[] args = call.getArgumentList().getExpressions();
                this.findDuplicates((PsiExpression[])IntStreamEx.range((int)0, (int)args.length, (int)2).elements(args).toArray(PsiExpression[]::new), JavaBundle.message((String)"inspection.overwritten.key.map.message", (Object[])new Object[0]));
            } else if (MAP_OF_ENTRIES.test(call)) {
                PsiExpression[] keys = (PsiExpression[])((StreamEx)StreamEx.of((Object[])call.getArgumentList().getExpressions()).map(PsiUtil::skipParenthesizedExprDown).select(PsiMethodCallExpression.class).filter((Predicate)MAP_ENTRY)).map(entryCall -> entryCall.getArgumentList().getExpressions()[0]).toArray(PsiExpression[]::new);
                this.findDuplicates(keys, JavaBundle.message((String)"inspection.overwritten.key.map.message", (Object[])new Object[0]));
            }
        }

        private void findDuplicates(PsiExpression[] expressions, @InspectionMessage String message) {
            Map groups = StreamEx.of((Object[])expressions).mapToEntry(OverwrittenKeyVisitor::getKey, Function.identity()).nonNullKeys().grouping();
            this.registerDuplicates(message, groups);
        }

        @NotNull
        private PsiExpressionStatement processArraySequence(PsiAssignmentExpression assignment, PsiExpressionStatement statement, @InspectionMessage String message) {
            PsiExpression nextQualifier;
            PsiArrayAccessExpression nextArrayAccess;
            PsiAssignmentExpression nextExpression;
            PsiExpressionStatement nextStatement;
            PsiVariable qualifierVar;
            if (!assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(2);
                }
                return psiExpressionStatement;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiArrayAccessExpression.class);
            if (arrayAccessExpression == null) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(3);
                }
                return psiExpressionStatement;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)arrayAccessExpression.getArrayExpression());
            PsiExpression arg = arrayAccessExpression.getIndexExpression();
            Object key = OverwrittenKeyVisitor.getKey(arg);
            if (key == null) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(4);
                }
                return psiExpressionStatement;
            }
            if (qualifier == null) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(5);
                }
                return psiExpressionStatement;
            }
            PsiVariable psiVariable = qualifierVar = qualifier instanceof PsiReferenceExpression ? (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)qualifier).resolve(), PsiVariable.class) : null;
            if (qualifierVar != null && VariableAccessUtils.variableIsUsed((PsiVariable)qualifierVar, (PsiElement)assignment.getRExpression())) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(6);
                }
                return psiExpressionStatement;
            }
            HashMap<Object, List<PsiExpression>> map = new HashMap<Object, List<PsiExpression>>();
            map.computeIfAbsent(key, k -> new ArrayList()).add(arg);
            while ((nextStatement = OverwrittenKeyVisitor.findNextStatement(statement)) != null && (nextExpression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)nextStatement.getExpression(), PsiAssignmentExpression.class)) != null && nextExpression.getOperationTokenType().equals(JavaTokenType.EQ) && (nextArrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)nextExpression.getLExpression(), PsiArrayAccessExpression.class)) != null && (nextQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextArrayAccess.getArrayExpression())) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)nextQualifier) && (qualifierVar == null || !VariableAccessUtils.variableIsUsed((PsiVariable)qualifierVar, (PsiElement)nextExpression.getRExpression()))) {
                PsiExpression nextArg = nextArrayAccess.getIndexExpression();
                Object nextKey = OverwrittenKeyVisitor.getKey(nextArg);
                if (nextKey != null) {
                    map.computeIfAbsent(nextKey, k -> new ArrayList()).add(nextArg);
                }
                statement = nextStatement;
            }
            this.registerDuplicates(message, map);
            PsiExpressionStatement psiExpressionStatement = statement;
            if (psiExpressionStatement == null) {
                OverwrittenKeyVisitor.$$$reportNull$$$0(7);
            }
            return psiExpressionStatement;
        }

        @NotNull
        private PsiExpressionStatement processCallSequence(PsiMethodCallExpression call, PsiExpressionStatement statement, CallMatcher myMatcher, @InspectionMessage String message) {
            PsiExpression nextQualifier;
            PsiMethodCallExpression nextCall;
            PsiExpressionStatement nextStatement;
            PsiVariable qualifierVar;
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)call.getMethodExpression()));
            Object key = OverwrittenKeyVisitor.getKey(arg);
            if (key == null) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(8);
                }
                return psiExpressionStatement;
            }
            if (qualifier == null) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(9);
                }
                return psiExpressionStatement;
            }
            PsiVariable psiVariable = qualifierVar = qualifier instanceof PsiReferenceExpression ? (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)qualifier).resolve(), PsiVariable.class) : null;
            if (qualifierVar != null && VariableAccessUtils.variableIsUsed((PsiVariable)qualifierVar, (PsiElement)call.getArgumentList())) {
                PsiExpressionStatement psiExpressionStatement = statement;
                if (psiExpressionStatement == null) {
                    OverwrittenKeyVisitor.$$$reportNull$$$0(10);
                }
                return psiExpressionStatement;
            }
            HashMap<Object, List<PsiExpression>> map = new HashMap<Object, List<PsiExpression>>();
            map.computeIfAbsent(key, k -> new ArrayList()).add(arg);
            while ((nextStatement = OverwrittenKeyVisitor.findNextStatement(statement)) != null && myMatcher.test(nextCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)nextStatement.getExpression(), PsiMethodCallExpression.class)) && (nextQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)nextCall.getMethodExpression()))) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)nextQualifier) && (qualifierVar == null || !VariableAccessUtils.variableIsUsed((PsiVariable)qualifierVar, (PsiElement)nextCall.getArgumentList()))) {
                PsiExpression nextArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])nextCall.getArgumentList().getExpressions());
                Object nextKey = OverwrittenKeyVisitor.getKey(nextArg);
                if (nextKey != null) {
                    map.computeIfAbsent(nextKey, k -> new ArrayList()).add(nextArg);
                }
                statement = nextStatement;
            }
            this.registerDuplicates(message, map);
            PsiExpressionStatement psiExpressionStatement = statement;
            if (psiExpressionStatement == null) {
                OverwrittenKeyVisitor.$$$reportNull$$$0(11);
            }
            return psiExpressionStatement;
        }

        @Nullable
        private static PsiExpressionStatement findNextStatement(@NotNull PsiExpressionStatement statement) {
            if (statement == null) {
                OverwrittenKeyVisitor.$$$reportNull$$$0(12);
            }
            for (PsiElement child = statement.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof PsiStatement) || child instanceof PsiSwitchLabelStatement) continue;
                return (PsiExpressionStatement)ObjectUtils.tryCast((Object)child, PsiExpressionStatement.class);
            }
            return null;
        }

        private void registerDuplicates(@InspectionMessage String message, Map<Object, List<PsiExpression>> map) {
            for (List<PsiExpression> args : map.values()) {
                if (args.size() < 2) continue;
                for (int i = 0; i < args.size(); ++i) {
                    PsiExpression arg = args.get(i);
                    PsiExpression nextArg = args.get((i + 1) % args.size());
                    NavigateToDuplicateExpressionFix fix = new NavigateToDuplicateExpressionFix(nextArg);
                    this.myHolder.registerProblem((PsiElement)arg, message, new LocalQuickFix[]{fix});
                }
            }
        }

        @Contract(value="null -> null")
        private static Object getKey(PsiExpression key) {
            if (key == null) {
                return null;
            }
            Object constant = ExpressionUtils.computeConstantExpression((PsiExpression)(key = PsiUtil.skipParenthesizedExprDown((PsiExpression)key)));
            if (constant != null) {
                return constant;
            }
            if (key instanceof PsiReferenceExpression) {
                PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)key).resolve(), PsiVariable.class);
                if (var instanceof PsiEnumConstant) {
                    return var;
                }
                if (var != null) {
                    PsiElement scope;
                    if (var.hasModifierProperty("final") && (var.hasModifierProperty("static") || ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)((PsiReferenceExpression)key)))) {
                        return var;
                    }
                    if (PsiUtil.isJvmLocalVariable((PsiElement)var) && (scope = PsiUtil.getVariableCodeBlock((PsiVariable)var, null)) != null && ControlFlowUtil.isEffectivelyFinal((PsiVariable)var, (PsiElement)scope)) {
                        return var;
                    }
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OverwrittenKeyInspection$OverwrittenKeyVisitor";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OverwrittenKeyInspection$OverwrittenKeyVisitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processArraySequence";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processCallSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitCodeBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findNextStatement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

