/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternVariableCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean reportAlsoCastWithIntroducingNewVariable = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"reportAlsoCastWithIntroducingNewVariable", (String)InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.report.cast.only", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.PATTERNS);
        if (set == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS, (PsiElement)holder.getFile())) {
                    return;
                }
                PsiTypeCastExpression qualifier = 1.getQualifierReferenceExpression(call);
                if (qualifier == null) {
                    return;
                }
                PsiInstanceOfExpression candidate = InstanceOfUtils.findPatternCandidate((PsiTypeCastExpression)qualifier);
                PsiTypeElement castTypeElement = qualifier.getCastType();
                if (castTypeElement == null || candidate == null) {
                    return;
                }
                if (!PatternVariableCanBeUsedInspection.compatibleTypes(candidate, castTypeElement.getType())) {
                    return;
                }
                PsiPrimaryPattern pattern = candidate.getPattern();
                if (pattern instanceof PsiDeconstructionPattern) {
                    PsiLocalVariable localVariable;
                    PsiDeconstructionPattern deconstruction = (PsiDeconstructionPattern)pattern;
                    PsiPatternVariable existingPatternVariable = 1.findExistingPatternVariable((PsiExpression)qualifier, deconstruction, call);
                    if (existingPatternVariable == null) {
                        return;
                    }
                    if (!1.isFinalOrEffectivelyFinal(existingPatternVariable)) {
                        return;
                    }
                    String patternName = existingPatternVariable.getName();
                    PsiElement psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
                    if (psiElement instanceof PsiLocalVariable && 1.canReplaceLocalVariableWithPatternVariable(localVariable = (PsiLocalVariable)psiElement, existingPatternVariable)) {
                        String name = localVariable.getName();
                        ExistingPatternVariableCanBeUsedFix fix = new ExistingPatternVariableCanBeUsedFix(name, existingPatternVariable);
                        holder.registerProblem((PsiElement)call, InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.existing.message", (Object[])new Object[]{patternName, name}), new LocalQuickFix[]{fix});
                    } else {
                        String callText = call.getText();
                        ExistingPatternVariableCanBeUsedFix fix = new ExistingPatternVariableCanBeUsedFix(callText, existingPatternVariable);
                        holder.registerProblem((PsiElement)call, InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.existing.message", (Object[])new Object[]{patternName, callText}), new LocalQuickFix[]{fix});
                    }
                }
            }

            private static boolean isFinalOrEffectivelyFinal(@NotNull PsiPatternVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !(variable.getPattern() instanceof PsiDeconstructionPattern) && variable.hasModifierProperty("final") || !VariableAccessUtils.variableIsAssigned((PsiVariable)variable, (PsiElement)variable.getDeclarationScope());
            }

            private static boolean canReplaceLocalVariableWithPatternVariable(@NotNull PsiLocalVariable localVariable, @NotNull PsiPatternVariable patternVariable) {
                PsiElement scope;
                if (localVariable == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (patternVariable == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((scope = PsiUtil.getVariableCodeBlock((PsiVariable)localVariable, null)) == null) {
                    return false;
                }
                return localVariable.hasModifierProperty("final") || !patternVariable.hasModifierProperty("final") || ControlFlowUtil.isEffectivelyFinal((PsiVariable)localVariable, (PsiElement)scope);
            }

            @Nullable
            private static PsiTypeCastExpression getQualifierReferenceExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(4);
                }
                while (call.getArgumentList().isEmpty()) {
                    PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
                    PsiMethodCallExpression qualifierMethodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)qualifier, PsiMethodCallExpression.class);
                    if (qualifierMethodCall == null) {
                        return (PsiTypeCastExpression)ObjectUtils.tryCast((Object)qualifier, PsiTypeCastExpression.class);
                    }
                    call = qualifierMethodCall;
                }
                return null;
            }

            private static PsiPatternVariable findExistingPatternVariable(@NotNull PsiExpression currentQualifier, @NotNull PsiDeconstructionPattern currentDeconstruction, @NotNull PsiMethodCallExpression call) {
                PsiMethodCallExpression currentCall;
                PsiMethod psiMethod;
                PsiElement parent;
                if (currentQualifier == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (currentDeconstruction == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (call == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)currentQualifier.getParent())) instanceof PsiReferenceExpression)) {
                    return null;
                }
                PsiElement grandParent = parent.getParent();
                if (grandParent instanceof PsiMethodCallExpression && (psiMethod = (currentCall = (PsiMethodCallExpression)grandParent).resolveMethod()) instanceof LightRecordMethod) {
                    PsiRecordComponent recordComponent;
                    LightRecordMethod recordMethod = (LightRecordMethod)psiMethod;
                    PsiClass aClass = recordMethod.getContainingClass();
                    Object[] recordComponents = aClass.getRecordComponents();
                    int index = ArrayUtil.find((Object[])recordComponents, (Object)(recordComponent = recordMethod.getRecordComponent()));
                    if (index < 0) {
                        return null;
                    }
                    PsiPattern[] deconstructionComponents = currentDeconstruction.getDeconstructionList().getDeconstructionComponents();
                    if (index >= deconstructionComponents.length) {
                        return null;
                    }
                    PsiPattern deconstructionComponent = deconstructionComponents[index];
                    PsiType componentType = JavaPsiPatternUtil.getPatternType((PsiCaseLabelElement)deconstructionComponent);
                    if (componentType == null || !componentType.equals(recordComponent.getType())) {
                        return null;
                    }
                    PsiPatternVariable variable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)deconstructionComponent);
                    if (currentCall.equals((Object)call)) {
                        return variable;
                    }
                    if (deconstructionComponent instanceof PsiDeconstructionPattern) {
                        PsiDeconstructionPattern deconstruction = (PsiDeconstructionPattern)deconstructionComponent;
                        return 1.findExistingPatternVariable((PsiExpression)currentCall, deconstruction, call);
                    }
                }
                return null;
            }

            public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (expression.getParent() instanceof PsiVariable) {
                    return;
                }
                InstanceOfCandidateResult result = PatternVariableCanBeUsedInspection.findInstanceOfCandidateResult(expression);
                if (result == null) {
                    return;
                }
                if (result.instanceOf() != null) {
                    PsiPrimaryPattern pattern = result.instanceOf().getPattern();
                    PsiPatternVariable existingPatternVariable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)pattern);
                    if (pattern != null && existingPatternVariable == null) {
                        return;
                    }
                    if (existingPatternVariable != null) {
                        if (!1.isFinalOrEffectivelyFinal(existingPatternVariable)) {
                            return;
                        }
                        holder.registerProblem((PsiElement)result.castTypeElement(), InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.existing.cast.message", (Object[])new Object[]{existingPatternVariable.getName()}), new LocalQuickFix[]{new ExistingPatternVariableCanBeUsedFix(null, existingPatternVariable)});
                    } else {
                        if (!PatternVariableCanBeUsedInspection.this.reportAlsoCastWithIntroducingNewVariable) {
                            if (isOnTheFly) {
                                holder.registerProblem((PsiElement)expression, InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.instead.of.cast.message", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new CastExpressionsCanBeReplacedWithPatternVariableFix(result.instanceOf())});
                            }
                            return;
                        }
                        holder.registerProblem((PsiElement)result.castTypeElement(), InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.instead.of.cast.message", (Object[])new Object[0]), new LocalQuickFix[]{new CastExpressionsCanBeReplacedWithPatternVariableFix(result.instanceOf())});
                    }
                }
            }

            public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
                PsiIdentifier identifier;
                if (variable == null) {
                    1.$$$reportNull$$$0(9);
                }
                if ((identifier = variable.getNameIdentifier()) == null) {
                    return;
                }
                PsiTypeCastExpression cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiTypeCastExpression.class);
                if (cast == null || cast.getCastType() == null) {
                    return;
                }
                PsiExpression operand = cast.getOperand();
                if (operand == null) {
                    return;
                }
                PsiType castType = cast.getCastType().getType();
                if (castType instanceof PsiPrimitiveType && !PsiUtil.isAvailable((JavaFeature)JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS, (PsiElement)operand)) {
                    return;
                }
                if (!variable.getType().equals(castType)) {
                    return;
                }
                PsiType operandType = operand.getType();
                if (operandType == null || castType.isAssignableFrom(operandType)) {
                    return;
                }
                PsiElement scope = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
                if (scope == null) {
                    return;
                }
                PsiDeclarationStatement declaration = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
                if (declaration == null) {
                    return;
                }
                PsiInstanceOfExpression instanceOf = InstanceOfUtils.findPatternCandidate((PsiTypeCastExpression)cast, (PsiVariable)variable);
                if (instanceOf == null) {
                    return;
                }
                if (!PatternVariableCanBeUsedInspection.compatibleTypes(instanceOf, castType)) {
                    return;
                }
                PsiPrimaryPattern pattern = instanceOf.getPattern();
                PsiPatternVariable existingPatternVariable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)pattern);
                if (pattern != null && existingPatternVariable == null) {
                    return;
                }
                String name = identifier.getText();
                if (existingPatternVariable != null) {
                    if (!1.canReplaceLocalVariableWithPatternVariable(variable, existingPatternVariable) || !1.isFinalOrEffectivelyFinal(existingPatternVariable)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.existing.message", (Object[])new Object[]{existingPatternVariable.getName(), name}), new LocalQuickFix[]{new ExistingPatternVariableCanBeUsedFix(name, existingPatternVariable)});
                } else {
                    if (!isOnTheFly && InstanceOfUtils.hasConflictingDeclaredNames((PsiLocalVariable)variable, (PsiInstanceOfExpression)instanceOf)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.message", (Object[])new Object[]{name}), new LocalQuickFix[]{new PatternVariableCanBeUsedFix(name, instanceOf)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localVariable";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "patternVariable";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentQualifier";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentDeconstruction";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isFinalOrEffectivelyFinal";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canReplaceLocalVariableWithPatternVariable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getQualifierReferenceExpression";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findExistingPatternVariable";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeCastExpression";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLocalVariable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean compatibleTypes(@NotNull PsiInstanceOfExpression instanceOfExpression, @NotNull PsiType castType) {
        PsiClassType castClassType;
        PsiClassType instanceOfClassType;
        PsiTypeElement typeElement;
        if (instanceOfExpression == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(3);
        }
        if (castType == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(4);
        }
        if ((typeElement = instanceOfExpression.getCheckType()) == null) {
            PsiPrimaryPattern psiPrimaryPattern = instanceOfExpression.getPattern();
            if (psiPrimaryPattern instanceof PsiTypeTestPattern) {
                PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)psiPrimaryPattern;
                typeElement = typeTestPattern.getCheckType();
            }
            if ((psiPrimaryPattern = instanceOfExpression.getPattern()) instanceof PsiDeconstructionPattern) {
                PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)psiPrimaryPattern;
                return deconstructionPattern.getTypeElement().getType().equals(castType);
            }
        }
        if (typeElement == null) {
            return false;
        }
        PsiType instanceOfType = typeElement.getType();
        if (instanceOfType instanceof PsiClassType && !(instanceOfClassType = (PsiClassType)instanceOfType).isRaw() && castType instanceof PsiClassType && (castClassType = (PsiClassType)castType).isRaw()) {
            return false;
        }
        return castType.isAssignableFrom(instanceOfType);
    }

    private static PsiTypeElement getTypeElement(PsiTypeElement originalTypeElement, PsiTypeElement instanceOfType) {
        PsiClassType originalClassType;
        PsiType psiType;
        PsiClassType instanceOfClassType;
        PsiType psiType2;
        PsiTypeElement typeElement = instanceOfType;
        if (instanceOfType != null && (psiType2 = instanceOfType.getType()) instanceof PsiClassType && (instanceOfClassType = (PsiClassType)psiType2).isRaw() && (psiType = originalTypeElement.getType()) instanceof PsiClassType && !(originalClassType = (PsiClassType)psiType).isRaw()) {
            PsiClassType.ClassResolveResult instanceOfClassResult = instanceOfClassType.resolveGenerics();
            PsiClass instanceOfClass = instanceOfClassResult.getElement();
            PsiClassType.ClassResolveResult originalClassResult = originalClassType.resolveGenerics();
            PsiClass originalClass = originalClassResult.getElement();
            if (originalClass != null && originalClass.getQualifiedName() != null && InheritanceUtil.isInheritor((PsiClass)instanceOfClass, (boolean)false, (String)originalClass.getQualifiedName())) {
                PsiSubstitutor classSubstitutor;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)instanceOfClass.getProject());
                if (originalClass.getManager().areElementsEquivalent((PsiElement)originalClass, (PsiElement)instanceOfClass)) {
                    classSubstitutor = PsiSubstitutor.EMPTY;
                    for (PsiTypeParameter parameter : originalClass.getTypeParameters()) {
                        classSubstitutor = classSubstitutor.put(parameter, (PsiType)factory.createType((PsiClass)parameter));
                    }
                } else {
                    classSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(originalClass, instanceOfClass, instanceOfClass.getResolveScope(), PsiSubstitutor.EMPTY);
                }
                if (classSubstitutor == null) {
                    return typeElement;
                }
                PsiSubstitutor target = instanceOfClassResult.getSubstitutor();
                for (Map.Entry originalTypeEntry : originalClassResult.getSubstitutor().getSubstitutionMap().entrySet()) {
                    PsiWildcardType wildcardType;
                    PsiType previousValue;
                    PsiWildcardType valueWildCard;
                    PsiClassType classType;
                    PsiClass psiClass;
                    PsiType keyType = (PsiType)classSubstitutor.getSubstitutionMap().get(originalTypeEntry.getKey());
                    if (!(keyType instanceof PsiClassType) || !((psiClass = (classType = (PsiClassType)keyType).resolve()) instanceof PsiTypeParameter)) continue;
                    PsiTypeParameter targetTypeParameter = (PsiTypeParameter)psiClass;
                    PsiType value = (PsiType)originalTypeEntry.getValue();
                    if (value == null || value instanceof PsiWildcardType && !(valueWildCard = (PsiWildcardType)value).isBounded() || (previousValue = (PsiType)target.getSubstitutionMap().get(targetTypeParameter)) != null && (!(previousValue instanceof PsiWildcardType) || (wildcardType = (PsiWildcardType)previousValue).isBounded())) continue;
                    target = target.put(targetTypeParameter, value);
                }
                for (Map.Entry entry : target.getSubstitutionMap().entrySet()) {
                    if (entry.getValue() != null) continue;
                    target = target.put((PsiTypeParameter)entry.getKey(), (PsiType)PsiWildcardType.createUnbounded((PsiManager)originalClass.getManager()));
                }
                for (PsiTypeParameter parameter : instanceOfClass.getTypeParameters()) {
                    if (target.getSubstitutionMap().containsKey(parameter)) continue;
                    target = target.put(parameter, (PsiType)PsiWildcardType.createUnbounded((PsiManager)originalClass.getManager()));
                }
                PsiClassType substituted = factory.createType(instanceOfClass, target);
                typeElement = factory.createTypeElement((PsiType)substituted);
            }
        }
        return typeElement;
    }

    @Nullable
    private static InstanceOfCandidateResult findInstanceOfCandidateResult(@NotNull PsiTypeCastExpression expression) {
        PsiTypeElement castTypeElement;
        if (expression == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(5);
        }
        if ((castTypeElement = expression.getCastType()) == null) {
            return null;
        }
        PsiExpression operand = expression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiType castType = castTypeElement.getType();
        if (castType instanceof PsiPrimitiveType && !PsiUtil.isAvailable((JavaFeature)JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS, (PsiElement)operand)) {
            return null;
        }
        PsiType operandType = operand.getType();
        if (operandType == null || castType.isAssignableFrom(operandType)) {
            return null;
        }
        PsiInstanceOfExpression instanceOf = InstanceOfUtils.findPatternCandidate((PsiTypeCastExpression)expression, null);
        if (instanceOf == null) {
            return null;
        }
        if (!PatternVariableCanBeUsedInspection.compatibleTypes(instanceOf, castType)) {
            return null;
        }
        return new InstanceOfCandidateResult(castTypeElement, instanceOf);
    }

    @Nullable
    private static StringBuilder generateTextForInstanceOf(@Nullable PsiLocalVariable variable, @NotNull CommentTracker ct, @NotNull PsiInstanceOfExpression instanceOf, @NotNull PsiTypeElement typeElement) {
        if (ct == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(6);
        }
        if (instanceOf == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(7);
        }
        if (typeElement == null) {
            PatternVariableCanBeUsedInspection.$$$reportNull$$$0(8);
        }
        StringBuilder text = new StringBuilder(ct.text((PsiElement)instanceOf.getOperand()));
        text.append(" instanceof ");
        PsiModifierList modifierList = variable != null ? variable.getModifierList() : null;
        JavaCodeStyleSettings codeStyleSettings = JavaCodeStyleSettings.getInstance((PsiFile)instanceOf.getContainingFile());
        if (modifierList != null && modifierList.getTextLength() > 0) {
            modifierList.setModifierProperty("final", codeStyleSettings.GENERATE_FINAL_LOCALS);
            text.append(ct.text((PsiElement)modifierList)).append(' ');
        } else if (codeStyleSettings.GENERATE_FINAL_LOCALS) {
            text.append("final ");
        }
        text.append(typeElement.getText()).append(' ');
        if (instanceOf.getPattern() instanceof PsiDeconstructionPattern) {
            return null;
        }
        if (variable == null) {
            String name = new VariableNameGenerator((PsiElement)instanceOf, VariableKind.LOCAL_VARIABLE).byType(typeElement.getType()).generate(true);
            text.append(name);
        } else {
            text.append(variable.getName());
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOfExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ct";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compatibleTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findInstanceOfCandidateResult";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateTextForInstanceOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    private record InstanceOfCandidateResult(@NotNull PsiTypeElement castTypeElement, @Nullable PsiInstanceOfExpression instanceOf) {
        @NotNull
        private final PsiTypeElement castTypeElement;

        private InstanceOfCandidateResult(@NotNull PsiTypeElement castTypeElement, @Nullable PsiInstanceOfExpression instanceOf) {
            if (castTypeElement == null) {
                InstanceOfCandidateResult.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public PsiTypeElement castTypeElement() {
            PsiTypeElement psiTypeElement = this.castTypeElement;
            if (psiTypeElement == null) {
                InstanceOfCandidateResult.$$$reportNull$$$0(1);
            }
            return psiTypeElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "castTypeElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$InstanceOfCandidateResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$InstanceOfCandidateResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "castTypeElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PatternVariableCanBeUsedFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final SmartPsiElementPointer<PsiInstanceOfExpression> myInstanceOfPointer;
        @NotNull
        private final String myName;

        private PatternVariableCanBeUsedFix(@NotNull String name, @NotNull PsiInstanceOfExpression instanceOf) {
            if (name == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(0);
            }
            if (instanceOf == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myInstanceOfPointer = SmartPointerManager.createPointer((PsiElement)instanceOf);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.fix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement psiElement;
            if (project == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(6);
            }
            if (!((psiElement = element.getParent()) instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)psiElement;
            PsiTypeCastExpression cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiTypeCastExpression.class);
            if (cast == null) {
                return;
            }
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)((PsiInstanceOfExpression)this.myInstanceOfPointer.getElement()), (PsiFile)element.getContainingFile());
            if (instanceOf == null) {
                return;
            }
            PsiTypeElement typeElement = PatternVariableCanBeUsedInspection.getTypeElement(cast.getCastType(), instanceOf.getCheckType());
            if (typeElement == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            StringBuilder text = PatternVariableCanBeUsedInspection.generateTextForInstanceOf(variable, ct, instanceOf, typeElement);
            if (text == null) {
                return;
            }
            PsiElement replaced = ct.replace((PsiElement)instanceOf, text.toString());
            ct.deleteAndRestoreComments((PsiElement)variable);
            if (!(replaced instanceof PsiInstanceOfExpression)) {
                return;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)replaced;
            PsiPrimaryPattern pattern = instanceOfExpression.getPattern();
            if (!(pattern instanceof PsiTypeTestPattern)) {
                return;
            }
            PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)pattern;
            PsiPatternVariable patternVariable = typeTestPattern.getPatternVariable();
            PsiElement scope = JavaSharedImplUtil.getPatternVariableDeclarationScope((PsiInstanceOfExpression)instanceOfExpression);
            boolean nameDeclaredInside = InstanceOfUtils.isConflictingNameDeclaredInside((PsiVariable)patternVariable, (PsiElement)scope, (boolean)true);
            if (!nameDeclaredInside) {
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            List names = new VariableNameGenerator((PsiElement)instanceOfExpression, VariableKind.LOCAL_VARIABLE).byType(patternVariable.getType()).byName(new String[]{codeStyleManager.suggestUniqueVariableName(patternVariable.getName(), (PsiElement)instanceOfExpression, true)}).generateAll(true);
            updater.rename((PsiNameIdentifierOwner)patternVariable, names);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceOf";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$PatternVariableCanBeUsedFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$PatternVariableCanBeUsedFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class CastExpressionsCanBeReplacedWithPatternVariableFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final SmartPsiElementPointer<PsiInstanceOfExpression> myInstanceOfPointer;

        private CastExpressionsCanBeReplacedWithPatternVariableFix(@NotNull PsiInstanceOfExpression instanceOf) {
            if (instanceOf == null) {
                CastExpressionsCanBeReplacedWithPatternVariableFix.$$$reportNull$$$0(0);
            }
            this.myInstanceOfPointer = SmartPointerManager.createPointer((PsiElement)instanceOf);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message((String)"inspection.pattern.variable.instead.of.cast.can.be.used.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                CastExpressionsCanBeReplacedWithPatternVariableFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiTypeCastExpression castExpression;
            if (project == null) {
                CastExpressionsCanBeReplacedWithPatternVariableFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                CastExpressionsCanBeReplacedWithPatternVariableFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CastExpressionsCanBeReplacedWithPatternVariableFix.$$$reportNull$$$0(4);
            }
            if ((castExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{PsiTypeCastExpression.class})) == null) {
                return;
            }
            final PsiTypeElement originalTypeElement = castExpression.getCastType();
            if (originalTypeElement == null) {
                return;
            }
            PsiInstanceOfExpression originalInstanceOf = (PsiInstanceOfExpression)this.myInstanceOfPointer.getElement();
            if (originalInstanceOf == null) {
                return;
            }
            final PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)originalInstanceOf, (PsiFile)element.getContainingFile());
            if (instanceOf.getPattern() instanceof PsiDeconstructionPattern) {
                return;
            }
            PsiTypeElement instanceOfType = instanceOf.getCheckType();
            PsiTypeElement typeElement = PatternVariableCanBeUsedInspection.getTypeElement(originalTypeElement, instanceOfType);
            if (typeElement == null) {
                return;
            }
            PsiStatement expectedScopeOfInstanceOf = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)instanceOf, PsiStatement.class);
            if (expectedScopeOfInstanceOf == null || expectedScopeOfInstanceOf.getParent() == null) {
                return;
            }
            var visitor = new JavaRecursiveElementVisitor(this){
                final List<PsiTypeCastExpression> myCasts = new ArrayList<PsiTypeCastExpression>();

                public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
                    PsiTypeElement castType;
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((castType = expression.getCastType()) == null) {
                        return;
                    }
                    if (!castType.textMatches((PsiElement)originalTypeElement)) {
                        return;
                    }
                    InstanceOfCandidateResult result = PatternVariableCanBeUsedInspection.findInstanceOfCandidateResult(expression);
                    if (result != null && result.instanceOf == instanceOf) {
                        this.myCasts.add(expression);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$CastExpressionsCanBeReplacedWithPatternVariableFix$1", "visitTypeCastExpression"));
                }
            };
            expectedScopeOfInstanceOf.getParent().accept((PsiElementVisitor)visitor);
            List<PsiTypeCastExpression> casts = visitor.myCasts;
            if (casts.isEmpty()) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            StringBuilder text = PatternVariableCanBeUsedInspection.generateTextForInstanceOf(null, ct, instanceOf, typeElement);
            if (text == null) {
                return;
            }
            PsiElement replaced = ct.replace((PsiElement)instanceOf, text.toString());
            if (!(replaced instanceof PsiInstanceOfExpression)) {
                return;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)replaced;
            PsiPrimaryPattern pattern = instanceOfExpression.getPattern();
            if (!(pattern instanceof PsiTypeTestPattern)) {
                return;
            }
            PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)pattern;
            PsiPatternVariable patternVariable = typeTestPattern.getPatternVariable();
            if (patternVariable == null) {
                return;
            }
            String variableName = patternVariable.getName();
            Iterator<PsiTypeCastExpression> iterator = casts.iterator();
            while (iterator.hasNext()) {
                PsiElement psiElement;
                PsiTypeCastExpression cast;
                PsiTypeCastExpression currentCast = cast = iterator.next();
                CommentTracker castCt = new CommentTracker();
                while ((psiElement = currentCast.getParent()) instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)psiElement;
                    currentCast = parenthesizedExpression;
                }
                castCt.replace((PsiElement)currentCast, variableName);
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            List names = new VariableNameGenerator((PsiElement)instanceOfExpression, VariableKind.LOCAL_VARIABLE).byType(patternVariable.getType()).byName(new String[]{codeStyleManager.suggestUniqueVariableName(variableName, (PsiElement)instanceOfExpression, true)}).generateAll(true);
            names.remove(patternVariable.getName());
            updater.rename((PsiNameIdentifierOwner)patternVariable, names);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instanceOf";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$CastExpressionsCanBeReplacedWithPatternVariableFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$CastExpressionsCanBeReplacedWithPatternVariableFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ExistingPatternVariableCanBeUsedFix
    extends PsiUpdateModCommandQuickFix {
        @Nullable
        private final String myName;
        @NotNull
        private final String myPatternName;

        private ExistingPatternVariableCanBeUsedFix(@Nullable String name, @NotNull PsiPatternVariable existingVariable) {
            if (existingVariable == null) {
                ExistingPatternVariableCanBeUsedFix.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myPatternName = existingVariable.getName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            if (this.myName != null) {
                String string = InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.existing.fix.name", (Object[])new Object[]{this.myName, this.myPatternName});
                if (string == null) {
                    ExistingPatternVariableCanBeUsedFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message((String)"inspection.pattern.variable.instead.of.cast.can.be.used.existing.fix.name", (Object[])new Object[]{this.myPatternName});
            if (string == null) {
                ExistingPatternVariableCanBeUsedFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message((String)"inspection.pattern.variable.can.be.used.existing.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ExistingPatternVariableCanBeUsedFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ExistingPatternVariableCanBeUsedFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                ExistingPatternVariableCanBeUsedFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                ExistingPatternVariableCanBeUsedFix.$$$reportNull$$$0(6);
            }
            if (this.myName == null) {
                PsiElement psiElement;
                PsiElement castExpression = PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class);
                if (castExpression == null) {
                    return;
                }
                while ((psiElement = castExpression.getParent()) instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)psiElement;
                    castExpression = parenthesizedExpression;
                }
                new CommentTracker().replace(castExpression, this.myPatternName);
            } else if (!this.myName.endsWith("()")) {
                PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
                if (variable == null) {
                    return;
                }
                if (VariableAccessUtils.variableIsAssigned((PsiVariable)variable)) {
                    new CommentTracker().replace(element, this.myPatternName);
                    return;
                }
                List references = VariableAccessUtils.getVariableReferences((PsiVariable)variable);
                for (PsiReferenceExpression ref : references) {
                    ExpressionUtils.bindReferenceTo((PsiReferenceExpression)ref, (String)this.myPatternName);
                }
                new CommentTracker().deleteAndRestoreComments((PsiElement)variable);
            } else {
                new CommentTracker().replace(element, this.myPatternName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingVariable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$ExistingPatternVariableCanBeUsedFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PatternVariableCanBeUsedInspection$ExistingPatternVariableCanBeUsedFix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

