/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RedundantFileCreationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantFileCreationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                if (newExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitNewExpression(newExpression);
                List<String> targetTypes = Arrays.asList("java.io.FileInputStream", "java.io.FileOutputStream", "java.io.FileReader", "java.io.FileWriter", "java.io.PrintStream", "java.io.PrintWriter", "java.util.Formatter");
                PsiType type = newExpression.getType();
                if (type == null || !targetTypes.contains(type.getCanonicalText())) {
                    return;
                }
                PsiMethod constructor = newExpression.resolveConstructor();
                if (constructor == null) {
                    return;
                }
                PsiParameter[] params = constructor.getParameterList().getParameters();
                if (params.length == 0 || !TypeUtils.typeEquals((String)"java.io.File", (PsiType)params[0].getType())) {
                    return;
                }
                PsiExpressionList argList = newExpression.getArgumentList();
                if (argList == null) {
                    return;
                }
                PsiExpression[] args = argList.getExpressions();
                if (args.length == 0) {
                    return;
                }
                PsiNewExpression arg = (PsiNewExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiNewExpression.class);
                if (arg == null) {
                    return;
                }
                PsiMethod fileConstructor = arg.resolveConstructor();
                if (fileConstructor == null) {
                    return;
                }
                PsiParameter[] fileParams = fileConstructor.getParameterList().getParameters();
                if (fileParams.length != 1) {
                    return;
                }
                if (!TypeUtils.isJavaLangString((PsiType)fileParams[0].getType())) {
                    return;
                }
                PsiExpressionList fileArgList = arg.getArgumentList();
                if (fileArgList == null) {
                    return;
                }
                if (!RedundantFileCreationInspection.canReplacedWithConstructorTakesFilename(constructor)) {
                    return;
                }
                holder.registerProblem((PsiElement)arg, JavaBundle.message((String)"inspection.redundant.file.creation.description", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new TextRange(0, fileArgList.getStartOffsetInParent()), new LocalQuickFix[]{new DeleteRedundantFileCreationFix()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/intellij/codeInspection/RedundantFileCreationInspection$1", "visitNewExpression"));
            }
        };
    }

    private static boolean canReplacedWithConstructorTakesFilename(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        List methodParams = ContainerUtil.map((Object[])method.getParameterList().getParameters(), param -> param.getType());
        assert (!methodParams.isEmpty());
        for (PsiMethod candidate : containingClass.getMethods()) {
            List candidateParams;
            if (!candidate.isConstructor() || candidate.equals((Object)method) || (candidateParams = ContainerUtil.map((Object[])candidate.getParameterList().getParameters(), param -> param.getType())).size() != methodParams.size() || !TypeUtils.isJavaLangString((PsiType)((PsiType)candidateParams.getFirst())) || !methodParams.subList(1, methodParams.size()).equals(candidateParams.subList(1, candidateParams.size()))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/RedundantFileCreationInspection", "buildVisitor"));
    }

    private static class DeleteRedundantFileCreationFix
    extends PsiUpdateModCommandQuickFix {
        private DeleteRedundantFileCreationFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.file.creation.quickfix", (Object[])new Object[0]);
            if (string == null) {
                DeleteRedundantFileCreationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                DeleteRedundantFileCreationFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                DeleteRedundantFileCreationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                DeleteRedundantFileCreationFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiExpressionList argList = newExpression.getArgumentList();
            if (argList == null) {
                return;
            }
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 1) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.replace((PsiElement)newExpression, (PsiElement)args[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantFileCreationInspection$DeleteRedundantFileCreationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantFileCreationInspection$DeleteRedundantFileCreationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

