/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public final class RedundantUnmodifiableInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher COLLECTIONS_UNMODIFIABLE = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"unmodifiableCollection", "unmodifiableList", "unmodifiableSet", "unmodifiableMap", "unmodifiableSortedSet", "unmodifiableSortedMap", "unmodifiableNavigableMap", "unmodifiableNavigableSet"}).parameterCount(1);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantUnmodifiableInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ExpressionUtils.isVoidContext((PsiExpression)call)) {
                    return;
                }
                if (COLLECTIONS_UNMODIFIABLE.test(call)) {
                    PsiExpression arg = call.getArgumentList().getExpressions()[0];
                    DfType dfType = CommonDataflow.getDfType((PsiExpression)arg);
                    if (!Mutability.fromDfType((DfType)dfType).isUnmodifiable()) {
                        return;
                    }
                    String methodName = call.getMethodExpression().getReferenceName();
                    if (methodName == null) {
                        return;
                    }
                    holder.registerProblem((PsiElement)call, JavaBundle.message((String)"inspection.redundant.unmodifiable.call.display.name", (Object[])new Object[]{methodName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new TextRange(0, call.getArgumentList().getStartOffsetInParent()), new LocalQuickFix[]{new UnwrapUnmodifiableFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/RedundantUnmodifiableInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/RedundantUnmodifiableInspection", "buildVisitor"));
    }

    private static class UnwrapUnmodifiableFix
    extends PsiUpdateModCommandQuickFix {
        private UnwrapUnmodifiableFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.unmodifiable.call.unwrap.argument.quickfix", (Object[])new Object[0]);
            if (string == null) {
                UnwrapUnmodifiableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                UnwrapUnmodifiableFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnwrapUnmodifiableFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnwrapUnmodifiableFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpressionList argList = call.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 1) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.replaceAndRestoreComments(element, commentTracker.text((PsiElement)args[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantUnmodifiableInspection$UnwrapUnmodifiableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantUnmodifiableInspection$UnwrapUnmodifiableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

