/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplaceInefficientStreamCountInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STREAM_COUNT = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"count"}).parameterCount(0);
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"stream"}).parameterCount(0);
    private static final CallMatcher CHAR_SEQUENCE_CHARS = CallMatcher.instanceCall((String)"java.lang.CharSequence", (String[])new String[]{"chars"}).parameterCount(0);
    private static final CallMatcher STREAM_FLAT_MAP = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"flatMap"}).parameterTypes(new String[]{"java.util.function.Function"});
    private static final CallMatcher STREAM_FILTER = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"filter"}).parameterTypes(new String[]{"java.util.function.Predicate"});
    private static final CallMatcher STREAM_PEEK = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"peek"}).parameterTypes(new String[]{"java.util.function.Consumer"});
    private static final CallMatcher STREAM_LIMIT = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"limit"}).parameterTypes(new String[]{"long"});
    private static final CallMapper<CountFix> FIX_MAPPER = new CallMapper().register(COLLECTION_STREAM, call -> new CountFix(SimplificationMode.COLLECTION_SIZE)).register(CHAR_SEQUENCE_CHARS, call -> new CountFix(SimplificationMode.CHAR_SEQUENCE_LENGTH)).register(STREAM_FLAT_MAP, call -> ReplaceInefficientStreamCountInspection.doesFlatMapCallCollectionStream(call) ? new CountFix(SimplificationMode.SUM) : null).register(STREAM_FILTER, call -> ReplaceInefficientStreamCountInspection.extractComparison(call, true) != null ? new CountFix(SimplificationMode.ANY_MATCH) : null).register(STREAM_FILTER, call -> ReplaceInefficientStreamCountInspection.extractComparison(call, false) != null ? new CountFix(SimplificationMode.NONE_MATCH) : null);
    private static final Logger LOG = Logger.getInstance(ReplaceInefficientStreamCountInspection.class);
    private static final String STREAM_METHOD = "stream";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            ReplaceInefficientStreamCountInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ReplaceInefficientStreamCountInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCall) {
                if (methodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (STREAM_COUNT.test(methodCall)) {
                    PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)methodCall);
                    CountFix fix = (CountFix)((Object)FIX_MAPPER.mapFirst(qualifierCall));
                    if (!(fix != null || STREAM_LIMIT.test(qualifierCall) && ExpressionUtils.isOne((PsiExpression)qualifierCall.getArgumentList().getExpressions()[0]))) {
                        if (ReplaceInefficientStreamCountInspection.extractComparison(methodCall, true) != null) {
                            fix = new CountFix(SimplificationMode.IS_PRESENT);
                        } else if (ReplaceInefficientStreamCountInspection.extractComparison(methodCall, false) != null) {
                            SimplificationMode simplificationMode = PsiUtil.getLanguageLevel((PsiElement)methodCall).isAtLeast(LanguageLevel.JDK_11) ? SimplificationMode.IS_EMPTY : SimplificationMode.NOT_IS_PRESENT;
                            fix = new CountFix(simplificationMode);
                        }
                    }
                    if (fix != null) {
                        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                        LOG.assertTrue(nameElement != null);
                        holder.registerProblem((PsiElement)methodCall, nameElement.getTextRange().shiftRight(-methodCall.getTextOffset()), fix.getMessage(), new LocalQuickFix[]{fix});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @Nullable
    private static PsiBinaryExpression extractComparison(PsiMethodCallExpression call, boolean isPresent) {
        PsiMethodCallExpression countCall;
        if (STREAM_FILTER.test(call)) {
            countCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
        } else if (STREAM_COUNT.test(call)) {
            countCall = call;
        } else {
            return null;
        }
        if (countCall == null || ReplaceInefficientStreamCountInspection.hasPeekCallBefore(call)) {
            return null;
        }
        LongRangeSet range = JavaPsiMathUtil.getRangeFromComparison((PsiExpression)countCall);
        if (range == null) {
            return null;
        }
        if (isPresent && ReplaceInefficientStreamCountInspection.isPresent(range) || !isPresent && ReplaceInefficientStreamCountInspection.isEmpty(range)) {
            return ReplaceInefficientStreamCountInspection.extractBinary(countCall);
        }
        return null;
    }

    private static boolean isPresent(@NotNull LongRangeSet range) {
        if (range == null) {
            ReplaceInefficientStreamCountInspection.$$$reportNull$$$0(2);
        }
        return range.equals(LongRangeSet.range((long)1L, (long)Long.MAX_VALUE)) || range.equals(LongRangeSet.all().without(0L));
    }

    private static boolean isEmpty(@NotNull LongRangeSet range) {
        if (range == null) {
            ReplaceInefficientStreamCountInspection.$$$reportNull$$$0(3);
        }
        return !range.isEmpty() && range.max() == 0L;
    }

    @Nullable
    private static PsiBinaryExpression extractBinary(PsiMethodCallExpression call) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
        return (PsiBinaryExpression)ObjectUtils.tryCast((Object)parent, PsiBinaryExpression.class);
    }

    static boolean doesFlatMapCallCollectionStream(PsiMethodCallExpression flatMapCall) {
        PsiExpression function = flatMapCall.getArgumentList().getExpressions()[0];
        if (function instanceof PsiMethodReferenceExpression) {
            PsiClass containingClass;
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)function;
            if (!STREAM_METHOD.equals(methodRef.getReferenceName())) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            if (method != null && STREAM_METHOD.equals(method.getName()) && method.getParameterList().isEmpty() && (containingClass = method.getContainingClass()) != null && "java.util.Collection".equals(containingClass.getQualifiedName())) {
                return true;
            }
        } else if (function instanceof PsiLambdaExpression) {
            PsiExpression expression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)function);
            return expression instanceof PsiMethodCallExpression && COLLECTION_STREAM.test((PsiMethodCallExpression)expression);
        }
        return false;
    }

    @Nullable
    private static PsiExpression extractLambdaReturnExpression(PsiLambdaExpression lambda) {
        PsiStatement[] statements;
        PsiElement lambdaBody = lambda.getBody();
        PsiExpression expression = null;
        if (lambdaBody instanceof PsiExpression) {
            expression = (PsiExpression)lambdaBody;
        } else if (lambdaBody instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambdaBody).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            expression = ((PsiReturnStatement)statements[0]).getReturnValue();
        }
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
    }

    private static boolean hasPeekCallBefore(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            ReplaceInefficientStreamCountInspection.$$$reportNull$$$0(4);
        }
        PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
        while (qualifierCall != null && TypeUtils.expressionHasTypeOrSubtype((PsiExpression)qualifierCall, (String)"java.util.stream.Stream") && !STREAM_PEEK.test(qualifierCall)) {
            qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)qualifierCall);
        }
        return STREAM_PEEK.test(qualifierCall);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPresent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasPeekCallBefore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class CountFix
    extends PsiUpdateModCommandQuickFix {
        private final SimplificationMode mySimplificationMode;

        CountFix(SimplificationMode simplificationMode) {
            this.mySimplificationMode = simplificationMode;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.mySimplificationMode.getName();
            if (string == null) {
                CountFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.replace.inefficient.stream.count", (Object[])new Object[0]);
            if (string == null) {
                CountFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                CountFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                CountFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CountFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression countCall = (PsiMethodCallExpression)element;
            PsiElement countName = countCall.getMethodExpression().getReferenceNameElement();
            if (countName == null) {
                return;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)countCall);
            switch (this.mySimplificationMode.ordinal()) {
                case 0: {
                    CountFix.replaceFlatMap(countName, qualifierCall);
                    break;
                }
                case 2: {
                    CountFix.replaceSimpleCount(countCall, qualifierCall, "size");
                    break;
                }
                case 1: {
                    CountFix.replaceSimpleCount(countCall, qualifierCall, "length");
                    break;
                }
                case 3: {
                    CountFix.replaceFilterCountComparison(qualifierCall, true);
                    break;
                }
                case 4: {
                    CountFix.replaceFilterCountComparison(qualifierCall, false);
                    break;
                }
                case 5: {
                    CountFix.replaceSimpleCountComparison(countCall, true);
                    break;
                }
                case 6: 
                case 7: {
                    CountFix.replaceSimpleCountComparison(countCall, false);
                }
            }
        }

        private static void replaceFilterCountComparison(PsiMethodCallExpression filterCall, boolean isAnyMatch) {
            if (!STREAM_FILTER.test(filterCall)) {
                return;
            }
            PsiBinaryExpression comparison = ReplaceInefficientStreamCountInspection.extractComparison(filterCall, isAnyMatch);
            if (comparison == null) {
                return;
            }
            String filterText = filterCall.getArgumentList().getExpressions()[0].getText();
            PsiExpression filterQualifier = filterCall.getMethodExpression().getQualifierExpression();
            if (filterQualifier == null) {
                return;
            }
            String base = filterQualifier.getText();
            CommentTracker ct = new CommentTracker();
            ct.markUnchanged((PsiElement)filterQualifier);
            ct.replaceAndRestoreComments((PsiElement)comparison, base + "." + (isAnyMatch ? "anyMatch" : "noneMatch") + "(" + filterText + ")");
        }

        private static void replaceSimpleCount(PsiMethodCallExpression countCall, PsiMethodCallExpression qualifierCall, String replacementName) {
            String replacementText;
            PsiElement replacement;
            PsiTypeElement castElement;
            if (!COLLECTION_STREAM.test(qualifierCall) && !CHAR_SEQUENCE_CHARS.test(qualifierCall)) {
                return;
            }
            PsiReferenceExpression methodExpression = qualifierCall.getMethodExpression();
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)qualifierCall, (String)replacementName);
            boolean addCast = true;
            PsiMethodCallExpression toReplace = countCall;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)countCall.getParent());
            if (parent instanceof PsiExpressionStatement) {
                addCast = false;
            } else if (parent instanceof PsiTypeCastExpression && (castElement = ((PsiTypeCastExpression)parent).getCastType()) != null && castElement.getType() instanceof PsiPrimitiveType) {
                addCast = false;
                if (PsiTypes.intType().equals((Object)castElement.getType())) {
                    toReplace = parent;
                }
            }
            CommentTracker ct = new CommentTracker();
            PsiReferenceParameterList parameterList = methodExpression.getParameterList();
            if (parameterList != null) {
                ct.delete((PsiElement)parameterList);
            }
            if ((replacement = ct.replaceAndRestoreComments((PsiElement)toReplace, replacementText = (addCast ? "(long) " : "") + ct.text((PsiElement)methodExpression) + "()")) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)replacement))) {
                RemoveRedundantCastUtil.removeCast((PsiTypeCastExpression)((PsiTypeCastExpression)replacement));
            }
        }

        private static void replaceFlatMap(PsiElement countName, PsiMethodCallExpression qualifierCall) {
            PsiLambdaExpression lambda;
            PsiExpression psiExpression;
            if (!STREAM_FLAT_MAP.test(qualifierCall)) {
                return;
            }
            PsiElement flatMapName = qualifierCall.getMethodExpression().getReferenceNameElement();
            if (flatMapName == null) {
                return;
            }
            PsiExpression parameter = qualifierCall.getArgumentList().getExpressions()[0];
            PsiElement streamCallName = null;
            if (parameter instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)parameter;
                streamCallName = methodRef.getReferenceNameElement();
            } else if (parameter instanceof PsiLambdaExpression && (psiExpression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression(lambda = (PsiLambdaExpression)parameter)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)psiExpression;
                streamCallName = call.getMethodExpression().getReferenceNameElement();
            }
            if (streamCallName == null || !streamCallName.getText().equals(ReplaceInefficientStreamCountInspection.STREAM_METHOD)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)qualifierCall.getProject());
            streamCallName.replace((PsiElement)factory.createIdentifier("size"));
            flatMapName.replace((PsiElement)factory.createIdentifier("mapToLong"));
            countName.replace((PsiElement)factory.createIdentifier("sum"));
            PsiReferenceParameterList parameterList = qualifierCall.getMethodExpression().getParameterList();
            if (parameterList != null) {
                parameterList.delete();
            }
        }

        private static void replaceSimpleCountComparison(PsiMethodCallExpression countCall, boolean isPresent) {
            PsiBinaryExpression comparison = ReplaceInefficientStreamCountInspection.extractComparison(countCall, isPresent);
            if (comparison == null) {
                return;
            }
            PsiExpression countQualifier = countCall.getMethodExpression().getQualifierExpression();
            if (countQualifier == null) {
                return;
            }
            String base = countQualifier.getText();
            CommentTracker ct = new CommentTracker();
            ct.markUnchanged((PsiElement)countQualifier);
            if (isPresent) {
                ct.replaceAndRestoreComments((PsiElement)comparison, base + ".findAny().isPresent()");
            } else if (PsiUtil.getLanguageLevel((PsiElement)countCall).isAtLeast(LanguageLevel.JDK_11)) {
                ct.replaceAndRestoreComments((PsiElement)comparison, base + ".findAny().isEmpty()");
            } else {
                ct.replaceAndRestoreComments((PsiElement)comparison, "!" + base + ".findAny().isPresent()");
            }
        }

        @InspectionMessage
        public String getMessage() {
            return this.mySimplificationMode.getMessage();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$CountFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static enum SimplificationMode {
        SUM("Stream.mapToLong().sum()"),
        CHAR_SEQUENCE_LENGTH("CharSequence.length()"),
        COLLECTION_SIZE("Collection.size()"),
        ANY_MATCH("stream.anyMatch()"),
        NONE_MATCH("stream.noneMatch()"),
        IS_PRESENT("stream.findAny().isPresent()"),
        NOT_IS_PRESENT("!stream.findAny().isPresent()"),
        IS_EMPTY("stream.findAny().isEmpty()");

        @NonNls
        @NotNull
        private final String myNew;

        private SimplificationMode(String aNew) {
            if (aNew == null) {
                SimplificationMode.$$$reportNull$$$0(0);
            }
            this.myNew = aNew;
        }

        @Nls
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myNew});
        }

        @InspectionMessage
        public String getMessage() {
            return CommonQuickFixBundle.message((String)"fix.can.replace.with.x", (Object[])new Object[]{this.myNew});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aNew", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$SimplificationMode", "<init>"));
        }
    }
}

