/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String SCHEDULED_THREAD_POOL_EXECUTOR_CLASS_NAME = "java.util.concurrent.ScheduledThreadPoolExecutor";
    private static final String SET_CORE_POOL_SIZE_METHOD_NAME = "setCorePoolSize";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitNewExpression(expression);
                PsiExpression arg = ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection.getZeroArgument(expression.getArgumentList());
                if (arg == null) {
                    return;
                }
                PsiType type = expression.getType();
                if (!TypeUtils.typeEquals((String)ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection.SCHEDULED_THREAD_POOL_EXECUTOR_CLASS_NAME, (PsiType)type)) {
                    return;
                }
                holder.registerProblem((PsiElement)arg, JavaBundle.message((String)"scheduled.thread.pool.executor.with.zero.core.threads.description", (Object[])new Object[0]), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitMethodCallExpression(expression);
                String methodName = expression.getMethodExpression().getReferenceName();
                if (methodName == null || !methodName.equals(ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection.SET_CORE_POOL_SIZE_METHOD_NAME)) {
                    return;
                }
                PsiExpression arg = ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection.getZeroArgument(expression.getArgumentList());
                if (arg == null) {
                    return;
                }
                PsiExpression qualifier = expression.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                TypeConstraint constraint = TypeConstraint.fromDfType((DfType)CommonDataflow.getDfType((PsiExpression)qualifier));
                PsiType type = constraint.getPsiType(expression.getProject());
                if (!TypeUtils.typeEquals((String)ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection.SCHEDULED_THREAD_POOL_EXECUTOR_CLASS_NAME, (PsiType)type)) {
                    return;
                }
                holder.registerProblem((PsiElement)arg, JavaBundle.message((String)"scheduled.thread.pool.executor.with.zero.core.threads.description", (Object[])new Object[0]), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "com/intellij/codeInspection/ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static PsiExpression getZeroArgument(@Nullable PsiExpressionList argList) {
        if (argList == null) {
            return null;
        }
        PsiExpression[] args = argList.getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression arg = args[0];
        PsiType argType = arg.getType();
        if (argType == null || !argType.equals(PsiTypes.intType())) {
            return null;
        }
        Integer value = (Integer)ObjectUtils.tryCast((Object)CommonDataflow.computeValue((PsiExpression)arg), Integer.class);
        return value != null && value == 0 ? arg : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ScheduledThreadPoolExecutorWithZeroCoreThreadsInspection", "buildVisitor"));
    }
}

