/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class SlowAbstractSetRemoveAllInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String FOR_EACH_METHOD = "forEach";
    private static final CallMatcher SET_REMOVE_ALL = CallMatcher.instanceCall((String)"java.util.Set", (String[])new String[]{"removeAll"}).parameterTypes(new String[]{"java.util.Collection"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SlowAbstractSetRemoveAllInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                LocalQuickFix[] fix;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(call);
                if (!SET_REMOVE_ALL.test(call)) {
                    return;
                }
                PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)call.getMethodExpression());
                if (qualifier == null) {
                    return;
                }
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                TypeConstraint constraint = TypeConstraint.fromDfType((DfType)CommonDataflow.getDfType((PsiExpression)arg));
                PsiType type = constraint.getPsiType(holder.getProject());
                if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.List")) {
                    return;
                }
                TypeConstraint qualifierConstraint = TypeConstraint.fromDfType((DfType)CommonDataflow.getDfType((PsiExpression)qualifier));
                PsiType qualifierType = qualifierConstraint.getPsiType(holder.getProject());
                if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.concurrent.CopyOnWriteArraySet")) {
                    return;
                }
                LongRangeSet setSizeRange = SlowAbstractSetRemoveAllInspection.getSizeRangeOfCollection(qualifier);
                if (setSizeRange.isEmpty() || setSizeRange.max() <= 1L) {
                    return;
                }
                LongRangeSet listSizeRange = SlowAbstractSetRemoveAllInspection.getSizeRangeOfCollection(arg);
                if (listSizeRange.isEmpty() || listSizeRange.max() <= 2L) {
                    return;
                }
                if (setSizeRange.min() > listSizeRange.max()) {
                    return;
                }
                if (PsiUtil.isAvailable((JavaFeature)JavaFeature.ADVANCED_COLLECTIONS_API, (PsiElement)call) && ExpressionUtils.isVoidContext((PsiExpression)call)) {
                    String replacement = ParenthesesUtils.getText((PsiExpression)arg, (int)2) + ".forEach(" + qualifier.getText() + "::remove)";
                    fix = new LocalQuickFix[]{new ReplaceWithListForEachFix(replacement)};
                } else {
                    fix = LocalQuickFix.EMPTY_ARRAY;
                }
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                holder.registerProblem((PsiElement)call, JavaBundle.message((String)"inspection.slow.abstract.set.remove.all.description", (Object[])new Object[0]), ProblemHighlightType.WARNING, nameElement.getTextRangeInParent(), fix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/SlowAbstractSetRemoveAllInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @NotNull
    public static LongRangeSet getSizeRangeOfCollection(PsiExpression collection) {
        SpecialField lengthField = SpecialField.COLLECTION_SIZE;
        DfType origType = CommonDataflow.getDfType((PsiExpression)collection);
        DfType length = lengthField.getFromQualifier(origType);
        DfIntegralType dfType = (DfIntegralType)ObjectUtils.tryCast((Object)length, DfIntegralType.class);
        if (dfType == null) {
            LongRangeSet longRangeSet = LongRangeSet.all();
            if (longRangeSet == null) {
                SlowAbstractSetRemoveAllInspection.$$$reportNull$$$0(1);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = dfType.getRange();
        if (longRangeSet == null) {
            SlowAbstractSetRemoveAllInspection.$$$reportNull$$$0(2);
        }
        return longRangeSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SlowAbstractSetRemoveAllInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SlowAbstractSetRemoveAllInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSizeRangeOfCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceWithListForEachFix
    extends PsiUpdateModCommandQuickFix {
        final String myExpressionText;

        ReplaceWithListForEachFix(String string) {
            this.myExpressionText = string;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myExpressionText});
            if (string == null) {
                ReplaceWithListForEachFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.slow.abstract.set.remove.all.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithListForEachFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithListForEachFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithListForEachFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithListForEachFix.$$$reportNull$$$0(4);
            }
            if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression arg = args[0];
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)SlowAbstractSetRemoveAllInspection.FOR_EACH_METHOD);
            CommentTracker ct = new CommentTracker();
            String setRemove = qualifier.getText() + "::remove";
            ct.replace((PsiElement)qualifier, (PsiElement)arg);
            ct.replace((PsiElement)arg, setRemove);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SlowAbstractSetRemoveAllInspection$ReplaceWithListForEachFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SlowAbstractSetRemoveAllInspection$ReplaceWithListForEachFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

