/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.util.JavaPsiStringTemplateUtil;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class StringTemplateReverseMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            StringTemplateReverseMigrationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitTemplateExpression(@NotNull PsiTemplateExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiTemplate template = expression.getTemplate();
                PsiLiteralExpression literal = expression.getLiteralExpression();
                if (template == null && literal == null) {
                    return;
                }
                if (!JavaPsiStringTemplateUtil.isStrTemplate((PsiExpression)expression.getProcessor(), (boolean)true)) {
                    return;
                }
                if (template != null && ContainerUtil.exists((Iterable)template.getFragments(), f -> f.getValue() == null)) {
                    return;
                }
                if (literal != null && literal.getValue() == null) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.string.template.reverse.migration.string.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithStringConcatenationFix()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/StringTemplateReverseMigrationInspection$1", "visitTemplateExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/StringTemplateReverseMigrationInspection", "buildVisitor"));
    }

    private static class ReplaceWithStringConcatenationFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithStringConcatenationFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.replace.with.string.concatenation.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithStringConcatenationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceWithStringConcatenationFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithStringConcatenationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithStringConcatenationFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiTemplateExpression)) {
                return;
            }
            PsiTemplateExpression templateExpression = (PsiTemplateExpression)element;
            PsiLiteralExpression literal = templateExpression.getLiteralExpression();
            if (literal != null) {
                templateExpression.replace((PsiElement)literal);
                return;
            }
            PsiTemplate template = templateExpression.getTemplate();
            if (template == null) {
                return;
            }
            @NotNull List fragments = template.getFragments();
            @NotNull List expressions = template.getEmbeddedExpressions();
            CommentTracker ct = new CommentTracker();
            StringBuilder concatenation = new StringBuilder();
            boolean stringSeen = false;
            for (int i = 0; i < expressions.size(); ++i) {
                boolean needParentheses;
                PsiFragment fragment = (PsiFragment)fragments.get(i);
                String value = fragment.getValue();
                if (value == null) {
                    return;
                }
                if (!value.isEmpty() || i > 0 && !stringSeen) {
                    if (!concatenation.isEmpty()) {
                        concatenation.append('+');
                    }
                    concatenation.append('\"').append(StringUtil.escapeStringCharacters((String)value)).append('\"');
                    stringSeen = true;
                }
                if (!concatenation.isEmpty()) {
                    concatenation.append('+');
                }
                PsiExpression expression = (PsiExpression)expressions.get(i);
                int precedence = PsiPrecedenceUtil.getPrecedence((PsiExpression)expression);
                boolean string = ExpressionUtils.hasStringType((PsiExpression)expression);
                boolean bl = needParentheses = precedence > 6 || stringSeen && precedence == 6 && !string;
                if (needParentheses) {
                    concatenation.append('(').append(ct.text((PsiElement)expression)).append(')');
                } else {
                    String text = ct.text((PsiElement)expression);
                    concatenation.append(text.isEmpty() ? "null" : text);
                }
                if (!string) continue;
                stringSeen = true;
            }
            String last = ((PsiFragment)fragments.getLast()).getValue();
            if (last == null) {
                return;
            }
            if (!last.isEmpty()) {
                concatenation.append("+\"").append(StringUtil.escapeStringCharacters((String)last)).append('\"');
            }
            ct.replaceAndRestoreComments((PsiElement)templateExpression, concatenation.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/StringTemplateReverseMigrationInspection$ReplaceWithStringConcatenationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/StringTemplateReverseMigrationInspection$ReplaceWithStringConcatenationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

