/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class TextBlockBackwardMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.TEXT_BLOCKS);
        if (set == null) {
            TextBlockBackwardMigrationInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            TextBlockBackwardMigrationInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!expression.isTextBlock() || PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)expression) == null || expression.getParent() instanceof PsiTemplateExpression) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.text.block.backward.migration.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithRegularStringLiteralFix()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/TextBlockBackwardMigrationInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithRegularStringLiteralFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithRegularStringLiteralFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.replace.with.regular.string.literal.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiLiteralExpression literalExpression;
            if (project == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(3);
            }
            if ((literalExpression = (PsiLiteralExpression)ObjectUtils.tryCast((Object)element, PsiLiteralExpression.class)) == null || !literalExpression.isTextBlock()) {
                return;
            }
            String text = PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)literalExpression);
            if (text == null) {
                return;
            }
            String replacement = ReplaceWithRegularStringLiteralFix.convertToConcatenation(text);
            PsiFile file = element.getContainingFile();
            if (file == null) {
                return;
            }
            CodeStyleSettings tempSettings = CodeStyle.getSettings((PsiFile)file);
            tempSettings.getCommonSettings((Language)JavaLanguage.INSTANCE).ALIGN_MULTILINE_BINARY_OPERATION = true;
            CodeStyleManager manager = CodeStyleManager.getInstance((Project)literalExpression.getProject());
            CodeStyle.runWithLocalSettings((Project)project, (CodeStyleSettings)tempSettings, () -> {
                PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)literalExpression, replacement);
                manager.reformat(result);
            });
        }

        @NotNull
        private static String convertToConcatenation(@NotNull String text) {
            if (text == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(4);
            }
            if (text.isEmpty()) {
                return "\"\"";
            }
            StringJoiner joiner = new StringJoiner(" +\n");
            String[] lines = ReplaceWithRegularStringLiteralFix.getTextBlockLines(text).split("\n", -1);
            for (int i = 0; i < lines.length; ++i) {
                boolean addNewLine;
                String line = lines[i];
                boolean bl = addNewLine = i != lines.length - 1;
                if (!addNewLine && line.isEmpty()) break;
                joiner.add("\"" + line + (addNewLine ? "\\n\"" : "\""));
            }
            String string = joiner.toString();
            if (string == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private static String getTextBlockLines(@NotNull String text) {
            if (text == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(6);
            }
            int length = text.length();
            StringBuilder result = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                int nSlashes = 0;
                int next = i;
                while (next < length && (next = PsiLiteralUtil.parseBackSlash((String)text, (int)next)) != -1) {
                    ++nSlashes;
                    i = next;
                }
                if (i >= length) {
                    result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes));
                    break;
                }
                next = ReplaceWithRegularStringLiteralFix.parseQuote(i, text, nSlashes, result);
                if (next != -1) {
                    i = next;
                    continue;
                }
                if (nSlashes != 0) {
                    i = ReplaceWithRegularStringLiteralFix.parseEscapedChar(i, text, nSlashes, result);
                    continue;
                }
                result.append(text.charAt(i));
                ++i;
            }
            String string = result.toString();
            if (string == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static int parseEscapedChar(int i, @NotNull String text, int nSlashes, @NotNull StringBuilder result) {
            int next;
            if (text == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(8);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(9);
            }
            if ((next = ReplaceWithRegularStringLiteralFix.parseEscapedSpace(i, text, nSlashes, result)) != -1) {
                return next;
            }
            next = ReplaceWithRegularStringLiteralFix.parseEscapedLineBreak(i, text, nSlashes, result);
            if (next != -1) {
                return next;
            }
            result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes)).append(text.charAt(i));
            return i + 1;
        }

        private static int parseEscapedSpace(int i, @NotNull String text, int nSlashes, @NotNull StringBuilder result) {
            char c;
            if (text == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(10);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(11);
            }
            if ((c = text.charAt(i)) == 's' && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1))).append(' ');
                return i + 1;
            }
            if (StringUtil.startsWith((CharSequence)text, (int)i, (CharSequence)"040") && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1))).append(' ');
                return i + 3;
            }
            return -1;
        }

        private static int parseEscapedLineBreak(int i, @NotNull String text, int nSlashes, @NotNull StringBuilder result) {
            char c;
            if (text == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(12);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(13);
            }
            if ((c = text.charAt(i)) == '\n' && nSlashes % 2 != 0) {
                result.append(StringUtil.repeatSymbol((char)'\\', (int)(nSlashes - 1)));
                return i + 1;
            }
            return -1;
        }

        private static int parseQuote(int i, @NotNull String text, int nSlashes, @NotNull StringBuilder result) {
            char c;
            if (text == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(14);
            }
            if (result == null) {
                ReplaceWithRegularStringLiteralFix.$$$reportNull$$$0(15);
            }
            if ((c = text.charAt(i)) != '\"') {
                return -1;
            }
            if (nSlashes % 2 == 0) {
                ++nSlashes;
            }
            result.append(StringUtil.repeatSymbol((char)'\\', (int)nSlashes)).append(c);
            return i + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection$ReplaceWithRegularStringLiteralFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 9: 
                case 11: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/TextBlockBackwardMigrationInspection$ReplaceWithRegularStringLiteralFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToConcatenation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextBlockLines";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToConcatenation";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextBlockLines";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "parseEscapedChar";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "parseEscapedSpace";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "parseEscapedLineBreak";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "parseQuote";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
            };
        }
    }
}

