/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.java.JavaBundle;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiBoxingUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WrapperTypeMayBePrimitiveInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher TO_STRING = CallMatcher.instanceCall((String)"java.lang.Object", (String[])new String[]{"toString"});
    private static final CallMatcher HASH_CODE = CallMatcher.instanceCall((String)"java.lang.Object", (String[])new String[]{"hashCode"});
    private static final CallMatcher VALUE_OF = WrapperTypeMayBePrimitiveInspection.getValueOfMatcher();
    private static final Set<String> ourAllowedInstanceCalls = Set.of("isInfinite", "isNaN", "byteValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue");

    private static CallMatcher getValueOfMatcher() {
        CallMatcher[] matchers = (CallMatcher[])JvmPrimitiveTypeKind.getBoxedFqns().stream().filter(fqn -> !fqn.equals("java.lang.Character")).map(fqn -> CallMatcher.staticCall((String)fqn, (String[])new String[]{"valueOf"}).parameterTypes(new String[]{"java.lang.String"})).toArray(CallMatcher[]::new);
        return CallMatcher.anyOf((CallMatcher[])matchers);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            WrapperTypeMayBePrimitiveInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethod(@NotNull PsiMethod method) {
                PsiCodeBlock body;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((body = method.getBody()) == null) {
                    return;
                }
                WrapperTypeMayBePrimitiveDetectingVisitor visitor = new WrapperTypeMayBePrimitiveDetectingVisitor();
                body.accept((PsiElementVisitor)visitor);
                for (PsiVariable variable : visitor.getVariablesToUnbox()) {
                    PsiVariable elementToHighlight = variable.getTypeElement() != null ? variable.getTypeElement() : variable;
                    holder.registerProblem((PsiElement)elementToHighlight, JavaBundle.message((String)"inspection.wrapper.type.may.be.primitive.name", (Object[])new Object[0]), new LocalQuickFix[]{new ConvertWrapperTypeToPrimitive()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/WrapperTypeMayBePrimitiveInspection$1", "visitMethod"));
            }
        };
    }

    private static boolean isValueOfCall(PsiExpression expression) {
        return expression instanceof PsiMethodCallExpression && VALUE_OF.test((PsiMethodCallExpression)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/WrapperTypeMayBePrimitiveInspection", "buildVisitor"));
    }

    private static class ConvertWrapperTypeToPrimitive
    extends PsiUpdateModCommandQuickFix {
        private ConvertWrapperTypeToPrimitive() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                ConvertWrapperTypeToPrimitive.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.wrapper.type.may.be.primitive.fix.name", (Object[])new Object[0]);
            if (string == null) {
                ConvertWrapperTypeToPrimitive.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiType type;
            String boxedType;
            String unboxedType;
            PsiTypeElement typeElement;
            if (project == null) {
                ConvertWrapperTypeToPrimitive.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ConvertWrapperTypeToPrimitive.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ConvertWrapperTypeToPrimitive.$$$reportNull$$$0(4);
            }
            if ((typeElement = (PsiTypeElement)ObjectUtils.tryCast((Object)element, PsiTypeElement.class)) == null) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)typeElement.getParent(), PsiLocalVariable.class);
            if (variable == null) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ConvertWrapperTypeToPrimitive.tryReplaceStaticCall(initializer);
            }
            if ((unboxedType = PsiTypesUtil.unboxIfPossible((String)(boxedType = (type = variable.getType()).getCanonicalText()))).equals(boxedType)) {
                return;
            }
            PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
            if (codeBlock == null) {
                return;
            }
            codeBlock.accept((PsiElementVisitor)new UnboxingVisitor(variable));
            new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, unboxedType);
        }

        private static void tryReplaceStaticCall(PsiExpression expression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression, PsiMethodCallExpression.class);
            if (!VALUE_OF.test(callExpression)) {
                return;
            }
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            String replacementMethodCall = JavaPsiBoxingUtils.getParseMethod((PsiType)callExpression.getType());
            if (replacementMethodCall == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String argumentText = tracker.text((PsiElement)argument);
            String replacementText = containingClassName + "." + replacementMethodCall + "(" + argumentText + ")";
            tracker.replaceAndRestoreComments((PsiElement)callExpression, replacementText);
        }

        private static void replaceInstanceCall(PsiMethodCallExpression call) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return;
            }
            String qualifierTypeText = qualifierType.getCanonicalText();
            CommentTracker tracker = new CommentTracker();
            String qualifierText = tracker.text((PsiElement)qualifier);
            String replacement = ConvertWrapperTypeToPrimitive.findStaticReplacement(call, qualifierText, qualifierTypeText);
            if (replacement == null) {
                return;
            }
            tracker.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        private static String findStaticReplacement(PsiMethodCallExpression call, String qualifierText, String qualifierTypeText) {
            String type;
            String callName = call.getMethodExpression().getReferenceName();
            String methodNameText = HASH_CODE.test(call) ? "hashCode" : (TO_STRING.test(call) ? "toString" : ("isInfinite".equals(callName) ? "isInfinite" : ("isNaN".equals(callName) ? "isNaN" : null)));
            if (methodNameText != null) {
                return qualifierTypeText + "." + methodNameText + "(" + qualifierText + ")";
            }
            if ("intValue".equals(callName)) {
                type = "int";
            } else if ("byteValue".equals(callName)) {
                type = "byte";
            } else if ("floatValue".equals(callName)) {
                type = "float";
            } else if ("doubleValue".equals(callName)) {
                type = "double";
            } else if ("shortValue".equals(callName)) {
                type = "short";
            } else {
                return null;
            }
            return "(" + type + ")" + qualifierText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/WrapperTypeMayBePrimitiveInspection$ConvertWrapperTypeToPrimitive";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/WrapperTypeMayBePrimitiveInspection$ConvertWrapperTypeToPrimitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }

        private static class UnboxingVisitor
        extends JavaRecursiveElementVisitor {
            private final PsiLocalVariable myVariable;

            UnboxingVisitor(PsiLocalVariable variable) {
                this.myVariable = variable;
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    UnboxingVisitor.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                if (!ExpressionUtils.isReferenceTo((PsiExpression)expression, (PsiVariable)this.myVariable)) {
                    return;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression).getParent();
                PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression);
                if (call != null) {
                    ConvertWrapperTypeToPrimitive.replaceInstanceCall(call);
                } else if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                    if (!ExpressionUtils.isReferenceTo((PsiExpression)assignment.getLExpression(), (PsiVariable)this.myVariable)) {
                        return;
                    }
                    ConvertWrapperTypeToPrimitive.tryReplaceStaticCall(assignment.getRExpression());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/WrapperTypeMayBePrimitiveInspection$ConvertWrapperTypeToPrimitive$UnboxingVisitor", "visitReferenceExpression"));
            }
        }
    }

    private static class WrapperTypeMayBePrimitiveDetectingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private static final int IN_LOOP_OPERATION_MULTIPLIER = 10;
        private final Map<PsiVariable, List<BoxingInfo>> myBoxingMap = new HashMap<PsiVariable, List<BoxingInfo>>();

        private WrapperTypeMayBePrimitiveDetectingVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(0);
            }
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable);
            if (variable instanceof PsiField) {
                return;
            }
            if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)variable.getType())) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            BoxingInfo boxingInfo = new BoxingInfo((PsiVariable)variable);
            if (initializer != null && !boxingInfo.checkExpression(initializer)) {
                return;
            }
            ArrayList<BoxingInfo> infos = new ArrayList<BoxingInfo>();
            infos.add(boxingInfo);
            this.myBoxingMap.put((PsiVariable)variable, infos);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(2);
            }
            super.visitReferenceExpression(expression);
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)expression.resolve(), PsiVariable.class);
            if (variable == null) {
                return;
            }
            List<BoxingInfo> infos = this.myBoxingMap.get(variable);
            if (infos == null) {
                return;
            }
            Iterator<BoxingInfo> iterator = infos.iterator();
            while (iterator.hasNext()) {
                BoxingInfo boxingInfo = iterator.next();
                if (!ExpressionUtils.isReferenceTo((PsiExpression)expression, (PsiVariable)boxingInfo.myVariable)) continue;
                boxingInfo.myHasReferences = true;
                Integer boxingRemovalImpact = WrapperTypeMayBePrimitiveDetectingVisitor.afterBoxingRemovalReferenceBoostedImpact(expression, boxingInfo);
                if (boxingRemovalImpact == null) {
                    iterator.remove();
                    break;
                }
                boxingInfo.myAfterRemovalOperationCountDiff += boxingRemovalImpact.intValue();
                break;
            }
            if (infos.isEmpty()) {
                this.myBoxingMap.remove(variable);
            }
        }

        public List<PsiVariable> getVariablesToUnbox() {
            ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
            for (List<BoxingInfo> infos : this.myBoxingMap.values()) {
                for (BoxingInfo boxingInfo : infos) {
                    if (!boxingInfo.myHasReferences || !boxingInfo.primitiveReplacementReducesUnnecessaryOperationCount()) continue;
                    variables.add(boxingInfo.myVariable);
                }
            }
            return variables;
        }

        private static boolean isAllowedInstanceCall(@NotNull PsiMethodCallExpression call) {
            PsiMethod method;
            if (call == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(3);
            }
            if ((method = call.resolveMethod()) == null) {
                return false;
            }
            if (method.hasModifier(JvmModifier.STATIC)) {
                return false;
            }
            return ourAllowedInstanceCalls.contains(call.getMethodExpression().getReferenceName());
        }

        @Nullable(value="When use not allows unboxing")
        private static @Nullable(value="When use not allows unboxing") Integer afterBoxingRemovalReferenceBoostedImpact(@NotNull PsiReferenceExpression expression, @NotNull BoxingInfo boxingInfo) {
            Integer impact;
            if (expression == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(4);
            }
            if (boxingInfo == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(5);
            }
            if ((impact = WrapperTypeMayBePrimitiveDetectingVisitor.afterBoxingRemovalReferenceImpact(expression, boxingInfo)) == null) {
                return null;
            }
            LocalSearchScope scope = (LocalSearchScope)ObjectUtils.tryCast((Object)boxingInfo.myVariable.getUseScope(), LocalSearchScope.class);
            if (scope == null) {
                return impact;
            }
            Object[] scopeElements = scope.getScope();
            PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiLoopStatement.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class, PsiMethod.class});
            if (loop != null && ContainerUtil.or((Object[])scopeElements, scopeElement -> PsiTreeUtil.isAncestor((PsiElement)scopeElement, (PsiElement)loop, (boolean)false)) && !PsiTreeUtil.isAncestor((PsiElement)loop, (PsiElement)boxingInfo.myVariable, (boolean)true)) {
                impact = impact * 10;
            }
            return impact;
        }

        @Nullable(value="When use does not allow unboxing")
        private static @Nullable(value="When use does not allow unboxing") Integer afterBoxingRemovalReferenceImpact(@NotNull PsiReferenceExpression expression, @NotNull BoxingInfo boxingInfo) {
            PsiType returnType;
            PsiMethod method;
            if (expression == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(6);
            }
            if (boxingInfo == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(7);
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression).getParent();
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression);
            if (!(call == null || TO_STRING.test(call) || HASH_CODE.test(call) || WrapperTypeMayBePrimitiveDetectingVisitor.isAllowedInstanceCall(call))) {
                return null;
            }
            if (parent instanceof PsiExpressionList) {
                return WrapperTypeMayBePrimitiveDetectingVisitor.expressionListImpactAfterBoxingRemoval((PsiExpressionList)parent, expression);
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                PsiType lExprType = assignment.getLExpression().getType();
                if (lExprType != null && TypeUtils.isJavaLangString((PsiType)lExprType)) {
                    return 0;
                }
                PsiExpression rExpression = assignment.getRExpression();
                if (rExpression == null) {
                    return 0;
                }
                if (!boxingInfo.checkExpression(rExpression)) {
                    return null;
                }
                return TypeConversionUtil.convertEQtoOperation((IElementType)assignment.getOperationTokenType()) != null ? -2 : -1;
            }
            if (parent instanceof PsiSynchronizedStatement) {
                return null;
            }
            if (parent instanceof PsiPolyadicExpression) {
                return WrapperTypeMayBePrimitiveDetectingVisitor.polyadicExpressionImpactAfterBoxingRemoval((PsiPolyadicExpression)parent, expression);
            }
            if (parent instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiLambdaExpression.class})) != null && (returnType = method.getReturnType()) != null) {
                return returnType instanceof PsiPrimitiveType ? -1 : 1;
            }
            return 0;
        }

        @Nullable(value="When use not allows unboxing")
        private static @Nullable(value="When use not allows unboxing") Integer expressionListImpactAfterBoxingRemoval(@NotNull PsiExpressionList expressionList, @NotNull PsiReferenceExpression reference) {
            int parameterIndex;
            PsiElement grandParent;
            if (expressionList == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(8);
            }
            if (reference == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(9);
            }
            if (!((grandParent = expressionList.getParent()) instanceof PsiCallExpression)) {
                return null;
            }
            PsiCallExpression callExpression = (PsiCallExpression)grandParent;
            Object[] arguments = expressionList.getExpressions();
            int argumentsIndex = ArrayUtil.indexOf((Object[])arguments, (Object)reference);
            if (argumentsIndex == -1) {
                return null;
            }
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return null;
            }
            if (!WrapperTypeMayBePrimitiveDetectingVisitor.changedCallResolvesToSameMethod(callExpression, (PsiExpression)arguments[argumentsIndex], method)) {
                return null;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            int n = parameterIndex = parameters.length < argumentsIndex + 1 ? parameters.length - 1 : argumentsIndex;
            if (parameterIndex < 0) {
                return null;
            }
            PsiParameter parameter = parameters[parameterIndex];
            PsiType type = parameter.getType();
            return type instanceof PsiPrimitiveType ? -1 : 1;
        }

        private static boolean changedCallResolvesToSameMethod(PsiCallExpression call, PsiExpression argument, PsiMethod method) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)call.getProject());
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            int indexOfArgument = ArrayUtil.indexOf((Object[])argumentList.getExpressions(), (Object)argument);
            PsiCallExpression callCopy = (PsiCallExpression)call.copy();
            PsiExpression argumentCopy = Objects.requireNonNull(callCopy.getArgumentList()).getExpressions()[indexOfArgument];
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)argumentCopy.getType());
            if (unboxedType == null) {
                return false;
            }
            PsiExpression argumentWithNewType = factory.createExpressionFromText("(" + unboxedType.getCanonicalText() + ")(" + argumentCopy.getText() + ")", (PsiElement)argumentCopy);
            argumentCopy.replace((PsiElement)argumentWithNewType);
            return callCopy.resolveMethod() == method;
        }

        private static int getBinOpImpact(boolean haveBoxAfter, IElementType operationTokenType) {
            if (!haveBoxAfter) {
                return -1;
            }
            if (operationTokenType == JavaTokenType.EQEQ || operationTokenType == JavaTokenType.NE) {
                return -1;
            }
            boolean isRelational = operationTokenType == JavaTokenType.GT || operationTokenType == JavaTokenType.GE || operationTokenType == JavaTokenType.LT || operationTokenType == JavaTokenType.LE;
            return isRelational ? 0 : 1;
        }

        @Nullable(value="When use does not allow unboxing")
        private static @Nullable(value="When use does not allow unboxing") Integer polyadicExpressionImpactAfterBoxingRemoval(@NotNull PsiPolyadicExpression polyadic, PsiReferenceExpression reference) {
            int nextOperandIndex;
            if (polyadic == null) {
                WrapperTypeMayBePrimitiveDetectingVisitor.$$$reportNull$$$0(10);
            }
            PsiExpression[] operands = polyadic.getOperands();
            IElementType tokenType = polyadic.getOperationTokenType();
            int afterRemovalOpCountDiff = 0;
            int referenceIndex = -1;
            boolean leftPartBoxed = false;
            boolean hasLeftPart = false;
            boolean isPlus = polyadic.getOperationTokenType() == JavaTokenType.PLUS;
            for (int i = 0; i < operands.length; ++i) {
                PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operands[i]);
                if (operand == null) {
                    return null;
                }
                if (operand == reference) {
                    referenceIndex = i;
                    break;
                }
                hasLeftPart = true;
                PsiType operandType = operand.getType();
                if (isPlus && TypeUtils.isJavaLangString((PsiType)operandType)) {
                    return afterRemovalOpCountDiff;
                }
                if (operandType instanceof PsiPrimitiveType) continue;
                if (NullabilityUtil.getExpressionNullability((PsiExpression)operand, (boolean)true) != Nullability.NOT_NULL) {
                    return null;
                }
                leftPartBoxed = true;
            }
            if (hasLeftPart) {
                afterRemovalOpCountDiff += WrapperTypeMayBePrimitiveDetectingVisitor.getBinOpImpact(leftPartBoxed, tokenType);
            }
            if ((nextOperandIndex = referenceIndex + 1) < operands.length) {
                PsiExpression next = operands[nextOperandIndex];
                if (ExpressionUtils.isNullLiteral((PsiExpression)next)) {
                    return null;
                }
                afterRemovalOpCountDiff += WrapperTypeMayBePrimitiveDetectingVisitor.getBinOpImpact(!(next.getType() instanceof PsiPrimitiveType), tokenType);
            }
            return afterRemovalOpCountDiff;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boxingInfo";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionList";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "polyadic";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/WrapperTypeMayBePrimitiveInspection$WrapperTypeMayBePrimitiveDetectingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAllowedInstanceCall";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterBoxingRemovalReferenceBoostedImpact";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterBoxingRemovalReferenceImpact";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expressionListImpactAfterBoxingRemoval";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "polyadicExpressionImpactAfterBoxingRemoval";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class BoxingInfo {
        @NotNull
        private final PsiVariable myVariable;
        boolean myHasReferences;
        private int myAfterRemovalOperationCountDiff;

        private BoxingInfo(@NotNull PsiVariable variable) {
            if (variable == null) {
                BoxingInfo.$$$reportNull$$$0(0);
            }
            this.myHasReferences = false;
            this.myAfterRemovalOperationCountDiff = 0;
            this.myVariable = variable;
        }

        boolean checkExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                BoxingInfo.$$$reportNull$$$0(1);
            }
            if (expression.getType() instanceof PsiPrimitiveType && !PsiTypes.nullType().equals(expression.getType())) {
                --this.myAfterRemovalOperationCountDiff;
            } else if (WrapperTypeMayBePrimitiveInspection.isValueOfCall(expression)) {
                --this.myAfterRemovalOperationCountDiff;
            } else {
                if (NullabilityUtil.getExpressionNullability((PsiExpression)expression, (boolean)true) != Nullability.NOT_NULL) {
                    return false;
                }
                ++this.myAfterRemovalOperationCountDiff;
            }
            return true;
        }

        boolean primitiveReplacementReducesUnnecessaryOperationCount() {
            return this.myAfterRemovalOperationCountDiff < 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/WrapperTypeMayBePrimitiveInspection$BoxingInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

