/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.classCanBeRecord;

import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@NotNullByDefault
final class ConstructorBodyProcessor {
    private final PsiMethod constructor;
    private final Map<PsiParameter, @Nullable PsiField> paramsToFields = new HashMap<PsiParameter, PsiField>();
    private final LinkedHashMap<String, PsiExpression> fieldNamesToInitializers = new LinkedHashMap();
    private final List<PsiField> instanceFields;
    private boolean canonical = false;
    private boolean delegating = false;
    private boolean hasUnresolvedRefs = false;
    private boolean tooComplex = false;
    private boolean statementsBeforeAllFieldsAssigned = false;
    private final List<PsiStatement> otherStatements = new ArrayList<PsiStatement>();
    private final MultiMap<PsiField, PsiParameter> fieldsToParams = new MultiMap();

    ConstructorBodyProcessor(PsiMethod constructor, List<PsiField> instanceFields) {
        this.constructor = constructor;
        this.instanceFields = instanceFields;
        PsiCodeBlock body = Objects.requireNonNull(constructor.getBody(), "constructor must have body");
        for (PsiStatement statement : body.getStatements()) {
            this.execute(statement);
        }
        this.postprocess();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void execute(PsiStatement statement) {
        PsiMethodCallExpression methodCallExpr;
        if (!(statement instanceof PsiExpressionStatement)) {
            this.otherStatements.add(statement);
            return;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        PsiClass containingClass = this.constructor.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (expression instanceof PsiMethodCallExpression && JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)(methodCallExpr = (PsiMethodCallExpression)expression))) {
            this.delegating = true;
            for (PsiExpression arg : methodCallExpr.getArgumentList().getExpressions()) {
                if (!ConstructorBodyProcessor.hasReferenceToContainingClass(containingClass, arg)) continue;
                this.statementsBeforeAllFieldsAssigned = true;
            }
            return;
        }
        if (!ConstructorBodyProcessor.expressionIsAssignmentToInstanceField(expression) && !this.delegating) {
            this.otherStatements.add(statement);
            if (this.fieldNamesToInitializers.isEmpty() && PsiUtil.isAvailable((JavaFeature)JavaFeature.STATEMENTS_BEFORE_SUPER, (PsiElement)statement)) {
                PsiExpression exprToConsider;
                if (expression instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignExpr = (PsiAssignmentExpression)expression;
                    v0 = assignExpr.getRExpression();
                } else {
                    v0 = exprToConsider = expression;
                }
                if (ConstructorBodyProcessor.hasReferenceToContainingClass(containingClass, exprToConsider)) {
                    this.statementsBeforeAllFieldsAssigned = true;
                }
            } else if (this.fieldNamesToInitializers.size() < this.instanceFields.size()) {
                this.statementsBeforeAllFieldsAssigned = true;
            }
            return;
        }
        if (!(expression instanceof PsiAssignmentExpression)) {
            return;
        }
        PsiAssignmentExpression assignExpr = (PsiAssignmentExpression)expression;
        PsiExpression psiExpression = assignExpr.getLExpression();
        if (!(psiExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression leftRefExpr = (PsiReferenceExpression)psiExpression;
        if (leftRefExpr.resolve() == null) {
            this.hasUnresolvedRefs = true;
            return;
        }
        PsiElement psiElement = leftRefExpr.resolve();
        if (!(psiElement instanceof PsiField)) {
            return;
        }
        final PsiField field = (PsiField)psiElement;
        PsiExpression rightExpr = assignExpr.getRExpression();
        if (rightExpr == null) {
            return;
        }
        PsiType targetType = leftRefExpr.getType();
        PsiType assignedType = rightExpr.getType();
        if (targetType == null || assignedType == null || !targetType.isAssignableFrom(assignedType)) {
            this.hasUnresolvedRefs = true;
            return;
        }
        this.fieldNamesToInitializers.put(field.getName(), rightExpr);
        final @Nullable Ref refParameterForField = new Ref();
        rightExpr.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved == null) {
                    ConstructorBodyProcessor.this.hasUnresolvedRefs = true;
                } else if (resolved instanceof PsiParameter) {
                    PsiParameter parameter = (PsiParameter)resolved;
                    ConstructorBodyProcessor.this.fieldsToParams.putValue((Object)field, (Object)parameter);
                    if (!ConstructorBodyProcessor.this.paramsToFields.containsKey(parameter)) {
                        refParameterForField.set((Object)parameter);
                    }
                }
            }
        });
        PsiParameter parameterForField = (PsiParameter)refParameterForField.get();
        if (parameterForField != null) {
            this.paramsToFields.put(parameterForField, field);
        }
    }

    private void postprocess() {
        for (PsiParameter parameter : this.constructor.getParameterList().getParameters()) {
            if (this.paramsToFields.get(parameter) != null) continue;
            this.paramsToFields.put(parameter, null);
        }
        for (PsiParameter parameter : this.fieldsToParams.values()) {
            if (this.fieldsToParams.keySet().stream().filter(field -> this.fieldsToParams.get(field).contains(parameter)).count() <= 1L) continue;
            this.tooComplex = true;
            return;
        }
        if (!this.delegating) {
            assert (this.constructor.getBody() != null);
            PsiParameter[] ctorParams = this.constructor.getParameterList().getParameters();
            if (ConstructorBodyProcessor.allFieldsAssignedIn(this.constructor.getBody(), this.instanceFields)) {
                if (ctorParams.length == this.instanceFields.size()) {
                    assert (this.constructor.getContainingClass() != null);
                    if (this.constructor.getContainingClass().getConstructors().length == 1) {
                        this.canonical = true;
                    } else {
                        boolean fieldsMatchInOrder = true;
                        for (int i = 0; i < ctorParams.length; ++i) {
                            PsiType ctorParamType = ctorParams[i].getType();
                            PsiType instanceFieldType = this.instanceFields.get(i).getType();
                            if (TypeConversionUtil.isAssignable((PsiType)instanceFieldType, (PsiType)ctorParamType)) continue;
                            fieldsMatchInOrder = false;
                            break;
                        }
                        if (fieldsMatchInOrder) {
                            this.canonical = true;
                        }
                    }
                }
            } else {
                this.hasUnresolvedRefs = true;
            }
        }
    }

    boolean isCanonical() {
        return this.canonical;
    }

    boolean isDelegating() {
        return this.delegating;
    }

    boolean hasUnresolvedRefs() {
        return this.hasUnresolvedRefs;
    }

    boolean isTooComplex() {
        return this.tooComplex;
    }

    boolean hasAnyStatementBeforeAllFieldsAreAssigned() {
        return this.statementsBeforeAllFieldsAssigned;
    }

    Map<PsiParameter, @Nullable PsiField> getParamsToFields() {
        return this.paramsToFields;
    }

    LinkedHashMap<String, PsiExpression> getFieldNamesToInitializers() {
        return this.fieldNamesToInitializers;
    }

    @UnmodifiableView List<PsiStatement> getOtherStatements() {
        return Collections.unmodifiableList(this.otherStatements);
    }

    private static boolean allFieldsAssignedIn(PsiCodeBlock block, List<PsiField> instanceFields) {
        for (PsiField instanceField : instanceFields) {
            if (ControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)instanceField, (PsiElement)block)) continue;
            return false;
        }
        return true;
    }

    private static boolean expressionIsAssignmentToInstanceField(PsiExpression expr) {
        PsiField psiField;
        if (!(expr instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignExpr = (PsiAssignmentExpression)expr;
        PsiExpression leftExpr = assignExpr.getLExpression();
        if (!(leftExpr instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpr = (PsiReferenceExpression)leftExpr;
        PsiElement resolved = referenceExpr.resolve();
        return resolved instanceof PsiField && !(psiField = (PsiField)resolved).hasModifierProperty("static");
    }

    private static boolean hasReferenceToContainingClass(final PsiClass containingClass, @Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        final Ref hasReferenceToClassUnderConstruction = new Ref((Object)false);
        expression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            void markInvalid() {
                hasReferenceToClassUnderConstruction.set((Object)true);
                this.stopWalking();
            }

            public void visitClass(PsiClass aClass) {
                PsiAnonymousClass anonymousClass;
                PsiExpressionList arguments;
                if (aClass instanceof PsiAnonymousClass && (arguments = (anonymousClass = (PsiAnonymousClass)aClass).getArgumentList()) != null) {
                    for (PsiExpression expression : arguments.getExpressions()) {
                        if (!ConstructorBodyProcessor.hasReferenceToContainingClass(containingClass, expression)) continue;
                        this.markInvalid();
                        return;
                    }
                }
            }

            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                this.markInvalid();
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiMethod method;
                PsiField field;
                super.visitReferenceExpression(expression);
                if (expression.getQualifier() != null) {
                    return;
                }
                PsiElement resolved = expression.resolve();
                if (resolved == null) {
                    this.markInvalid();
                    return;
                }
                if (resolved instanceof PsiField && !(field = (PsiField)resolved).hasModifierProperty("static") && field.getContainingClass() == containingClass) {
                    this.markInvalid();
                } else if (resolved instanceof PsiMethod && !(method = (PsiMethod)resolved).hasModifierProperty("static") && InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)method.getContainingClass(), (boolean)true)) {
                    this.markInvalid();
                }
            }
        });
        return (Boolean)hasReferenceToClassUnderConstruction.get();
    }
}

