/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.classCanBeRecord;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.classCanBeRecord.ConstructorBodyProcessor;
import com.intellij.codeInspection.classCanBeRecord.ConvertToRecordProcessor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.java.JavaBundle;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class ConvertToRecordFix
implements LocalQuickFix {
    private final boolean mySuggestAccessorsRenaming;
    @NotNull
    private final List<String> myIgnoredAnnotations;

    public ConvertToRecordFix(boolean suggestAccessorsRenaming, @NotNull List<String> ignoredAnnotations) {
        if (ignoredAnnotations == null) {
            ConvertToRecordFix.$$$reportNull$$$0(0);
        }
        this.mySuggestAccessorsRenaming = suggestAccessorsRenaming;
        this.myIgnoredAnnotations = ignoredAnnotations;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"class.can.be.record.quick.fix", (Object[])new Object[0]);
        if (string == null) {
            ConvertToRecordFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        ConvertToRecordProcessor processor;
        if (project == null) {
            ConvertToRecordFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            ConvertToRecordFix.$$$reportNull$$$0(3);
        }
        if ((processor = this.getRecordProcessor(descriptor)) == null) {
            return;
        }
        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
        processor.run();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        ConvertToRecordProcessor processor;
        if (project == null) {
            ConvertToRecordFix.$$$reportNull$$$0(4);
        }
        if (previewDescriptor == null) {
            ConvertToRecordFix.$$$reportNull$$$0(5);
        }
        if ((processor = this.getRecordProcessor(previewDescriptor)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ConvertToRecordFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }
        processor.performRefactoring(UsageInfo.EMPTY_ARRAY);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            ConvertToRecordFix.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    @Nullable
    private ConvertToRecordProcessor getRecordProcessor(ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)psiElement.getParent(), PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        RecordCandidate recordCandidate = ConvertToRecordFix.tryCreateRecordCandidate(psiClass, this.mySuggestAccessorsRenaming, this.myIgnoredAnnotations);
        if (recordCandidate == null) {
            return null;
        }
        return new ConvertToRecordProcessor(recordCandidate, this.mySuggestAccessorsRenaming);
    }

    @Nullable
    static RecordCandidate tryCreateRecordCandidate(@NotNull PsiClass psiClass, boolean suggestAccessorsRenaming, @NotNull List<String> ignoredAnnotations) {
        boolean hasInheritors;
        boolean isNotAppropriatePsiClass;
        if (psiClass == null) {
            ConvertToRecordFix.$$$reportNull$$$0(8);
        }
        if (ignoredAnnotations == null) {
            ConvertToRecordFix.$$$reportNull$$$0(9);
        }
        boolean bl = isNotAppropriatePsiClass = psiClass.isEnum() || psiClass.isAnnotationType() || psiClass instanceof PsiAnonymousClass || psiClass.isInterface() || psiClass.isRecord();
        if (isNotAppropriatePsiClass) {
            return null;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null || modifierList.hasModifierProperty("abstract") || modifierList.hasModifierProperty("sealed")) {
            return null;
        }
        if (PsiUtil.isLocalClass((PsiClass)psiClass) && ConvertToRecordFix.containsOuterNonStaticReferences(psiClass)) {
            return null;
        }
        if (psiClass.getContainingClass() != null && !psiClass.hasModifierProperty("static")) {
            return null;
        }
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass == null || !"java.lang.Object".equals(superClass.getQualifiedName())) {
            return null;
        }
        if (ContainerUtil.exists((Object[])psiClass.getInitializers(), initializer -> !initializer.hasModifierProperty("static"))) {
            return null;
        }
        if (AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)psiClass, ignoredAnnotations)) {
            return null;
        }
        RecordCandidate result = new RecordCandidate(psiClass, suggestAccessorsRenaming);
        if (!result.isValid()) {
            return null;
        }
        boolean bl2 = hasInheritors = ClassInheritorsSearch.search((PsiClass)psiClass, (boolean)false).findFirst() != null;
        if (hasInheritors) {
            return null;
        }
        return result;
    }

    private static boolean containsOuterNonStaticReferences(PsiClass psiClass) {
        InnerClassReferenceVisitor visitor = new InnerClassReferenceVisitor(psiClass);
        psiClass.accept((PsiElementVisitor)visitor);
        return !visitor.canInnerClassBeStatic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredAnnotations";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateRecordCandidate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7 -> new IllegalStateException(string);
        };
    }

    static class RecordCandidate {
        private static final CallMatcher OBJECT_METHOD_CALLS = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.exactInstanceCall((String)"java.lang.Object", (String[])new String[]{"equals"}).parameterCount(1), CallMatcher.exactInstanceCall((String)"java.lang.Object", (String[])new String[]{"hashCode", "toString"}).parameterCount(0)});
        private final boolean mySuggestAccessorsRenaming;
        @NotNull
        private final PsiClass myClass;
        private final MultiMap<PsiField, FieldAccessorCandidate> myFieldsToAccessorCandidates;
        private final Map<PsiMethod, @Nullable RecordConstructorCandidate> myMethodsToConstructorCandidates;
        private final List<PsiMethod> myOrdinaryMethods;
        @Nullable
        private PsiMethod myEqualsMethod;
        @Nullable
        private PsiMethod myHashCodeMethod;
        private Map<PsiField, FieldAccessorCandidate> myFieldAccessorsCache;

        private RecordCandidate(@NotNull PsiClass psiClass, boolean suggestAccessorsRenaming) {
            if (psiClass == null) {
                RecordCandidate.$$$reportNull$$$0(0);
            }
            this.myFieldsToAccessorCandidates = new MultiMap(new LinkedHashMap());
            this.myMethodsToConstructorCandidates = new HashMap<PsiMethod, RecordConstructorCandidate>();
            this.myOrdinaryMethods = new SmartList();
            this.myClass = psiClass;
            this.mySuggestAccessorsRenaming = suggestAccessorsRenaming;
            this.prepare();
        }

        @NotNull
        Project getProject() {
            Project project = this.myClass.getProject();
            if (project == null) {
                RecordCandidate.$$$reportNull$$$0(1);
            }
            return project;
        }

        @NotNull
        PsiClass getPsiClass() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                RecordCandidate.$$$reportNull$$$0(2);
            }
            return psiClass;
        }

        @UnmodifiableView @NotNull Map<PsiField, @Nullable FieldAccessorCandidate> getFieldsToAccessorCandidates() {
            if (this.myFieldAccessorsCache != null) {
                Map<PsiField, FieldAccessorCandidate> map = this.myFieldAccessorsCache;
                if (map == null) {
                    RecordCandidate.$$$reportNull$$$0(3);
                }
                return map;
            }
            LinkedHashMap<PsiField, FieldAccessorCandidate> result = new LinkedHashMap<PsiField, FieldAccessorCandidate>();
            for (Map.Entry entry : this.myFieldsToAccessorCandidates.entrySet()) {
                PsiField newKey = (PsiField)entry.getKey();
                Collection oldValue = (Collection)entry.getValue();
                FieldAccessorCandidate newValue = (FieldAccessorCandidate)ContainerUtil.getOnlyItem((Collection)oldValue);
                result.put(newKey, newValue);
            }
            this.myFieldAccessorsCache = Collections.unmodifiableMap(result);
            LinkedHashMap<PsiField, FieldAccessorCandidate> linkedHashMap = result;
            if (linkedHashMap == null) {
                RecordCandidate.$$$reportNull$$$0(4);
            }
            return linkedHashMap;
        }

        @Nullable
        RecordConstructorCandidate getCanonicalConstructorCandidate() {
            RecordConstructorCandidate result = null;
            for (RecordConstructorCandidate candidate : this.myMethodsToConstructorCandidates.values()) {
                if (candidate == null || candidate.kind() != RecordConstructorCandidate.Kind.CANONICAL) continue;
                if (result != null) {
                    String constructor1 = HighlightMessageUtil.getSymbolName((PsiElement)candidate.constructor());
                    String constructor2 = HighlightMessageUtil.getSymbolName((PsiElement)result.constructor());
                    throw new IllegalStateException("there can be only 1 canonical constructor candidate (found " + constructor1 + " and " + constructor2 + ")");
                }
                result = candidate;
            }
            return result;
        }

        @NotNull
        Map<PsiMethod, RecordConstructorCandidate> getMethodsToConstructorCandidates() {
            Map<PsiMethod, RecordConstructorCandidate> map = this.myMethodsToConstructorCandidates;
            if (map == null) {
                RecordCandidate.$$$reportNull$$$0(5);
            }
            return map;
        }

        @Nullable
        PsiMethod getEqualsMethod() {
            return this.myEqualsMethod;
        }

        @Nullable
        PsiMethod getHashCodeMethod() {
            return this.myHashCodeMethod;
        }

        private boolean isValid() {
            int possibleCanonicalConstructorCount = 0;
            for (RecordConstructorCandidate constructorCandidate : this.myMethodsToConstructorCandidates.values()) {
                if (constructorCandidate == null) {
                    return false;
                }
                if (!RecordCandidate.throwsOnlyUncheckedExceptions(constructorCandidate.constructor())) {
                    return false;
                }
                if (RecordCandidate.containsObjectMethodCalls(constructorCandidate.constructor())) {
                    return false;
                }
                if (constructorCandidate.kind != RecordConstructorCandidate.Kind.CANONICAL) continue;
                for (PsiParameter parameter : constructorCandidate.constructor().getParameterList().getParameters()) {
                    boolean fieldWithMatchingNameExists;
                    PsiField field2;
                    if (!constructorCandidate.paramsToFields().containsKey(parameter) || (field2 = constructorCandidate.paramsToFields.get(parameter)) != null) continue;
                    boolean bl = fieldWithMatchingNameExists = this.myClass.findFieldByName(parameter.getName(), false) != null;
                    if (fieldWithMatchingNameExists) continue;
                    return false;
                }
                ++possibleCanonicalConstructorCount;
            }
            if (!this.myMethodsToConstructorCandidates.isEmpty() && possibleCanonicalConstructorCount != 1) {
                return false;
            }
            if (this.myFieldsToAccessorCandidates.size() == 0) {
                return false;
            }
            for (Map.Entry entry : this.myFieldsToAccessorCandidates.entrySet()) {
                PsiField field3 = (PsiField)entry.getKey();
                if (!field3.hasModifierProperty("final")) {
                    return false;
                }
                if (field3.hasInitializer()) {
                    return false;
                }
                if (JavaPsiRecordUtil.ILLEGAL_RECORD_COMPONENT_NAMES.contains(field3.getName())) {
                    return false;
                }
                if (((Collection)entry.getValue()).size() > 1) {
                    return false;
                }
                FieldAccessorCandidate firstAccessor = (FieldAccessorCandidate)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue()));
                if (firstAccessor == null || !RecordCandidate.containsObjectMethodCalls(firstAccessor.method())) continue;
                return false;
            }
            for (PsiMethod ordinaryMethod : this.myOrdinaryMethods) {
                boolean conflictsWithPotentialAccessor;
                if (ordinaryMethod.hasModifierProperty("native")) {
                    return false;
                }
                boolean bl = conflictsWithPotentialAccessor = ordinaryMethod.getParameterList().isEmpty() && ContainerUtil.exists((Iterable)this.myFieldsToAccessorCandidates.keySet(), field -> field.getName().equals(ordinaryMethod.getName()));
                if (conflictsWithPotentialAccessor) {
                    return false;
                }
                if (!RecordCandidate.containsObjectMethodCalls(ordinaryMethod)) continue;
                return false;
            }
            return true;
        }

        private void prepare() {
            for (PsiField psiField : this.myClass.getFields()) {
                if (psiField.hasModifierProperty("static")) continue;
                this.myFieldsToAccessorCandidates.put((Object)psiField, new ArrayList());
            }
            for (PsiField psiField : this.myClass.getMethods()) {
                if (psiField.isConstructor()) {
                    ArrayList<PsiField> orderedInstanceFields = new ArrayList<PsiField>(this.myFieldsToAccessorCandidates.keySet());
                    RecordConstructorCandidate recordConstructorCandidate = RecordCandidate.tryCreateRecordConstructorCandidate((PsiMethod)psiField, orderedInstanceFields);
                    this.myMethodsToConstructorCandidates.put((PsiMethod)psiField, recordConstructorCandidate);
                    continue;
                }
                if (MethodUtils.isEquals((PsiMethod)psiField)) {
                    this.myEqualsMethod = psiField;
                    continue;
                }
                if (MethodUtils.isHashCode((PsiMethod)psiField)) {
                    this.myHashCodeMethod = psiField;
                    continue;
                }
                if (!RecordCandidate.throwsOnlyUncheckedExceptions((PsiMethod)psiField)) {
                    this.myOrdinaryMethods.add((PsiMethod)psiField);
                    continue;
                }
                FieldAccessorCandidate fieldAccessorCandidate = this.tryCreateFieldAccessorCandidate((PsiMethod)psiField);
                if (fieldAccessorCandidate == null) {
                    this.myOrdinaryMethods.add((PsiMethod)psiField);
                    continue;
                }
                this.myFieldsToAccessorCandidates.putValue((Object)fieldAccessorCandidate.backingField, (Object)fieldAccessorCandidate);
            }
        }

        private static boolean throwsOnlyUncheckedExceptions(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                RecordCandidate.$$$reportNull$$$0(6);
            }
            for (PsiClassType throwsType : psiMethod.getThrowsList().getReferencedTypes()) {
                if (throwsType == null || ExceptionUtil.isUncheckedException((PsiClassType)throwsType)) continue;
                return false;
            }
            return true;
        }

        private static boolean containsObjectMethodCalls(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                RecordCandidate.$$$reportNull$$$0(7);
            }
            var visitor = new JavaRecursiveElementWalkingVisitor(){
                boolean existsSuperMethodCalls;

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethodCallExpression(expression);
                    if (1.hasSuperQualifier(expression.getMethodExpression()) && OBJECT_METHOD_CALLS.test(expression)) {
                        this.existsSuperMethodCalls = true;
                        this.stopWalking();
                    }
                }

                public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitMethodReferenceExpression(expression);
                    if (1.hasSuperQualifier((PsiReferenceExpression)expression) && OBJECT_METHOD_CALLS.methodReferenceMatches(expression)) {
                        this.existsSuperMethodCalls = true;
                        this.stopWalking();
                    }
                }

                private static boolean hasSuperQualifier(@NotNull PsiReferenceExpression expression) {
                    PsiElement qualifier;
                    if (expression == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return (qualifier = expression.getQualifier()) != null && "super".equals(qualifier.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "expression";
                    objectArray2[1] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordFix$RecordCandidate$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethodCallExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethodReferenceExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "hasSuperQualifier";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            psiMethod.accept((PsiElementVisitor)visitor);
            return visitor.existsSuperMethodCalls;
        }

        @Nullable
        private FieldAccessorCandidate tryCreateFieldAccessorCandidate(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                RecordCandidate.$$$reportNull$$$0(8);
            }
            if (psiMethod.hasModifier(JvmModifier.STATIC)) {
                return null;
            }
            if (!psiMethod.getParameterList().isEmpty()) {
                return null;
            }
            String methodName = psiMethod.getName();
            PsiField backingField = null;
            boolean recordStyleNaming = false;
            for (PsiField field : this.myFieldsToAccessorCandidates.keySet()) {
                if (!field.getType().equals(psiMethod.getReturnType())) continue;
                String fieldName = field.getName();
                if (fieldName.equals(methodName)) {
                    backingField = field;
                    recordStyleNaming = true;
                    break;
                }
                if (!this.mySuggestAccessorsRenaming || !fieldName.equals(PropertyUtilBase.getPropertyNameByGetter((PsiMethod)psiMethod)) || ContainerUtil.exists((Object[])psiMethod.findDeepestSuperMethods(), superMethod -> superMethod instanceof PsiCompiledElement || superMethod instanceof SyntheticElement)) continue;
                backingField = field;
                break;
            }
            return backingField == null ? null : new FieldAccessorCandidate(psiMethod, backingField, recordStyleNaming);
        }

        @Nullable
        private static RecordConstructorCandidate tryCreateRecordConstructorCandidate(@NotNull PsiMethod constructorMethod, List<PsiField> instanceFields) {
            if (constructorMethod == null) {
                RecordCandidate.$$$reportNull$$$0(9);
            }
            if (constructorMethod.getTypeParameters().length > 0) {
                return null;
            }
            PsiCodeBlock ctorBody = constructorMethod.getBody();
            if (ctorBody == null) {
                return null;
            }
            ConstructorBodyProcessor bodyProcessor = new ConstructorBodyProcessor(constructorMethod, instanceFields);
            boolean canonical = bodyProcessor.isCanonical();
            boolean invalid = bodyProcessor.isTooComplex() || bodyProcessor.hasUnresolvedRefs() || !canonical && bodyProcessor.hasAnyStatementBeforeAllFieldsAreAssigned();
            boolean delegating = bodyProcessor.isDelegating();
            if (invalid) {
                return null;
            }
            RecordConstructorCandidate.Kind type = canonical ? RecordConstructorCandidate.Kind.CANONICAL : (delegating ? RecordConstructorCandidate.Kind.DELEGATING : RecordConstructorCandidate.Kind.CUSTOM);
            HashSet<PsiStatement> otherStatements = new HashSet<PsiStatement>(bodyProcessor.getOtherStatements());
            return new RecordConstructorCandidate(type, constructorMethod, bodyProcessor.getParamsToFields(), bodyProcessor.getFieldNamesToInitializers(), otherStatements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordFix$RecordCandidate";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructorMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordFix$RecordCandidate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiClass";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldsToAccessorCandidates";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodsToConstructorCandidates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "throwsOnlyUncheckedExceptions";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "containsObjectMethodCalls";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "tryCreateFieldAccessorCandidate";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "tryCreateRecordConstructorCandidate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    @NotNullByDefault
    record FieldAccessorCandidate(PsiMethod method, PsiField backingField, boolean isDefault, boolean usesRecordStyleNaming) {
        private FieldAccessorCandidate(PsiMethod accessor, PsiField backingField, boolean recordStyleNaming) {
            this(accessor, backingField, FieldAccessorCandidate.calculateDefault(accessor, backingField), recordStyleNaming);
        }

        private static boolean calculateDefault(PsiMethod accessor, PsiField backingField) {
            if (accessor.getDocComment() != null) {
                return false;
            }
            PsiExpression returnExpr = PropertyUtilBase.getSingleReturnValue((PsiMethod)accessor);
            boolean isDefaultAccessor = backingField.equals((Object)PropertyUtil.getFieldOfGetter((PsiMethod)accessor, () -> returnExpr, (boolean)false));
            if (!isDefaultAccessor) {
                return false;
            }
            isDefaultAccessor = !FieldAccessorCandidate.hasAnnotationConflict((PsiModifierListOwner)accessor, (PsiModifierListOwner)backingField, PsiAnnotation.TargetType.FIELD) && !FieldAccessorCandidate.hasAnnotationConflict((PsiModifierListOwner)backingField, (PsiModifierListOwner)accessor, PsiAnnotation.TargetType.METHOD);
            return isDefaultAccessor;
        }

        private static boolean hasAnnotationConflict(PsiModifierListOwner first, PsiModifierListOwner second, PsiAnnotation.TargetType targetType) {
            boolean result = false;
            for (PsiAnnotation firstAnn : first.getAnnotations()) {
                boolean hasDesiredTarget;
                PsiAnnotation.TargetType firstAnnTarget = AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)firstAnn, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{targetType});
                boolean bl = hasDesiredTarget = firstAnnTarget != null && firstAnnTarget != PsiAnnotation.TargetType.UNKNOWN;
                if (!hasDesiredTarget || ContainerUtil.exists((Object[])second.getAnnotations(), secondAnn -> AnnotationUtil.equal((PsiAnnotation)firstAnn, (PsiAnnotation)secondAnn))) continue;
                result = true;
                break;
            }
            return result;
        }
    }

    @NotNullByDefault
    record RecordConstructorCandidate(Kind kind, PsiMethod constructor, Map<PsiParameter, @Nullable PsiField> paramsToFields, LinkedHashMap<String, PsiExpression> fieldNamesToInitializers, Set<PsiStatement> otherStatements) {
        private final Map<PsiParameter, @Nullable PsiField> paramsToFields;
        private final Set<PsiStatement> otherStatements;

        public @UnmodifiableView Map<PsiParameter, @Nullable PsiField> paramsToFields() {
            return Collections.unmodifiableMap(this.paramsToFields);
        }

        public @UnmodifiableView Set<PsiStatement> otherStatements() {
            return Collections.unmodifiableSet(this.otherStatements);
        }

        static enum Kind {
            CANONICAL,
            DELEGATING,
            CUSTOM;

        }
    }
}

