/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.classCanBeRecord;

import com.intellij.codeInspection.RedundantRecordConstructorInspection;
import com.intellij.codeInspection.classCanBeRecord.BrokenEncapsulationUsageInfo;
import com.intellij.codeInspection.classCanBeRecord.ConvertToRecordFix;
import com.intellij.codeInspection.classCanBeRecord.ConvertToRecordUsageInfo;
import com.intellij.codeInspection.classCanBeRecord.EqualsChecker;
import com.intellij.codeInspection.classCanBeRecord.FieldUsageInfo;
import com.intellij.codeInspection.classCanBeRecord.RecordBuilder;
import com.intellij.codeInspection.classCanBeRecord.RenameMethodUsageInfo;
import com.intellij.java.JavaBundle;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class ConvertToRecordProcessor
extends BaseRefactoringProcessor {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.instanceCall((String)"java.lang.Object", (String[])new String[]{"equals"}).parameterTypes(new String[]{"java.lang.Object"});
    private static final CallMatcher OBJECT_HASHCODE = CallMatcher.instanceCall((String)"java.lang.Object", (String[])new String[]{"hashCode"}).parameterCount(0);
    private final ConvertToRecordFix.RecordCandidate myRecordCandidate;
    private final boolean mySuggestAccessorsRenaming;
    private final Map<PsiElement, String> myAllRenames;

    ConvertToRecordProcessor(@NotNull ConvertToRecordFix.RecordCandidate recordCandidate, boolean suggestAccessorsRenaming) {
        if (recordCandidate == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(0);
        }
        super(recordCandidate.getProject());
        this.myAllRenames = new LinkedHashMap<PsiElement, String>();
        this.myRecordCandidate = recordCandidate;
        this.mySuggestAccessorsRenaming = suggestAccessorsRenaming;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(1);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{ConvertToRecordProcessor.this.myRecordCandidate.getPsiClass()};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return JavaBundle.message((String)"class.can.be.record.quick.fix", (Object[])new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordProcessor$1", "getElements"));
            }
        };
    }

    protected void doRun() {
        this.prepareRenameOfAccessors();
        super.doRun();
    }

    private void prepareRenameOfAccessors() {
        List<ConvertToRecordFix.FieldAccessorCandidate> accessorsToRename = this.getAccessorsToRename();
        for (ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate : accessorsToRename) {
            String backingFieldName = fieldAccessorCandidate.backingField().getName();
            List<PsiMethod> methods = ConvertToRecordProcessor.substituteWithSuperMethodsIfPossible(fieldAccessorCandidate.method());
            RenamePsiElementProcessor methodRenameProcessor = RenamePsiElementProcessor.forElement((PsiElement)((PsiElement)methods.getFirst()));
            methods.forEach(method -> {
                this.myAllRenames.put((PsiElement)method, backingFieldName);
                methodRenameProcessor.prepareRenaming((PsiElement)method, backingFieldName, this.myAllRenames);
            });
        }
    }

    protected UsageInfo @NotNull [] findUsages() {
        String backingFieldName;
        SmartList usages = new SmartList();
        for (PsiField psiField : this.myRecordCandidate.getFieldsToAccessorCandidates().keySet()) {
            if (psiField.hasModifierProperty("private")) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiField).findAll()) {
                usages.add(new FieldUsageInfo(psiField, reference));
            }
        }
        List<ConvertToRecordFix.FieldAccessorCandidate> accessorsToRename = this.getAccessorsToRename();
        for (ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate : accessorsToRename) {
            backingFieldName = fieldAccessorCandidate.backingField().getName();
            List<PsiMethod> methods = ConvertToRecordProcessor.substituteWithSuperMethodsIfPossible(fieldAccessorCandidate.method());
            methods.forEach(arg_0 -> this.lambda$findUsages$1(backingFieldName, (List)usages, arg_0));
        }
        for (ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate : accessorsToRename) {
            backingFieldName = fieldAccessorCandidate.backingField().getName();
            usages.add(new RenameMethodUsageInfo(fieldAccessorCandidate.method(), backingFieldName));
        }
        usages.addAll(ConvertToRecordProcessor.findConflicts(this.myRecordCandidate));
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @NotNull
    private @NotNull @Unmodifiable List<@NotNull ConvertToRecordFix.FieldAccessorCandidate> getAccessorsToRename() {
        List list;
        List list2 = list = ContainerUtil.filter(this.myRecordCandidate.getFieldsToAccessorCandidates().values(), fieldAccessorCandidate -> fieldAccessorCandidate != null && !fieldAccessorCandidate.usesRecordStyleNaming());
        if (list2 == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private static @NotNull @Unmodifiable List<@NotNull PsiMethod> substituteWithSuperMethodsIfPossible(@NotNull PsiMethod accessor) {
        PsiMethod[] superMethods;
        if (accessor == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(4);
        }
        if ((superMethods = accessor.findSuperMethods()).length == 0) {
            List<PsiMethod> list = List.of(accessor);
            if (list == null) {
                ConvertToRecordProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<PsiMethod> list = List.of(superMethods);
        if (list == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    static List<UsageInfo> findConflicts(@NotNull ConvertToRecordFix.RecordCandidate recordCandidate) {
        if (recordCandidate == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(7);
        }
        SmartList result = new SmartList();
        for (Map.Entry<PsiField, ConvertToRecordFix.FieldAccessorCandidate> entry : recordCandidate.getFieldsToAccessorCandidates().entrySet()) {
            PsiField psiField = entry.getKey();
            ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate = entry.getValue();
            if (fieldAccessorCandidate == null) {
                if (!ConvertToRecordProcessor.firstHasWeakerAccess((PsiModifierListOwner)recordCandidate.getPsiClass(), (PsiModifierListOwner)psiField)) continue;
                result.add(new BrokenEncapsulationUsageInfo(psiField, JavaRefactoringBundle.message((String)"convert.to.record.accessor.more.accessible", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)psiField, (boolean)false)), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)psiField), VisibilityUtil.toPresentableText((String)"public")})));
                continue;
            }
            PsiMethod accessor = fieldAccessorCandidate.method();
            if (!ConvertToRecordProcessor.firstHasWeakerAccess((PsiModifierListOwner)recordCandidate.getPsiClass(), (PsiModifierListOwner)accessor)) continue;
            result.add(new BrokenEncapsulationUsageInfo(accessor, JavaRefactoringBundle.message((String)"convert.to.record.accessor.more.accessible", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)accessor, (boolean)false)), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)accessor), VisibilityUtil.toPresentableText((String)"public")})));
        }
        ConvertToRecordFix.RecordConstructorCandidate canonicalCtorCandidate = recordCandidate.getCanonicalConstructorCandidate();
        if (canonicalCtorCandidate != null) {
            PsiMethod canonicalCtor = canonicalCtorCandidate.constructor();
            if (ConvertToRecordProcessor.firstHasWeakerAccess((PsiModifierListOwner)recordCandidate.getPsiClass(), (PsiModifierListOwner)canonicalCtor)) {
                result.add(new BrokenEncapsulationUsageInfo(canonicalCtor, JavaRefactoringBundle.message((String)"convert.to.record.ctor.more.accessible", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)canonicalCtor, (boolean)false)), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)canonicalCtor), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)recordCandidate.getPsiClass())})));
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(9);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        @NlsContexts.DialogMessage MultiMap conflicts = new MultiMap();
        RenameUtil.addConflictDescriptions((UsageInfo[])usages, (MultiMap)conflicts);
        for (UsageInfo usage : usages) {
            if (usage instanceof BrokenEncapsulationUsageInfo) {
                BrokenEncapsulationUsageInfo brokenEncapsulationUsageInfo = (BrokenEncapsulationUsageInfo)usage;
                conflicts.putValue((Object)usage.getElement(), (Object)brokenEncapsulationUsageInfo.errorMessage);
                continue;
            }
            if (usage instanceof FieldUsageInfo) {
                PsiReferenceExpression refExpr;
                boolean canBeFixed;
                FieldUsageInfo fieldUsageInfo = (FieldUsageInfo)usage;
                PsiElement element = fieldUsageInfo.getElement();
                if (element == null || this.isAccessible(element, fieldUsageInfo.field)) continue;
                boolean bl = canBeFixed = element instanceof PsiReferenceExpression && !PsiUtil.isAccessedForWriting((PsiExpression)(refExpr = (PsiReferenceExpression)element));
                if (canBeFixed) continue;
                PsiElement container = ConflictsUtil.getContainer((PsiElement)element);
                String message = JavaRefactoringBundle.message((String)"0.will.become.inaccessible.from.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)fieldUsageInfo.field, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)});
                conflicts.putValue((Object)element, (Object)message);
                continue;
            }
            if (!(usage instanceof RenameMethodUsageInfo)) continue;
            RenameMethodUsageInfo renameMethodInfo = (RenameMethodUsageInfo)usage;
            RenamePsiElementProcessor renameMethodProcessor = RenamePsiElementProcessor.forElement((PsiElement)renameMethodInfo.method);
            renameMethodProcessor.findExistingNameConflicts((PsiElement)renameMethodInfo.method, renameMethodInfo.newName, conflicts, this.myAllRenames);
        }
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            return true;
        }
        return this.showConflicts(conflicts, usages);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(10);
        }
        this.renameMembers(usages);
        this.renameConstructorParameters();
        PsiClass psiClass = this.myRecordCandidate.getPsiClass();
        ConvertToRecordFix.RecordConstructorCandidate canonicalCtorCandidate = this.myRecordCandidate.getCanonicalConstructorCandidate();
        Map<PsiMethod, ConvertToRecordFix.RecordConstructorCandidate> methodsToConstructorCandidates = this.myRecordCandidate.getMethodsToConstructorCandidates();
        Map<PsiField, ConvertToRecordFix.FieldAccessorCandidate> fieldToAccessorCandidateMap = this.myRecordCandidate.getFieldsToAccessorCandidates();
        RecordBuilder recordBuilder = new RecordBuilder(psiClass);
        PsiIdentifier classIdentifier = null;
        PsiElement nextElement = psiClass.getFirstChild();
        while (nextElement != null) {
            PsiKeyword keyword;
            if (nextElement instanceof PsiKeyword && JavaTokenType.CLASS_KEYWORD.equals((keyword = (PsiKeyword)nextElement).getTokenType())) {
                recordBuilder.addRecordDeclaration();
            } else if (nextElement instanceof PsiIdentifier) {
                PsiIdentifier psiIdentifier;
                classIdentifier = psiIdentifier = (PsiIdentifier)nextElement;
                recordBuilder.addPsiElement((PsiElement)psiIdentifier);
            } else if (nextElement instanceof PsiTypeParameterList) {
                recordBuilder.addPsiElement(nextElement);
                if (PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)nextElement) == classIdentifier) {
                    recordBuilder.addRecordHeader(canonicalCtorCandidate, fieldToAccessorCandidateMap);
                    classIdentifier = null;
                }
            } else if (nextElement instanceof PsiModifierList) {
                PsiModifierList modifierList = (PsiModifierList)nextElement;
                recordBuilder.addModifierList(modifierList);
            } else if (nextElement instanceof PsiField) {
                PsiField psiField = (PsiField)nextElement;
                psiField.normalizeDeclaration();
                if (fieldToAccessorCandidateMap.containsKey(psiField)) {
                    nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextElement);
                    continue;
                }
                recordBuilder.addPsiElement(nextElement);
            } else if (nextElement instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)nextElement;
                if (methodsToConstructorCandidates.containsKey(psiMethod)) {
                    ConvertToRecordFix.RecordConstructorCandidate constructorCandidate = methodsToConstructorCandidates.get(psiMethod);
                    switch (constructorCandidate.kind()) {
                        case CANONICAL: {
                            recordBuilder.addCanonicalCtor(psiMethod);
                            break;
                        }
                        case DELEGATING: {
                            recordBuilder.addCtor(psiMethod);
                            break;
                        }
                        case CUSTOM: {
                            if (canonicalCtorCandidate == null) break;
                            recordBuilder.addDelegatingCtor(canonicalCtorCandidate.constructor(), psiMethod, constructorCandidate.fieldNamesToInitializers(), constructorCandidate.otherStatements());
                        }
                    }
                } else {
                    ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate = ConvertToRecordProcessor.getFieldAccessorCandidate(fieldToAccessorCandidateMap, psiMethod);
                    if (fieldAccessorCandidate == null) {
                        recordBuilder.addPsiElement((PsiElement)psiMethod);
                    } else {
                        recordBuilder.addFieldAccessor(fieldAccessorCandidate);
                    }
                }
            } else {
                recordBuilder.addPsiElement(nextElement);
            }
            nextElement = nextElement.getNextSibling();
        }
        Set<PsiMethod> syntheticGetters = Arrays.stream(psiClass.getMethods()).filter(method -> method instanceof SyntheticElement).filter(method -> ContainerUtil.exists(fieldToAccessorCandidateMap.keySet(), field -> field.getName().equals(PropertyUtilBase.getPropertyNameByGetter((PsiMethod)method)))).collect(Collectors.toSet());
        this.useAccessorsWhenNecessary(usages);
        CallMatcher redundantObjectMethods = ConvertToRecordProcessor.findRedundantObjectMethods(this.myRecordCandidate);
        PsiClass result = (PsiClass)psiClass.replace((PsiElement)recordBuilder.build());
        ConvertToRecordProcessor.tryToCompactCanonicalCtor(result);
        ConvertToRecordProcessor.removeRedundantObjectMethods(result, redundantObjectMethods);
        this.addImplicitSyntheticGetters(result, syntheticGetters.toArray(PsiMethod.EMPTY_ARRAY));
        ConvertToRecordProcessor.removeRedundantLombokAnnotations(result);
        ConvertToRecordProcessor.generateJavaDocForDocumentedFields(result, this.myRecordCandidate.getFieldsToAccessorCandidates().keySet());
        CodeStyleManager.getInstance((Project)this.myProject).reformat(JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)result));
    }

    private void addImplicitSyntheticGetters(@NotNull PsiClass record, @NotNull @NotNull PsiMethod @NotNull [] implicitGetters) {
        if (record == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(11);
        }
        if (implicitGetters == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(12);
        }
        if (!this.mySuggestAccessorsRenaming) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
            for (PsiMethod getter : implicitGetters) {
                record.add((PsiElement)elementFactory.createMethodFromText(getter.getText(), (PsiElement)record));
            }
        }
    }

    private void useAccessorsWhenNecessary(@NotNull @NotNull UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(13);
        }
        for (UsageInfo usage : usages) {
            PsiReferenceExpression refExpr;
            if (!(usage instanceof FieldUsageInfo)) continue;
            FieldUsageInfo fieldUsageInfo = (FieldUsageInfo)usage;
            PsiField field = fieldUsageInfo.field;
            PsiElement target = fieldUsageInfo.getElement();
            if (target instanceof PsiReferenceExpression && !PsiUtil.isAccessedForWriting((PsiExpression)(refExpr = (PsiReferenceExpression)target)) && !this.isAccessible(target, field)) {
                refExpr.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText(refExpr.getText() + "()", (PsiElement)refExpr));
            }
            if (!(target instanceof PsiDocTagValue)) continue;
            PsiDocTagValue docTagValue = (PsiDocTagValue)target;
            PsiDocTag docTag = JavaPsiFacade.getElementFactory((Project)this.myProject).createDocTagFromText("@see " + docTagValue.getText() + "()");
            docTagValue.replace((PsiElement)Objects.requireNonNull(docTag.getValueElement()));
        }
    }

    private boolean isAccessible(@NotNull PsiElement place, @NotNull PsiField psiField) {
        if (place == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(14);
        }
        if (psiField == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(15);
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)psiField, (PsiModifierList)new LightModifierList(psiField.getManager(), psiField.getLanguage(), new String[]{"private"}), place, null, null);
    }

    private void renameConstructorParameters() {
        ConvertToRecordFix.RecordConstructorCandidate ctorCandidate = this.myRecordCandidate.getCanonicalConstructorCandidate();
        if (ctorCandidate == null) {
            return;
        }
        LinkedHashMap ctorParamRenames = new LinkedHashMap();
        ArrayList usagesToRename = new ArrayList();
        ctorCandidate.paramsToFields().forEach((ctorParam, field) -> {
            if (field != null && !ctorParam.getName().equals(field.getName())) {
                UsageInfo[] usages = RenameUtil.findUsages((PsiElement)ctorParam, (String)field.getName(), (boolean)false, (boolean)false, (Map)ctorParamRenames);
                usagesToRename.addAll(Arrays.asList(usages));
                ctorParamRenames.put(ctorParam, field.getName());
            }
        });
        MultiMap renameUsagesByElement = RenameProcessor.classifyUsages(ctorParamRenames.keySet(), usagesToRename);
        for (Map.Entry entry : ctorParamRenames.entrySet()) {
            PsiElement element = (PsiElement)entry.getKey();
            String newName = (String)entry.getValue();
            UsageInfo[] elementRenameUsages = renameUsagesByElement.get((Object)((PsiElement)entry.getKey())).toArray(UsageInfo.EMPTY_ARRAY);
            RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement((PsiElement)element);
            renamePsiElementProcessor.renameElement(element, newName, elementRenameUsages, null);
        }
    }

    private void renameMembers(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(16);
        }
        List renameUsages = ContainerUtil.filter((Object[])usages, u -> !(u instanceof ConvertToRecordUsageInfo));
        MultiMap renameUsagesByElement = RenameProcessor.classifyUsages(this.myAllRenames.keySet(), (Collection)renameUsages);
        for (Map.Entry<PsiElement, String> entry : this.myAllRenames.entrySet()) {
            PsiElement element = entry.getKey();
            String newName = entry.getValue();
            UsageInfo[] elementRenameUsages = renameUsagesByElement.get((Object)entry.getKey()).toArray(UsageInfo.EMPTY_ARRAY);
            RenamePsiElementProcessor.forElement((PsiElement)element).renameElement(element, newName, elementRenameUsages, null);
        }
    }

    private static CallMatcher findRedundantObjectMethods(@NotNull ConvertToRecordFix.RecordCandidate recordCandidate) {
        if (recordCandidate == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(17);
        }
        PsiMethod equalsMethod = recordCandidate.getEqualsMethod();
        PsiMethod hashCodeMethod = recordCandidate.getHashCodeMethod();
        if (equalsMethod == null && hashCodeMethod == null) {
            return CallMatcher.none();
        }
        SmartList result = new SmartList();
        Set<PsiField> fields = recordCandidate.getFieldsToAccessorCandidates().keySet();
        if (EqualsChecker.isStandardEqualsMethod(equalsMethod, fields)) {
            result.add(OBJECT_EQUALS);
        }
        if (hashCodeMethod != null) {
            HashCodeVisitor hashCodeVisitor = new HashCodeVisitor(fields);
            hashCodeMethod.accept((PsiElementVisitor)hashCodeVisitor);
            if (hashCodeVisitor.myNonVisitedFields.isEmpty()) {
                result.add(OBJECT_HASHCODE);
            }
        }
        return CallMatcher.anyOf((CallMatcher[])result.toArray(new CallMatcher[0]));
    }

    private static void tryToCompactCanonicalCtor(@NotNull PsiClass record) {
        if (record == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(18);
        }
        if (!record.isRecord()) {
            throw new IllegalArgumentException("Not a record: " + String.valueOf(record));
        }
        PsiMethod canonicalCtor = (PsiMethod)ContainerUtil.find((Object[])record.getConstructors(), JavaPsiRecordUtil::isCanonicalConstructor);
        if (canonicalCtor != null) {
            RedundantRecordConstructorInspection.ConstructorSimplifier ctorSimplifier;
            PsiCodeBlock ctorBody = canonicalCtor.getBody();
            if (ctorBody != null) {
                ((StreamEx)StreamEx.of((Object[])ctorBody.getStatements()).select(PsiExpressionStatement.class).filter(st -> JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)st.getExpression()))).findFirst().ifPresent(PsiElement::delete);
            }
            if ((ctorSimplifier = RedundantRecordConstructorInspection.createCtorSimplifier(canonicalCtor)) != null) {
                ctorSimplifier.simplify(canonicalCtor);
            }
        }
    }

    private static void removeRedundantObjectMethods(@NotNull PsiClass record, @NotNull CallMatcher redundantObjectMethods) {
        if (record == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(19);
        }
        if (redundantObjectMethods == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(20);
        }
        ContainerUtil.filter((Object[])record.getMethods(), arg_0 -> ((CallMatcher)redundantObjectMethods).methodMatches(arg_0)).forEach(PsiElement::delete);
    }

    private static void removeRedundantLombokAnnotations(@NotNull PsiClass record) {
        if (record == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(21);
        }
        if (!record.isRecord()) {
            throw new IllegalArgumentException("Not a record: " + String.valueOf(record));
        }
        if (!JavaLibraryUtil.hasLibraryJar((Project)record.getProject(), (String)"org.projectlombok:lombok")) {
            return;
        }
        for (PsiAnnotation psiAnnotation : record.getAnnotations()) {
            String qualifiedName = psiAnnotation.getQualifiedName();
            if (qualifiedName == null || !Set.of("lombok.ToString", "lombok.Getter", "lombok.EqualsAndHashCode", "lombok.RequiredArgsConstructor", "lombok.Data", "lombok.Value").contains(qualifiedName)) continue;
            psiAnnotation.delete();
        }
        for (PsiAnnotation psiAnnotation : record.getFields()) {
            for (PsiAnnotation annotation : psiAnnotation.getAnnotations()) {
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.equals("lombok.Getter")) continue;
                annotation.delete();
            }
        }
    }

    private static void generateJavaDocForDocumentedFields(@NotNull PsiClass record, @NotNull @NotNull Set<@NotNull PsiField> fields) {
        if (record == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(22);
        }
        if (fields == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(23);
        }
        LinkedHashMap<String, String> comments = new LinkedHashMap<String, String>();
        for (PsiField field : fields) {
            StringBuilder fieldComment = new StringBuilder();
            for (PsiComment comment : (PsiComment[])ObjectUtils.notNull((Object)((PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)field, PsiComment.class)), (Object)new PsiComment[0])) {
                if (comment instanceof PsiDocComment) {
                    PsiDocComment docComment = (PsiDocComment)comment;
                    Arrays.stream(docComment.getDescriptionElements()).map(PsiElement::getText).forEach(fieldComment::append);
                    continue;
                }
                String commentText = comment.getText();
                String unwrappedText = comment.getTokenType() == JavaTokenType.END_OF_LINE_COMMENT ? StringUtil.trimStart((String)commentText, (String)"//") : StringUtil.trimEnd((String)commentText.substring(2), (String)"*/");
                fieldComment.append(unwrappedText);
            }
            if (fieldComment.isEmpty()) continue;
            comments.put(field.getName(), fieldComment.toString());
        }
        if (comments.isEmpty()) {
            return;
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)record.getProject()).getParserFacade();
        PsiDocComment recordDoc = record.getDocComment();
        if (recordDoc == null) {
            PsiDocComment emptyDoc = parserFacade.createDocCommentFromText("/** */");
            recordDoc = (PsiDocComment)record.addBefore((PsiElement)emptyDoc, record.getFirstChild());
        }
        for (Map.Entry entry : comments.entrySet()) {
            String paramName = (String)entry.getKey();
            String paramComment = (String)entry.getValue();
            PsiDocTag docTag = parserFacade.createDocTagFromText("@param " + paramName + " " + paramComment);
            recordDoc.add((PsiElement)docTag);
        }
    }

    @NlsContexts.Command
    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"convert.to.record.title", (Object[])new Object[0]);
        if (string == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static boolean firstHasWeakerAccess(@NotNull PsiModifierListOwner first, @NotNull PsiModifierListOwner second) {
        if (first == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(25);
        }
        if (second == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(26);
        }
        return VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)first.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)second.getModifierList())) < 0;
    }

    @Nullable
    private static ConvertToRecordFix.FieldAccessorCandidate getFieldAccessorCandidate(@NotNull Map<PsiField, @Nullable ConvertToRecordFix.FieldAccessorCandidate> fieldAccessors, @NotNull PsiMethod psiMethod) {
        if (fieldAccessors == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(27);
        }
        if (psiMethod == null) {
            ConvertToRecordProcessor.$$$reportNull$$$0(28);
        }
        return (ConvertToRecordFix.FieldAccessorCandidate)ContainerUtil.find(fieldAccessors.values(), value -> value != null && psiMethod.equals((Object)value.method()));
    }

    private /* synthetic */ void lambda$findUsages$1(String backingFieldName, List usages, PsiMethod method) {
        UsageInfo[] methodUsages = RenameUtil.findUsages((PsiElement)method, (String)backingFieldName, (boolean)false, (boolean)false, this.myAllRenames);
        usages.addAll(Arrays.asList(methodUsages));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 8, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordCandidate";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 11: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitGetters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "redundantObjectMethods";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldAccessors";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorsToRename";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteWithSuperMethodsIfPossible";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findConflicts";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithSuperMethodsIfPossible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitSyntheticGetters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "useAccessorsWhenNecessary";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameMembers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findRedundantObjectMethods";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryToCompactCanonicalCtor";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantObjectMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundantLombokAnnotations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateJavaDocForDocumentedFields";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "firstHasWeakerAccess";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAccessorCandidate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 8, 24 -> new IllegalStateException(string);
        };
    }

    private static class HashCodeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final CallMatcher OBJECTS_CALL;
        private final CallMatcher FLOAT_CALL;
        private final CallMatcher DOUBLE_CALL;
        private final CallMatcher INSTANCE_CALL;
        private final Set<PsiField> myNonVisitedFields;

        private HashCodeVisitor(@NotNull Set<PsiField> fields) {
            if (fields == null) {
                HashCodeVisitor.$$$reportNull$$$0(0);
            }
            this.OBJECTS_CALL = CallMatcher.staticCall((String)"java.util.Objects", (String[])new String[]{"hash", "hashCode"});
            this.FLOAT_CALL = CallMatcher.staticCall((String)"java.lang.Float", (String[])new String[]{"floatToIntBits"});
            this.DOUBLE_CALL = CallMatcher.staticCall((String)"java.lang.Double", (String[])new String[]{"doubleToLongBits"});
            this.INSTANCE_CALL = CallMatcher.instanceCall((String)"java.lang.Object", (String[])new String[]{"hashCode"});
            this.myNonVisitedFields = new SmartHashSet(fields);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiField field;
            if (expression == null) {
                HashCodeVisitor.$$$reportNull$$$0(1);
            }
            if ((field = (PsiField)ObjectUtils.tryCast((Object)expression.resolve(), PsiField.class)) == null) {
                return;
            }
            PsiType fieldType = field.getType();
            if (PsiTypes.charType().equals((Object)fieldType) || PsiTypes.shortType().equals((Object)fieldType)) {
                PsiTypeCastExpression castExpression;
                PsiTypeElement castType;
                PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiParenthesizedExpression.class});
                if (parent instanceof PsiTypeCastExpression && (castType = (castExpression = (PsiTypeCastExpression)parent).getCastType()) != null && PsiTypes.intType().equals((Object)castType.getType())) {
                    this.myNonVisitedFields.remove(field);
                }
            } else {
                this.myNonVisitedFields.remove(field);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiField field;
            PsiExpression qualifier;
            PsiReferenceExpression fieldRef;
            if (expression == null) {
                HashCodeVisitor.$$$reportNull$$$0(2);
            }
            if (this.OBJECTS_CALL.test(expression)) {
                for (PsiExpression argument : expression.getArgumentList().getExpressions()) {
                    PsiReferenceExpression fieldRef2 = (PsiReferenceExpression)ObjectUtils.tryCast((Object)argument, PsiReferenceExpression.class);
                    if (fieldRef2 != null && this.myNonVisitedFields.remove(fieldRef2.resolve())) continue;
                    this.stopWalking();
                    return;
                }
                return;
            }
            PsiPrimitiveType expectedType = null;
            if (this.FLOAT_CALL.test(expression)) {
                expectedType = PsiTypes.floatType();
            } else if (this.DOUBLE_CALL.test(expression)) {
                expectedType = PsiTypes.doubleType();
            }
            if (expectedType != null) {
                PsiField field2;
                PsiReferenceExpression refExpr;
                PsiExpression[] expressions = expression.getArgumentList().getExpressions();
                if (expressions.length == 1 && (refExpr = (PsiReferenceExpression)ObjectUtils.tryCast((Object)expressions[0], PsiReferenceExpression.class)) != null && (field2 = (PsiField)ObjectUtils.tryCast((Object)refExpr.resolve(), PsiField.class)) != null && expectedType.equals(field2.getType())) {
                    this.myNonVisitedFields.remove(field2);
                    return;
                }
                this.stopWalking();
                return;
            }
            if (this.INSTANCE_CALL.test(expression) && (fieldRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)(qualifier = expression.getMethodExpression().getQualifierExpression()), PsiReferenceExpression.class)) != null && (field = (PsiField)ObjectUtils.tryCast((Object)fieldRef.resolve(), PsiField.class)) != null) {
                this.myNonVisitedFields.remove(field);
                return;
            }
            this.stopWalking();
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                HashCodeVisitor.$$$reportNull$$$0(3);
            }
            super.visitPolyadicExpression(expression);
            IElementType operationType = expression.getOperationTokenType();
            if (!(JavaTokenType.PLUS.equals(operationType) || JavaTokenType.MINUS.equals(operationType) || JavaTokenType.ASTERISK.equals(operationType) || JavaTokenType.GTGTGT.equals(operationType) || JavaTokenType.EQEQ.equals(operationType) || JavaTokenType.NE.equals(operationType))) {
                this.stopWalking();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/classCanBeRecord/ConvertToRecordProcessor$HashCodeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

