/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.DefaultInferredAnnotationProvider;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.ModCommandAwareExternalAnnotationsManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.dataFlow.ContractInspection;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModEditOptions;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditContractIntention
implements ModCommandAction {
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.family.edit.method.contract", (Object[])new Object[0]);
        if (string == null) {
            EditContractIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static PsiMethod getTargetMethod(@NotNull ActionContext context) {
        PsiMethod method;
        PsiModifierListOwner owner;
        if (context == null) {
            EditContractIntention.$$$reportNull$$$0(1);
        }
        if ((owner = AddAnnotationPsiFix.getContainer((PsiFile)context.file(), (int)context.offset())) instanceof PsiMethod && ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable((PsiModifierListOwner)(method = (PsiMethod)owner))) {
            PsiMethod origMethod;
            PsiElement psiElement = owner.getOriginalElement();
            return psiElement instanceof PsiMethod ? (origMethod = (PsiMethod)psiElement) : method;
        }
        return null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull ActionContext context) {
        PsiMethod method;
        if (context == null) {
            EditContractIntention.$$$reportNull$$$0(2);
        }
        PsiAnnotation annotation = (method = EditContractIntention.getTargetMethod(context)) == null ? null : JavaMethodContractUtil.findContractAnnotation((PsiMethod)method);
        String text = "(\"...\")";
        if (annotation != null) {
            text = annotation.getParameterList().getText();
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, "@Contract()\nclass X{}", "@Contract" + text + "\nclass X{}");
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        PsiMethod method;
        if (context == null) {
            EditContractIntention.$$$reportNull$$$0(3);
        }
        if ((method = EditContractIntention.getTargetMethod(context)) != null) {
            boolean hasContract = JavaMethodContractUtil.findContractAnnotation((PsiMethod)method) != null;
            return Presentation.of((String)(hasContract ? JavaBundle.message((String)"intention.text.edit.method.contract.of.0", (Object[])new Object[]{method.getName()}) : JavaBundle.message((String)"intention.text.add.method.contract.to.0", (Object[])new Object[]{method.getName()}))).withPriority(PriorityAction.Priority.LOW);
        }
        return null;
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        PsiMethod method;
        if (context == null) {
            EditContractIntention.$$$reportNull$$$0(4);
        }
        if ((method = EditContractIntention.getTargetMethod(context)) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                EditContractIntention.$$$reportNull$$$0(5);
            }
            return modCommand;
        }
        PsiAnnotation existingAnno = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(Contract.class.getName()));
        return new ModEditOptions(JavaBundle.message((String)"dialog.title.edit.method.contract", (Object[])new Object[0]), () -> ContractData.fromAnnotation(method, existingAnno), false, data -> EditContractIntention.updateContract(method, data));
    }

    @NotNull
    private static ModCommand updateContract(@NotNull PsiMethod method, @NotNull ContractData data) {
        if (method == null) {
            EditContractIntention.$$$reportNull$$$0(6);
        }
        if (data == null) {
            EditContractIntention.$$$reportNull$$$0(7);
        }
        Project project = method.getProject();
        ModCommandAwareExternalAnnotationsManager manager = ModCommandAwareExternalAnnotationsManager.getInstance((Project)project);
        PsiAnnotation mockAnno = DefaultInferredAnnotationProvider.createContractAnnotation((Project)project, (!data.impure ? 1 : 0) != 0, (String)data.contract, (String)Objects.requireNonNullElse(data.mutates, ""));
        if (mockAnno != null) {
            ModCommand modCommand = manager.annotateExternallyModCommand((PsiModifierListOwner)method, JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT, mockAnno.getParameterList().getAttributes());
            if (modCommand == null) {
                EditContractIntention.$$$reportNull$$$0(8);
            }
            return modCommand;
        }
        ModCommand modCommand = manager.deannotateModCommand(List.of(method), List.of(JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
        if (modCommand == null) {
            EditContractIntention.$$$reportNull$$$0(9);
        }
        return modCommand;
    }

    @NlsContexts.DialogMessage
    @Nullable
    private static String getMutatesErrorMessage(String mutates, PsiMethod method) {
        return StringUtil.isEmpty((String)mutates) ? null : MutationSignature.checkSignature((String)mutates, (PsiMethod)method);
    }

    @NlsContexts.DialogMessage
    @Nullable
    private static String getContractErrorMessage(String contract, PsiMethod method) {
        if (StringUtil.isEmpty((String)contract)) {
            return null;
        }
        StandardMethodContract.ParseException error = ContractInspection.checkContract((PsiMethod)method, (String)contract);
        return error != null ? error.getMessage() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/EditContractIntention";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/EditContractIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "updateContract";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTargetMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateContract";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class ContractData
    implements OptionContainer {
        @NotNull
        private final PsiMethod method;
        @NlsSafe
        String contract;
        boolean impure;
        @NlsSafe
        String mutates;

        private ContractData(@NotNull PsiMethod method) {
            if (method == null) {
                ContractData.$$$reportNull$$$0(0);
            }
            this.contract = "";
            this.impure = true;
            this.mutates = "";
            this.method = method;
        }

        @NotNull
        private static ContractData fromAnnotation(@NotNull PsiMethod method, @Nullable PsiAnnotation existingAnno) {
            if (method == null) {
                ContractData.$$$reportNull$$$0(1);
            }
            ContractData data = new ContractData(method);
            if (existingAnno != null) {
                data.contract = AnnotationUtil.getStringAttributeValue((PsiAnnotation)existingAnno, (String)"value");
                data.impure = !Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)existingAnno, (String)"pure"));
                data.mutates = AnnotationUtil.getStringAttributeValue((PsiAnnotation)existingAnno, (String)"mutates");
            }
            ContractData contractData = data;
            if (contractData == null) {
                ContractData.$$$reportNull$$$0(2);
            }
            return contractData;
        }

        @NotNull
        public OptPane getOptionsPane() {
            OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"contract", (String)JavaBundle.message((String)"label.contract", (Object[])new Object[0]), (StringValidator)StringValidator.of((String)"java.method.contract", string -> EditContractIntention.getContractErrorMessage(string, this.method))).description(HtmlChunk.raw((String)JavaBundle.message((String)"edit.contract.dialog.hint", (Object[])new Object[0]))), OptPane.checkbox((String)"impure", (String)JavaBundle.message((String)"edit.contract.dialog.checkbox.impure.method", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"mutates", (String)JavaBundle.message((String)"label.mutates", (Object[])new Object[0]), (StringValidator)StringValidator.of((String)"java.method.mutates", string -> EditContractIntention.getMutatesErrorMessage(string, this.method))).description(HtmlChunk.raw((String)JavaBundle.message((String)"edit.contract.dialog.mutates.hint", (Object[])new Object[0])))})}).withHelpId("define_contract_dialog");
            if (optPane == null) {
                ContractData.$$$reportNull$$$0(3);
            }
            return optPane;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/EditContractIntention$ContractData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/EditContractIntention$ContractData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromAnnotation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionsPane";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromAnnotation";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

