/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.ModCommandAwareExternalAnnotationsManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModEditOptions;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiLiteralUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditRangeIntention
implements ModCommandAction {
    private static final String JETBRAINS_RANGE = "org.jetbrains.annotations.Range";

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.family.edit.range", (Object[])new Object[0]);
        if (string == null) {
            EditRangeIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static PsiModifierListOwner getTarget(@NotNull ActionContext context) {
        PsiModifierListOwner owner;
        LongRangeSet rangeFromType;
        if (context == null) {
            EditRangeIntention.$$$reportNull$$$0(1);
        }
        if ((rangeFromType = EditRangeIntention.rangeFromType(owner = AddAnnotationPsiFix.getContainer((PsiFile)context.file(), (int)context.offset()))) == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable((PsiModifierListOwner)owner)) {
            return null;
        }
        PsiElement original = owner.getOriginalElement();
        return original instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : owner;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull ActionContext context) {
        PsiModifierListOwner target;
        if (context == null) {
            EditRangeIntention.$$$reportNull$$$0(2);
        }
        if ((target = EditRangeIntention.getTarget(context)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                EditRangeIntention.$$$reportNull$$$0(3);
            }
            return intentionPreviewInfo;
        }
        Project project = context.project();
        PsiAnnotation mockAnno = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@org.jetbrains.annotations.Range(from=___, to=___)", null);
        ModCommandAwareExternalAnnotationsManager manager = ModCommandAwareExternalAnnotationsManager.getInstance((Project)project);
        ModCommand command = manager.annotateExternallyModCommand(target, JETBRAINS_RANGE, mockAnno.getParameterList().getAttributes());
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewUtils.getModCommandPreview((ModCommand)command, (ActionContext)context);
        if (intentionPreviewInfo == null) {
            EditRangeIntention.$$$reportNull$$$0(4);
        }
        return intentionPreviewInfo;
    }

    @Contract(value="null -> null")
    private static LongRangeSet rangeFromType(PsiModifierListOwner owner) {
        Object type;
        if (owner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            type = method.getReturnType();
        } else {
            type = owner instanceof PsiField || owner instanceof PsiParameter ? ((PsiVariable)owner).getType() : null;
        }
        return JvmPsiRangeSetUtil.typeRange((PsiType)type);
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        PsiModifierListOwner owner;
        if (context == null) {
            EditRangeIntention.$$$reportNull$$$0(5);
        }
        if ((owner = EditRangeIntention.getTarget(context)) != null) {
            boolean hasRange = !JvmPsiRangeSetUtil.fromPsiElement((PsiModifierListOwner)owner).equals(LongRangeSet.all());
            String name = EditRangeIntention.getElementName(owner);
            return Presentation.of((String)(hasRange ? JavaBundle.message((String)"intention.text.edit.range.of.0", (Object[])new Object[]{name}) : JavaBundle.message((String)"intention.text.add.range.to.0", (Object[])new Object[]{name}))).withPriority(PriorityAction.Priority.LOW);
        }
        return null;
    }

    @Nullable
    private static String getElementName(PsiModifierListOwner owner) {
        Object name = ((PsiNamedElement)owner).getName();
        if (owner instanceof PsiMethod) {
            name = (String)name + "()";
        }
        return name;
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        PsiModifierListOwner owner;
        if (context == null) {
            EditRangeIntention.$$$reportNull$$$0(6);
        }
        if ((owner = EditRangeIntention.getTarget(context)) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                EditRangeIntention.$$$reportNull$$$0(7);
            }
            return modCommand;
        }
        return new ModEditOptions(JavaBundle.message((String)"dialog.title.edit.range", (Object[])new Object[]{EditRangeIntention.getElementName(owner)}), () -> RangeData.from(owner), false, data -> EditRangeIntention.updateRange(owner, data.myType, data.min, data.max));
    }

    @NotNull
    private static ModCommand updateRange(PsiModifierListOwner owner, LongRangeSet fromType, String min, String max) {
        Project project = owner.getProject();
        ModCommandAwareExternalAnnotationsManager manager = ModCommandAwareExternalAnnotationsManager.getInstance((Project)project);
        min = min.trim();
        max = max.trim();
        Long minValue = EditRangeIntention.parseValue(min, fromType, true);
        Long maxValue = EditRangeIntention.parseValue(max, fromType, false);
        if (minValue == null || maxValue == null || minValue.longValue() == fromType.min() && maxValue.longValue() == fromType.max()) {
            ModCommand modCommand = manager.deannotateModCommand(List.of(owner), List.of(JETBRAINS_RANGE));
            if (modCommand == null) {
                EditRangeIntention.$$$reportNull$$$0(8);
            }
            return modCommand;
        }
        if (minValue == Long.MIN_VALUE) {
            min = "java.lang.Long.MIN_VALUE";
        }
        if (minValue == Integer.MIN_VALUE) {
            min = "java.lang.Integer.MIN_VALUE";
        }
        if (maxValue == Long.MAX_VALUE) {
            max = "java.lang.Long.MAX_VALUE";
        }
        if (maxValue == Integer.MAX_VALUE) {
            max = "java.lang.Integer.MAX_VALUE";
        }
        if (min.isEmpty()) {
            min = minValue.toString();
        }
        if (max.isEmpty()) {
            max = maxValue.toString();
        }
        PsiAnnotation mockAnno = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@org.jetbrains.annotations.Range(from=" + min + ", to=" + max + ")", null);
        ModCommand modCommand = manager.annotateExternallyModCommand(owner, JETBRAINS_RANGE, mockAnno.getParameterList().getAttributes());
        if (modCommand == null) {
            EditRangeIntention.$$$reportNull$$$0(9);
        }
        return modCommand;
    }

    private static @NotNull Couple<@Nls String> getErrorMessages(String minText, String maxText, LongRangeSet fromType) {
        Long minValue = EditRangeIntention.parseValue(minText, fromType, true);
        Long maxValue = EditRangeIntention.parseValue(maxText, fromType, false);
        String minError = null;
        String maxError = null;
        if (minValue == null) {
            minError = JavaBundle.message((String)"edit.range.error.invalid.value", (Object[])new Object[0]);
        } else if (minValue < fromType.min()) {
            minError = JavaBundle.message((String)"edit.range.value.should.be.less.than", (Object[])new Object[]{fromType.min()});
        }
        if (maxValue == null) {
            maxError = JavaBundle.message((String)"edit.range.error.invalid.value", (Object[])new Object[0]);
        } else if (maxValue > fromType.max()) {
            maxError = JavaBundle.message((String)"edit.range.value.should.be.bigger.than", (Object[])new Object[]{fromType.max()});
        } else if (minValue != null && maxValue < minValue) {
            minError = JavaBundle.message((String)"edit.range.should.not.be.greater.than.to", (Object[])new Object[0]);
            maxError = JavaBundle.message((String)"edit.range.should.not.be.less.than.from", (Object[])new Object[0]);
        }
        Couple couple = Couple.of((Object)minError, (Object)maxError);
        if (couple == null) {
            EditRangeIntention.$$$reportNull$$$0(10);
        }
        return couple;
    }

    @Nullable
    private static Long parseValue(String text, LongRangeSet fromType, boolean isMin) {
        if ((text = text.trim()).isEmpty()) {
            return isMin ? fromType.min() : fromType.max();
        }
        Long value = PsiLiteralUtil.parseLong((String)text);
        if (value != null) {
            return value;
        }
        Integer intValue = PsiLiteralUtil.parseInteger((String)text);
        return intValue != null ? Long.valueOf(intValue.longValue()) : value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/EditRangeIntention";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/EditRangeIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static class RangeData
    implements OptionContainer {
        private final LongRangeSet myType;
        String min;
        String max;

        RangeData(@NotNull LongRangeSet type, @NotNull String min, @NotNull String max) {
            if (type == null) {
                RangeData.$$$reportNull$$$0(0);
            }
            if (min == null) {
                RangeData.$$$reportNull$$$0(1);
            }
            if (max == null) {
                RangeData.$$$reportNull$$$0(2);
            }
            this.myType = type;
            this.min = min;
            this.max = max;
        }

        @NotNull
        static RangeData from(@NotNull PsiModifierListOwner owner) {
            if (owner == null) {
                RangeData.$$$reportNull$$$0(3);
            }
            LongRangeSet existingRange = JvmPsiRangeSetUtil.fromPsiElement((PsiModifierListOwner)owner);
            LongRangeSet fromType = EditRangeIntention.rangeFromType(owner);
            assert (fromType != null);
            return new RangeData(fromType, existingRange.min() > fromType.min() ? String.valueOf(existingRange.min()) : "", existingRange.max() < fromType.max() ? String.valueOf(existingRange.max()) : "");
        }

        @NotNull
        public OptPane getOptionsPane() {
            OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"min", (String)JavaBundle.message((String)"label.from.inclusive", (Object[])new Object[0]), (StringValidator)StringValidator.of((String)"java.range.min", value -> (String)EditRangeIntention.getErrorMessages((String)value, (String)this.max, (LongRangeSet)this.myType).first)).description(JavaBundle.message((String)"edit.range.dialog.message", (Object[])new Object[0])), OptPane.string((String)"max", (String)JavaBundle.message((String)"label.to.inclusive", (Object[])new Object[0]), (StringValidator)StringValidator.of((String)"java.range.max", value -> (String)EditRangeIntention.getErrorMessages((String)this.min, (String)value, (LongRangeSet)this.myType).second)).description(JavaBundle.message((String)"edit.range.dialog.message", (Object[])new Object[0]))}).withHelpId("define_range_dialog");
            if (optPane == null) {
                RangeData.$$$reportNull$$$0(4);
            }
            return optPane;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "min";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "max";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/EditRangeIntention$RangeData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/EditRangeIntention$RangeData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionsPane";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

