/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defUse;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAssignmentFix;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.defUse.OverwrittenFieldAnalyzer;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class DefUseInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean REPORT_PREFIX_EXPRESSIONS;
    public boolean REPORT_POSTFIX_EXPRESSIONS = true;
    public boolean REPORT_REDUNDANT_INITIALIZER = true;
    public boolean REPORT_PATTERN_VARIABLE = true;
    public boolean REPORT_FOR_EACH_PARAMETER = true;
    public static final String SHORT_NAME = "UnusedAssignment";

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            DefUseInspection.$$$reportNull$$$0(0);
        }
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name = child.getAttributeValue("name");
            String value = child.getAttributeValue("value");
            if (!Set.of("REPORT_PATTERN_VARIABLE", "REPORT_FOR_EACH_PARAMETER").contains(name) || !"true".equals(value)) continue;
            node.removeContent((Content)child);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DefUseInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                DefUseInspection.this.checkBody((PsiElement)method.getBody(), holder);
            }

            public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
                if (initializer == null) {
                    1.$$$reportNull$$$0(1);
                }
                DefUseInspection.this.checkBody((PsiElement)initializer.getBody(), holder);
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                DefUseInspection.this.checkBody(expression.getBody(), holder);
            }

            public void visitField(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(3);
                }
                DefUseInspection.this.checkField(field, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/defUse/DefUseInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void checkBody(PsiElement body, ProblemsHolder holder) {
        if (body == null) {
            return;
        }
        HashSet usedVariables = new HashSet();
        List unusedDefs = DefUseUtil.getUnusedDefs((PsiElement)body, usedVariables);
        if (unusedDefs != null && !unusedDefs.isEmpty()) {
            unusedDefs.sort(Comparator.comparingInt(o -> o.getContext().getTextOffset()));
            for (DefUseUtil.Info info : unusedDefs) {
                PsiForeachStatement foreachStatement;
                PsiElement context = info.getContext();
                PsiVariable psiVariable = info.getVariable();
                if (context instanceof PsiDeclarationStatement || context instanceof PsiResourceVariable) {
                    PsiTypeElement typeElement;
                    if (!info.isRead() || !this.REPORT_REDUNDANT_INITIALIZER || (typeElement = psiVariable.getTypeElement()) != null && typeElement.isInferredType()) continue;
                    DefUseInspection.reportInitializerProblem(psiVariable, holder);
                    continue;
                }
                if (context instanceof PsiAssignmentExpression) {
                    PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)context.getParent());
                    if (parent == psiVariable || parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType() == JavaTokenType.EQ && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(((PsiAssignmentExpression)parent).getLExpression(), ((PsiAssignmentExpression)context).getLExpression())) continue;
                    DefUseInspection.reportAssignmentProblem((PsiAssignmentExpression)context, holder);
                    continue;
                }
                if (context instanceof PsiPrefixExpression && this.REPORT_PREFIX_EXPRESSIONS || context instanceof PsiPostfixExpression && this.REPORT_POSTFIX_EXPRESSIONS) {
                    holder.registerProblem(context, JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor4", (Object[])new Object[0]), new LocalQuickFix[0]);
                    continue;
                }
                if (this.REPORT_PATTERN_VARIABLE && psiVariable instanceof PsiPatternVariable && info.isWriteOutsideDeclaration()) {
                    holder.registerProblem((PsiElement)psiVariable.getNameIdentifier(), JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor5", (Object[])new Object[0]), new LocalQuickFix[0]);
                    continue;
                }
                if (!this.REPORT_FOR_EACH_PARAMETER || !(context instanceof PsiForeachStatement) || (foreachStatement = (PsiForeachStatement)context).getIterationParameter() != psiVariable || psiVariable.getNameIdentifier() == null || !info.isWriteOutsideDeclaration()) continue;
                holder.registerProblem((PsiElement)psiVariable.getNameIdentifier(), JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor6", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        }
        this.processFieldsViaDfa(body, holder);
    }

    private void processFieldsViaDfa(PsiElement body, ProblemsHolder holder) {
        DfaValueFactory factory = new DfaValueFactory(holder.getProject());
        com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow flow = ControlFlowAnalyzer.buildFlow((PsiElement)body, (DfaValueFactory)factory, (boolean)true);
        Set<DfaAnchor> variables = OverwrittenFieldAnalyzer.getOverwrittenFields(flow);
        for (DfaAnchor anchor : variables) {
            if (!(anchor instanceof JavaExpressionAnchor)) continue;
            JavaExpressionAnchor expressionAnchor = (JavaExpressionAnchor)anchor;
            PsiExpression expression = expressionAnchor.getExpression();
            if (expression instanceof PsiPrefixExpression && this.REPORT_PREFIX_EXPRESSIONS || expression instanceof PsiPostfixExpression && this.REPORT_POSTFIX_EXPRESSIONS) {
                holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor4", (Object[])new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (!(expression instanceof PsiAssignmentExpression)) continue;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            DefUseInspection.reportAssignmentProblem(assignment, holder);
        }
    }

    private static void reportInitializerProblem(PsiVariable psiVariable, ProblemsHolder holder) {
        holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)psiVariable.getInitializer(), (Object)psiVariable), JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor2", (Object[])new Object[]{psiVariable.getName()}), new LocalQuickFix[]{new RemoveInitializerFix()});
    }

    private static void reportAssignmentProblem(PsiAssignmentExpression assignment, ProblemsHolder holder) {
        holder.registerProblem((PsiElement)assignment.getLExpression(), JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor3", (Object[])new Object[]{Objects.requireNonNull(assignment.getRExpression()).getText()}), new LocalQuickFix[]{new RemoveAssignmentFix()});
    }

    private void checkField(@NotNull PsiField field, @NotNull ProblemsHolder holder) {
        boolean fieldHasInitializer;
        boolean isStatic;
        PsiMethod[] constructors;
        if (field == null) {
            DefUseInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            DefUseInspection.$$$reportNull$$$0(3);
        }
        if (field.hasModifierProperty("final")) {
            return;
        }
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClassInitializer[] classInitializers = psiClass.getInitializers();
        int maxPossibleWritesCount = classInitializers.length + ((constructors = !(isStatic = field.hasModifierProperty("static")) ? psiClass.getConstructors() : PsiMethod.EMPTY_ARRAY).length != 0 ? 1 : 0) + ((fieldHasInitializer = field.hasInitializer() && PsiAugmentProvider.canTrustFieldInitializer((PsiField)field)) ? 1 : 0);
        if (maxPossibleWritesCount <= 1) {
            return;
        }
        PsiClassInitializer initializerBeforeField = (PsiClassInitializer)PsiTreeUtil.getPrevSiblingOfType((PsiElement)field, PsiClassInitializer.class);
        ArrayList<FieldWrite> fieldWrites = new ArrayList<FieldWrite>();
        if (fieldHasInitializer && initializerBeforeField == null) {
            fieldWrites.add(FieldWrite.createInitializer());
        }
        for (PsiClassInitializer classInitializer : classInitializers) {
            List<PsiAssignmentExpression> assignments;
            if (classInitializer.hasModifierProperty("static") == isStatic && !(assignments = DefUseInspection.collectAssignments(field, classInitializer)).isEmpty()) {
                boolean isDefinitely = ControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)classInitializer.getBody());
                if (isDefinitely) {
                    try {
                        ControlFlow flow = ControlFlowFactory.getControlFlowNoConstantEvaluate((PsiElement)classInitializer.getBody());
                        if (ContainerUtil.exists((Iterable)ControlFlowUtil.getReadBeforeWrite((ControlFlow)flow), read -> (isStatic || ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)read)) && read.isReferenceTo((PsiElement)field))) {
                            isDefinitely = false;
                        }
                    }
                    catch (AnalysisCanceledException analysisCanceledException) {
                        // empty catch block
                    }
                }
                fieldWrites.add(FieldWrite.createAssignments(isDefinitely, assignments));
            }
            if (!fieldHasInitializer || initializerBeforeField != classInitializer) continue;
            fieldWrites.add(FieldWrite.createInitializer());
        }
        Collections.reverse(fieldWrites);
        boolean wasDefinitelyAssigned = DefUseInspection.isAssignedInAllConstructors(field, constructors);
        for (FieldWrite fieldWrite : fieldWrites) {
            if (wasDefinitelyAssigned) {
                if (fieldWrite.isInitializer()) {
                    if (!this.REPORT_REDUNDANT_INITIALIZER) continue;
                    DefUseInspection.reportInitializerProblem((PsiVariable)field, holder);
                    continue;
                }
                for (PsiAssignmentExpression assignment : fieldWrite.getAssignments()) {
                    DefUseInspection.reportAssignmentProblem(assignment, holder);
                }
                continue;
            }
            if (!fieldWrite.isDefinitely()) continue;
            wasDefinitelyAssigned = true;
        }
    }

    private static boolean isAssignedInAllConstructors(@NotNull PsiField field, PsiMethod @NotNull [] constructors) {
        if (field == null) {
            DefUseInspection.$$$reportNull$$$0(4);
        }
        if (constructors == null) {
            DefUseInspection.$$$reportNull$$$0(5);
        }
        if (constructors.length == 0 || field.hasModifierProperty("static")) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            if (!JavaPsiConstructorUtil.getChainedConstructors((PsiMethod)constructor).isEmpty()) continue;
            PsiCodeBlock body = constructor.getBody();
            if (body == null || !ControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body)) {
                return false;
            }
            try {
                ControlFlow flow = ControlFlowFactory.getControlFlowNoConstantEvaluate((PsiElement)body);
                if (ContainerUtil.exists((Iterable)ControlFlowUtil.getReadBeforeWrite((ControlFlow)flow), read -> ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)read) && read.isReferenceTo((PsiElement)field))) {
                    return false;
                }
                if (!DefUseInspection.canBeUsedInCalledMethods(field, DefUseInspection.collectMethodsBeforeAssignment(field, flow))) continue;
                return false;
            }
            catch (AnalysisCanceledException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean canBeUsedInCalledMethods(PsiField field, List<PsiMethodCallExpression> expressions) {
        PsiClass containingClass = field.getContainingClass();
        PsiManager manager = field.getManager();
        for (PsiMethodCallExpression expression : expressions) {
            PsiMethod method;
            PsiElement psiElement = expression.getMethodExpression().resolve();
            if (psiElement instanceof PsiMethod && !(method = (PsiMethod)psiElement).isConstructor() && !method.hasModifierProperty("static") && manager.areElementsEquivalent((PsiElement)method.getContainingClass(), (PsiElement)containingClass)) {
                return true;
            }
            if (PsiTreeUtil.getChildrenOfType((PsiElement)expression.getArgumentList(), PsiThisExpression.class) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiMethodCallExpression> collectMethodsBeforeAssignment(PsiField field, ControlFlow flow) {
        ArrayList<PsiMethodCallExpression> results = new ArrayList<PsiMethodCallExpression>();
        PsiManager manager = field.getManager();
        List edges = ControlFlowUtil.getEdges((ControlFlow)flow, (int)0);
        Int2ObjectOpenHashMap edgesFromStart = new Int2ObjectOpenHashMap();
        List instructions = flow.getInstructions();
        for (ControlFlowUtil.ControlFlowEdge edge : edges) {
            List existedEdge = (List)edgesFromStart.get(edge.myFrom);
            if (existedEdge != null) {
                existedEdge.add(edge);
                continue;
            }
            ArrayList<ControlFlowUtil.ControlFlowEdge> newEdges = new ArrayList<ControlFlowUtil.ControlFlowEdge>();
            newEdges.add(edge);
            edgesFromStart.put(edge.myFrom, newEdges);
        }
        BitSet untilAssignment = new BitSet();
        ArrayDeque<Integer> unprocessedInstructions = new ArrayDeque<Integer>();
        unprocessedInstructions.add(0);
        while (!unprocessedInstructions.isEmpty()) {
            int currentPoint = (Integer)unprocessedInstructions.poll();
            if (instructions.size() <= currentPoint) {
                ArrayList<PsiMethodCallExpression> arrayList = results;
                if (arrayList == null) {
                    DefUseInspection.$$$reportNull$$$0(6);
                }
                return arrayList;
            }
            if (untilAssignment.get(currentPoint)) continue;
            Instruction instruction = (Instruction)instructions.get(currentPoint);
            if (instruction instanceof WriteVariableInstruction) {
                WriteVariableInstruction writeVariableInstruction = (WriteVariableInstruction)instruction;
                if (manager.areElementsEquivalent((PsiElement)writeVariableInstruction.variable, (PsiElement)field)) continue;
            }
            untilAssignment.set(currentPoint);
            List nextPoints = (List)edgesFromStart.get(currentPoint);
            if (nextPoints == null) continue;
            unprocessedInstructions.addAll(ContainerUtil.map((Collection)nextPoints, t -> t.myTo));
        }
        for (int index : untilAssignment.stream().toArray()) {
            PsiElement psiElement = flow.getElement(index);
            if (!(psiElement instanceof PsiMethodCallExpression)) continue;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)psiElement;
            results.add(methodCallExpression);
        }
        ArrayList<PsiMethodCallExpression> arrayList = results;
        if (arrayList == null) {
            DefUseInspection.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiAssignmentExpression> collectAssignments(final @NotNull PsiField field, @NotNull PsiClassInitializer classInitializer) {
        if (field == null) {
            DefUseInspection.$$$reportNull$$$0(8);
        }
        if (classInitializer == null) {
            DefUseInspection.$$$reportNull$$$0(9);
        }
        final ArrayList<PsiAssignmentExpression> assignmentExpressions = new ArrayList<PsiAssignmentExpression>();
        classInitializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                PsiExpression rExpression;
                PsiExpression lExpression;
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((lExpression = expression.getLExpression()) instanceof PsiJavaReference && ((PsiJavaReference)lExpression).isReferenceTo((PsiElement)field) && (rExpression = expression.getRExpression()) != null) {
                    assignmentExpressions.add(expression);
                }
                super.visitAssignmentExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/defUse/DefUseInspection$2", "visitAssignmentExpression"));
            }
        });
        ArrayList<PsiAssignmentExpression> arrayList = assignmentExpressions;
        if (arrayList == null) {
            DefUseInspection.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"REPORT_REDUNDANT_INITIALIZER", (String)JavaBundle.message((String)"inspection.unused.assignment.option2", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_PREFIX_EXPRESSIONS", (String)JavaBundle.message((String)"inspection.unused.assignment.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_POSTFIX_EXPRESSIONS", (String)JavaBundle.message((String)"inspection.unused.assignment.option1", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_PATTERN_VARIABLE", (String)JavaBundle.message((String)"inspection.unused.assignment.option3", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_FOR_EACH_PARAMETER", (String)JavaBundle.message((String)"inspection.unused.assignment.option4", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            DefUseInspection.$$$reportNull$$$0(11);
        }
        return optPane;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
        if (string == null) {
            DefUseInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/defUse/DefUseInspection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/defUse/DefUseInspection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMethodsBeforeAssignment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAssignments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAssignedInAllConstructors";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static final class FieldWrite {
        final boolean myDefinitely;
        final List<PsiAssignmentExpression> myAssignments;

        private FieldWrite(boolean definitely, List<PsiAssignmentExpression> assignments) {
            this.myDefinitely = definitely;
            this.myAssignments = assignments;
        }

        public boolean isDefinitely() {
            return this.myDefinitely;
        }

        public boolean isInitializer() {
            return this.myAssignments == null;
        }

        public List<PsiAssignmentExpression> getAssignments() {
            return this.myAssignments != null ? this.myAssignments : Collections.emptyList();
        }

        @NotNull
        public static FieldWrite createInitializer() {
            return new FieldWrite(true, null);
        }

        @NotNull
        public static FieldWrite createAssignments(boolean definitely, @NotNull List<PsiAssignmentExpression> assignmentExpressions) {
            if (assignmentExpressions == null) {
                FieldWrite.$$$reportNull$$$0(0);
            }
            return new FieldWrite(definitely, assignmentExpressions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpressions", "com/intellij/codeInspection/defUse/DefUseInspection$FieldWrite", "createAssignments"));
        }
    }
}

