/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.enhancedSwitch;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantLabeledSwitchRuleCodeBlockInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ENHANCED_SWITCH);
        if (set == null) {
            RedundantLabeledSwitchRuleCodeBlockInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            RedundantLabeledSwitchRuleCodeBlockInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitSwitchLabeledRuleStatement(statement);
                PsiStatement body = statement.getBody();
                if (body instanceof PsiBlockStatement) {
                    PsiCodeBlock codeBlock = ((PsiBlockStatement)body).getCodeBlock();
                    PsiStatement bodyStatement = RedundantLabeledSwitchRuleCodeBlockInspection.getSingleStatement(codeBlock);
                    if (bodyStatement instanceof PsiYieldStatement) {
                        PsiYieldStatement yieldStatement = (PsiYieldStatement)bodyStatement;
                        if (yieldStatement.getExpression() != null && PsiTreeUtil.getParentOfType((PsiElement)yieldStatement, PsiSwitchBlock.class) instanceof PsiSwitchExpression) {
                            this.registerProblem(bodyStatement.getFirstChild());
                        }
                    } else if (bodyStatement instanceof PsiThrowStatement || bodyStatement instanceof PsiExpressionStatement) {
                        this.registerProblem((PsiElement)codeBlock.getLBrace());
                        if (isOnTheFly) {
                            this.registerProblem((PsiElement)codeBlock.getRBrace());
                        }
                    }
                }
            }

            private void registerProblem(@Nullable PsiElement element) {
                if (element != null) {
                    holder.registerProblem(element, JavaBundle.message((String)"inspection.labeled.switch.rule.redundant.code.block.message", (Object[])new Object[0]), new LocalQuickFix[]{new UnwrapCodeBlockFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection$1", "visitSwitchLabeledRuleStatement"));
            }
        };
    }

    @Nullable
    private static PsiStatement getSingleStatement(@NotNull PsiCodeBlock block) {
        PsiStatement firstStatement;
        if (block == null) {
            RedundantLabeledSwitchRuleCodeBlockInspection.$$$reportNull$$$0(2);
        }
        if ((firstStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)block.getLBrace(), PsiStatement.class)) != null && PsiTreeUtil.getNextSiblingOfType((PsiElement)firstStatement, PsiStatement.class) == null) {
            return firstStatement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSingleStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class UnwrapCodeBlockFix
    extends PsiUpdateModCommandQuickFix {
        private UnwrapCodeBlockFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.labeled.switch.rule.redundant.code.fix.name", (Object[])new Object[0]);
            if (string == null) {
                UnwrapCodeBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiBlockStatement body;
            if (project == null) {
                UnwrapCodeBlockFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnwrapCodeBlockFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnwrapCodeBlockFix.$$$reportNull$$$0(3);
            }
            if ((body = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiBlockStatement.class)) != null && body.getParent() instanceof PsiSwitchLabeledRuleStatement) {
                PsiStatement bodyStatement = RedundantLabeledSwitchRuleCodeBlockInspection.getSingleStatement(body.getCodeBlock());
                if (bodyStatement instanceof PsiYieldStatement) {
                    UnwrapCodeBlockFix.unwrapYieldValue((PsiStatement)body, (PsiYieldStatement)bodyStatement);
                } else if (bodyStatement instanceof PsiThrowStatement || bodyStatement instanceof PsiExpressionStatement) {
                    UnwrapCodeBlockFix.unwrap((PsiStatement)body, bodyStatement);
                }
            }
        }

        private static void unwrapYieldValue(PsiStatement body, PsiYieldStatement yieldStatement) {
            PsiExpression valueExpression = yieldStatement.getExpression();
            if (valueExpression != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)body.getProject());
                PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText("x=1;", (PsiElement)body);
                statement.getExpression().replace((PsiElement)valueExpression);
                CommentTracker tracker = new CommentTracker();
                tracker.markUnchanged((PsiElement)valueExpression);
                tracker.replaceAndRestoreComments((PsiElement)body, (PsiElement)statement);
            }
        }

        private static void unwrap(PsiStatement body, PsiStatement bodyStatement) {
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)body, (PsiElement)bodyStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection$UnwrapCodeBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/enhancedSwitch/RedundantLabeledSwitchRuleCodeBlockInspection$UnwrapCodeBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

