/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.intermediaryVariable;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.CommonJavaInlineUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReturnSeparatedFromComputationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ReturnSeparatedFromComputationInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
                if (returnStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReturnStatement(returnStatement);
                ReturnContext context = ReturnSeparatedFromComputationInspection.createReturnContext(returnStatement);
                if (context != null && ReturnSeparatedFromComputationInspection.isApplicable(context)) {
                    ReturnSeparatedFromComputationInspection.registerProblem(holder, returnStatement, context.returnedVariable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/intellij/codeInspection/intermediaryVariable/ReturnSeparatedFromComputationInspection$1", "visitReturnStatement"));
            }
        };
    }

    private static ReturnContext createReturnContext(PsiReturnStatement returnStatement) {
        PsiElement returnMethod;
        PsiElement variableMethod;
        PsiVariable returnedVariable;
        PsiCodeBlock variableScope;
        PsiReferenceExpression ref;
        PsiElement psiElement;
        PsiExpression returnValue;
        PsiStatement refactoredStatement;
        PsiType returnType;
        PsiCodeBlock returnScope;
        PsiStatement[] statements;
        PsiElement returnParent = returnStatement.getParent();
        if (returnParent instanceof PsiCodeBlock && (statements = (returnScope = (PsiCodeBlock)returnParent).getStatements()).length != 0 && statements[statements.length - 1] == returnStatement && (returnType = PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement)) != null && (refactoredStatement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)returnStatement, null)) != null && (returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue())) instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)returnValue).resolve()) instanceof PsiVariable && (variableScope = ReturnSeparatedFromComputationInspection.getVariableScopeBlock(returnedVariable = (PsiVariable)psiElement)) != null && (variableMethod = PsiTreeUtil.getParentOfType((PsiElement)variableScope, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class})) == (returnMethod = PsiTreeUtil.getParentOfType((PsiElement)returnScope, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class}))) {
            return new ReturnContext(returnStatement, returnScope, returnType, refactoredStatement, returnedVariable, variableScope);
        }
        return null;
    }

    @Nullable
    private static PsiCodeBlock getVariableScopeBlock(@Nullable PsiVariable variable) {
        if (variable instanceof PsiLocalVariable) {
            PsiLocalVariable localVar = (PsiLocalVariable)variable;
            PsiElement psiElement = CommonJavaRefactoringUtil.getVariableScope((PsiLocalVariable)localVar);
            if (psiElement instanceof PsiCodeBlock) {
                PsiCodeBlock block = (PsiCodeBlock)psiElement;
                return block;
            }
        } else if (variable instanceof PsiParameter) {
            PsiLambdaExpression lambda;
            PsiElement psiElement;
            PsiParameter parameter = (PsiParameter)variable;
            PsiElement parameterScope = parameter.getDeclarationScope();
            if (parameterScope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)parameterScope;
                return method.getBody();
            }
            if (parameterScope instanceof PsiLambdaExpression && (psiElement = (lambda = (PsiLambdaExpression)parameterScope).getBody()) instanceof PsiCodeBlock) {
                PsiCodeBlock block = (PsiCodeBlock)psiElement;
                return block;
            }
        }
        return null;
    }

    private static boolean hasChainedAssignmentsInScope(@NotNull ControlFlow flow, @NotNull PsiVariable variable, @NotNull PsiStatement lastStatementInScope) {
        if (flow == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(1);
        }
        if (variable == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(2);
        }
        if (lastStatementInScope == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(3);
        }
        PsiStatement statement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)lastStatementInScope, null);
        while (statement != null) {
            PsiAssignmentExpression assignmentExpression;
            PsiExpressionStatement expressionStatement;
            PsiExpression expression;
            if (statement instanceof PsiExpressionStatement && (expression = (expressionStatement = (PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression && ReturnSeparatedFromComputationInspection.isVariableUsed(flow, (PsiElement)(assignmentExpression = (PsiAssignmentExpression)expression).getLExpression(), variable) && ReturnSeparatedFromComputationInspection.isVariableUsed(flow, (PsiElement)assignmentExpression.getRExpression(), variable)) {
                return true;
            }
            statement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)statement, null);
        }
        return false;
    }

    private static boolean isVariableUsed(@NotNull ControlFlow flow, @Nullable PsiElement element, @NotNull PsiVariable variable) {
        if (flow == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(4);
        }
        if (variable == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return false;
        }
        int startOffset = flow.getStartOffset(element);
        int endOffset = flow.getEndOffset(element);
        if (startOffset < 0 || endOffset < 0) {
            return true;
        }
        return ControlFlowUtil.isVariableUsed((ControlFlow)flow, (int)startOffset, (int)endOffset, (PsiVariable)variable);
    }

    private static boolean isApplicable(@NotNull ReturnContext context) {
        ControlFlow flow;
        if (context == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(6);
        }
        return (flow = ReturnSeparatedFromComputationInspection.createControlFlow(context)) != null && ReturnSeparatedFromComputationInspection.isApplicable(flow, context);
    }

    @Nullable
    private static ControlFlow createControlFlow(@NotNull ReturnContext context) {
        if (context == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(7);
        }
        try {
            LocalsControlFlowPolicy policy = new LocalsControlFlowPolicy((PsiElement)context.variableScope);
            return ControlFlowFactory.getInstance((Project)context.variableScope.getProject()).getControlFlow((PsiElement)context.variableScope, (ControlFlowPolicy)policy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    private static boolean isApplicable(@NotNull ControlFlow flow, @NotNull ReturnContext context) {
        if (flow == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(8);
        }
        if (context == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(9);
        }
        if (ReturnSeparatedFromComputationInspection.hasChainedAssignmentsInScope(flow, context.returnedVariable, (PsiStatement)context.returnStatement)) {
            return false;
        }
        if (context.returnScope != context.variableScope) {
            if (ControlFlowUtil.isVariableReadInFinally((ControlFlow)flow, (PsiElement)context.returnScope, (PsiElement)context.variableScope, (PsiVariable)context.returnedVariable)) {
                return false;
            }
            int flowStart = flow.getStartOffset((PsiElement)context.returnScope);
            int flowEnd = flow.getEndOffset((PsiElement)context.returnScope);
            if (flowStart < 0 || flowEnd < 0) {
                return false;
            }
            if (ControlFlowUtil.hasObservableThrowExitPoints((ControlFlow)flow, (int)flowStart, (int)flowEnd, (PsiElement[])new PsiElement[]{context.refactoredStatement}, (PsiElement)context.variableScope)) {
                return false;
            }
        }
        Mover mover = new Mover(flow, context.refactoredStatement, context.returnedVariable, context.returnType, true);
        mover.moveTo(context.refactoredStatement, true);
        return !mover.isEmpty();
    }

    private static void doApply(PsiReturnStatement returnStatement, @NotNull ModPsiUpdater updater) {
        ControlFlow flow;
        ReturnContext context;
        if (updater == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(10);
        }
        if ((context = ReturnSeparatedFromComputationInspection.createReturnContext(returnStatement)) != null && (flow = ReturnSeparatedFromComputationInspection.createControlFlow(context)) != null) {
            Mover mover = new Mover(flow, context.refactoredStatement, context.returnedVariable, context.returnType, false);
            boolean removeReturn = mover.moveTo(context.refactoredStatement, true);
            if (!mover.isEmpty()) {
                ReturnSeparatedFromComputationInspection.applyChanges(mover, context, removeReturn, updater);
                ReturnSeparatedFromComputationInspection.deleteRedundantVariable(context, updater);
            }
        }
    }

    private static void deleteRedundantVariable(@NotNull ReturnContext context, @NotNull ModPsiUpdater updater) {
        boolean isSingleUsage;
        PsiExpression value;
        if (context == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(11);
        }
        if (updater == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(12);
        }
        boolean isConstant = (value = PsiUtil.skipParenthesizedExprDown((PsiExpression)context.returnedVariable.getInitializer())) instanceof PsiLiteralExpression || value instanceof PsiThisExpression || PsiUtil.isConstantExpression((PsiExpression)value);
        boolean isSimple = ReturnSeparatedFromComputationInspection.isSimpleExpression(value, (PsiElement)context.returnScope);
        if (value != null && !isConstant && !isSimple) {
            return;
        }
        List usages = VariableAccessUtils.getVariableReferences((PsiVariable)context.returnedVariable, (PsiElement)context.variableScope);
        for (PsiReference usage : usages) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)usage.getElement(), (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class});
            if (parent instanceof PsiReturnStatement) continue;
            return;
        }
        PsiExpression firstInlined = null;
        boolean bl = isSingleUsage = value != null && usages.size() == 1;
        if (isSimple || isSingleUsage) {
            for (PsiJavaCodeReferenceElement usage : usages) {
                PsiExpression inlined = CommonJavaInlineUtil.getInstance().inlineVariable(context.returnedVariable, value, usage, null);
                if (firstInlined == null) {
                    firstInlined = inlined;
                }
                updater.highlight((PsiElement)inlined);
            }
        }
        if (isSimple || isSingleUsage || usages.isEmpty()) {
            CommentTracker tracker = new CommentTracker();
            if (firstInlined != null) {
                tracker.delete((PsiElement)context.returnedVariable);
                tracker.insertCommentsBefore(firstInlined);
            } else {
                tracker.deleteAndRestoreComments((PsiElement)context.returnedVariable);
            }
        }
    }

    @Contract(value="null,_ -> false")
    private static boolean isSimpleExpression(@Nullable PsiExpression expression, @NotNull PsiElement scope) {
        if (scope == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(13);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression).resolve(), PsiVariable.class);
            return variable != null && (variable.hasModifierProperty("final") || ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)scope));
        }
        if (expression instanceof PsiUnaryExpression) {
            return ((PsiUnaryExpression)expression).getOperand() instanceof PsiLiteralExpression;
        }
        return expression instanceof PsiLiteralExpression || expression instanceof PsiThisExpression || expression instanceof PsiClassObjectAccessExpression;
    }

    private static void applyChanges(@NotNull Mover mover, @NotNull ReturnContext context, boolean removeReturn, @NotNull ModPsiUpdater updater) {
        if (mover == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(14);
        }
        if (context == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(15);
        }
        if (updater == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(16);
        }
        for (PsiElement anchor : mover.insertBefore) {
            PsiElement added = anchor.getParent().addBefore((PsiElement)context.returnStatement, anchor);
            updater.highlight(added);
        }
        mover.replaceInline.forEach(e -> {
            if (e instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)e;
                ReturnSeparatedFromComputationInspection.replaceStatementKeepComments((PsiStatement)breakStatement, context.returnStatement, updater);
            } else if (e instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)e;
                ReturnSeparatedFromComputationInspection.inlineAssignment(assignment, context.returnStatement, updater);
            }
        });
        mover.removeCompletely.forEach(e -> ReturnSeparatedFromComputationInspection.removeElementKeepComments(e));
        if (removeReturn) {
            ReturnSeparatedFromComputationInspection.removeReturn(context);
        }
    }

    private static void removeReturn(@NotNull ReturnContext context) {
        if (context == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(17);
        }
        HashSet skippedEmptyStatements = new HashSet();
        ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)context.returnStatement, skippedEmptyStatements);
        skippedEmptyStatements.forEach(PsiElement::delete);
        ReturnSeparatedFromComputationInspection.removeElementKeepComments((PsiElement)context.returnStatement);
    }

    private static void inlineAssignment(PsiAssignmentExpression assignmentExpression, PsiReturnStatement returnStatement, @NotNull ModPsiUpdater updater) {
        if (updater == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(18);
        }
        PsiElement assignmentParent = assignmentExpression.getParent();
        LOG.assertTrue(assignmentParent instanceof PsiExpressionStatement, (Object)"PsiExpressionStatement");
        PsiReturnStatement returnStatementCopy = (PsiReturnStatement)returnStatement.copy();
        PsiExpression rExpression = assignmentExpression.getRExpression();
        PsiExpression returnValue = returnStatementCopy.getReturnValue();
        if (rExpression != null && returnValue != null) {
            returnValue.replace((PsiElement)rExpression);
            ReturnSeparatedFromComputationInspection.replaceStatementKeepComments((PsiStatement)((PsiExpressionStatement)assignmentParent), returnStatementCopy, updater);
        }
    }

    private static void replaceStatementKeepComments(PsiStatement replacedStatement, PsiReturnStatement returnStatement, @NotNull ModPsiUpdater updater) {
        if (updater == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(19);
        }
        updater.highlight(new CommentTracker().replaceAndRestoreComments((PsiElement)replacedStatement, (PsiElement)returnStatement));
    }

    private static void removeElementKeepComments(PsiElement removedElement) {
        new CommentTracker().deleteAndRestoreComments(removedElement);
    }

    @Nullable
    private static PsiStatement getPrevNonEmptyStatement(@Nullable PsiElement psiElement, @Nullable Set<? super PsiElement> skippedEmptyStatements) {
        if (psiElement == null || !(psiElement.getParent() instanceof PsiCodeBlock)) {
            return null;
        }
        PsiStatement prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psiElement, PsiStatement.class);
        ArrayList<PsiStatement> skipped = new ArrayList<PsiStatement>();
        while (prevStatement instanceof PsiEmptyStatement) {
            skipped.add(prevStatement);
            prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevStatement, PsiStatement.class);
        }
        if (prevStatement != null && skippedEmptyStatements != null) {
            skippedEmptyStatements.addAll(skipped);
        }
        return prevStatement;
    }

    @Nullable
    private static PsiStatement getNearestEnclosingStatement(@Nullable PsiElement element) {
        return element instanceof PsiStatement ? (PsiStatement)element : (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull PsiReturnStatement returnStatement, @NotNull PsiVariable variable) {
        if (holder == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(20);
        }
        if (returnStatement == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(21);
        }
        if (variable == null) {
            ReturnSeparatedFromComputationInspection.$$$reportNull$$$0(22);
        }
        String name = variable.getName();
        holder.registerProblem((PsiElement)returnStatement, JavaBundle.message((String)"inspection.return.separated.from.computation.descriptor", (Object[])new Object[]{name}), new LocalQuickFix[]{new VariableFix(name)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 2: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastStatementInScope";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mover";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/intermediaryVariable/ReturnSeparatedFromComputationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasChainedAssignmentsInScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isVariableUsed";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createControlFlow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doApply";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRedundantVariable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimpleExpression";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "applyChanges";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "removeReturn";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineAssignment";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceStatementKeepComments";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record ReturnContext(@NotNull PsiReturnStatement returnStatement, @NotNull PsiCodeBlock returnScope, @NotNull PsiType returnType, @NotNull PsiStatement refactoredStatement, @NotNull PsiVariable returnedVariable, @NotNull PsiCodeBlock variableScope) {
        @NotNull
        private final PsiReturnStatement returnStatement;
        @NotNull
        private final PsiCodeBlock returnScope;
        @NotNull
        private final PsiType returnType;
        @NotNull
        private final PsiStatement refactoredStatement;
        @NotNull
        private final PsiVariable returnedVariable;
        @NotNull
        private final PsiCodeBlock variableScope;

        private ReturnContext(@NotNull PsiReturnStatement returnStatement, @NotNull PsiCodeBlock returnScope, @NotNull PsiType returnType, @NotNull PsiStatement refactoredStatement, @NotNull PsiVariable returnedVariable, @NotNull PsiCodeBlock variableScope) {
            if (returnStatement == null) {
                ReturnContext.$$$reportNull$$$0(0);
            }
            if (returnScope == null) {
                ReturnContext.$$$reportNull$$$0(1);
            }
            if (returnType == null) {
                ReturnContext.$$$reportNull$$$0(2);
            }
            if (refactoredStatement == null) {
                ReturnContext.$$$reportNull$$$0(3);
            }
            if (returnedVariable == null) {
                ReturnContext.$$$reportNull$$$0(4);
            }
            if (variableScope == null) {
                ReturnContext.$$$reportNull$$$0(5);
            }
        }

        @NotNull
        public PsiReturnStatement returnStatement() {
            PsiReturnStatement psiReturnStatement = this.returnStatement;
            if (psiReturnStatement == null) {
                ReturnContext.$$$reportNull$$$0(6);
            }
            return psiReturnStatement;
        }

        @NotNull
        public PsiCodeBlock returnScope() {
            PsiCodeBlock psiCodeBlock = this.returnScope;
            if (psiCodeBlock == null) {
                ReturnContext.$$$reportNull$$$0(7);
            }
            return psiCodeBlock;
        }

        @NotNull
        public PsiType returnType() {
            PsiType psiType = this.returnType;
            if (psiType == null) {
                ReturnContext.$$$reportNull$$$0(8);
            }
            return psiType;
        }

        @NotNull
        public PsiStatement refactoredStatement() {
            PsiStatement psiStatement = this.refactoredStatement;
            if (psiStatement == null) {
                ReturnContext.$$$reportNull$$$0(9);
            }
            return psiStatement;
        }

        @NotNull
        public PsiVariable returnedVariable() {
            PsiVariable psiVariable = this.returnedVariable;
            if (psiVariable == null) {
                ReturnContext.$$$reportNull$$$0(10);
            }
            return psiVariable;
        }

        @NotNull
        public PsiCodeBlock variableScope() {
            PsiCodeBlock psiCodeBlock = this.variableScope;
            if (psiCodeBlock == null) {
                ReturnContext.$$$reportNull$$$0(11);
            }
            return psiCodeBlock;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refactoredStatement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnedVariable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableScope";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/intermediaryVariable/ReturnSeparatedFromComputationInspection$ReturnContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/intermediaryVariable/ReturnSeparatedFromComputationInspection$ReturnContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "returnStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "returnScope";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "returnType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "refactoredStatement";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "returnedVariable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "variableScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Mover {
        final ControlFlow flow;
        final PsiStatement enclosingStatement;
        final PsiVariable resultVariable;
        final PsiType returnType;
        final boolean checkingApplicability;
        final Set<PsiElement> insertBefore;
        final Set<PsiElement> replaceInline;
        final Set<PsiElement> removeCompletely;
        private Map<PsiStatement, Set<PsiBreakStatement>> breakStatements;

        private Mover(@NotNull ControlFlow flow, @NotNull PsiStatement enclosingStatement, @NotNull PsiVariable resultVariable, PsiType returnType, boolean checkingApplicability) {
            if (flow == null) {
                Mover.$$$reportNull$$$0(0);
            }
            if (enclosingStatement == null) {
                Mover.$$$reportNull$$$0(1);
            }
            if (resultVariable == null) {
                Mover.$$$reportNull$$$0(2);
            }
            this.insertBefore = new HashSet<PsiElement>();
            this.replaceInline = new HashSet<PsiElement>();
            this.removeCompletely = new HashSet<PsiElement>();
            this.flow = flow;
            this.enclosingStatement = enclosingStatement;
            this.resultVariable = resultVariable;
            this.returnType = returnType;
            this.checkingApplicability = checkingApplicability;
        }

        boolean isEmpty() {
            return this.insertBefore.isEmpty() && this.replaceInline.isEmpty();
        }

        boolean moveTo(PsiStatement targetStatement, boolean returnAtTheEnd) {
            if (this.checkingApplicability && !this.isEmpty()) {
                return false;
            }
            if (targetStatement instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)targetStatement;
                return this.moveToBlock(blockStatement, returnAtTheEnd);
            }
            if (targetStatement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)targetStatement;
                return this.moveToIf(ifStatement);
            }
            if (targetStatement instanceof PsiConditionalLoopStatement) {
                PsiConditionalLoopStatement loop = (PsiConditionalLoopStatement)targetStatement;
                return this.moveToConditionalLoop(loop);
            }
            if (targetStatement instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)targetStatement;
                return this.moveToForeach(foreachStatement);
            }
            if (targetStatement instanceof PsiSwitchStatement) {
                PsiSwitchStatement switchStatement = (PsiSwitchStatement)targetStatement;
                return this.moveToSwitch(switchStatement);
            }
            if (targetStatement instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)targetStatement;
                return this.moveToTry(tryStatement, returnAtTheEnd);
            }
            if (targetStatement instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)targetStatement;
                return this.moveToLabeled(labeledStatement, returnAtTheEnd);
            }
            if (targetStatement instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)targetStatement;
                return this.inlineExpression(expressionStatement);
            }
            return targetStatement instanceof PsiThrowStatement || targetStatement instanceof PsiReturnStatement || targetStatement instanceof PsiBreakStatement || targetStatement instanceof PsiContinueStatement;
        }

        private boolean moveToBlock(@NotNull PsiBlockStatement targetStatement, boolean returnAtTheEnd) {
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(3);
            }
            return this.moveToBlockBody(targetStatement.getCodeBlock(), returnAtTheEnd);
        }

        private boolean moveToBlockBody(@NotNull PsiCodeBlock codeBlock, boolean returnAtTheEnd) {
            PsiJavaToken rBrace;
            if (codeBlock == null) {
                Mover.$$$reportNull$$$0(4);
            }
            if ((rBrace = codeBlock.getRBrace()) != null) {
                PsiStatement lastNonEmptyStatement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)rBrace, this.removeCompletely);
                if (lastNonEmptyStatement == null) {
                    return false;
                }
                if (this.moveTo(lastNonEmptyStatement, returnAtTheEnd)) {
                    return true;
                }
                if (returnAtTheEnd) {
                    this.insertBefore.add((PsiElement)rBrace);
                    return true;
                }
            }
            return false;
        }

        private boolean moveToIf(@NotNull PsiIfStatement targetStatement) {
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(5);
            }
            PsiStatement thenBranch = targetStatement.getThenBranch();
            PsiStatement elseBranch = targetStatement.getElseBranch();
            boolean thenPart = thenBranch != null && this.moveTo(thenBranch, false);
            boolean elsePart = elseBranch != null && this.moveTo(elseBranch, false);
            return thenPart && elsePart;
        }

        private boolean moveToConditionalLoop(@NotNull PsiConditionalLoopStatement loop) {
            if (loop == null) {
                Mover.$$$reportNull$$$0(6);
            }
            this.moveToBreaks((PsiStatement)loop);
            return Mover.isAlwaysTrue(loop.getCondition(), loop instanceof PsiForStatement);
        }

        private boolean moveToForeach(@NotNull PsiForeachStatement targetStatement) {
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(7);
            }
            this.moveToBreaks((PsiStatement)targetStatement);
            return false;
        }

        private boolean moveToSwitch(@NotNull PsiSwitchStatement targetStatement) {
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(8);
            }
            this.moveToBreaks((PsiStatement)targetStatement);
            PsiCodeBlock body = targetStatement.getBody();
            return body != null && this.moveToBlockBody(body, false) && Mover.hasTotalSwitchLabel(body);
        }

        private boolean moveToTry(@NotNull PsiTryStatement targetStatement, boolean returnAtTheEnd) {
            PsiCatchSection[] catchSections;
            PsiCodeBlock tryBlock;
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(9);
            }
            if ((tryBlock = targetStatement.getTryBlock()) == null) {
                return false;
            }
            PsiCodeBlock finallyBlock = targetStatement.getFinallyBlock();
            if (ReturnSeparatedFromComputationInspection.isVariableUsed(this.flow, (PsiElement)finallyBlock, this.resultVariable)) {
                return false;
            }
            boolean allCatchesReturn = true;
            for (PsiCatchSection catchSection : catchSections = targetStatement.getCatchSections()) {
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (catchBlock != null && this.moveToBlockBody(catchBlock, false)) continue;
                allCatchesReturn = false;
            }
            return this.moveToBlockBody(tryBlock, returnAtTheEnd && allCatchesReturn) && allCatchesReturn;
        }

        private boolean moveToLabeled(@NotNull PsiLabeledStatement targetStatement, boolean returnAtTheEnd) {
            PsiStatement statement;
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(10);
            }
            if ((statement = targetStatement.getStatement()) == null) {
                return false;
            }
            this.moveToBreaks(statement);
            return this.moveTo(statement, returnAtTheEnd);
        }

        private boolean inlineExpression(@NotNull PsiExpressionStatement statement) {
            PsiExpression expression;
            if (statement == null) {
                Mover.$$$reportNull$$$0(11);
            }
            if ((expression = statement.getExpression()) instanceof PsiAssignmentExpression) {
                PsiType rExpressionType;
                PsiExpression rExpression;
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                PsiExpression lExpression = assignmentExpression.getLExpression();
                if (assignmentExpression.getOperationTokenType() == JavaTokenType.EQ && Mover.isReferenceTo(lExpression, this.resultVariable) && (rExpression = assignmentExpression.getRExpression()) != null && (rExpressionType = rExpression.getType()) != null && this.returnType.isAssignableFrom(rExpressionType)) {
                    this.replaceInline.add((PsiElement)assignmentExpression);
                    return true;
                }
            }
            return false;
        }

        private void moveToBreaks(@NotNull PsiStatement targetStatement) {
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(12);
            }
            Set<PsiBreakStatement> breaks = this.getBreaks(targetStatement);
            for (PsiBreakStatement breakStatement : breaks) {
                PsiStatement prevNonEmptyStatement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)breakStatement, this.removeCompletely);
                if (prevNonEmptyStatement == null || !this.moveTo(prevNonEmptyStatement, false)) {
                    this.replaceInline.add((PsiElement)breakStatement);
                    continue;
                }
                this.removeCompletely.add((PsiElement)breakStatement);
            }
        }

        private static boolean hasTotalSwitchLabel(@NotNull PsiCodeBlock switchBody) {
            if (switchBody == null) {
                Mover.$$$reportNull$$$0(13);
            }
            for (PsiStatement statement : switchBody.getStatements()) {
                if (!(statement instanceof PsiSwitchLabelStatement) || !SwitchUtils.isUnconditionalLabel((PsiSwitchLabelStatementBase)((PsiSwitchLabelStatement)statement))) continue;
                return true;
            }
            return false;
        }

        private static boolean isAlwaysTrue(@Nullable PsiExpression condition, boolean nullIsTrue) {
            if (condition == null) {
                return nullIsTrue;
            }
            return ExpressionUtils.computeConstantExpression((PsiExpression)condition) == Boolean.TRUE;
        }

        private Set<PsiBreakStatement> getBreaks(@NotNull PsiStatement targetStatement) {
            Set<PsiBreakStatement> breaks;
            if (targetStatement == null) {
                Mover.$$$reportNull$$$0(14);
            }
            if (this.breakStatements == null) {
                this.breakStatements = new HashMap<PsiStatement, Set<PsiBreakStatement>>();
                List instructions = this.flow.getInstructions();
                for (int i = 0; i < instructions.size(); ++i) {
                    PsiStatement exitedStatement;
                    PsiElement element = this.flow.getElement(i);
                    PsiStatement statement = ReturnSeparatedFromComputationInspection.getNearestEnclosingStatement(element);
                    if (!(statement instanceof PsiBreakStatement) || (exitedStatement = ((PsiBreakStatement)statement).findExitedStatement()) == null) continue;
                    this.breakStatements.computeIfAbsent(exitedStatement, unused -> new HashSet()).add((PsiBreakStatement)statement);
                }
            }
            return (breaks = this.breakStatements.get(targetStatement)) != null ? breaks : Collections.emptySet();
        }

        private static boolean isReferenceTo(PsiExpression expression, PsiVariable variable) {
            PsiReferenceExpression referenceExpression;
            return expression instanceof PsiReferenceExpression && !(referenceExpression = (PsiReferenceExpression)expression).isQualified() && referenceExpression.resolve() == variable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enclosingStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultVariable";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetStatement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeBlock";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loop";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchBody";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/intermediaryVariable/ReturnSeparatedFromComputationInspection$Mover";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToBlock";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToBlockBody";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToIf";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToConditionalLoop";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToForeach";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToSwitch";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToTry";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToLabeled";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inlineExpression";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToBreaks";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasTotalSwitchLabel";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBreaks";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableFix
    extends PsiUpdateModCommandQuickFix {
        private final String myName;

        VariableFix(String name) {
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.return.separated.from.computation.quickfix", (Object[])new Object[]{this.myName});
            if (string == null) {
                VariableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.return.separated.from.computation.family.quickfix", (Object[])new Object[0]);
            if (string == null) {
                VariableFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                VariableFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                VariableFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                VariableFix.$$$reportNull$$$0(4);
            }
            if (element instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                ReturnSeparatedFromComputationInspection.doApply(returnStatement, updater);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/intermediaryVariable/ReturnSeparatedFromComputationInspection$VariableFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/intermediaryVariable/ReturnSeparatedFromComputationInspection$VariableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

