/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.ForEachCollectionTraversal;
import com.intellij.codeInspection.util.IterableTraversal;
import com.intellij.codeInspection.util.IteratorDeclaration;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8CollectionRemoveIfInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ADVANCED_COLLECTIONS_API);
        if (set == null) {
            Java8CollectionRemoveIfInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java8CollectionRemoveIfInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            void handleIteratorLoop(PsiLoopStatement statement, PsiJavaToken endToken, IteratorDeclaration declaration) {
                PsiStatement element;
                PsiStatement psiStatement;
                if (endToken == null || declaration == null || !declaration.isCollection()) {
                    return;
                }
                PsiStatement[] statements = ControlFlowUtils.unwrapBlock((PsiStatement)statement.getBody());
                if (statements.length == 2 && (psiStatement = statements[1]) instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)psiStatement;
                    element = declaration.getNextElementVariable(statements[0]);
                    if (element == null) {
                        return;
                    }
                    if (1.checkAndExtractCondition((IterableTraversal)declaration, ifStatement) == null) {
                        return;
                    }
                    this.registerProblem(statement);
                } else if (statements.length == 1 && (element = statements[0]) instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)element;
                    PsiExpression condition = 1.checkAndExtractCondition((IterableTraversal)declaration, ifStatement);
                    if (condition == null) {
                        return;
                    }
                    PsiElement ref = declaration.findOnlyIteratorRef(condition);
                    if (ref != null && declaration.isIteratorMethodCall(ref.getParent().getParent(), "next") && 1.isAlwaysExecuted(condition, ref)) {
                        this.registerProblem(statement);
                    }
                }
            }

            private static boolean isAlwaysExecuted(PsiExpression condition, PsiElement ref) {
                while (ref != condition) {
                    PsiPolyadicExpression polyadicExpression;
                    IElementType type;
                    PsiElement parent = ref.getParent();
                    if (parent instanceof PsiPolyadicExpression && ((type = (polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || type.equals(JavaTokenType.OROR)) && polyadicExpression.getOperands()[0] != ref) {
                        return false;
                    }
                    if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != ref) {
                        return false;
                    }
                    ref = parent;
                }
                return true;
            }

            private void registerProblem(PsiLoopStatement statement) {
                holder.registerProblem(statement.getFirstChild(), QuickFixBundle.message((String)"java.8.collection.removeif.inspection.description", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithRemoveIfQuickFix()});
            }

            @Nullable
            private static PsiExpression checkAndExtractCondition(IterableTraversal traversal, PsiIfStatement ifStatement) {
                PsiVariable iterableVariable;
                PsiExpression condition = ifStatement.getCondition();
                if (condition == null || ifStatement.getElseBranch() != null) {
                    return null;
                }
                PsiStatement thenStatement = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
                if (!(thenStatement instanceof PsiExpressionStatement)) {
                    return null;
                }
                if (!traversal.isRemoveCall(((PsiExpressionStatement)thenStatement).getExpression())) {
                    return null;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)condition)) {
                    return null;
                }
                PsiReferenceExpression iterable = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)traversal.getIterable()), PsiReferenceExpression.class);
                PsiVariable psiVariable = iterableVariable = iterable != null ? (PsiVariable)ObjectUtils.tryCast((Object)iterable.resolve(), PsiVariable.class) : null;
                if (iterableVariable != null && VariableAccessUtils.variableIsUsed((PsiVariable)iterableVariable, (PsiElement)condition)) {
                    return null;
                }
                return condition;
            }

            public void visitForStatement(@NotNull PsiForStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitForStatement(statement);
                IteratorDeclaration declaration = IteratorDeclaration.fromLoop((PsiLoopStatement)statement);
                this.handleIteratorLoop((PsiLoopStatement)statement, statement.getRParenth(), declaration);
            }

            public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitWhileStatement(statement);
                IteratorDeclaration declaration = IteratorDeclaration.fromLoop((PsiLoopStatement)statement);
                this.handleIteratorLoop((PsiLoopStatement)statement, statement.getRParenth(), declaration);
            }

            public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitForeachStatement(statement);
                ForEachCollectionTraversal traversal = ForEachCollectionTraversal.fromLoop((PsiForeachStatement)statement);
                if (traversal == null) {
                    return;
                }
                PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces((PsiStatement)statement.getBody()), PsiIfStatement.class);
                if (ifStatement == null) {
                    return;
                }
                PsiExpression condition = 1.checkAndExtractCondition((IterableTraversal)traversal, ifStatement);
                if (condition == null) {
                    return;
                }
                PsiJavaToken endToken = statement.getRParenth();
                if (endToken == null) {
                    return;
                }
                this.registerProblem((PsiLoopStatement)statement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "statement";
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWhileStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForeachStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithRemoveIfQuickFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithRemoveIfQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"java.8.collection.removeif.inspection.fix.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithRemoveIfQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            String replacement;
            PsiElement psiElement;
            if (project == null) {
                ReplaceWithRemoveIfQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithRemoveIfQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithRemoveIfQuickFix.$$$reportNull$$$0(3);
            }
            if (!((psiElement = element.getParent()) instanceof PsiLoopStatement)) {
                return;
            }
            PsiLoopStatement loop = (PsiLoopStatement)psiElement;
            Object[] statements = ControlFlowUtils.unwrapBlock((PsiStatement)loop.getBody());
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)ArrayUtil.getLastElement((Object[])statements), PsiIfStatement.class);
            if (ifStatement == null) {
                return;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (loop instanceof PsiForeachStatement) {
                ForEachCollectionTraversal traversal = ForEachCollectionTraversal.fromLoop((PsiForeachStatement)((PsiForeachStatement)loop));
                if (traversal == null || statements.length != 1) {
                    return;
                }
                replacement = ReplaceWithRemoveIfQuickFix.generateRemoveIf((IterableTraversal)traversal, ct, condition, traversal.getParameter().getName());
            } else {
                IteratorDeclaration declaration = IteratorDeclaration.fromLoop((PsiLoopStatement)loop);
                if (declaration == null) {
                    return;
                }
                switch (statements.length) {
                    case 1: {
                        PsiElement ref = declaration.findOnlyIteratorRef(condition);
                        if (ref == null) {
                            return;
                        }
                        PsiElement call = ref.getParent().getParent();
                        if (!declaration.isIteratorMethodCall(call, "next")) {
                            return;
                        }
                        PsiType type = ((PsiExpression)call).getType();
                        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                        SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type);
                        if (info.names.length == 0) {
                            info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, "value", null, type);
                        }
                        String paramName = javaCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)info, (PsiElement)condition, (boolean)true).names[0];
                        ct.replace(call, (PsiElement)JavaPsiFacade.getElementFactory((Project)project).createIdentifier(paramName));
                        replacement = ReplaceWithRemoveIfQuickFix.generateRemoveIf((IterableTraversal)declaration, ct, condition, paramName);
                        break;
                    }
                    case 2: {
                        PsiVariable variable = declaration.getNextElementVariable((PsiStatement)statements[0]);
                        if (variable == null) {
                            return;
                        }
                        replacement = ReplaceWithRemoveIfQuickFix.generateRemoveIf((IterableTraversal)declaration, ct, condition, variable.getName());
                        break;
                    }
                    default: {
                        return;
                    }
                }
                ct.delete((PsiElement)declaration.getIterator());
            }
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)loop, replacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static String generateRemoveIf(IterableTraversal traversal, CommentTracker ct, PsiExpression condition, String paramName) {
            String string = (String)(traversal.getIterable() == null ? "" : ct.text((PsiElement)traversal.getIterable()) + ".") + "removeIf(" + paramName + "->" + ct.text((PsiElement)condition) + ");";
            if (string == null) {
                ReplaceWithRemoveIfQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/Java8CollectionRemoveIfInspection$ReplaceWithRemoveIfQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateRemoveIf";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

