/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaDfaAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceArgumentAnchor;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class OptionalGetWithoutIsPresentInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            OptionalGetWithoutIsPresentInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalGetWithoutIsPresentInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                PsiElement nameElement;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nameElement = call.getMethodExpression().getReferenceNameElement()) == null) {
                    return;
                }
                if (!OptionalUtil.OPTIONAL_GET.test(call)) {
                    return;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
                if (qualifier == null) {
                    return;
                }
                PsiClass optionalClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
                if (optionalClass == null) {
                    return;
                }
                JavaExpressionAnchor anchor = new JavaExpressionAnchor(qualifier);
                if (1.isOptionalProblem(qualifier, (JavaDfaAnchor)anchor) && !this.isPresentCallWithSameQualifierExists(qualifier)) {
                    holder.registerProblem(nameElement, JavaBundle.message((String)"inspection.optional.get.without.is.present.message", (Object[])new Object[]{optionalClass.getName()}), LocalQuickFix.notNullElements((LocalQuickFix)OptionalGetWithoutIsPresentInspection.tryCreateFix(call)));
                }
            }

            private static boolean isOptionalProblem(@NotNull PsiExpression context, @NotNull JavaDfaAnchor anchor) {
                CommonDataflow.DataflowResult result;
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (anchor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((result = CommonDataflow.getDataflowResult((PsiElement)context)) == null || !result.anchorWasAnalyzed(anchor)) {
                    return false;
                }
                DfType dfType = SpecialField.OPTIONAL_VALUE.getFromQualifier(result.getDfType(anchor));
                if (dfType != DfType.TOP && !(dfType instanceof DfReferenceType)) {
                    return false;
                }
                DfaNullability nullability = DfaNullability.fromDfType((DfType)dfType);
                return nullability == DfaNullability.UNKNOWN || nullability == DfaNullability.NULLABLE;
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression methodRef) {
                if (methodRef == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!OptionalUtil.OPTIONAL_GET.methodReferenceMatches(methodRef)) {
                    return;
                }
                if (1.isOptionalProblem((PsiExpression)methodRef, (JavaDfaAnchor)new JavaMethodReferenceArgumentAnchor(methodRef))) {
                    holder.registerProblem((PsiElement)methodRef, JavaBundle.message((String)"inspection.optional.get.without.is.present.method.reference.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public boolean isPresentCallWithSameQualifierExists(PsiExpression qualifier) {
                PsiElement context;
                if (qualifier instanceof PsiMethodCallExpression && (context = PsiTreeUtil.getParentOfType((PsiElement)qualifier, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null) {
                    return !PsiTreeUtil.processElements((PsiElement)context, e -> {
                        if (e == qualifier || !(e instanceof PsiMethodCallExpression)) {
                            return true;
                        }
                        PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                        String name = call.getMethodExpression().getReferenceName();
                        if (!"isPresent".equals(name) && !"isEmpty".equals(name) || !call.getArgumentList().isEmpty()) {
                            return true;
                        }
                        PsiExpression isPresentQualifier = call.getMethodExpression().getQualifierExpression();
                        return isPresentQualifier == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)isPresentQualifier);
                    });
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anchor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodRef";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isOptionalProblem";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static LocalQuickFix tryCreateFix(PsiMethodCallExpression call) {
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiClass optionalClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
        if (optionalClass == null || !"java.util.Optional".equals(optionalClass.getQualifiedName())) {
            return null;
        }
        PsiType optionalElementType = OptionalUtil.getOptionalElementType((PsiType)qualifier.getType());
        if (optionalElementType == null) {
            return null;
        }
        PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
        if (nextCall != null && optionalClass.equals((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)nextCall.getType()))) {
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nextCall)) {
                PsiMethodCallExpression copy = (PsiMethodCallExpression)nextCall.copy();
                PsiExpression copyQualifier = Objects.requireNonNull(copy.getMethodExpression().getQualifierExpression());
                try {
                    copyQualifier.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)call.getProject()).createExpressionFromText("((" + optionalElementType.getCanonicalText() + ")null)", (PsiElement)copyQualifier));
                }
                catch (IncorrectOperationException e) {
                    return null;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)copy)) {
                    return null;
                }
            }
            return new UseFlatMapFix();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class UseFlatMapFix
    extends PsiUpdateModCommandQuickFix {
        private UseFlatMapFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.use.flatmap", (Object[])new Object[0]);
            if (string == null) {
                UseFlatMapFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                UseFlatMapFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UseFlatMapFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UseFlatMapFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType elementType = OptionalUtil.getOptionalElementType((PsiType)qualifier.getType());
            PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            if (nextCall == null) {
                return;
            }
            String name = new VariableNameGenerator((PsiElement)qualifier, VariableKind.PARAMETER).byExpression(qualifier).byType(elementType).byName(new String[]{"value"}).generate(true);
            CommentTracker ct = new CommentTracker();
            PsiReferenceExpression methodExpression = nextCall.getMethodExpression();
            ct.markRangeUnchanged(Objects.requireNonNull(methodExpression.getQualifierExpression()).getNextSibling(), methodExpression.getLastChild());
            ct.markRangeUnchanged(methodExpression.getNextSibling(), nextCall.getLastChild());
            PsiMethodCallExpression newNextCall = (PsiMethodCallExpression)nextCall.copy();
            PsiExpression newQualifier = Objects.requireNonNull(newNextCall.getMethodExpression().getQualifierExpression());
            newQualifier.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(name, (PsiElement)newNextCall));
            String lambda = name + "->" + newNextCall.getText();
            String replacement = ct.text((PsiElement)qualifier) + ".flatMap(" + lambda + ")";
            PsiMethodCallExpression result = (PsiMethodCallExpression)ct.replaceAndRestoreComments((PsiElement)nextCall, replacement);
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)((PsiLambdaExpression)result.getArgumentList().getExpressions()[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection$UseFlatMapFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection$UseFlatMapFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

