/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.java.JavaBundle;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtil;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaEmptyModuleInfoFileInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> JVM_LANGUAGES = Set.of("java", "kt", "kts", "groovy");

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)file)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().equals("module-info.java")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!(file instanceof PsiJavaFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiJavaModule descriptor = javaFile.getModuleDeclaration();
        if (descriptor == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!JavaEmptyModuleInfoFileInspection.isEmptyModule(descriptor)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!JavaEmptyModuleInfoFileInspection.needRequires(descriptor)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)file, JavaBundle.message((String)"inspection.unresolved.module.dependencies.problem.descriptor", (Object[])new Object[0]), isOnTheFly, LocalQuickFix.notNullElements((LocalQuickFix)new GenerateModuleInfoRequiresFix()), ProblemHighlightType.WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    private static boolean isEmptyModule(@NotNull PsiJavaModule module) {
        PsiElement element;
        if (module == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(2);
        }
        if ((element = JavaEmptyModuleInfoFileInspection.getStartContentElement(module)) == null) {
            return false;
        }
        while ((element = element.getNextSibling()) != null) {
            if (element.getNode().getElementType() == JavaTokenType.RBRACE) {
                return true;
            }
            if (element instanceof PsiWhiteSpace) continue;
            return false;
        }
        return true;
    }

    private static boolean needRequires(@NotNull PsiJavaModule descriptor) {
        Set<PsiJavaModule> modules;
        if (descriptor == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(3);
        }
        return !(modules = JavaEmptyModuleInfoFileInspection.walk(descriptor, psiJavaModule -> psiJavaModule.getName().equals(descriptor.getName()) || psiJavaModule.getName().equals("java.base"))).isEmpty();
    }

    @Nullable
    private static PsiElement getStartContentElement(@NotNull PsiJavaModule module) {
        PsiElement child;
        if (module == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(4);
        }
        for (child = module.getFirstChild(); child != null && child.getNode().getElementType() != JavaTokenType.LBRACE; child = child.getNextSibling()) {
        }
        return child;
    }

    private static Set<PsiJavaModule> walk(@NotNull PsiJavaModule descriptor, @NotNull @NotNull Predicate<@NotNull PsiJavaModule> shouldProcessFollowingFile) {
        PsiFile descriptorFile;
        Module module;
        if (descriptor == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(5);
        }
        if (shouldProcessFollowingFile == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(6);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)(descriptorFile = descriptor.getContainingFile().getOriginalFile()))) == null) {
            return Set.of();
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        ModuleFileIndex fileIndex = rootManager.getFileIndex();
        HashMap imports = new HashMap();
        ImportsCollector collector = new ImportsCollector(psiManager, statement -> {
            PsiJavaModule result = imports.computeIfAbsent(statement, stmt -> JavaEmptyModuleInfoFileInspection.findDescriptor(stmt.resolve()));
            return result == null || shouldProcessFollowingFile.test(result);
        });
        DependencyScope scope = JavaEmptyModuleInfoFileInspection.getScope(descriptor);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            DependencyScope currentScope;
            DependencyScope dependencyScope = currentScope = fileIndex.isInTestSourceContent(root) ? DependencyScope.TEST : DependencyScope.COMPILE;
            if (currentScope != scope) continue;
            VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, file -> file.isDirectory() || file.getExtension() != null && JVM_LANGUAGES.contains(file.getExtension()), (ContentIterator)collector);
        }
        return imports.values().stream().filter(Objects::nonNull).filter(m -> !m.getName().equals(descriptor.getName())).filter(m -> !m.getName().equals("java.base")).collect(Collectors.toCollection(() -> new TreeSet((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()))));
    }

    @NotNull
    private static DependencyScope getScope(@NotNull PsiJavaModule descriptor) {
        PsiFile file;
        Module module;
        if (descriptor == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)(file = descriptor.getContainingFile().getOriginalFile()))) == null) {
            DependencyScope dependencyScope = DependencyScope.COMPILE;
            if (dependencyScope == null) {
                JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(8);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(file.getVirtualFile()) ? DependencyScope.TEST : DependencyScope.COMPILE;
        if (dependencyScope == null) {
            JavaEmptyModuleInfoFileInspection.$$$reportNull$$$0(9);
        }
        return dependencyScope;
    }

    @Nullable
    private static PsiJavaModule findDescriptor(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof PsiPackage) {
            PsiDirectory[] directories;
            PsiPackage psiPackage = (PsiPackage)psiElement;
            for (PsiDirectory directory : directories = psiPackage.getDirectories(psiPackage.getResolveScope())) {
                PsiJavaModule descriptor = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)directory);
                if (descriptor == null) continue;
                return descriptor;
            }
        } else {
            return JavaPsiModuleUtil.findDescriptorByElement((PsiElement)psiElement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldProcessFollowingFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/JavaEmptyModuleInfoFileInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/JavaEmptyModuleInfoFileInspection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "needRequires";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStartContentElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "walk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class GenerateModuleInfoRequiresFix
    extends PsiUpdateModCommandQuickFix {
        private GenerateModuleInfoRequiresFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.auto.add.module.requirements.quickfix", (Object[])new Object[0]);
            if (string == null) {
                GenerateModuleInfoRequiresFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                GenerateModuleInfoRequiresFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                GenerateModuleInfoRequiresFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                GenerateModuleInfoRequiresFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile psiJavaFile = (PsiJavaFile)element;
            PsiJavaModule descriptor = psiJavaFile.getModuleDeclaration();
            if (descriptor == null) {
                return;
            }
            if (!JavaEmptyModuleInfoFileInspection.isEmptyModule(descriptor)) {
                return;
            }
            Set<PsiJavaModule> modules = JavaEmptyModuleInfoFileInspection.walk(descriptor, stmt -> true);
            if (modules.isEmpty()) {
                PsiElement content = JavaEmptyModuleInfoFileInspection.getStartContentElement(descriptor);
                PsiElement newLine = PsiParserFacade.getInstance((Project)element.getProject()).createWhiteSpaceFromText("\n");
                PsiComment comment = JavaPsiFacade.getElementFactory((Project)element.getProject()).createCommentFromText("// no dependencies", null);
                descriptor.addAfter((PsiElement)comment, content);
                descriptor.addAfter(newLine, content);
            } else {
                DependencyScope scope = JavaEmptyModuleInfoFileInspection.getScope(descriptor);
                for (PsiJavaModule target : modules) {
                    JavaModuleGraphUtil.addDependency((PsiJavaModule)descriptor, (PsiJavaModule)target, (DependencyScope)scope);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19api/JavaEmptyModuleInfoFileInspection$GenerateModuleInfoRequiresFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19api/JavaEmptyModuleInfoFileInspection$GenerateModuleInfoRequiresFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ImportsCollector
    implements ContentIterator {
        @NotNull
        private final PsiManager myPsiManager;
        @NotNull
        private final Predicate<PsiImportStatement> myShouldProcessFollowingFile;

        private ImportsCollector(@NotNull PsiManager manager, @NotNull Predicate<PsiImportStatement> shouldProcessFollowingFile) {
            if (manager == null) {
                ImportsCollector.$$$reportNull$$$0(0);
            }
            if (shouldProcessFollowingFile == null) {
                ImportsCollector.$$$reportNull$$$0(1);
            }
            this.myPsiManager = manager;
            this.myShouldProcessFollowingFile = shouldProcessFollowingFile;
        }

        public boolean processFile(@NotNull VirtualFile fileOrDir) {
            PsiFile file;
            if (fileOrDir == null) {
                ImportsCollector.$$$reportNull$$$0(2);
            }
            if ((file = this.myPsiManager.findFile(fileOrDir)) == null) {
                return true;
            }
            if (!(file instanceof PsiJavaFile)) {
                return true;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            PsiImportList imports = javaFile.getImportList();
            if (imports == null) {
                return true;
            }
            for (PsiImportStatement importStatement : imports.getImportStatements()) {
                if (this.myShouldProcessFollowingFile.test(importStatement)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shouldProcessFollowingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOrDir";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/java19api/JavaEmptyModuleInfoFileInspection$ImportsCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

