/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.java19api.UniqueModuleNames;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

final class ModuleNode
implements Comparable<ModuleNode> {
    @Nullable
    private final Module myModule;
    @NotNull
    private final Set<String> myDeclaredPackages;
    @NotNull
    private final Set<String> myRequiredPackages;
    @NotNull
    private final Map<ModuleNode, Set<DependencyType>> myDependencies;
    @NotNull
    private final Set<String> myExports;
    @Nullable
    private final PsiJavaModule myDescriptor;
    @NotNull
    private final String myName;

    ModuleNode(@NotNull Module module, @NotNull Set<String> declaredPackages, @NotNull Set<String> requiredPackages, @NotNull UniqueModuleNames uniqueModuleNames) {
        if (module == null) {
            ModuleNode.$$$reportNull$$$0(0);
        }
        if (declaredPackages == null) {
            ModuleNode.$$$reportNull$$$0(1);
        }
        if (requiredPackages == null) {
            ModuleNode.$$$reportNull$$$0(2);
        }
        if (uniqueModuleNames == null) {
            ModuleNode.$$$reportNull$$$0(3);
        }
        this.myDependencies = new TreeMap<ModuleNode, Set<DependencyType>>();
        this.myExports = new TreeSet<String>();
        this.myModule = module;
        this.myDeclaredPackages = new HashSet<String>(declaredPackages);
        this.myRequiredPackages = new HashSet<String>(requiredPackages);
        this.myRequiredPackages.removeAll(this.myDeclaredPackages);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)this.myModule);
        this.myDescriptor = (PsiJavaModule)ReadAction.compute(() -> {
            VirtualFile[] sourceRoots = moduleRootManager.getSourceRoots(false);
            return sourceRoots.length != 0 ? ModuleNode.findDescriptor(module, sourceRoots[0]) : null;
        });
        this.myName = (String)ReadAction.compute(() -> this.myDescriptor != null ? this.myDescriptor.getName() : uniqueModuleNames.getUniqueName(this.myModule));
    }

    ModuleNode(@NotNull PsiJavaModule descriptor) {
        if (descriptor == null) {
            ModuleNode.$$$reportNull$$$0(4);
        }
        this.myDependencies = new TreeMap<ModuleNode, Set<DependencyType>>();
        this.myExports = new TreeSet<String>();
        this.myModule = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)descriptor));
        this.myDeclaredPackages = Collections.emptySet();
        this.myRequiredPackages = Collections.emptySet();
        this.myDescriptor = descriptor;
        this.myName = (String)ReadAction.compute(() -> this.myDescriptor.getName());
    }

    @Nullable
    Module getModule() {
        return this.myModule;
    }

    @NotNull
    Set<String> getDeclaredPackages() {
        Set<String> set = this.myDeclaredPackages;
        if (set == null) {
            ModuleNode.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    Set<String> getRequiredPackages() {
        Set<String> set = this.myRequiredPackages;
        if (set == null) {
            ModuleNode.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    Map<ModuleNode, Set<DependencyType>> getDependencies() {
        Map<ModuleNode, Set<DependencyType>> map = this.myDependencies;
        if (map == null) {
            ModuleNode.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    Set<String> getExports() {
        Set<String> set = this.myExports;
        if (set == null) {
            ModuleNode.$$$reportNull$$$0(8);
        }
        return set;
    }

    void addExport(@NotNull String packageName) {
        if (packageName == null) {
            ModuleNode.$$$reportNull$$$0(9);
        }
        this.myExports.add(packageName);
    }

    @Nullable
    PsiJavaModule getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ModuleNode.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String toString() {
        return this.myName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ModuleNode)) return false;
        ModuleNode node = (ModuleNode)o;
        if (!this.getName().equals(node.getName())) return false;
        return true;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @Override
    public int compareTo(@NotNull ModuleNode o) {
        int j2;
        int m2;
        if (o == null) {
            ModuleNode.$$$reportNull$$$0(11);
        }
        int m1 = this.myModule == null ? 0 : 1;
        int n = m2 = o.myModule == null ? 0 : 1;
        if (m1 != m2) {
            return m1 - m2;
        }
        int j1 = this.getName().startsWith("java.") || this.getName().startsWith("javax.") ? 0 : 1;
        int n2 = j2 = o.getName().startsWith("java.") || o.getName().startsWith("javax.") ? 0 : 1;
        if (j1 != j2) {
            return j1 - j2;
        }
        return StringUtil.compare((String)this.getName(), (String)o.getName(), (boolean)false);
    }

    @Nullable
    PsiDirectory getRootDir() {
        if (this.myModule == null) {
            return null;
        }
        return (PsiDirectory)ReadAction.compute(() -> {
            ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)this.myModule);
            ArrayList<VirtualFile> folderCandidates = new ArrayList<VirtualFile>();
            for (ContentEntry entry : moduleManager.getContentEntries()) {
                for (SourceFolder folder : entry.getSourceFolders()) {
                    if (!ModuleNode.isSourceFolder(folder)) continue;
                    folderCandidates.add(folder.getFile());
                }
            }
            PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
            return folderCandidates.stream().filter(Objects::nonNull).sorted(Comparator.comparingInt(vFile -> "java".equals(vFile.getName()) ? 0 : 1).thenComparing(VirtualFile::getName)).map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
        });
    }

    private static boolean isSourceFolder(@NotNull SourceFolder folder) {
        JpsModuleSourceRoot sourceRoot;
        if (folder == null) {
            ModuleNode.$$$reportNull$$$0(12);
        }
        if ((sourceRoot = folder.getJpsElement()).getRootType() != JavaSourceRootType.SOURCE) {
            return false;
        }
        JpsElement jpsElement = sourceRoot.getProperties();
        if (!(jpsElement instanceof JavaSourceRootProperties)) {
            return false;
        }
        JavaSourceRootProperties javaProperties = (JavaSourceRootProperties)jpsElement;
        return !javaProperties.isForGeneratedSources();
    }

    @Nullable
    private static PsiJavaModule findDescriptor(@NotNull Module module, @Nullable VirtualFile root) {
        if (module == null) {
            ModuleNode.$$$reportNull$$$0(13);
        }
        return JavaModuleGraphUtil.findDescriptorByFile((VirtualFile)root, (Project)module.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredPackages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredPackages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueModuleNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/ModuleNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/ModuleNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addExport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSourceFolder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    static enum DependencyType {
        STATIC,
        TRANSITIVE;

    }
}

