/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.lambdaToExplicit.LambdaAndExplicitMethodPair;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExcessiveLambdaUsageInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher LIST_REPLACE_ALL = CallMatcher.instanceCall((String)"java.util.List", (String[])new String[]{"replaceAll"}).parameterTypes(new String[]{"java.util.function.UnaryOperator"});

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.LAMBDA_EXPRESSIONS);
        if (set == null) {
            ExcessiveLambdaUsageInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExcessiveLambdaUsageInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
                PsiElement parent;
                if (lambda == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((parent = lambda.getParent()) instanceof PsiExpressionList)) {
                    return;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                if (call == null) {
                    return;
                }
                LambdaAndExplicitMethodPair[] lambdaAndExplicitMethodPairArray = lambda.getBody();
                if (!(lambdaAndExplicitMethodPairArray instanceof PsiExpression)) {
                    return;
                }
                PsiExpression expr = (PsiExpression)lambdaAndExplicitMethodPairArray;
                if (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expr)) {
                    return;
                }
                if (ContainerUtil.or((Object[])lambda.getParameterList().getParameters(), param -> ExpressionUtils.isReferenceTo((PsiExpression)expr, (PsiVariable)param))) {
                    return;
                }
                if (LIST_REPLACE_ALL.test(call)) {
                    this.registerProblem(lambda, expr, (LocalQuickFix)new ReplaceWithCollectionsFillFix());
                    return;
                }
                for (LambdaAndExplicitMethodPair info : LambdaAndExplicitMethodPair.INFOS) {
                    if (!info.isLambdaCall(call, lambda)) continue;
                    this.registerProblem(lambda, expr, (LocalQuickFix)new RemoveExcessiveLambdaFix(info, info.getExplicitMethodName(call)));
                }
            }

            private void registerProblem(PsiLambdaExpression lambda, PsiExpression expr, LocalQuickFix fix) {
                holder.registerProblem((PsiElement)lambda, JavaBundle.message((String)"inspection.excessive.lambda.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new TextRange(0, expr.getStartOffsetInParent()), new LocalQuickFix[]{fix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection$1", "visitLambdaExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class Context {
        @NotNull
        private final PsiMethodCallExpression myCall;
        @NotNull
        private final PsiLambdaExpression myLambda;
        @NotNull
        private final PsiElement myBody;

        private Context(@NotNull PsiMethodCallExpression call, @NotNull PsiLambdaExpression lambda, @NotNull PsiElement body) {
            if (call == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (lambda == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (body == null) {
                Context.$$$reportNull$$$0(2);
            }
            this.myCall = call;
            this.myLambda = lambda;
            this.myBody = body;
        }

        @Nullable
        static Context from(@Nullable PsiElement element) {
            if (!(element instanceof PsiLambdaExpression)) {
                return null;
            }
            PsiLambdaExpression lambda = (PsiLambdaExpression)element;
            PsiElement body = lambda.getBody();
            if (body == null) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda, PsiMethodCallExpression.class);
            if (call == null) {
                return null;
            }
            return new Context(call, lambda, body);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lambda";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "body";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection$Context";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ReplaceWithCollectionsFillFix
    extends PsiUpdateModCommandQuickFix {
        ReplaceWithCollectionsFillFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.excessive.lambda.fix.name", (Object[])new Object[]{"Collections.fill()"});
            if (string == null) {
                ReplaceWithCollectionsFillFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Context context;
            if (project == null) {
                ReplaceWithCollectionsFillFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithCollectionsFillFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithCollectionsFillFix.$$$reportNull$$$0(3);
            }
            if ((context = Context.from(element)) == null) {
                return;
            }
            PsiExpression expression = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)context.myCall.getMethodExpression());
            if (expression == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String firstArg = expression instanceof PsiSuperExpression ? "this" : ct.text((PsiElement)expression);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            String text = "java.util.Collections.fill(" + firstArg + ", " + ct.text(context.myBody) + ")";
            PsiExpression replacement = factory.createExpressionFromText(text, (PsiElement)context.myCall);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replacement);
            ct.replaceAndRestoreComments((PsiElement)context.myCall, (PsiElement)replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection$ReplaceWithCollectionsFillFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection$ReplaceWithCollectionsFillFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    static class RemoveExcessiveLambdaFix
    extends PsiUpdateModCommandQuickFix {
        private final LambdaAndExplicitMethodPair myInfo;
        private final String myName;

        RemoveExcessiveLambdaFix(LambdaAndExplicitMethodPair info, String name) {
            this.myInfo = info;
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.excessive.lambda.fix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.excessive.lambda.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Context context;
            if (project == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                RemoveExcessiveLambdaFix.$$$reportNull$$$0(4);
            }
            if ((context = Context.from(element)) == null) {
                return;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)context.myCall, (String)this.myInfo.getExplicitMethodName(context.myCall));
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)context.myLambda, ct.text(context.myBody));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection$RemoveExcessiveLambdaFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/ExcessiveLambdaUsageInspection$RemoveExcessiveLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

