/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FileModifier.SafeTypeForPreview
class LambdaAndExplicitMethodPair {
    static final LambdaAndExplicitMethodPair[] INFOS = new LambdaAndExplicitMethodPair[]{new LambdaAndExplicitMethodPair("java.util.Map", "computeIfAbsent", "putIfAbsent", 1, "V", new String[]{"k"}){

        @Override
        boolean isLambdaCall(PsiMethodCallExpression lambdaCall, PsiLambdaExpression lambda) {
            return ExpressionUtils.isVoidContext((PsiExpression)lambdaCall) && super.isLambdaCall(lambdaCall, lambda) && DfaUtil.inferLambdaNullability((PsiLambdaExpression)lambda) == Nullability.NOT_NULL;
        }

        @Override
        PsiExpression getLambdaCandidateFromExplicitCall(PsiMethodCallExpression explicitCall) {
            if (!ExpressionUtils.isVoidContext((PsiExpression)explicitCall)) {
                return null;
            }
            PsiExpression expr = super.getLambdaCandidateFromExplicitCall(explicitCall);
            if (expr != null && NullabilityUtil.getExpressionNullability((PsiExpression)expr, (boolean)true) != Nullability.NOT_NULL) {
                return null;
            }
            return expr;
        }
    }, new LambdaAndExplicitMethodPair("java.util.Optional", "orElseGet", "orElse", 0, "T", new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalInt", "orElseGet", "orElse", 0, "int", new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalLong", "orElseGet", "orElse", 0, "long", new String[0]), new LambdaAndExplicitMethodPair("java.util.OptionalDouble", "orElseGet", "orElse", 0, "double", new String[0]), new LambdaAndExplicitMethodPair("com.google.common.base.Optional", "or", "*", 0, "T", new String[0]), new LambdaAndExplicitMethodPair("java.util.Objects", "requireNonNull", "*", 1, "java.lang.String", new String[0]), new LambdaAndExplicitMethodPair("java.util.Objects", "requireNonNullElseGet", "requireNonNullElse", 1, "T", new String[0]), new LambdaAndExplicitMethodPair("org.junit.jupiter.api.Assertions", "assert(?!Timeout).*|fail", "*", -1, "java.lang.String", new String[0]), new LambdaAndExplicitMethodPair("org.junit.jupiter.api.Assertions", "assert(True|False)", "*", 0, "java.lang.String", new String[0]), new LambdaAndExplicitMethodPair("java.util.Arrays", "setAll", "fill", 1, null, "i")};
    @NotNull
    private final String myClass;
    @NotNull
    private final Pattern myLambdaMethod;
    @NotNull
    private final String myExplicitMethod;
    private final int myParameterIndex;
    @Nullable
    private final String myExplicitParameterType;
    private final String @NotNull [] myDefaultLambdaParameters;

    LambdaAndExplicitMethodPair(@NotNull String aClass, @NotNull @RegExp String lambdaMethod, @NotNull String explicitMethod, int index, @Nullable String explicitParameterType, String ... defaultLambdaParameters) {
        if (aClass == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(0);
        }
        if (lambdaMethod == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(1);
        }
        if (explicitMethod == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(2);
        }
        if (defaultLambdaParameters == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(3);
        }
        this.myClass = aClass;
        this.myLambdaMethod = Pattern.compile(lambdaMethod);
        this.myExplicitMethod = explicitMethod;
        this.myParameterIndex = index;
        this.myExplicitParameterType = explicitParameterType;
        this.myDefaultLambdaParameters = defaultLambdaParameters.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : defaultLambdaParameters;
    }

    boolean isLambdaCall(PsiMethodCallExpression lambdaCall, PsiLambdaExpression lambda) {
        int index;
        String name = lambdaCall.getMethodExpression().getReferenceName();
        if (name == null || !this.myLambdaMethod.matcher(name).matches()) {
            return false;
        }
        PsiExpression[] args = lambdaCall.getArgumentList().getExpressions();
        if (args.length == 0) {
            return false;
        }
        int n = index = this.myParameterIndex == -1 ? args.length - 1 : this.myParameterIndex;
        if (args.length <= index || args[index] != lambda) {
            return false;
        }
        PsiMethod method = lambdaCall.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length <= index) {
            return false;
        }
        PsiClass fnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameters[index].getType());
        return fnClass != null && LambdaUtil.getFunction((PsiClass)fnClass) != null && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (boolean)false, (String)this.myClass);
    }

    PsiExpression getLambdaCandidateFromExplicitCall(PsiMethodCallExpression explicitCall) {
        int index;
        if (this.myExplicitParameterType == null) {
            return null;
        }
        String name = explicitCall.getMethodExpression().getReferenceName();
        if (name == null) {
            return null;
        }
        if (this.myExplicitMethod.equals("*") ? !this.myLambdaMethod.matcher(name).matches() : !this.myExplicitMethod.equals(name)) {
            return null;
        }
        PsiExpression[] args = explicitCall.getArgumentList().getExpressions();
        if (args.length == 0) {
            return null;
        }
        int n = index = this.myParameterIndex == -1 ? args.length - 1 : this.myParameterIndex;
        if (args.length <= index) {
            return null;
        }
        PsiExpression arg = args[index];
        if (arg instanceof PsiFunctionalExpression) {
            return null;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)arg)) {
            return null;
        }
        PsiMethod method = explicitCall.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length <= index) {
            return null;
        }
        PsiType type = parameters[index].getType();
        if (!type.equalsToText(this.myExplicitParameterType)) {
            return null;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (boolean)false, (String)this.myClass)) {
            return null;
        }
        return arg;
    }

    public String getExplicitMethodName(PsiMethodCallExpression lambdaCall) {
        if (this.myExplicitMethod.equals("*")) {
            return lambdaCall.getMethodExpression().getReferenceName();
        }
        return this.myExplicitMethod;
    }

    public String getLambdaMethodName(PsiMethodCallExpression explicitCall) {
        if (this.myExplicitMethod.equals("*")) {
            return explicitCall.getMethodExpression().getReferenceName();
        }
        return this.myLambdaMethod.pattern();
    }

    @NotNull
    public String makeLambda(@NotNull PsiExpression expression) {
        if (expression == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(4);
        }
        if (this.myDefaultLambdaParameters.length == 0) {
            String string = "()->" + expression.getText();
            if (string == null) {
                LambdaAndExplicitMethodPair.$$$reportNull$$$0(5);
            }
            return string;
        }
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)expression.getProject());
        Object params = StreamEx.of((Object[])this.myDefaultLambdaParameters).map(param -> manager.suggestUniqueVariableName(param, (PsiElement)expression, true)).joining((CharSequence)",");
        if (this.myDefaultLambdaParameters.length != 1) {
            params = "(" + (String)params + ")";
        }
        String string = (String)params + "->" + expression.getText();
        if (string == null) {
            LambdaAndExplicitMethodPair.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLambdaParameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/LambdaAndExplicitMethodPair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/LambdaAndExplicitMethodPair";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeLambda";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "makeLambda";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

