/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.ChangeTypeSignatureHandlerBase;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RawUseOfParameterizedTypeInspection
extends BaseInspection {
    public boolean ignoreObjectConstruction = false;
    public boolean ignoreTypeCasts = false;
    public boolean ignoreUncompilable = true;
    public boolean ignoreParametersOfOverridingMethods = false;
    public boolean ignoreWhenQuickFixNotAvailable = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "rawtypes";
    }

    @NotNull
    public String getAlternativeID() {
        return "RawUseOfParameterized";
    }

    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = JavaBundle.message((String)"inspection.raw.use.of.parameterized.type.problem.descriptor", (Object[])new Object[0]);
        if (string == null) {
            RawUseOfParameterizedTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreObjectConstruction", (String)JavaBundle.message((String)"raw.use.of.parameterized.type.ignore.new.objects.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreTypeCasts", (String)JavaBundle.message((String)"raw.use.of.parameterized.type.ignore.type.casts.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreUncompilable", (String)JavaBundle.message((String)"raw.use.of.parameterized.type.ignore.uncompilable.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreParametersOfOverridingMethods", (String)JavaBundle.message((String)"raw.use.of.parameterized.type.ignore.overridden.parameter.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreWhenQuickFixNotAvailable", (String)JavaBundle.message((String)"raw.use.of.parameterized.type.ignore.quickfix.not.available.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RawUseOfParameterizedTypeInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.GENERICS);
        if (set == null) {
            RawUseOfParameterizedTypeInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    protected LocalQuickFix buildFix(Object ... infos) {
        return (LocalQuickFix)infos[0];
    }

    @Nullable
    private static LocalQuickFix createFix(PsiElement target) {
        PsiVariable variable;
        PsiType type;
        PsiElement psiElement;
        if (target instanceof PsiTypeElement && (psiElement = target.getParent()) instanceof PsiVariable && (type = RawUseOfParameterizedTypeInspection.getSuggestedType(variable = (PsiVariable)psiElement)) != null) {
            String typeText = GenericsUtil.getVariableTypeByExpressionType((PsiType)type).getPresentableText();
            String message = JavaBundle.message((String)"raw.variable.type.can.be.generic.quickfix", (Object[])new Object[]{variable.getName(), typeText});
            return new RawTypeCanBeGenericFix(message);
        }
        if (target instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)target;
            PsiElement parent = target.getParent();
            if (parent instanceof PsiTypeElement) {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiReferenceParameterList params = ref.getParameterList();
                if (params != null && !params.textMatches((CharSequence)"")) {
                    return null;
                }
                PsiTypeCastExpression cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)typeElement.getParent(), PsiTypeCastExpression.class);
                if (cast == null) {
                    return null;
                }
                if (!RawUseOfParameterizedTypeInspection.canUseUpperBound(cast)) {
                    return null;
                }
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)cast.getType());
                if (psiClass == null) {
                    return null;
                }
                int count = psiClass.getTypeParameters().length;
                return new CastQuickFix(typeElement.getText() + StreamEx.constant((Object)"?", (long)count).joining((CharSequence)",", (CharSequence)"<", (CharSequence)">"));
            }
            if (parent instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)parent;
                if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.DIAMOND_TYPES, (PsiElement)parent)) {
                    return null;
                }
                if (newExpression.isArrayCreation() || newExpression.getAnonymousClass() != null) {
                    return null;
                }
                PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)newExpression, (boolean)false);
                if (expectedType == null || expectedType.equals(PsiTypes.nullType()) || expectedType instanceof PsiClassType && ((PsiClassType)expectedType).isRaw()) {
                    return null;
                }
                PsiNewExpression copy = (PsiNewExpression)LambdaUtil.copyWithExpectedType((PsiElement)parent, (PsiType)expectedType);
                PsiJavaCodeReferenceElement reference = copy.getClassReference();
                if (reference == null) {
                    return null;
                }
                PsiReferenceParameterList parameterList = reference.getParameterList();
                if (parameterList == null || !parameterList.textMatches((CharSequence)"")) {
                    return null;
                }
                parameterList.replace(PsiDiamondTypeUtil.createExplicitReplacement((PsiElement)parameterList));
                JavaResolveResult resolveResult = copy.resolveMethodGenerics();
                if (!resolveResult.isValidResult()) {
                    return null;
                }
                PsiType diamondType = copy.getType();
                if (diamondType == null || !expectedType.isAssignableFrom(diamondType)) {
                    return null;
                }
                return new UseDiamondFix();
            }
        }
        return null;
    }

    private static boolean canUseUpperBound(PsiTypeCastExpression cast) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)cast.getType());
        if (psiClass == null) {
            return false;
        }
        Set<PsiTypeParameter> parameters = Set.of(psiClass.getTypeParameters());
        if (parameters.isEmpty()) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)cast.getParent());
        if (parent instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)parent;
            PsiElement target = ref.resolve();
            if (!(target instanceof PsiMember)) {
                return false;
            }
            PsiClass containingClass = ((PsiMember)target).getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (target instanceof PsiField) {
                PsiType type = substitutor.substitute(((PsiField)target).getType());
                PsiClass varType = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                return varType instanceof PsiTypeParameter && parameters.contains(varType) && !PsiUtil.isAccessedForWriting((PsiExpression)ref) || !PsiTypesUtil.mentionsTypeParameters((PsiType)type, parameters);
            }
            if (target instanceof PsiMethod) {
                PsiType type;
                PsiClass varType;
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getParent(), PsiMethodCallExpression.class);
                if (call == null) {
                    return false;
                }
                if (!(ExpressionUtils.isVoidContext((PsiExpression)call) || (varType = PsiUtil.resolveClassInClassTypeOnly((PsiType)(type = substitutor.substitute(((PsiMethod)target).getReturnType())))) instanceof PsiTypeParameter && parameters.contains(varType) || !PsiTypesUtil.mentionsTypeParameters((PsiType)type, parameters))) {
                    return false;
                }
                PsiParameterList parameterList = ((PsiMethod)target).getParameterList();
                for (PsiParameter parameter : parameterList.getParameters()) {
                    PsiType parameterType;
                    if (parameter.isVarArgs() && call.getArgumentList().getExpressionCount() == parameterList.getParametersCount() - 1 || !PsiTypesUtil.mentionsTypeParameters((PsiType)(parameterType = parameter.getType()), (Predicate)Predicates.alwaysTrue())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new RawUseOfParameterizedTypeVisitor();
    }

    @Nullable
    private static PsiType getSuggestedType(@NotNull PsiVariable variable) {
        PsiExpression initializer;
        if (variable == null) {
            RawUseOfParameterizedTypeInspection.$$$reportNull$$$0(3);
        }
        if ((initializer = variable.getInitializer()) == null) {
            return null;
        }
        PsiType variableType = variable.getType();
        PsiType initializerType = initializer.getType();
        if (!(variableType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType variableClassType = (PsiClassType)variableType;
        if (!variableClassType.isRaw()) {
            return null;
        }
        if (!(initializerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType initializerClassType = (PsiClassType)initializerType;
        if (initializerClassType.isRaw()) {
            return null;
        }
        PsiClassType.ClassResolveResult variableResolveResult = variableClassType.resolveGenerics();
        PsiClassType.ClassResolveResult initializerResolveResult = initializerClassType.resolveGenerics();
        if (initializerResolveResult.getElement() == null) {
            return null;
        }
        PsiClass variableResolved = variableResolveResult.getElement();
        if (variableResolved == null) {
            return null;
        }
        PsiSubstitutor targetSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)variableResolved, (PsiClass)initializerResolveResult.getElement(), (PsiSubstitutor)initializerResolveResult.getSubstitutor());
        if (targetSubstitutor == null) {
            return null;
        }
        PsiClassType type = JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType(variableResolved, targetSubstitutor);
        if (variableType.equals(type)) {
            return null;
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static class RawTypeCanBeGenericFix
    implements LocalQuickFix {
        @IntentionName
        private final String myName;

        RawTypeCanBeGenericFix(@NotNull @IntentionName String name) {
            if (name == null) {
                RawTypeCanBeGenericFix.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                RawTypeCanBeGenericFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"raw.variable.type.can.be.generic.family.quickfix", (Object[])new Object[0]);
            if (string == null) {
                RawTypeCanBeGenericFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiVariable variable;
            PsiType type;
            PsiElement problemElement;
            if (project == null) {
                RawTypeCanBeGenericFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                RawTypeCanBeGenericFix.$$$reportNull$$$0(4);
            }
            if ((problemElement = descriptor.getPsiElement()) == null || !problemElement.isValid()) {
                return;
            }
            PsiElement element = descriptor.getStartElement().getParent();
            if (element instanceof PsiVariable && (type = RawUseOfParameterizedTypeInspection.getSuggestedType(variable = (PsiVariable)element)) != null) {
                ChangeTypeSignatureHandlerBase handler = CommonJavaRefactoringUtil.getRefactoringSupport().getChangeTypeSignatureHandler();
                handler.runHighlightingTypeMigrationSilently(project, null, PsiSearchHelper.getInstance((Project)project).getUseScope((PsiElement)variable), (PsiElement)variable, type);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection$RawTypeCanBeGenericFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection$RawTypeCanBeGenericFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class CastQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myTargetType;

        private CastQuickFix(String type) {
            this.myTargetType = type;
        }

        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"raw.variable.type.can.be.generic.cast.quickfix", (Object[])new Object[]{this.myTargetType});
            if (string == null) {
                CastQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"raw.variable.type.can.be.generic.cast.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                CastQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiTypeElement cast;
            if (project == null) {
                CastQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                CastQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CastQuickFix.$$$reportNull$$$0(4);
            }
            if ((cast = (PsiTypeElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{PsiTypeElement.class})) == null) {
                return;
            }
            CodeStyleManager.getInstance((Project)project).reformat(new CommentTracker().replace((PsiElement)cast, this.myTargetType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection$CastQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection$CastQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UseDiamondFix
    extends PsiUpdateModCommandQuickFix
    implements HighPriorityAction {
        private UseDiamondFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.insert.x", (Object[])new Object[]{"<>"});
            if (string == null) {
                UseDiamondFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiJavaCodeReferenceElement element;
            if (project == null) {
                UseDiamondFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                UseDiamondFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UseDiamondFix.$$$reportNull$$$0(3);
            }
            if ((element = (PsiJavaCodeReferenceElement)ObjectUtils.tryCast((Object)startElement, PsiJavaCodeReferenceElement.class)) == null) {
                return;
            }
            PsiReferenceParameterList parameterList = element.getParameterList();
            if (parameterList == null) {
                return;
            }
            RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)parameterList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection$UseDiamondFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection$UseDiamondFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class RawUseOfParameterizedTypeVisitor
    extends BaseInspectionVisitor {
        private RawUseOfParameterizedTypeVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                RawUseOfParameterizedTypeVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            if (RawUseOfParameterizedTypeInspection.this.ignoreObjectConstruction) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && expression.isArrayCreation()) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
            this.checkReferenceElement(classReference);
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            PsiParameter parameter;
            PsiElement declarationScope;
            PsiAnnotationMemberValue defaultValue;
            PsiType parentType;
            PsiElement directParent;
            if (typeElement == null) {
                RawUseOfParameterizedTypeVisitor.$$$reportNull$$$0(1);
            }
            if ((directParent = typeElement.getParent()) instanceof PsiVariable && RawUseOfParameterizedTypeInspection.getSuggestedType((PsiVariable)directParent) != null) {
                this.reportProblem((PsiElement)typeElement);
                return;
            }
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            super.visitTypeElement(typeElement);
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && directParent instanceof PsiTypeElement && (parentType = ((PsiTypeElement)directParent).getType()) instanceof PsiArrayType && PsiTreeUtil.skipParentsOfType((PsiElement)directParent, (Class[])new Class[]{PsiTypeElement.class}) instanceof PsiMethodReferenceExpression) {
                return;
            }
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class, PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class});
            if (parent instanceof PsiInstanceOfExpression || parent instanceof PsiClassObjectAccessExpression || parent instanceof PsiDeconstructionPattern) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreTypeCasts && parent instanceof PsiTypeCastExpression) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiComment.class) != null) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && parent instanceof PsiAnnotationMethod && (defaultValue = ((PsiAnnotationMethod)parent).getDefaultValue()) != null && directParent instanceof PsiTypeElement) {
                return;
            }
            if (parent instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)parent).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)declarationScope;
                if (RawUseOfParameterizedTypeInspection.this.ignoreParametersOfOverridingMethods ? MethodUtils.getSuper((PsiMethod)method) != null || MethodCallUtils.isUsedAsSuperConstructorCallArgument((PsiParameter)parameter, (boolean)false) : RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && (LibraryUtil.isOverrideOfLibraryMethod((PsiMethod)method) || MethodCallUtils.isUsedAsSuperConstructorCallArgument((PsiParameter)parameter, (boolean)true))) {
                    return;
                }
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            this.checkReferenceElement(referenceElement);
        }

        private void reportProblem(@NotNull PsiElement element) {
            LocalQuickFix fix;
            if (element == null) {
                RawUseOfParameterizedTypeVisitor.$$$reportNull$$$0(2);
            }
            if ((fix = RawUseOfParameterizedTypeInspection.createFix(element)) == null && RawUseOfParameterizedTypeInspection.this.ignoreWhenQuickFixNotAvailable) {
                return;
            }
            this.registerError(element, new Object[]{fix});
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                RawUseOfParameterizedTypeVisitor.$$$reportNull$$$0(3);
            }
            super.visitReferenceElement(reference);
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)referenceParent;
            PsiElement listParent = referenceList.getParent();
            if (!(listParent instanceof PsiClass)) {
                return;
            }
            if (referenceList.equals((Object)((PsiClass)listParent).getPermitsList())) {
                return;
            }
            this.checkReferenceElement(reference);
        }

        private void checkReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                return;
            }
            PsiType[] typeParameters = reference.getTypeParameters();
            if (typeParameters.length > 0) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            PsiElement qualifier = reference.getQualifier();
            if (qualifier instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement qualifierReference = (PsiJavaCodeReferenceElement)qualifier;
                if (!(aClass.hasModifierProperty("static") || aClass.isInterface() || aClass.isEnum())) {
                    this.checkReferenceElement(qualifierReference);
                }
            }
            if (!aClass.hasTypeParameters()) {
                return;
            }
            this.reportProblem((PsiElement)reference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RawUseOfParameterizedTypeInspection$RawUseOfParameterizedTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportProblem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

