/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RedundantArrayForVarargsCallInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(0);
        }
        return new RedundantArrayForVarargVisitor(holder);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.verbose.or.redundant.code.constructs", (Object[])new Object[0]);
        if (string == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "RedundantArrayCreation";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class RedundantArrayForVarargVisitor
    extends JavaElementVisitor {
        private static final String[] LOGGER_NAMES = new String[]{"debug", "error", "info", "trace", "warn"};
        private static final CallMatcher LOGGER_MESSAGE_CALL = CallMatcher.exactInstanceCall((String)"org.slf4j.Logger", (String[])LOGGER_NAMES).parameterTypes(new String[]{String.class.getName(), "java.lang.Object..."});
        private static final LocalQuickFix redundantArrayForVarargsCallFixAction = new RedundantArrayForVarargsCallFix();
        @NotNull
        private final ProblemsHolder myHolder;

        private RedundantArrayForVarargVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitCallExpression(@NotNull PsiCallExpression expression) {
            if (expression == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(1);
            }
            super.visitCallExpression(expression);
            this.checkCall((PsiCall)expression);
        }

        public void visitEnumConstant(@NotNull PsiEnumConstant expression) {
            if (expression == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(2);
            }
            super.visitEnumConstant(expression);
            this.checkCall((PsiCall)expression);
        }

        private void checkCall(PsiCall expression) {
            PsiExpression[] initializers = CommonJavaRefactoringUtil.getArrayInitializersToFlattenInVarargs((PsiCall)expression);
            if (initializers == null) {
                return;
            }
            if (!(expression instanceof PsiExpression && LOGGER_MESSAGE_CALL.matches((PsiExpression)expression) || CommonJavaRefactoringUtil.isSafeToFlattenToVarargsCall((PsiCall)expression, (PsiExpression[])initializers))) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = Objects.requireNonNull(argumentList).getExpressions();
            PsiExpression arrayCreation = Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)args[args.length - 1]));
            if (!(arrayCreation instanceof PsiNewExpression)) {
                return;
            }
            String message = JavaBundle.message((String)"inspection.redundant.array.creation.for.varargs.call.descriptor", (Object[])new Object[0]);
            PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)arrayCreation).getArrayInitializer();
            if (arrayInitializer == null) {
                this.myHolder.registerProblem((PsiElement)arrayCreation, message, new LocalQuickFix[]{redundantArrayForVarargsCallFixAction});
            } else {
                this.myHolder.registerProblem((PsiElement)arrayCreation, new TextRange(0, arrayInitializer.getStartOffsetInParent()), message, new LocalQuickFix[]{redundantArrayForVarargsCallFixAction});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$RedundantArrayForVarargVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnumConstant";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class RedundantArrayForVarargsCallFix
        extends PsiUpdateModCommandQuickFix {
            private RedundantArrayForVarargsCallFix() {
            }

            protected void applyFix(@NotNull Project project, @NotNull PsiElement arrayCreation, @NotNull ModPsiUpdater updater) {
                if (project == null) {
                    RedundantArrayForVarargsCallFix.$$$reportNull$$$0(0);
                }
                if (arrayCreation == null) {
                    RedundantArrayForVarargsCallFix.$$$reportNull$$$0(1);
                }
                if (updater == null) {
                    RedundantArrayForVarargsCallFix.$$$reportNull$$$0(2);
                }
                if (!(arrayCreation instanceof PsiNewExpression)) {
                    return;
                }
                PsiNewExpression newExpression = (PsiNewExpression)arrayCreation;
                CommonJavaRefactoringUtil.inlineArrayCreationForVarargs((PsiNewExpression)newExpression);
            }

            @NotNull
            public String getFamilyName() {
                String string = JavaBundle.message((String)"inspection.redundant.array.creation.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    RedundantArrayForVarargsCallFix.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayCreation";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$RedundantArrayForVarargVisitor$RedundantArrayForVarargsCallFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$RedundantArrayForVarargVisitor$RedundantArrayForVarargsCallFix";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }
}

