/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.numeric.ConvertNumericLiteralQuickFix;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.NotNull;

public final class RemoveLiteralUnderscoresInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RemoveLiteralUnderscoresInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.UNDERSCORES, (PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RemoveLiteralUnderscoresInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression literalExpression) {
                if (literalExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiType type = literalExpression.getType();
                if (!(PsiTypes.intType().equals((Object)type) || PsiTypes.longType().equals((Object)type) || PsiTypes.floatType().equals((Object)type) || PsiTypes.doubleType().equals((Object)type))) {
                    return;
                }
                String text = literalExpression.getText();
                if (text == null || !text.contains("_")) {
                    return;
                }
                String converted = LiteralFormatUtil.removeUnderscores((String)text);
                if (converted.length() == text.length()) {
                    return;
                }
                String displayMessage = JavaBundle.message((String)"inspection.remove.literal.underscores.display.name", (Object[])new Object[0]);
                String familyName = JavaBundle.message((String)"inspection.remove.literal.underscores.family.name", (Object[])new Object[0]);
                String actionText = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{text, converted});
                ConvertNumericLiteralQuickFix quickFix = new ConvertNumericLiteralQuickFix(converted, actionText, familyName);
                holder.registerProblem((PsiElement)literalExpression, displayMessage, new LocalQuickFix[]{quickFix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/codeInspection/numeric/RemoveLiteralUnderscoresInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/numeric/RemoveLiteralUnderscoresInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/numeric/RemoveLiteralUnderscoresInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

