/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.preview;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.java.codeserver.core.JavaPreviewFeatureUtil;
import com.intellij.openapi.module.JdkApiCompatibilityService;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class PreviewFeatureInspection
extends LocalInspectionTool {
    @NotNull
    public String getID() {
        return "preview";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PreviewFeatureInspection.$$$reportNull$$$0(0);
        }
        final LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)holder.getFile());
        final boolean preview = level.isPreview();
        return new PsiElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                PsiJavaCodeReferenceElement refElement;
                PsiElement resolved;
                JavaPreviewFeatureUtil.PreviewFeatureUsage usage;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((usage = JavaPreviewFeatureUtil.getPreviewFeatureUsage((PsiElement)element)) != null) {
                    PsiReferenceExpression ref;
                    PsiElement nameElement;
                    if (!preview && !usage.isReflective()) {
                        return;
                    }
                    if (element.getParent() instanceof PsiImportStatementBase) {
                        return;
                    }
                    if (element instanceof PsiReferenceExpression && (nameElement = (ref = (PsiReferenceExpression)element).getReferenceNameElement()) != null) {
                        element = nameElement;
                    }
                    holder.registerProblem(element, usage.isReflective() ? JavaBundle.message((String)"preview.api.usage.reflective", (Object[])new Object[]{usage.targetName()}) : JavaBundle.message((String)"preview.api.usage", (Object[])new Object[]{usage.targetName()}), new LocalQuickFix[0]);
                } else if (element instanceof PsiJavaCodeReferenceElement && (resolved = (refElement = (PsiJavaCodeReferenceElement)element).resolve()) instanceof PsiMember) {
                    PsiMember owner = (PsiMember)resolved;
                    JdkApiCompatibilityService.LevelInfo info = JdkApiCompatibilityService.getInstance().firstCompatibleLanguageLevelInfo(owner, level);
                    if (info != null && info.outOfPreviewLevel() != null && level.isAtLeast(info.firstAppearLevel()) && level.isLessThan(info.outOfPreviewLevel())) {
                        Object object;
                        if (owner instanceof PsiClass) {
                            PsiClass cls = (PsiClass)owner;
                            object = cls.getQualifiedName();
                        } else {
                            object = Objects.requireNonNull(owner.getContainingClass()).getQualifiedName() + "#" + owner.getName();
                        }
                        String name = object;
                        holder.registerProblem(element, JavaBundle.message((String)"preview.api.usage.old.jdk", (Object[])new Object[]{name, level.feature()}), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/preview/PreviewFeatureInspection$1", "visitElement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/preview/PreviewFeatureInspection", "buildVisitor"));
    }
}

