/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaLangReflectHandleInvocationChecker;
import com.intellij.codeInspection.reflectiveAccess.JavaLangReflectVarHandleInvocationChecker;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JavaLangInvokeHandleSignatureInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Key<JavaReflectionReferenceUtil.ReflectiveSignature> DEFAULT_SIGNATURE = Key.create((String)"DEFAULT_SIGNATURE");
    public static final Key<List<LookupElement>> POSSIBLE_SIGNATURES = Key.create((String)"POSSIBLE_SIGNATURES");
    static final @Unmodifiable Set<String> KNOWN_METHOD_NAMES = ContainerUtil.union(Arrays.asList(JavaReflectionReferenceUtil.HANDLE_FACTORY_METHOD_NAMES), Collections.singletonList("findConstructor"));
    private static final CallChecker[] CALL_CHECKERS = new CallChecker[]{JavaLangInvokeHandleSignatureInspection::checkHandlerFactoryCall, JavaLangReflectHandleInvocationChecker::checkMethodHandleInvocation, JavaLangReflectVarHandleInvocationChecker::checkVarHandleAccess};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
                if (callExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(callExpression);
                for (CallChecker checker : CALL_CHECKERS) {
                    if (!checker.checkCall(callExpression, holder)) continue;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static boolean checkHandlerFactoryCall(@NotNull PsiMethodCallExpression callExpression, @NotNull ProblemsHolder holder) {
        PsiReferenceExpression methodExpression;
        String methodName;
        if (callExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(2);
        }
        if ((methodName = (methodExpression = callExpression.getMethodExpression()).getReferenceName()) != null && KNOWN_METHOD_NAMES.contains(methodName)) {
            PsiMethod method = callExpression.resolveMethod();
            if (method != null && JavaReflectionReferenceUtil.isClassWithName((PsiClass)method.getContainingClass(), (String)"java.lang.invoke.MethodHandles.Lookup")) {
                PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
                JavaLangInvokeHandleSignatureInspection.checkHandleFactory(methodName, methodExpression, arguments, holder);
            }
            return true;
        }
        if (JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)callExpression, (String)"java.lang.invoke.MethodHandles", (String)"arrayElementVarHandle")) {
            JavaLangInvokeHandleSignatureInspection.checkArrayElementVarHandle(callExpression, holder);
            return true;
        }
        return false;
    }

    private static void checkHandleFactory(@NotNull String factoryMethodName, @NotNull PsiReferenceExpression factoryMethodExpression, PsiExpression @NotNull [] arguments, @NotNull ProblemsHolder holder) {
        PsiExpression nameExpression;
        PsiExpression nameDefinition;
        String memberName;
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        if (factoryMethodName == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(3);
        }
        if (factoryMethodExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(5);
        }
        if (arguments == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(6);
        }
        if (arguments.length == 2) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass2;
            if ("findConstructor".equals(factoryMethodName) && (ownerClass2 = JavaReflectionReferenceUtil.getReflectiveClass((PsiExpression)arguments[0])) != null) {
                PsiExpression typeExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[1]);
                if (typeExpression == null) {
                    return;
                }
                JavaLangInvokeHandleSignatureInspection.checkConstructor(ownerClass2, typeExpression, holder);
            }
        } else if (arguments.length >= 3 && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass((PsiExpression)arguments[0])) != null && !StringUtil.isEmpty((String)(memberName = (String)JavaReflectionReferenceUtil.computeConstantExpression((PsiExpression)(nameDefinition = JavaReflectionReferenceUtil.findDefinition((PsiExpression)(nameExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[1])))), String.class)))) {
            PsiExpression typeExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[2]);
            if (typeExpression == null) {
                return;
            }
            switch (factoryMethodName) {
                case "findGetter": 
                case "findSetter": 
                case "findVarHandle": {
                    JavaLangInvokeHandleSignatureInspection.checkField(ownerClass, memberName, nameExpression, typeExpression, false, factoryMethodExpression, holder);
                    break;
                }
                case "findStaticGetter": 
                case "findStaticSetter": 
                case "findStaticVarHandle": {
                    JavaLangInvokeHandleSignatureInspection.checkField(ownerClass, memberName, nameExpression, typeExpression, true, factoryMethodExpression, holder);
                    break;
                }
                case "findVirtual": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, false, true, factoryMethodExpression, holder);
                    break;
                }
                case "findStatic": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, true, true, factoryMethodExpression, holder);
                    break;
                }
                case "findSpecial": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, false, false, factoryMethodExpression, holder);
                    if (arguments.length <= 3) break;
                    JavaLangInvokeHandleSignatureInspection.checkSpecial(ownerClass, arguments[3], holder);
                }
            }
        }
    }

    private static void checkConstructor(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull PsiExpression constructorTypeExpression, @NotNull ProblemsHolder holder) {
        if (ownerClass == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(7);
        }
        if (constructorTypeExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(9);
        }
        if (!ownerClass.isExact()) {
            return;
        }
        JavaReflectionReferenceUtil.ReflectiveSignature constructorSignature = JavaReflectionReferenceUtil.composeMethodSignature((PsiExpression)constructorTypeExpression);
        if (constructorSignature != null) {
            String declarationText;
            List constructors = ContainerUtil.filter((Object[])ownerClass.getPsiClass().getMethods(), PsiMethod::isConstructor);
            List<Object> validSignatures = null;
            if (constructors.isEmpty()) {
                if (!constructorSignature.equals((Object)JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE)) {
                    validSignatures = Collections.singletonList(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE);
                }
            } else if (JavaLangInvokeHandleSignatureInspection.findMethodBySignature(constructors, constructorSignature).isEmpty()) {
                validSignatures = constructors.stream().map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (validSignatures != null && (declarationText = JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(ownerClass, constructorSignature)) != null) {
                LocalQuickFix fix = null;
                String ownerClassName = ownerClass.getPsiClass().getName();
                if (ownerClassName != null) {
                    fix = ReplaceSignatureQuickFix.createFix((PsiElement)constructorTypeExpression, ownerClassName, validSignatures, true, holder.isOnTheFly());
                }
                holder.registerProblem((PsiElement)constructorTypeExpression, JavaErrorBundle.message((String)"cannot.resolve.constructor", (Object[])new Object[]{declarationText}), LocalQuickFix.notNullElements((LocalQuickFix)fix));
            }
        }
    }

    private static void checkField(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull String fieldName, @NotNull PsiExpression fieldNameExpression, @NotNull PsiExpression fieldTypeExpression, boolean isStaticExpected, @NotNull PsiReferenceExpression factoryMethodExpression, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveType reflectiveType;
        if (ownerClass == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(11);
        }
        if (fieldNameExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(12);
        }
        if (fieldTypeExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(13);
        }
        if (factoryMethodExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(15);
        }
        if (!ownerClass.isExact()) {
            return;
        }
        PsiField field = ownerClass.getPsiClass().findFieldByName(fieldName, true);
        if (field == null) {
            holder.registerProblem((PsiElement)fieldNameExpression, JavaBundle.message((String)"inspection.handle.signature.field.cannot.resolve", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
            return;
        }
        if (field.hasModifierProperty("static") != isStaticExpected) {
            String factoryMethodName = factoryMethodExpression.getReferenceName();
            PsiElement factoryMethodNameElement = factoryMethodExpression.getReferenceNameElement();
            if (factoryMethodName != null && factoryMethodNameElement != null) {
                LocalQuickFix fix = SwitchStaticnessQuickFix.createFix(factoryMethodName, isStaticExpected);
                String message = JavaBundle.message((String)(isStaticExpected ? "inspection.handle.signature.field.not.static" : "inspection.handle.signature.field.static"), (Object[])new Object[]{fieldName});
                holder.registerProblem(factoryMethodNameElement, message, LocalQuickFix.notNullElements((LocalQuickFix)fix));
                return;
            }
        }
        if ((reflectiveType = JavaReflectionReferenceUtil.getReflectiveType((PsiExpression)fieldTypeExpression)) != null && !reflectiveType.isEqualTo(field.getType())) {
            String expectedTypeText = JavaReflectionReferenceUtil.getTypeText((PsiType)field.getType());
            String message = JavaBundle.message((String)"inspection.handle.signature.field.type", (Object[])new Object[]{fieldName, expectedTypeText});
            holder.registerProblem((PsiElement)fieldTypeExpression, message, new LocalQuickFix[]{new FieldTypeQuickFix(expectedTypeText)});
        }
    }

    private static void checkMethod(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull String methodName, @NotNull PsiExpression methodNameExpression, @NotNull PsiExpression methodTypeExpression, boolean isStaticExpected, boolean isAbstractAllowed, @NotNull PsiReferenceExpression factoryMethodExpression, @NotNull ProblemsHolder holder) {
        String className;
        boolean allAbstract;
        PsiMethod onlyMethod;
        if (ownerClass == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(16);
        }
        if (methodName == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(17);
        }
        if (methodNameExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(18);
        }
        if (methodTypeExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(19);
        }
        if (factoryMethodExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(20);
        }
        if (holder == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(21);
        }
        if (!ownerClass.isExact()) {
            return;
        }
        Object[] methods = ownerClass.getPsiClass().findMethodsByName(methodName, true);
        if (methods.length == 0) {
            holder.registerProblem((PsiElement)methodNameExpression, JavaErrorBundle.message((String)"cannot.resolve.method", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
            return;
        }
        List filteredMethods = ContainerUtil.filter((Object[])methods, method -> method.hasModifierProperty("static") == isStaticExpected);
        if (filteredMethods.isEmpty()) {
            String factoryMethodName = factoryMethodExpression.getReferenceName();
            PsiElement factoryMethodNameElement = factoryMethodExpression.getReferenceNameElement();
            if (factoryMethodName != null && factoryMethodNameElement != null) {
                LocalQuickFix fix = SwitchStaticnessQuickFix.createFix(factoryMethodName, isStaticExpected);
                String message = JavaBundle.message((String)(isStaticExpected ? "inspection.handle.signature.method.not.static" : "inspection.handle.signature.method.static"), (Object[])new Object[]{methodName});
                holder.registerProblem(factoryMethodNameElement, message, LocalQuickFix.notNullElements((LocalQuickFix)fix));
                return;
            }
        }
        if ((onlyMethod = (PsiMethod)ContainerUtil.getOnlyItem((Collection)filteredMethods)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)onlyMethod, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
            return;
        }
        JavaReflectionReferenceUtil.ReflectiveSignature methodSignature = JavaReflectionReferenceUtil.composeMethodSignature((PsiExpression)methodTypeExpression);
        if (methodSignature == null) {
            return;
        }
        List<PsiMethod> matchingMethods = JavaLangInvokeHandleSignatureInspection.findMethodBySignature(filteredMethods, methodSignature);
        if (matchingMethods.isEmpty()) {
            String declarationText = JavaLangInvokeHandleSignatureInspection.getMethodDeclarationText(methodName, methodSignature);
            List<JavaReflectionReferenceUtil.ReflectiveSignature> validSignatures = filteredMethods.stream().map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).collect(Collectors.toList());
            LocalQuickFix fix = ReplaceSignatureQuickFix.createFix((PsiElement)methodTypeExpression, methodName, validSignatures, false, holder.isOnTheFly());
            holder.registerProblem((PsiElement)methodTypeExpression, JavaErrorBundle.message((String)"cannot.resolve.method", (Object[])new Object[]{declarationText}), LocalQuickFix.notNullElements((LocalQuickFix)fix));
            return;
        }
        if (!isAbstractAllowed && (allAbstract = ContainerUtil.and(matchingMethods, method -> method.hasModifierProperty("abstract"))) && (className = ownerClass.getPsiClass().getQualifiedName()) != null) {
            holder.registerProblem((PsiElement)methodNameExpression, JavaBundle.message((String)"inspection.handle.signature.method.abstract", (Object[])new Object[]{methodName, className}), new LocalQuickFix[0]);
        }
    }

    private static void checkSpecial(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull PsiExpression callerClassExpression, @NotNull ProblemsHolder holder) {
        PsiClass owner;
        PsiClass caller;
        JavaReflectionReferenceUtil.ReflectiveClass callerClass;
        if (ownerClass == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(22);
        }
        if (callerClassExpression == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(23);
        }
        if (holder == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(24);
        }
        if ((callerClass = JavaReflectionReferenceUtil.getReflectiveClass((PsiExpression)callerClassExpression)) != null && callerClass.isExact() && !InheritanceUtil.isInheritorOrSelf((PsiClass)(caller = callerClass.getPsiClass()), (PsiClass)(owner = ownerClass.getPsiClass()), (boolean)true)) {
            String callerName = caller.getQualifiedName();
            String ownerName = owner.getQualifiedName();
            if (callerName != null && ownerName != null) {
                holder.registerProblem((PsiElement)callerClassExpression, JavaBundle.message((String)"inspection.handle.signature.not.subclass", (Object[])new Object[]{callerName, ownerName}), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkArrayElementVarHandle(PsiMethodCallExpression factoryCallExpression, ProblemsHolder holder) {
        String name;
        PsiExpressionList argumentList = factoryCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            holder.registerProblem((PsiElement)argumentList, JavaBundle.message((String)"inspection.reflection.invocation.argument.count", (Object[])new Object[]{1}), new LocalQuickFix[0]);
            return;
        }
        JavaReflectionReferenceUtil.ReflectiveType argumentType = JavaReflectionReferenceUtil.getReflectiveType((PsiExpression)arguments[0]);
        if (argumentType == null || argumentType.getType() instanceof PsiArrayType) {
            return;
        }
        if (!argumentType.isPrimitive() && !argumentType.isExact() && ("java.lang.Object".equals(name = argumentType.getQualifiedName()) || "java.io.Serializable".equals(name) || "java.lang.Cloneable".equals(name))) {
            return;
        }
        holder.registerProblem((PsiElement)arguments[0], JavaBundle.message((String)"inspection.reflect.handle.invocation.argument.not.array", (Object[])new Object[0]), new LocalQuickFix[0]);
    }

    @NotNull
    private static String getMethodDeclarationText(@NotNull String methodName, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        if (methodName == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(25);
        }
        if (methodSignature == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(26);
        }
        String returnType = methodSignature.getShortReturnType();
        String string = returnType + " " + methodName + methodSignature.getShortArgumentTypes();
        if (string == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    private static String getConstructorDeclarationText(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        String className;
        if (ownerClass == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(28);
        }
        if (methodSignature == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(29);
        }
        if ((className = ownerClass.getPsiClass().getName()) != null) {
            return JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(className, methodSignature);
        }
        return null;
    }

    @NotNull
    private static String getConstructorDeclarationText(@NotNull String className, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        String returnType;
        if (className == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(30);
        }
        if (methodSignature == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(31);
        }
        Object fakeReturnType = !"void".equals(returnType = methodSignature.getShortReturnType()) ? returnType + " " : "";
        String string = (String)fakeReturnType + className + methodSignature.getShortArgumentTypes();
        if (string == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static @Unmodifiable List<PsiMethod> findMethodBySignature(@NotNull List<? extends PsiMethod> methods, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature expectedMethodSignature) {
        if (methods == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(33);
        }
        if (expectedMethodSignature == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(34);
        }
        List list = ContainerUtil.filter(methods, method -> expectedMethodSignature.equals((Object)JavaReflectionReferenceUtil.getMethodSignature((PsiMethod)method)));
        if (list == null) {
            JavaLangInvokeHandleSignatureInspection.$$$reportNull$$$0(35);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 27, 32, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryMethodName";
                break;
            }
            case 4: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryMethodExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorTypeExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNameExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldTypeExpression";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNameExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodTypeExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callerClassExpression";
                break;
            }
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 27: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedMethodSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDeclarationText";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorDeclarationText";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodBySignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkHandlerFactoryCall";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkHandleFactory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructor";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkSpecial";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclarationText";
                break;
            }
            case 27: 
            case 32: 
            case 35: {
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorDeclarationText";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 27, 32, 35 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceSignatureQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myName;
        private final List<JavaReflectionReferenceUtil.ReflectiveSignature> mySignatures;
        private final boolean myIsConstructor;

        ReplaceSignatureQuickFix(@Nullable PsiElement element, @NotNull String name, @NotNull List<JavaReflectionReferenceUtil.ReflectiveSignature> signatures, boolean isConstructor) {
            if (name == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(0);
            }
            if (signatures == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(1);
            }
            super(element);
            this.myName = name;
            this.mySignatures = signatures;
            this.myIsConstructor = isConstructor;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getText() {
            if (this.mySignatures.size() == 1) {
                String declarationText = this.getDeclarationText(this.mySignatures.getFirst());
                String string = JavaBundle.message((String)(this.myIsConstructor ? "inspection.handle.signature.use.constructor.fix.name" : "inspection.handle.signature.use.method.fix.name"), (Object[])new Object[]{declarationText});
                if (string == null) {
                    ReplaceSignatureQuickFix.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = JavaBundle.message((String)(this.myIsConstructor ? "inspection.handle.signature.use.constructor.fix.family.name" : "inspection.handle.signature.use.method.fix.family.name"), (Object[])new Object[0]);
            if (string == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return this.mySignatures.size() == 1 || ApplicationManager.getApplication().isUnitTestMode();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(5);
            }
            if (psiFile == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(6);
            }
            if (startElement == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(7);
            }
            if (endElement == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(8);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiElement element = this.myStartElement.getElement();
                if (editor != null && element != null) {
                    JavaReflectionReferenceUtil.ReflectiveSignature signature = (JavaReflectionReferenceUtil.ReflectiveSignature)editor.getUserData(DEFAULT_SIGNATURE);
                    if (signature != null && this.mySignatures.contains(signature)) {
                        ReplaceSignatureQuickFix.applyFix(project, element, signature);
                    }
                    editor.putUserData(POSSIBLE_SIGNATURES, this.createLookupElements());
                }
                return;
            }
            if (this.mySignatures.size() == 1) {
                ReplaceSignatureQuickFix.applyFix(project, startElement, this.mySignatures.getFirst());
            } else if (editor != null) {
                this.showLookup(project, editor);
            }
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (project == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(9);
            }
            if (editor == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(10);
            }
            if (psiFile == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(11);
            }
            if (this.mySignatures.isEmpty()) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    ReplaceSignatureQuickFix.$$$reportNull$$$0(12);
                }
                return intentionPreviewInfo;
            }
            JavaReflectionReferenceUtil.ReflectiveSignature signature = this.mySignatures.getFirst();
            PsiElement element = PsiTreeUtil.findSameElementInCopy((PsiElement)this.getStartElement(), (PsiFile)psiFile);
            if (element == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    ReplaceSignatureQuickFix.$$$reportNull$$$0(13);
                }
                return intentionPreviewInfo;
            }
            ReplaceSignatureQuickFix.applyFix(project, element, signature);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(14);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        private List<LookupElement> createLookupElements() {
            List<LookupElement> list = this.mySignatures.stream().sorted(JavaReflectionReferenceUtil.ReflectiveSignature::compareTo).map(signature -> LookupElementBuilder.create((Object)signature, (String)"").withIcon(signature.getIcon()).withPresentableText(this.myName + signature.getShortArgumentTypes()).withTypeText(!this.myIsConstructor ? signature.getShortReturnType() : null)).collect(Collectors.toList());
            if (list == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(15);
            }
            return list;
        }

        private void showLookup(final @NotNull Project project, @NotNull Editor editor) {
            if (project == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(16);
            }
            if (editor == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(17);
            }
            editor.getSelectionModel().removeSelection();
            List<LookupElement> items = this.createLookupElements();
            LookupManager lookupManager = LookupManager.getInstance((Project)project);
            LookupEx lookup = lookupManager.showLookup(editor, items.toArray(LookupElement.EMPTY_ARRAY));
            if (lookup != null) {
                lookup.addLookupListener(new LookupListener(){

                    public void itemSelected(@NotNull LookupEvent event) {
                        LookupElement item;
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((item = event.getItem()) != null) {
                            PsiElement element = this.getStartElement();
                            Object object = item.getObject();
                            if (element != null && object instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
                                WriteAction.run(() -> ReplaceSignatureQuickFix.applyFix(project, element, (JavaReflectionReferenceUtil.ReflectiveSignature)object));
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix$1", "itemSelected"));
                    }
                });
            }
        }

        private static void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature) {
            if (project == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(18);
            }
            if (element == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(19);
            }
            if (signature == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(20);
            }
            String replacementText = JavaReflectionReferenceUtil.getMethodTypeExpressionText((JavaReflectionReferenceUtil.ReflectiveSignature)signature);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression replacement = factory.createExpressionFromText(replacementText, element);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences(element.replace((PsiElement)replacement));
        }

        @NotNull
        private String getDeclarationText(@NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature) {
            if (signature == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(21);
            }
            String string = this.myIsConstructor ? JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(this.myName, signature) : JavaLangInvokeHandleSignatureInspection.getMethodDeclarationText(this.myName, signature);
            if (string == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(22);
            }
            return string;
        }

        @Nullable
        private static LocalQuickFix createFix(@Nullable PsiElement element, @NotNull String methodName, @NotNull List<JavaReflectionReferenceUtil.ReflectiveSignature> methodSignatures, boolean isConstructor, boolean isOnTheFly) {
            if (methodName == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(23);
            }
            if (methodSignatures == null) {
                ReplaceSignatureQuickFix.$$$reportNull$$$0(24);
            }
            if (isOnTheFly && !methodSignatures.isEmpty() || methodSignatures.size() == 1) {
                return new ReplaceSignatureQuickFix(element, methodName, methodSignatures, isConstructor);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 12, 13, 14, 15, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signatures";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix";
                    break;
                }
                case 5: 
                case 9: 
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 10: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodSignatures";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupElements";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclarationText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 22: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "showLookup";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeclarationText";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "createFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 12, 13, 14, 15, 22 -> new IllegalStateException(string);
            };
        }
    }

    private static class SwitchStaticnessQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final Map<String, String> STATIC_TO_NON_STATIC = Map.of("findStaticGetter", "findGetter", "findStaticSetter", "findSetter", "findStaticVarHandle", "findVarHandle", "findStatic", "findVirtual");
        private static final Map<String, String> NON_STATIC_TO_STATIC = Map.of("findGetter", "findStaticGetter", "findSetter", "findStaticSetter", "findVarHandle", "findStaticVarHandle", "findVirtual", "findStatic");
        private final String myReplacementName;

        SwitchStaticnessQuickFix(@NotNull String replacementName) {
            if (replacementName == null) {
                SwitchStaticnessQuickFix.$$$reportNull$$$0(0);
            }
            this.myReplacementName = replacementName;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacementName});
            if (string == null) {
                SwitchStaticnessQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                SwitchStaticnessQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                SwitchStaticnessQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                SwitchStaticnessQuickFix.$$$reportNull$$$0(4);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiIdentifier identifier = factory.createIdentifier(this.myReplacementName);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences(element.replace((PsiElement)identifier));
        }

        @Nullable
        public static LocalQuickFix createFix(@NotNull String methodName, boolean wasStatic) {
            if (methodName == null) {
                SwitchStaticnessQuickFix.$$$reportNull$$$0(5);
            }
            String replacementName = wasStatic ? STATIC_TO_NON_STATIC.get(methodName) : NON_STATIC_TO_STATIC.get(methodName);
            return replacementName != null ? new SwitchStaticnessQuickFix(replacementName) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacementName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$SwitchStaticnessQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$SwitchStaticnessQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class FieldTypeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myFieldTypeText;

        FieldTypeQuickFix(String fieldTypeText) {
            this.myFieldTypeText = fieldTypeText;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.handle.signature.change.type.fix.name", (Object[])new Object[]{this.myFieldTypeText});
            if (string == null) {
                FieldTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                FieldTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                FieldTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                FieldTypeQuickFix.$$$reportNull$$$0(3);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression typeExpression = factory.createExpressionFromText(this.myFieldTypeText + ".class", element);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences(element.replace((PsiElement)typeExpression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$FieldTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$FieldTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static interface CallChecker {
        public boolean checkCall(@NotNull PsiMethodCallExpression var1, @NotNull ProblemsHolder var2);
    }
}

