/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.reflectiveAccess.JavaReflectionInvocationInspection;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaReflectionMemberAccessInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> MEMBER_METHOD_NAMES = Set.of("getField", "getDeclaredField", "getMethod", "getDeclaredMethod", "getConstructor", "getDeclaredConstructor");
    private final List<String> ignoredClassNames = new ArrayList<String>();
    public boolean checkMemberExistsInNonFinalClasses = true;
    public String ignoredClassNamesString = "java.lang.Object,java.lang.Throwable";

    public JavaReflectionMemberAccessInspection() {
        this.parseSettings();
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"ignoredClassNames", (String)JavaBundle.message((String)"inspection.reflection.member.access.check.exists.exclude.label", (Object[])new Object[0]), (StringValidator)new JavaClassValidator().withTitle(JavaBundle.message((String)"inspection.reflection.member.access.check.exists.exclude.chooser", (Object[])new Object[0]))), OptPane.checkbox((String)"checkMemberExistsInNonFinalClasses", (String)JavaBundle.message((String)"inspection.reflection.member.access.check.exists", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(element);
        this.parseSettings();
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(2);
        }
        this.collectSettings();
        super.writeSettings(element);
    }

    private void parseSettings() {
        this.ignoredClassNames.clear();
        ContainerUtil.addAll(this.ignoredClassNames, (Object[])this.ignoredClassNamesString.split(","));
    }

    private void collectSettings() {
        this.ignoredClassNamesString = String.join((CharSequence)",", this.ignoredClassNames);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(3);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                PsiClass containingClass;
                PsiMethod method;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                String referenceName = expression.getMethodExpression().getReferenceName();
                if (referenceName != null && MEMBER_METHOD_NAMES.contains(referenceName) && (method = expression.resolveMethod()) != null && (containingClass = method.getContainingClass()) != null && "java.lang.Class".equals(containingClass.getQualifiedName())) {
                    switch (referenceName) {
                        case "getField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression, false, holder);
                            break;
                        }
                        case "getDeclaredField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression, true, holder);
                            break;
                        }
                        case "getMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression, false, holder);
                            break;
                        }
                        case "getDeclaredMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression, true, holder);
                            break;
                        }
                        case "getConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression, false, holder);
                            break;
                        }
                        case "getDeclaredConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression, true, holder);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private void checkField(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        PsiExpression nameExpression;
        String fieldName;
        PsiExpression[] arguments;
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(5);
        }
        if ((arguments = callExpression.getArgumentList().getExpressions()).length != 0 && (fieldName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiField field = ownerClass.getPsiClass().findFieldByName(fieldName, true);
            if (field == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.field", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && field.getContainingClass() != ownerClass.getPsiClass()) {
                UseAppropriateMethodFix fix = field.hasModifierProperty("public") ? new UseAppropriateMethodFix("getField") : null;
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.field.not.in.class", (Object[])new Object[]{fieldName, ownerClass.getPsiClass().getQualifiedName()}), LocalQuickFix.notNullElements((LocalQuickFix)fix));
                return;
            }
            if (!isDeclared && !field.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.field.not.public", (Object[])new Object[]{fieldName}), new LocalQuickFix[]{new UseAppropriateMethodFix("getDeclaredField")});
            }
        }
    }

    private void checkMethod(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        PsiExpression nameExpression;
        String methodName;
        PsiExpression[] arguments;
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(7);
        }
        if ((arguments = callExpression.getArgumentList().getExpressions()).length != 0 && (methodName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiMethod[] methods = ownerClass.getPsiClass().findMethodsByName(methodName, true);
            if (methods.length == 0) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            PsiMethod matchingMethod = JavaReflectionMemberAccessInspection.matchMethod(callExpression, methods, arguments, 1);
            if (matchingMethod == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method.arguments", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && matchingMethod.getContainingClass() != ownerClass.getPsiClass()) {
                LocalQuickFix[] localQuickFixArray;
                if (matchingMethod.hasModifierProperty("public")) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new UseAppropriateMethodFix("getMethod");
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fix = localQuickFixArray;
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.method.not.in.class", (Object[])new Object[]{methodName, ownerClass.getPsiClass().getQualifiedName()}), fix);
                return;
            }
            if (!isDeclared && !matchingMethod.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.method.not.public", (Object[])new Object[]{methodName}), new LocalQuickFix[]{new UseAppropriateMethodFix("getDeclaredMethod")});
            }
        }
    }

    private void checkConstructor(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(9);
        }
        if ((ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiClass constructorOrClass;
            PsiMethod[] methods = ownerClass.getPsiClass().getConstructors();
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            if (methods.length != 0) {
                constructorOrClass = JavaReflectionMemberAccessInspection.matchMethod(callExpression, methods, arguments, 0);
            } else {
                PsiClass psiClass = constructorOrClass = arguments.length == 0 ? ownerClass.getPsiClass() : null;
            }
            if (constructorOrClass == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)callExpression.getArgumentList(), JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.constructor.arguments", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
                return;
            }
            if (!isDeclared && !constructorOrClass.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)callExpression.getArgumentList(), JavaBundle.message((String)"inspection.reflection.member.access.constructor.not.public", (Object[])new Object[0]), new LocalQuickFix[]{new UseAppropriateMethodFix("getDeclaredConstructor")});
            }
        }
    }

    private boolean reportUnresolvedMembersOf(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass) {
        if (ownerClass == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(10);
        }
        return (this.checkMemberExistsInNonFinalClasses || ownerClass.getPsiClass().hasModifierProperty("final")) && !this.ignoredClassNames.contains(ownerClass.getPsiClass().getQualifiedName());
    }

    @Contract(value="null->null")
    @Nullable
    private static String getMemberName(@Nullable PsiExpression memberNameArgument) {
        return (String)JavaReflectionReferenceUtil.computeConstantExpression((PsiExpression)memberNameArgument, String.class);
    }

    @Nullable
    private static JavaReflectionReferenceUtil.ReflectiveClass getOwnerClass(@NotNull PsiMethodCallExpression callExpression) {
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(11);
        }
        return JavaReflectionReferenceUtil.getReflectiveClass((PsiExpression)callExpression.getMethodExpression().getQualifierExpression());
    }

    @Nullable
    private static PsiMethod matchMethod(@NotNull PsiMethodCallExpression callExpression, PsiMethod[] methods, PsiExpression[] arguments, int argumentOffset) {
        JavaReflectionInvocationInspection.Arguments methodArguments;
        if (callExpression == null) {
            JavaReflectionMemberAccessInspection.$$$reportNull$$$0(12);
        }
        if ((methodArguments = JavaReflectionInvocationInspection.getActualMethodArguments(arguments, argumentOffset, MethodCallUtils.isVarArgCall((PsiCall)callExpression))) == null) {
            return null;
        }
        List argumentTypes = ContainerUtil.map((Object[])methodArguments.expressions(), JavaReflectionReferenceUtil::getReflectiveType);
        return JavaLangClassMemberReference.matchMethod((PsiMethod[])methods, (List)argumentTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedMembersOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOwnerClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    static final class UseAppropriateMethodFix
    extends PsiUpdateModCommandQuickFix {
        private final String myProperMethod;

        UseAppropriateMethodFix(String method) {
            this.myProperMethod = method;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.use", (Object[])new Object[]{this.myProperMethod + "()"});
            if (string == null) {
                UseAppropriateMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.reflection.member.access.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                UseAppropriateMethodFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpressionList expressionList;
            if (project == null) {
                UseAppropriateMethodFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                UseAppropriateMethodFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UseAppropriateMethodFix.$$$reportNull$$$0(4);
            }
            if ((expressionList = (PsiExpressionList)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpressionList.class})) == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)this.myProperMethod);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection$UseAppropriateMethodFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection$UseAppropriateMethodFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

