/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.OperationReductionMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

final class CountMigration
extends BaseStreamApiMigration {
    CountMigration(boolean shouldWarn) {
        super(shouldWarn, "count");
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body, @NotNull TerminalBlock tb) {
        PsiExpression operand;
        PsiExpression expression;
        if (project == null) {
            CountMigration.$$$reportNull$$$0(0);
        }
        if (body == null) {
            CountMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            CountMigration.$$$reportNull$$$0(2);
        }
        if ((expression = tb.getSingleExpression(PsiExpression.class)) == null) {
            expression = tb.getCountExpression();
        }
        if (!((operand = StreamApiMigrationInspection.extractIncrementedLValue(expression)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand).resolve();
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        CommentTracker ct = new CommentTracker();
        return CountMigration.replaceWithOperation(tb.getStreamSourceStatement(), (PsiVariable)var, tb.generate(ct) + ".count()", (PsiType)PsiTypes.longType(), OperationReductionMigration.SUM_OPERATION, ct);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "body";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tb";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamMigration/CountMigration";
        objectArray[2] = "migrate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

