/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.streamMigration.CollectMigration;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FuseStreamOperationsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"collect"}).parameterTypes(new String[]{"java.util.stream.Collector"});
    private static final CallMatcher COLLECT_TO_COLLECTION = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toList", "toSet"}).parameterCount(0), CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toCollection"}).parameterCount(1)});
    public boolean myStrictMode = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myStrictMode", (String)JavaBundle.message((String)"inspection.fuse.stream.operations.option.strict.mode", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            FuseStreamOperationsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            FuseStreamOperationsInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FuseStreamOperationsInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                PsiMethodCallExpression arg;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (STREAM_COLLECT.test(call) && COLLECT_TO_COLLECTION.test(arg = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class))) {
                    CollectMigration.CollectTerminal newTerminal = FuseStreamOperationsInspection.extractTerminal(call);
                    if (newTerminal == null) {
                        return;
                    }
                    PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                    if (nameElement == null) {
                        return;
                    }
                    String fusedSteps = (String)newTerminal.fusedElements().collect(NlsMessages.joiningAnd());
                    holder.registerProblem(nameElement, JavaBundle.message((String)"inspection.fuse.stream.operations.message", (Object[])new Object[]{fusedSteps}), new LocalQuickFix[]{new FuseStreamOperationsFix(fusedSteps, FuseStreamOperationsInspection.this.myStrictMode)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @Nullable
    private static CollectMigration.CollectTerminal extractTerminal(PsiMethodCallExpression streamChain) {
        PsiElement nextElement;
        StreamCollectChain terminal;
        if (streamChain.getMethodExpression().getQualifierExpression() == null) {
            return null;
        }
        PsiMethodCallExpression collector = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])streamChain.getArgumentList().getExpressions()))), PsiMethodCallExpression.class);
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)streamChain.getParent(), PsiLocalVariable.class);
        if (var == null) {
            terminal = new StreamCollectChainNoVar(streamChain, collector);
            nextElement = CommonJavaRefactoringUtil.getParentStatement((PsiElement)streamChain, (boolean)false);
        } else {
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)var.getParent(), PsiDeclarationStatement.class);
            if (declaration == null || declaration.getDeclaredElements().length != 1) {
                return null;
            }
            terminal = new StreamCollectChain(var, streamChain, collector);
            nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)declaration);
        }
        CollectMigration.CollectTerminal newTerminal = CollectMigration.includePostStatements(terminal, nextElement);
        if (newTerminal == terminal) {
            return null;
        }
        return newTerminal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class StreamCollectChainNoVar
    extends StreamCollectChain {
        protected StreamCollectChainNoVar(PsiMethodCallExpression chain, PsiMethodCallExpression collector) {
            super(null, chain, collector);
        }

        StreamEx<PsiExpression> targetReferences() {
            return StreamEx.of((Object)this.myChain);
        }

        @Override
        boolean isTargetReference(PsiExpression expression) {
            return expression == this.myChain;
        }
    }

    private static class StreamCollectChain
    extends CollectMigration.CollectTerminal {
        final PsiMethodCallExpression myCollector;
        final PsiMethodCallExpression myChain;

        protected StreamCollectChain(PsiLocalVariable variable, PsiMethodCallExpression chain, PsiMethodCallExpression collector) {
            super(variable, null, ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE);
            this.myCollector = collector;
            this.myChain = chain;
        }

        @Override
        String generateIntermediate(CommentTracker ct) {
            PsiExpression qualifier = this.myChain.getMethodExpression().getQualifierExpression();
            return ct.text((PsiElement)Objects.requireNonNull(qualifier));
        }

        @Override
        String generateTerminal(CommentTracker ct, boolean strictMode) {
            return ".collect(" + ct.text((PsiElement)this.myCollector) + ")";
        }

        private static PsiClass resolveClassCreatedByFunction(PsiExpression function) {
            PsiJavaCodeReferenceElement classReference;
            PsiExpression body;
            PsiNewExpression newExpression;
            if ((function = PsiUtil.skipParenthesizedExprDown((PsiExpression)function)) instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)function).isConstructor()) {
                PsiElement target = ((PsiMethodReferenceExpression)function).resolve();
                return target instanceof PsiClass ? (PsiClass)target : (target instanceof PsiMethod ? ((PsiMethod)target).getContainingClass() : null);
            }
            if (function instanceof PsiLambdaExpression && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)(body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)((PsiLambdaExpression)function).getBody()))), PsiNewExpression.class)) != null && newExpression.getAnonymousClass() == null && newExpression.getQualifier() == null && newExpression.getArgumentList() != null && newExpression.getArgumentList().isEmpty() && (classReference = newExpression.getClassReference()) != null) {
                return (PsiClass)ObjectUtils.tryCast((Object)classReference.resolve(), PsiClass.class);
            }
            return null;
        }

        @Override
        String getIntermediateStepsFromCollection() {
            String name = this.myCollector.getMethodExpression().getReferenceName();
            if ("toList".equals(name)) {
                return "";
            }
            if ("toSet".equals(name)) {
                return ".distinct()";
            }
            if ("toCollection".equals(name)) {
                PsiExpression collectionFunction = this.myCollector.getArgumentList().getExpressions()[0];
                PsiClass psiClass = StreamCollectChain.resolveClassCreatedByFunction(collectionFunction);
                if (psiClass == null) {
                    return null;
                }
                return CollectMigration.INTERMEDIATE_STEPS.get(psiClass.getQualifiedName());
            }
            return null;
        }
    }

    private static class FuseStreamOperationsFix
    extends PsiUpdateModCommandQuickFix {
        private final String myFusedSteps;
        private final boolean myStrictMode;

        FuseStreamOperationsFix(String fusedSteps, boolean strictMode) {
            this.myFusedSteps = fusedSteps;
            this.myStrictMode = strictMode;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.fuse.stream.operations.fix.name", (Object[])new Object[]{this.myFusedSteps});
            if (string == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.fuse.stream.operations.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement result;
            PsiMethodCallExpression chain;
            if (project == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                FuseStreamOperationsFix.$$$reportNull$$$0(4);
            }
            if ((chain = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            CollectMigration.CollectTerminal terminal = FuseStreamOperationsInspection.extractTerminal(chain);
            if (terminal == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String stream = terminal.generateIntermediate(ct) + terminal.generateTerminal(ct, this.myStrictMode);
            PsiElement toReplace = terminal.getElementToReplace();
            terminal.cleanUp(ct);
            if (toReplace != null) {
                result = ct.replaceAndRestoreComments(toReplace, stream);
            } else {
                PsiVariable variable = (PsiVariable)Objects.requireNonNull(terminal.getTargetVariable());
                PsiExpression initializer = Objects.requireNonNull(variable.getInitializer());
                result = ct.replaceAndRestoreComments((PsiElement)initializer, stream);
            }
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection$FuseStreamOperationsFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/FuseStreamOperationsInspection$FuseStreamOperationsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

