/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

final class MatchMigration
extends BaseStreamApiMigration {
    private static final Logger LOG = Logger.getInstance(MatchMigration.class);

    MatchMigration(boolean shouldWarn, String methodName) {
        super(shouldWarn, methodName);
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body, @NotNull TerminalBlock tb) {
        PsiStatement[] statements;
        PsiReturnStatement returnStatement;
        PsiLiteralExpression literal;
        if (project == null) {
            MatchMigration.$$$reportNull$$$0(0);
        }
        if (body == null) {
            MatchMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            MatchMigration.$$$reportNull$$$0(2);
        }
        PsiStatement sourceStatement = tb.getStreamSourceStatement();
        CommentTracker ct = new CommentTracker();
        PsiStatement psiStatement = tb.getSingleStatement();
        if (psiStatement instanceof PsiReturnStatement && (literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)(returnStatement = (PsiReturnStatement)psiStatement).getReturnValue()), PsiLiteralExpression.class)) != null && literal.getValue() instanceof Boolean) {
            boolean foundResult = (Boolean)literal.getValue();
            PsiReturnStatement nextReturnStatement = ControlFlowUtils.getNextReturnStatement((PsiStatement)sourceStatement);
            if (nextReturnStatement != null) {
                PsiExpression returnValue = nextReturnStatement.getReturnValue();
                if (returnValue == null) {
                    return null;
                }
                String methodName = foundResult ? "anyMatch" : "noneMatch";
                Object streamText = MatchMigration.addTerminalOperation(ct, methodName, (PsiElement)sourceStatement, tb);
                if (nextReturnStatement.getParent() == sourceStatement.getParent()) {
                    if (!ExpressionUtils.isLiteral((PsiElement)returnValue, (Object)(!foundResult ? 1 : 0))) {
                        streamText = (String)streamText + (foundResult ? "||" : "&&") + ct.text(returnValue, 12);
                    }
                    MatchMigration.removeLoop(ct, sourceStatement);
                    return new CommentTracker().replaceAndRestoreComments((PsiElement)returnValue, (String)streamText);
                }
                PsiElement result = ct.replaceAndRestoreComments((PsiElement)sourceStatement, "return " + (String)streamText + ";");
                if (!ControlFlowUtils.isReachable((PsiStatement)nextReturnStatement)) {
                    new CommentTracker().deleteAndRestoreComments((PsiElement)nextReturnStatement);
                }
                return result;
            }
        }
        if (!((statements = tb.getStatements()).length == 1 || sourceStatement instanceof PsiLoopStatement && statements.length == 2 && ControlFlowUtils.statementBreaksLoop((PsiStatement)statements[1], (PsiLoopStatement)((PsiLoopStatement)sourceStatement)))) {
            return null;
        }
        String streamText = MatchMigration.addTerminalOperation(ct, "anyMatch", (PsiElement)sourceStatement, tb);
        PsiStatement statement = statements[0];
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statement);
        if (assignment != null) {
            PsiElement maybeVar;
            PsiExpression lValue = assignment.getLExpression();
            PsiExpression rValue = assignment.getRExpression();
            if (lValue instanceof PsiReferenceExpression && rValue != null && (maybeVar = ((PsiReferenceExpression)lValue).resolve()) instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)maybeVar;
                PsiExpression initializer = var.getInitializer();
                ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)var, (PsiStatement)sourceStatement);
                if (initializer != null && status != ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
                    Object replacement = ExpressionUtils.isLiteral((PsiElement)initializer, (Object)Boolean.FALSE) && ExpressionUtils.isLiteral((PsiElement)rValue, (Object)Boolean.TRUE) ? streamText : (ExpressionUtils.isLiteral((PsiElement)initializer, (Object)Boolean.TRUE) && ExpressionUtils.isLiteral((PsiElement)rValue, (Object)Boolean.FALSE) ? "!" + streamText : streamText + "?" + ct.text((PsiElement)rValue) + ":" + ct.text((PsiElement)initializer));
                    return MatchMigration.replaceInitializer(sourceStatement, var, initializer, (String)replacement, status, ct);
                }
            }
        }
        String replacement = "if(" + streamText + "){" + ct.text((PsiElement)statement) + "\n}";
        return ct.replaceAndRestoreComments((PsiElement)sourceStatement, replacement);
    }

    private static String addTerminalOperation(CommentTracker ct, String methodName, @NotNull PsiElement contextElement, @NotNull TerminalBlock tb) {
        if (contextElement == null) {
            MatchMigration.$$$reportNull$$$0(3);
        }
        if (tb == null) {
            MatchMigration.$$$reportNull$$$0(4);
        }
        String origStream = tb.generate(ct);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)contextElement.getProject());
        PsiMethodCallExpression stream = (PsiMethodCallExpression)elementFactory.createExpressionFromText(origStream, contextElement);
        PsiElement nameElement = stream.getMethodExpression().getReferenceNameElement();
        if (nameElement != null && nameElement.getText().equals("filter")) {
            PsiLambdaExpression lambda;
            PsiElement lambdaBody;
            PsiExpression psiExpression;
            PsiExpression[] expressions;
            if (methodName.equals("noneMatch") && (expressions = stream.getArgumentList().getExpressions()).length == 1 && (psiExpression = expressions[0]) instanceof PsiLambdaExpression && (lambdaBody = (lambda = (PsiLambdaExpression)psiExpression).getBody()) instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)((PsiExpression)lambdaBody))) {
                PsiExpression negated = BoolUtils.getNegated((PsiExpression)((PsiExpression)lambdaBody));
                LOG.assertTrue(negated != null, (Object)lambdaBody.getText());
                lambdaBody.replace((PsiElement)negated);
                methodName = "allMatch";
            }
            nameElement.replace((PsiElement)elementFactory.createIdentifier(methodName));
            return stream.getText();
        }
        return origStream + "." + methodName + "(" + tb.getVariable().getName() + " -> true)";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tb";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/streamMigration/MatchMigration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "migrate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTerminalOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

